; The "better then nothing" particle system
; A 256-byte intro by Blacky/Exact
; Works on DosBox 0.74-3
; Compile with "nasm.exe particle.asm -fbin -o particle.com"

%define numParticles 5560 ; free to change as long as they all fit in the segment

org 100h

	mov al,13h ; ah=0 on dosbox 
	int 10h

	;xor ebp, ebp ; frame counter, start value is don't care, so why zero it

	;push cs ; apparently cs=ds=es on dosbox, so this is not needed
	;pop es

	; particle init is omitted, as particles will eventually fall down anyway and will be re-initialized

	; install int3 interrupt handler to misuse it to call random with just 1 byte instead of 3 bytes
	mov ax, 2503h
	lea dx, random
	int 21h

redraw:
	mov ax, 0b000h ; push-pop would be shorter, but we reuse al=0 below
	mov es,ax
	xor di,di
	;mov al, 0 ; al=0 anyway due to segment value above
	;mov cx, 320*200
	dec cx ; cx=0 here due to the last rep command at the end of the main loop. if we clear some more memory, no problem
		   ; If we clear incorrect amount of pixels on the first frame, that is also fine. 
	rep stosb

	push cs ; this is needed as ds is used for another segment later
	pop ds

	mov si, particleData
	mov cx, numParticles
drawParticles:
		push cx
		movsx ax, byte [si+3] ; integer part of pos_y to avoid extra "sar ax, 8".
		mov dx, 320
		add ax, 100 ; offset down to center
		mul dx
		jc skipWrite ; avoid drawing overflown pixels
		mov di, ax	
		movsx bx, [si+1] ; integer part of pos_x to avoid extra "sar bx, 8"
		lea di, [di+bx] ; Use bx beacasue that's what LEA works with. Horizontal offset is done with the segment register during copy, so not needed here

		mov ax,si ; set color based on high byte of particle index
		mov al, ah

		mov bx, bp ; get timer and extract effect ID
		and bh, 110b
		shr bx, 9
		and al, [colorAndTable + bx] ; color lookup table based on demo part (0 to 3)
		add al, [colorOffsetTable + bx]
		
		stosb
	skipWrite:

		mov di, si ; prepare for particle reinit later

		; update particle positions with velocity
		mov cx,2
	updateParticlePosLoop:
		mov ax, [si + 0] ; pos_x, then pos_y
		add ax, [si + 4] ; vel_x, then vel_y
		jo reinit ; overflown particles are reused as new
		mov [si + 0], ax

		inc si
		inc si
		loop updateParticlePosLoop
		
		jmp endUpdate
	reinit:
		lea si, [di+4] ; pretend that we did the particle update even if we did a reinit instead, at least pointer-wise
		
		push es

		push ds
		pop es

		mov bx, bp
		and bh, 110b		
		jnz part1
part0:	; snowfall	
		mov cx, 2
	part0_pos_xy:
		int3 ; call random
		mov ah, al ; instead of sal ax, 8
		stosw ; pos_x then pos_y
		loop part0_pos_xy
		int3 
		stosw ; vel_x
		int3 
		stosw ; vel_y
		jmp partsEnd
part1:	; fountain
		cmp bh, 010b
		jnz part2_3
		mov ax, bp ; update X emitting position with time
		and al, 11100000b ; but make it jaggy
		mov ah, al
		stosw ; pos_x
		mov ah, 7fh
		stosw ; pos_y
		int3 
		stosw ; vel_x
		int3 
		sal ax, 4
		stosw ; vel_y		
		jmp partsEnd
part2_3: ; Hyperspace (alternating horizontal and vertical emission from center)
		xor ax, ax
		stosw ; pos_x
		stosw ; pos_y

		int3 ; call random

		; above code is shared with part3
		cmp bh, 100b
		jnz part3
		
		; this is part2 only
		and bl, 1000000b ;timer from random for alternating emission scaling - unfortunately flags do not survive the interrupt, so we cannot move this to the random function
		jz noVelocityScaleX
		sal ax, 4 ; scaling of velocity in X direction
	noVelocityScaleX:
		stosw ; vel_x

		int3 
		and bl, 1000000b 
		jnz noVelocityScaleY
		sal ax, 4 ; scaling of velocity in Y direction
	noVelocityScaleY:
		stosw ; vel_y
		jmp partsEnd
part3:	; volcano
		stosw ; vel_x, random value from above
		int3
		stosw ; vel_y

partsEnd:

		pop es
	endUpdate:

		add word [si + 2], 4 ; gravity
				
		add si, 4 ; next particle

		pop cx
		;loop drawParticles ; too big code in between for a short loop :/
		dec cx
		jnz drawParticles
	
	; copy b000h buffer to a000h video buffer and offset to center
	push es ; es = b000 here
	pop ds
	push 0a00ah ; Offset X to center: 0a000h + 160 pixels / 16 
	pop es

	xor si, si	
	xor di, di
	dec cx ; instead of mov cx, 320*200, cx=0 here anyway
	rep movsb

	inc ebp ; time

	in al,0x60 ; check keyboard
	dec al
	jnz redraw

	;mov ax,03h ; be nice and switch back to text mode - or save some bytes instead
	;int 10h

	ret ; exit program

; random function based on xorshift
; returns random number in ax, limited between -0.5 and +0.5 (with 8 bit fractional part)
; ruins dx
; simpler randoms made the particle patterns look too regular
; 16 bit version from https://codebase64.org/doku.php?id=base:16bit_xorshift_random_generator
; while the 32-bit version indeed looks better, this is much smaller

random: 
	mov ax, 433ch ; store the random seed IN the code and update the constant at the end
	mov dx, ax
	shl ax, 7
	xor ax, dx
	mov dx, ax
	shr ax, 9
	xor ax, dx
	mov dx, ax
	shl ax, 8
	xor ax, dx
	mov [random+1], ax ; update random seed in the parameter of the mov ax instruction

	; limit random to +0.5 .. 0.5
	cbw

	iret

colorAndTable db	0fh,  1h,  3h,  3h
colorOffsetTable db 10h, 36h, 35h, 28h

particleData:
; particle struct offsets
; high byte is pixel coord, lower byte is fractional
; all values are treated as signed and positions centred to screen during render
;	pos_x 0 
;	pos_y 2
;	vel_x 4
;	vel_y 6
