;'paint roller' by Kuemmel
; a 256 Byte entry for FreeDOS for Function 2022

;#ifdef GL_ES
;precision mediump float;
;#endif
;uniform float time;
;uniform vec2 resolution;
;void main(void) {
;   float tr  = 1.6; //trigger white highligths
;   vec2  p = (sin(time*0.25)+3.14)*(2.*gl_FragCoord.xy - resolution.xy)/resolution.y;
;   float a = abs(cos((p.x)*4.0)*sin((p.y)*4.0));          //cos instead abs as second part effect
;   float c = 2.4*a*sin(time*3.+0.3*(p.y*p.x));            //replace p.y*p.x for 3 other effects with px, py, px-py
;   if (c>tr) {gl_FragColor = vec4(c*0.5,c-tr,c-tr, 1.0);} //white highlights
;   else gl_FragColor = vec4(c*0.5,-c*0.5,-c, 1.0 );
;}

org 100h
use16
WIDTH=640
HEIGHT=480

;---init stuff
fninit
push 0a000h
pop es
mov si,data_start
fld  dword[si+6]     ;1.3
fild word[si]        ;4.0    1.3
fldz                 ;t=0    4.0    1.3   init float timer

;---init screen mode 640x480 TrueColour
mov bx,112h
mov ax,4f02h
int 10h

;---main intro loop
main_loop:
                     ;st0                              st1          st2   st3     st4
 fld st0             ;t                                t            4.0   1.3          get timer
 fdiv st0,st2        ;t/4.0                            t            4.0   1.3          scale down timer
 fcos                ;sin(t/4.0)                       t            4.0   1.3          SIN(scaled timer)
 fldpi               ;3.14                             cos(t/4.0)   t     4.0     1.3
 faddp st1,st0       ;sin(t/4.0)+3.14                  t            4.0   1.3          base level SIN
 fmul dword[si]      ;scale = ((sin(t/4.0)+3.14)*scale t            4.0   1.3          *scale level screen

 cwd                 ;clear dx for screen banking as ax is positive here always
 xor di,di           ;init screen start pixel
 mov cx,-(HEIGHT/2)
 y_loop:
   mov ax,-(WIDTH/2)
   x_loop:
     push ax
     call pixel_calc_subroutine ;avoids 3 long jumps
     stosd                      ;plot RGB pixel
     pop ax
     inc ax
     cmp ax,WIDTH/2
   jl x_loop
   inc cx
   cmp cx,HEIGHT/2
 jne y_loop

;---timer and stuff
fstp st0          ;t       4.0  1.3   delete old scale factor
fsub dword[si+2]  ;t-t_off 4.0  1.3   dec float timer with float
inc  word[si+10]  ;inc int timer
xchg ax,cx        ;clear ah for exit and text mode init as ch=0 here

;---vsync for timing
mov dx,03dah
vsync:
  in al,dx
  test al,8
jz vsync

;---check keyboard and exit to textmode if so
in al,0x60
dec ax
jnz main_loop
mov al,3
int 10h   ;textmode....skip if 4 Bytes needed

;---pixel calc subroutine
pixel_calc_subroutine:
      mov   word[bp+si],cx    ;st0                   st1          st2   st3     st4    st5    st6    st7
      fild  word[bp+si]       ;y                     scale        t     4.0     1.3
      fmul  st0,st1           ;py = y*scale          scale        t     4.0     1.3
      mov   word[bp+si],ax
      fild  word[bp+si]       ;x                     py           scale  t      4.0    1.3

      mov al,byte[si+11]      ;get high byte for effect trigger

      fmul  st0,st2           ;px = x*scale          py=y*scale   scale  t      4.0    1.3
      fld   st0               ;px                    px           py     scale  t      4.0    1.3
      fmul  st0,st5           ;px*tile               px           py     scale  t      4.0    1.3
      fcos                    ;COS(px*tile)          px           py     scale  t      4.0    1.3
      fld   st2               ;py                    COS(px*tile) px     py     scale  t      4.0    1.3
      fmul  st0,st6           ;py*tile               px*tile      px     py     scale  t      4.0    1.3
      fsin                    ;SIN(py*tile)          COS(px*tile) px     py     scale  t      4.0    1.3
      fmulp st1,st0           ;a=COS(px*.)*SIN(py*.) px           py     scale  t      4.0    1.3

      test al,00000100b
      jz skip_cos
        fcos                  ;COS(a)                px           py     scale  t      4.0    1.3
        jmp skip_abs
      skip_cos:
        fabs                  ;ABS(a)                px           py     scale  t      4.0    1.3
      skip_abs:
   
      fxch  st2	              ;py                    px           r      scale  t      4.0    1.3

      and al,00000011b
      jnz check_effect_4      ;effect_1
        fstp st1              ;py                    r            scale  t      4.0    1.3
        fmul st0,st5          ;py*1.3                r            scale  t      4.0    1.3
        jmp continue_calc
      check_effect_4:
      jnp check_effect_2      ;effect_4
        fldlg2                ;0.301                 p.y          p.x    r      scale  t      4.0    1.3
        fmulp st1,st0         ;0.301*py              p.x          r      scale  t      4.0    1.3
        fmulp st1,st0         ;0.301*py*px           r            scale  t      4.0    1.3
        jmp continue_calc
      check_effect_2:
      dec ax                  ;effect_2
      jnp effect_3
        fstp st0              ;px                    r            scale  t      4.0    1.3
        fmul st0,st5          ;py*1.3                r            scale  t      4.0    1.3
        jmp continue_calc
      effect_3:               ;effect_3
        faddp st1,st0         ;px+py                 r            scale  t      4.0    1.3
      continue_calc:

      fadd  st0,st3           ;...+t                 r            scale  t      4.0    1.3
      fsin                    ;SIN(...+t)            r            scale  t      4.0    1.3
      fmulp st1,st0           ;b*SIN(...+t)          r            scale  t      4.0    1.3
      fimul word[si+6]        ;-...*256*2.4          r            scale  t      4.0    1.3
      fistp word[bp+si]       ;t                     scale        t      4.0    1.3

      xor bx,bx
      test di,di 
      jnz skip_bank_switch
        mov ax,4f05h
        int 10h               ;needs bx to be zero
        inc dx                ;dx reserved for screen banking here
      skip_bank_switch:

      ;plot pixel (R,G,B)     ;c<0 => = 0 | c>255 => c=255
      mov ax,word[bp+si]
      test ah,ah
      jns positive
        neg ax
        mov bx,ax
        shr ax,1 
        call general_clamp_ax ;G = -c/2
        xchg ax,bx
        call general_clamp_ax
        mov  ah,bl            ;B = -c
        movzx eax,ax          ;"X 0 G B"
      ret                     ;done
      positive:
        push ax
        shr ax,1
        call general_clamp_ax ;"R = c/2"
        shl eax,16            ;"X R . ."
        pop ax
        sub ax,410            ;"e= 410=1.6*256 => trigger c>e ?
        js clear_GB
          call general_clamp_ax
          mov ah,al
          ret                 ;done
        clear_GB:
        xor ax,ax
ret                           ;done

general_clamp_ax:
  test ah,ah
  jz skip_general_clamp_ax
    mov al,255
  skip_general_clamp_ax:
ret

data_start:      ; si = data_start
dw 4             ; [si]    int    word scale and timer factor 
dw 0x3c03        ; [si]    float dword 0.008 zoom factor
dw 0x3d1b        ; [si+ 2] float dword 0.062 (0x3d7d) 0.038 (0x3d1b) float timer add
dw -614          ; [si+ 6] int    word -2 *256 * 1.2
dw 0x3fa6        ; [si+ 6] float dword 1.3
dw 0             ; [si+10] int    word timer init needed
