precision mediump float;
//vec3 verdejpupper(){return vec3(0.0,1.0,0.8);}

// we need the sketch resolution to perform some calculations
uniform vec2 resolution ;
uniform float time ;
uniform vec2 mouse ;
uniform sampler2D feedback ;

varying vec2 vTexCoord ;

#define iTime time
#define iResolution resolution

#define PI 3.14159265359
#define TWO_PI 6.28318530718

#define OCTAVES 8
#define pi 3.14159265359

uniform sampler2D tx ;

uniform float v1 ;
uniform float v1_amp ;
uniform float v2 ;
uniform float v2_amp ;
uniform float v3 ;
uniform float v3_amp ;
uniform float v4 ;
uniform float v4_amp ;
uniform float faser ;
uniform float faseg ;
uniform float faseb ;
uniform float speed ;
uniform float e_force ;




float mapr(float _value,float _low2,float _high2) {
	float val = _low2 + (_high2 - _low2) * (_value - 0.) / (1.0 - 0.);
    //float val = 0.1;
	return val;
}


vec2 scale(vec2 uv, float s);

mat2 scale(vec2 _scale);
mat2 rotate2d(float _angle); 


float t = 0.0;
float desf(vec2 uv, float _fase){
		
	float e = 0.;
	float mt = mapr(speed,time*10.,-time*10.);//MAP TIME 
	mt = time*2.0;
	float ampmax = 5.0;
	float mv1_amp = mapr(v1_amp,0.5,ampmax);
	float mv2_amp = mapr(v2_amp,0.0,ampmax);
	float mv3_amp = mapr(v3_amp,0.0,ampmax);
	float mv4_amp = mapr(v4_amp,0.0,ampmax);
	
	mv1_amp = 1.8;
		
	e = sin(uv.y*mapr(v1,0.,50.)+mt+_fase
		  +sin(uv.y*mapr(v2,0.,50.)+mt+_fase
		  +sin(uv.x*mapr(v3,0.,50.)+mt+_fase
		  +sin(uv.y*mapr(v4,0.,50.)+mt+_fase
		  )*mv4_amp*0.5+mv4_amp*0.5
		  )*mv3_amp*0.5+mv3_amp*0.5
		  )*mv2_amp*0.5+mv2_amp*0.5
		  )*mv1_amp*0.5+mv1_amp*0.5;
	
	return e;
}


void main()
{	
	vec2 uv = gl_FragCoord.xy / resolution;
	uv = vTexCoord;

	
	float mt = mapr(speed,time*10.,-time*10.);//MAP TIME 
	mt = 0.02;
	
	float m_faser = faser * pi * 2.;
	float m_faseg = faseg * pi * 2.;
	float m_faseb = faseb * pi * 2.;
	
	float e1 = desf(uv,m_faser);
	float e2 = desf(uv,m_faseg);
	float e3 = desf(uv,m_faseb);
			  
	vec3 dib = vec3(e1,e2,e3);
	
	vec3 fin = vec3(0);
	
	
	vec4 txex = texture2D(tx,vec2(uv.x,1.-uv.y));

	vec2 p = vec2(0.5) - uv;
	float r = 1.-smoothstep(0.1,0.55,length(p));
	
	float meforce = mapr(e_force,0.5,0.8);
	meforce = 0.55;
	fin = txex.rgb*r+dib.rgb*.1;
	
	gl_FragColor = vec4(fin,1.0); 
}









