function drawGrayBox(_ps,_x,_y,_w,_h,_c){
    let bsize =2;
    _ps.noStroke();
    _ps.fill(_c);
     
    _ps.rectMode(CENTER);
    _ps.textAlign(CENTER,CENTER);
    _ps.textSize(20);
    _ps.rect(_x,_y,_w,_h);
    _ps.fill(255);
    _ps.rect(_x-_w/2,_y,bsize,_h);
    _ps.rect(_x,_y-_h/2,_w,bsize);
    _ps.fill(0);
    _ps.rect(_x,_y+_h/2,_w,bsize);
    _ps.rect(_x+_w/2,_y,bsize,_h);
}

class buttonSet{
    constructor(_x,_y,_w,_h,_st){
        this.x = _x;
        this.y = _y;
        this.ox = _x;
        this.oy = _y;
        this.w = _w;
        this.h = _h;
        this.st = _st;
        this.activeflag = false;
    }
    display(_ps){
        if(this.mouseOver()){
            drawGrayBox(_ps,this.x,this.y,this.w,this.h,color(255)); 
        }else{
            drawGrayBox(_ps,this.x,this.y,this.w,this.h,colores["ventanastandart"]); 
        }
        _ps.fill(0);
        _ps.textSize(18);
        _ps.text(this.st,this.x,this.y+2);
        
        if(mouseIsPressed && this.mouseOver() && this.activeflag == false){
            this.activeflag = true; 
        }
        if(!mouseIsPressed){
            this.activeflag = false;
        }

    }
    setPos(_x,_y){
        this.x = _x;
        this.y = _y;
    }
    mouseOver(){
        if(mouseX > this.x-this.w/2 && 
        mouseX < this.x+this.w/2 && 
        mouseY > this.y-this.h/2 && 
        mouseY < this.y+this.h/2 ){
            return true;
        }else{
            return false;
        }
    }

}

class loadingBar{
    constructor(_x,_y,_w,_h,_duration){
        this.duration =_duration;
        this.xv = millis();
        this.x = _x;
        this.y = _y;
        this.w = _w;
        this.h = _h;
        this.loopActive = true;

        this.standartColors = true;
        this.c1 = color(255,255);
        this.c2 = color(103,203,151);
    }
    
    
    display(_ps){
        _ps.rectMode(CENTER);
        _ps.fill(this.c1);
        _ps.rect(this.x,this.y,this.w,this.h);
        if(millis() - this.xv > this.duration){
            if(this.loopActive){
                this.xv = millis();
            }
        }
        let v = map(millis() - this.xv,0,this.duration,0,this.w);
        _ps.fill(this.c2);
        _ps.rect(this.x+v/2-this.w/2,this.y,v,this.h);
    }
    setPos(x,y){
        this.x = x;
        this.y = y;
    }
    getNormValue(){
        return map(millis() - this.xv,0,this.duration,0,1);
    }
    resetValue(){
        this.xv = millis();
    }
}