#version 330 core
layout (triangles) in;
layout (triangle_strip, max_vertices = 40) out;

in vec4 vertexColor[];
in vec4 vertexColor2[];
out vec4 gvertexColor;
out vec4 gvertexColor2;
out float PS;
out vec4 glitch;
uniform float time;

void glitchery(vec4 position, vec4 position2)
{    
    gvertexColor = vertexColor[0]; 
    gvertexColor2 = vertexColor2[0];
	gl_Position = position * .2 * (vec4(sin(time)*.1, -0.2, -.1, -.1) ); 
    EmitVertex();   
    gl_Position = position + vec4( 0.2, -0.2, 0.21, .21);
    EmitVertex();
    gl_Position = position + vec4(-0.2,  0.2, 0.0, 0.0); 
    EmitVertex();
    gl_Position = position + vec4( 0.2,  0.2, .5, 0.15); 
    EmitVertex();
    gvertexColor += gvertexColor2 - sin(time * vec4(.3, .3, .3, .3));
    EndPrimitive();
	gl_Position = position2 + vec4(.5, .5, .5, .5) + gvertexColor2;
	EmitVertex();
	EndPrimitive();
}

void main() 
{    
	gl_PointSize = gl_in[1].gl_Position.x + sin(gl_in[0].gl_Position.y) * 20.; 
    glitchery(gl_in[0].gl_Position, gl_in[1].gl_Position);
}