// basically a tuned http://tuxedolabs.blogspot.com/2018/05/bokeh-depth-of-field-in-single-pass.html 
#version 450 core

// varying inputs
in vec2 texCoord;

// outputs
out vec4 outColor;

// uniforms
uniform sampler2D t_source;
uniform sampler2D t_dof;

uniform vec2  g_srcResolution;
uniform vec2  g_dstResolution;

// dof uniforms
uniform vec2  g_pixelSize;          // practically (1.0/g_srcResolution)
uniform float g_maxRadius;          // max CoC size in pixels (that is, 20.0 covers 40 pixels)

void main() {
    vec4  sourceColor = texture(t_source, texCoord);
    vec4  dofColor    = texture(t_dof,    texCoord);
    
    float m = clamp(((10. * dofColor.a) / g_maxRadius), 0.0, 1.0);

    outColor = vec4(mix(sourceColor.rgb, dofColor.rgb, m), 1.0);
}
