#version 450 core

// inputs
in vec4 fragColor;
in vec2 texCoord;

// outputs
out vec4 outColor;

// samplers
uniform sampler2D t_sprite;

void main() {
	// alpha stipple
	vec4 color = texture(t_sprite, texCoord);
	if (all(lessThan(color.rgb, vec3(0.05)))) discard;
	
	// output otherwise
    outColor = fragColor*color;
    //outColor = vec4(gl_FragDepth, gl_FragCoord.z, 0.0, 1.0);
}
