/*
 * Some raymarching by rimina
 */

THREE.Universe = {

	uniforms: {
		"uNear": { type: "f", value: 0.01 },
		"uFar":   { type: "f", value: 180 },
		"uRo": { type: "v3", value: new THREE.Vector3(0, 0, 0)},
		"uTime" : { type: "f", value: 0.0},
		"uHb" : {type: "f", value: 0.0},
		"uResolution" : {type: "v2", value: new THREE.Vector2(0, 0)},
		"uPos" : {type: "v3", value: new THREE.Vector3(0, 0, 0)}
	},

	vertexShader: [

		"varying vec2 vUv;",
		"void main() {",
			"vUv = uv;",
			"gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );",
		"}"

	].join("\n"),

	fragmentShader: [
		"#include <packing>",
        "uniform float uNear;",
		"uniform float uFar;",
		"uniform vec3 uRo;",

		"uniform float uTime;",
		"uniform float uHb;",
		"uniform vec2 uResolution;",
		"uniform vec3 uPos;",

        "varying vec2 vUv;",

        "#define STEPS 50",
		"#define E 0.001",

		"int ID = 0;",

		"const float BPM = 120.0;",

		"float box(vec3 p, vec3 b){",
			"vec3 d = abs(p)-b;",
			"return length(max(d, 0.0)) + min(max(d.x, max(d.y, d.z)), 0.0);",
		"}",

		"void rotate(inout vec2 p, float a){",
			"p = cos(a)*p + sin(a)*vec2(p.y, -p.x);",
		"}",

		"float scene(vec3 p){",
			"vec3 pp = p;",
			"float plane = pp.y + 1.0;",

			"pp -= uPos;",
			"rotate(pp.xz, uHb);",
			"float cube = box(pp, vec3(1.0));",
			//*(mod(uTime*100.0, BPM)/BPM)

			"if(plane < cube){",
				"ID = 1;",
			"}",
			"else{",
				"ID = 0;",
			"}",

			"return min(plane, cube);",
		"}",

		"float march(vec3 ro, vec3 rd){",
		    "float t = E;",
		    "vec3 p = ro;",
		    "for(int i = 0; i < STEPS; ++i){",
		        "float d = scene(p);",
				"t += d;",
		        "p = ro + rd*t;",
		        
		        "if(d < E || t > uFar){",
		            "break;",
		        "}",
		    "}",
		    "return t;",
		"}",

		"vec3 normals(vec3 p){",
			"vec3 e = vec3(E, 0.0, 0.0);",
			"return normalize(vec3(",
			  "scene(p+e.xyy) - scene(p-e.xyy),",
			  "scene(p+e.yxy) - scene(p-e.yxy),",
			  "scene(p+e.yyx) - scene(p-e.yyx)",
			"));",
		"}",

		"vec3 shade(vec3 rd, vec3 p, vec3 ld){",
			"vec3 n = normals(p);",

			"float l = max(dot(n, ld), 0.0);",
			"float a = max(dot(reflect(ld, n), rd), 0.0);",
			"float s = pow(a, 10.0);",

			"float m = mod(p.x-uHb, 4.0) - 2.0;",

			"vec3 lc = vec3( 0.0, 0.6, 0.8);",
			"vec3 sc = vec3(0.9);",
			"if(ID == 0){",
				"if(m > 0.0 && m > 1.0){",
					"lc = lc.brg;",
				"}",
				"else if(m < 0.0 && m > -1.0){",
					"lc = lc.gbr;",
				"}",
			"}",
			"else{",
				"lc = vec3(0.8);",
			"}",

			"vec3 c = (l * lc + s * sc)*0.5;",
			"c.rgb = vec3( c.r * 0.3 + c.g * 0.59 + c.b * 0.11 );",
			"return c;",
		"}",

        "void main() {",

        	
			"vec2 q = -1.0+2.0*vUv;",
			// 0:7
			// 0:14
			// 0:23
			// 0:30-0:31
			// 0:47
			//1:03-1:07

			"if(uTime > 23.00 && uTime < 31.00){",
				"q = vUv *3.0;",
				"q = fract(q);",
				"q = -1.0+2.0*q;",
			"}",
			"else if(uTime > 47.00 && uTime < 60.02){",
				"q = vUv * 2.0;",
				"q = fract(q);",
				"q = -1.0+2.0*q;",
			"}",
			
    		"q.x *= uResolution.x/uResolution.y;",
			
    		"vec3 rd = normalize(vec3(q, -1.0));",
			
			"vec3 rol = uRo+vec3(-0.04, 0., 0.);",
			"vec3 ror = uRo+vec3(0.04, 0., 0.);",

    		"vec3 col = vec3(0.2);",
            "float tl = march(rol, rd);",
            "vec3 pl = uRo + rd*tl;",
			"vec3 ld = normalize(rol - pl);",
			"if(tl < uFar){",
				"col += vec3(1., 0., 0.) * shade(rd, pl, ld);",
			"}",

			"float tr = march(ror, rd);",
			"vec3 pr = uRo + rd * tr;",
			"ld = normalize(ror -pr);",
			"if(tr < uFar){",
				"col += vec3(0., 1., 1.) * shade(rd, pr, ld);",
			"}",

            "gl_FragColor = vec4(col, 1.0);",
        "}"
,
	].join("\n")

};
