pico-8 cartridge // http://www.pico-8.com
version 37
__lua__
ticks = 0
state="logon_screen"

function _init()
 memcpy(default_sprite, 0x0, sprite_size)
 reload(xp_sprite, 0x0, sprite_size, "xp.p8")
 reload(logon_sprite, 0x0, sprite_size, "logon.p8")
end

function _draw()
 if (state != "scroller_transition" and state != "outro") cls()
 
 if state == "logo" then
  draw_fx()
 end
 
 if state == "plasma" then
  draw_plasma()
 end
 
 if state == "scroller" then
  draw_fx()
  draw_scroller()
 end
 
 if state == "plasma_transition" then
  draw_plasma_trans()
 end
 
 if state == "scroller_transition" then
  scroller_trans_draw()
  draw_fx()
 end
 
 if state == "start_screen" then
  start_screen_draw()
 end
 
 if state == "logon_screen" then
  logon_screen_draw()
  draw_fx()
 end
 
 if state == "rectangles" then
  draw_rechtecke()
 end
 
 if state == "circles" then
  tunnel()
 end
 
 if state == "spiral" then
  spiral()
  draw_fx()
 end
 
 if state == "outro" then
  outro_draw()
  draw_fx()
 end
end

function _update60()
 ticks += 1
 
 if state == "plasma" then
  update_plasma()
 end
 
 if state == "logo" then
  update_fx()
 end
 
 if state == "scroller" then
  update_scroller()
  update_fx()
  update_circles()
 end
 
 if state == "plasma_transition" then
  update_plasma_trans()
 end
 
 if state == "scroller_transition" then
  scroller_trans_update()
  update_circles()
  update_fx()
 end
 
 if state == "start_screen" then
  start_screen_update()
 end
 
 if state == "logon_screen" then
  logon_screen_update()
  update_fx()
 end
 
 if state == "spiral" then
  update_fx()
 end
 
 if state == "outro" then
  outro_update()
  update_fx()
 end
end

-->8
-- effects

effects = {}

function add_fx(x,y,die,dx,dy,grav,grow,shrink,r,c_table)
 local fx={
  x=x, -- x
  y=y, -- y
  t=0, -- ticks alive
  die=die, -- lifetime 
  dx=dx, -- x motion
  dy=dy, -- y motion
  grav=grav, -- gravity
  grow=grow, -- if particle should grow
  shrink=shrink, -- if particle should shrink
  r=r, --radius
  c=0, -- current color
  ctable=c_table -- color table
 }
 
 add(effects, fx)
end

function update_fx()
 for fx in all(effects) do
  -- lifetime
  fx.t += 1
  if (fx.t > fx.die) del(effects, fx)
 
  -- color changing
  fx.c = fx.ctable[
   flr(lerp(
    1,
    #fx.ctable+1,
    fx.t/fx.die
   ))
  ]
 
  -- physics
  if (fx.grav) fx.dy += 0.1
  if (fx.grow) fx.r += 0.1
  if (fx.shrink) fx.r -= 0.1
 
  fx.x += fx.dx
  fx.y += fx.dy
 end
end

function draw_fx() 
 for fx in all(effects) do
  if fx.r == 1 then
   pset(fx.x, fx.y, fx.c)
  else
   circfill(fx.x, fx.y, fx.r, fx.c)
  end
 end
end
-->8
-- plasma

palette = {}
orig_palette = {3,8,9,10,11,12,14,129,135,137,138,139,140,129}
alt_palette = {0,139,139,139,0,139,139,139,0,139,139,139}

plasma = {}
lohl = 0
margin = 30
speed = 5
plasma_dur = 300
plasma_ticks = 0

function init_plasma()
 -- initialise array
 for y=margin,128-margin do
  plasma[y] = {}
 end
 
 generate_plasma()
 load_sprite(xp_sprite)
 music(0)
end

function generate_plasma()
	for iy=margin,128-margin do
  -- clear this row
  plasma[iy] = {}
  
  for ix=margin,128-margin do
   y = iy * lohl
   x = (ix * lohl) + (plasma_ticks * speed)
	  
   sine = 0
   + sin(x/160) + cos(y/220) * lohl
   + sin(y/360) * sin(t())
   // + sin(x/160+t()/2)+cos(y/220)+sin((x/120)/2)*16
   // + sin(x/160+t()/2)+cos((y/220))*16
   // + (sin(x/160+t()/2)+cos(y/220)+sin(x/120)/2)*16
   // + sqrt(x*x+y*y) * lohl
   // + sqrt((x-4)*(x-4)+(y-4)*(y-4))
   // + (sin(x/160+t()/2)+cos(y/220))*16
	  
	  plasma[iy][ix] = sine
	 end
	end
end

function get_color(sine)
 while (sine > 1) sine-=2
 while (sine < -1) sine+=2

 sine = (sine+1)/2

 return palette[
	        flr(lerp(1, #palette, sine))
	       ]
end

function update_plasma()
 generate_plasma()
 
 if (plasma_ticks==0) init_plasma()
 
 if (stat(53)+1)%8==0 then
  palette = alt_palette
 else
  palette = orig_palette
 end
 // palette = cylce_list(palette)

 if plasma_ticks<plasma_dur then
  lohl = flr(lerp(16, 24, (sin(t()/2)+1)/2))
  lohl /= 8
  
  speed = lerp(1, 10, (sin(t())+1)/2)
 else
  lohl -= 0.1
  speed -= 0.1
  if (lohl<=0) state = "plasma_transition"
 end
end

function draw_plasma()
 plasma_ticks += 1

 sspr(0, 0, 128, 128, 0, 0)

	for x=margin,128-margin do
	 for y=margin,128-margin do
   pset(x, y, get_color(plasma[y][x]))
	 end
	end
end

-->8
-- scroller
msg = "greetings to @monotoni from nogapnobacteria"
scroll_speed = 0.5
height = 5
scroll_y = 60
x_add = 0
scroller_ticks = 0
scroll_palette = {8,9,10,136,137,14}
scroller_music_cylces = 0

function init_scroller()
 add_spawner(
  -10,
  30,
  2,
  0,
  {12,13,14,11,2},
  6
 )
 
 add_spawner(
  -10,
  90,
  2,
  0,
  {5,8,3,15},
  6
 )
 
 music(17)
end

function draw_scroller()
 -- no black
 // pal(0, 138)

 if (scroller_ticks<60) return

 end_x = (127+x_add-time()*30)+(#msg*4)
 if end_x < 0 then
  x_add += 127
  x_add += #msg*4
 end

 cindex = 1

 min_h = 100
 max_h = 0

 for i=1, #msg do
  letter = sub(msg, i, i)
  t = time() + (0.1*i)
  x = 127+x_add-time()*30
  
  h = scroll_y+sin(t*scroll_speed)*height
  
  if (letter==" ") cindex+=1
  c = scroll_palette[cindex]
  
  if (letter == " ") cindex+=1
  if (cindex>#scroll_palette) cindex=1
  
  print(letter, x+i*4, h, c)
  if (stat(53)-2)%4==0 then
   print(letter, x+i*4, (scroll_y+sin(t*scroll_speed)*height)+1, c)
  	print(letter, x+i*4, (scroll_y+sin(t*scroll_speed)*height)+2, c)
  end
 end
end

function update_scroller()
 if (scroller_ticks==0) init_scroller()
 scroller_ticks += 1

 x = rnd(127)
 dx = x > 64 and 2 or -2

 if (stat(53)==31-scroller_music_cylces) scroller_music_cylces += 1

 if (scroller_music_cylces>3 and stat(53)==31) switch("circles")
 if (scroller_ticks<180) return

 -- stars
 add_fx(
  x,
  rnd(25),
  60,
  dx,
  0,
  false,
  false,
  false,
  1,
  {10}
 )
 
 -- stars
 add_fx(
  x,
  rnd(25)+100,
  60,
  dx,
  0,
  false,
  false,
  false,
  1,
  {10}
 )
 
 if (scroller_ticks<360 or true) return
 
 -- konfetti
 if (stat(53)-2)%4==0 then
	 add_fx(
	  0,
	  85,
	  75,
	  rnd(0.5)+0.5,
	  -3,
	  true, 
	  false,
	  false,
	  1,
	  {8,9,10,12,14}
	 )
	end
 
 -- konfetti
 if stat(53)%4==0 then
	 add_fx(
	  127,
	  85,
	  75,
	  rnd(0.5)-1,
	  -3,
	  true, 
	  false,
	  false,
	  1,
	  {135,136,137,142,143}
	 )
	end
end
-->8
-- circles

circle_spawner = {}
circ_speed = 10
lifetime = 300

function add_spawner(x, y, dx, dy, c_table, radius)
 local spawner = {
  x=x,	-- x
  y=y, -- y
  dx=dx, -- x motion
  dy=dy, -- y motion
  c=c_table, -- color table
  r=radius, -- radius (height/width)
  ci = 1, -- color index (in c)
  t=0 -- ticks alive
 }
 
 add(circle_spawner, spawner)
end

function update_circles()
 for cs in all(circle_spawner) do
  cs.t += 1

  c_table = {}
  c = cs.c[cs.ci]  
  if ((stat(53)-2)%4==0) c = 0
  add(c_table, c)  
 
  add_fx(
   cs.x,
   cs.y,
   lifetime,
   cs.dx,
   cs.dy,
   false,
   false,
   false,
   cs.r,
   c_table
  )
  
  if ticks%circ_speed==0 then
   cs.ci += 1
   if (cs.ci > #cs.c) cs.ci=1
  end
 end
end
-->8
-- plasma transition

trans_ticks = 0
trans_margin = 0
trans_color = 0

function init_plasma_trans()
 trans_margin = margin
 trans_color = 129
 music(-1)
end

function update_plasma_trans()
 if (trans_ticks==0) init_plasma_trans()
 trans_ticks += 1
 
 if (trans_ticks > 60) trans_margin -= 0.5
 
 if (trans_margin > 0) sfx(41)
 
 if trans_margin == 0 then
  music(49)
  sfx(-1)
 end 
 
 if (trans_margin < -200) scroller_trans("start_screen", default_sprite, 12)
end

function draw_plasma_trans()
 if trans_margin > 0 then
  sspr(0, 0, 128, 128, 0, 0)
  rectfill(trans_margin, trans_margin, 128-trans_margin, 128-trans_margin, trans_color)
 else
  if trans_margin < -80 then
   screen_shake()
   sfx(41)
  end
 
  cls(129)
  print("a problem has been detected!",0,0,7)
  print("please reboot your device.")
  print("")
  print("this demo is too badass")
  print("for this computer")
  print("if the problem persists")
  print("ask the creators to be less cool")
  print("")
  print("check with your hardware")
  print("and bios or press f8")
  print("")
  print("technichal information:")
  print("")
  print("*** stop: 0x0000007e")
  print("")
  print("*** pico-8.sys")
  print("")
  print("beginning dump of")
  print("physical memory")
 end
end
-->8
-- scroller transition

scroller_trans_ticks = 0
scroller_target = ""
scroller_color = 0

function scroller_trans(target, sprite, col)
 state = "scroller_transition"
 scroller_target = target
 load_sprite(sprite)
 scroller_color = col
end

function scroller_trans_update() 
 scroller_trans_ticks += 1

 if (scroller_trans_ticks % 5 != 0) return

 y = (scroller_trans_ticks * 4)-20
  
 add_spawner(
  -10,
  y,
  4,
  0,
  {0},
  10
 )
 
 if scroller_trans_ticks > 75 then
  deli(circle_spawner, 1)
 end
end

function scroller_trans_draw()
 if scroller_trans_ticks>75 then 
  -- draw new sprite in background
  if scroller_color == nil then
   sspr(0,0,128,128,0,0)
  else
   cls(scroller_color)
  end
 end

 if scroller_trans_ticks>150 then 
  -- clear arrays for better performance
  scroller_trans_ticks=0
  circle_spawner = {}
  effects = {}
  state = scroller_target
 end
end

-->8
-- start screen

start_screen_ticks = 0
start_screen_dur = 400

min_x = 37
max_x = 83
loading_x = 35
width = 7

function start_screen_update()
  -- init
  if (start_screen_ticks==0) load_sprite(startup_sprite)
  
  start_screen_ticks += 1

  if start_screen_ticks==60 then
   music(50)
  end

  loading_x += 1
  if (loading_x > max_x) loading_x = min_x
  
  if (start_screen_ticks>start_screen_dur) state="scroller"
end

function start_screen_draw()
 cls(12)
 sspr(0, 0, 58, 30, 64-(58/2), 64-(30/2))
 print("loading...", 40, 85, 7)
 rect(min_x-2, 95, max_x+2, 102, 7)
 
 rectfill(max(loading_x, min_x), 97, min(loading_x+width, max_x), 100, 1)
 
 if loading_x+2<=max_x then
  line(loading_x+2, 97, loading_x+2, 100, 12) 
 end
 
 if loading_x+5<=max_x then
  line(loading_x+5, 97, loading_x+5, 100, 12) 
 end
end
-->8
-- logon screen

logon_screen_ticks = 0
plus_ticks = 0
plus_msg = ""
next_plus = 50+rnd(60)

function init_logon_screen()
  music(50)
  load_sprite(logon_sprite)
end

function logon_screen_update()
 logon_screen_ticks += 1
 plus_ticks += 1
 
 if (logon_screen_ticks==1) init_logon_screen()
 
 if logon_screen_ticks > 260 then
  music(51)
  scroller_trans("plasma", xp_sprite)
 end
 
 if plus_ticks>next_plus and #plus_msg<4 then
  plus_msg ..= "+"
  plus_ticks = 0
  next_plus = rnd(60)
 end
end

function logon_screen_draw()
 sspr(0, 0, 128, 128, 0, 0)
 
 print(plus_msg,95,54,0)
end
-->8
-- outro

outro_text={"we are first time", "demoparty visitors", "and made this in", "the last two weeks", "hoped you enjoyed it!"}
credits={"","code", "impaulsible", "music & sounds", "femtastic", "sfx & concept", "kalinus"}
outro_y = 127
outro_ticks = 0
outro_speed = 0.25
solitaire = false
last_y = 0
is_over = false
logo = {
 x=64,
 y=64,
 dx=-0.5,
 dy=0.5,
 sx=60,
 sy=1,
 sw=38,
 sh=30,
 scale=1,
 gravity=0.1
}

function init_outro()
 effects = {}
 circle_spawner = {}

 pal()

 i = 0

 for l in all(outro_text) do
  print(l, 64-((#l*4)/2), i, 9)
  print(l, 64-((#l*4)/2), i+1, 10)
  
  i += 6
 end

 for l in all(credits) do
  c1 = (i/6)%2==0 and 129 or 3
  c2 = (i/6)%2==0 and 140 or 11
 
  print(l, 64-((#l*4)/2), i, c1)
  print(l, 64-((#l*4)/2), i+1, c2)
  
  i += 6
 end
 
 memcpy(font_sprite, 0x6000, 0x1fff) 
 cls()
end

function outro_update()
 outro_ticks += 1

 outro_y -= outro_speed
 
 logo.x += logo.dx
 logo.y += logo.dy
 
 if last_y==-20 then
  cls()
  solitaire = true
  
  logo.sx = 60
  logo.sy = 1
  logo.sw = 38
  logo.sh = 30
  logo.dy = 5
  logo.scale = 1
 end
 
 if (solitaire) logo.dy += logo.gravity
 
 if (is_over and stat(53)==31) stop()
end

function outro_draw()
 if solitaire then
  for i=1,1000 do
   -- don't clear edges
   x = rnd(123) + 2
   y = rnd(123) + 2
   
   pset(x,y,0)
  end
  
  rectfill(127-2,0,127,127,0)
  rectfill(0,0,2,127,0)
  rectfill(0,127-2,127,127,0)
  rectfill(0,0,127,2,0)
 else
  cls()
 end

 if (outro_ticks<=1) init_outro()

 load_sprite(default_sprite)
 
 if logo.x+(logo.sw/logo.scale)>127 and not is_over then
  -- right edge
  logo.dx = -logo.dx
  rectfill(127-2,0,127,127,6)
  
  if solitaire and logo.dy<=0.1 then
   explosion(logo.x,logo.y)
   logo.scale = 0
  end
 end
 
 if logo.x<0 and not is_over then
  -- left edge
  logo.dx = -logo.dx
  rectfill(0,0,2,127,6)
  
  if solitaire and logo.dy<=0.1 then
   explosion(logo.x,logo.y)
   logo.scale = 0
   is_over = true
  end
 end

 if logo.y+(logo.sh/logo.scale)>127 and not is_over then
  -- bottom edge
  logo.dy = -logo.dy
  rectfill(0,127-2,127,127,6)
  
  if solitaire then
   logo.dy /= 1.5
   if (logo.dy>-1) logo.dy = 0
   logo.y += logo.dy
  end
 end

 if logo.y<0 and not is_over then
  -- top edge
  logo.dy = -logo.dy
  rectfill(0,0,127,2,6)
 end
 
 sspr(
      logo.sx, -- sx
      logo.sy, -- sy
      logo.sw, -- sw
      logo.sh, -- sh
      logo.x, -- dx
      logo.y, -- dy
      logo.sw/logo.scale, -- dw
      logo.sh/logo.scale -- dh
     )
 
 load_sprite(font_sprite)

 i = 0
 
 lines = {}
 
 foreach(outro_text, function(t) add(lines,t) end)
 foreach(credits, function(t) add(lines,t) end)
 
 last_y = outro_y
 
 for l in all(lines) do
  y = last_y + 6
 
  if last_y<64 then
   sc = lerp(25,150,last_y/64)/100
  else
   sc = lerp(150,25,(last_y-64)/64)/100  
  end
 
  y += 6*sc

  if y<0 then
   last_y += 6
   goto continue
  end

  last_y = y

  sspr(
       0, --sx
       i, -- sy
       128, -- sw
       6, -- sh
       0, -- dx
       last_y, -- dy
       128, -- dw
       6*sc -- dh
      )

  ::continue::
  i += 6
 end
end
-->8
-- other stuff

sprite_size = 0x1fff
default_sprite = 0x8000
xp_sprite = 0x8000 + sprite_size
logon_sprite = 0x8000 + (sprite_size * 2)
-- start of the area where the font is stored
font_sprite = 0x8000 + (sprite_size * 3)

blue_pal   = {1,12,131,140,1,12,131,140,1,12,131,140,1,12,131,140}
red_pal    = {2,8,130,136,142,2,8,130,136,142,2,8,130,136,142,2}
green_pal  = {3,11,138,139,3,11,138,139,3,11,138,139,3,11,138,139}
yellow_pal = {9,10,135,137,9,10,135,137,9,10,135,137,9,10,135,137}

function apply_pal(p)
 p %= 4

 if p == 1 then
  pal(green_pal, 0)
 elseif p == 2 then
  pal(green_pal, 0)
 elseif p == 3 then
  pal(yellow_pal, 0)
 else
  pal(yellow_pal, 0)
 end
end

function sleep(s)
 for i = 1, s*60 do
  flip()
 end
end

function lerp(a, b, t)
	return a + (b-a)*t
end

function ease_in(t)
 return t*t
end

function ease_out(t)
 return 1 - (1-t)*(1-t)
end

function cycle_list(list)
 add(list, deli(list, 1))
 return list
end

function load_sprite(sprite)
 memcpy(0x00, sprite, sprite_size)
end

function screen_shake()
 camera(2-rnd(4), 2-rnd(4))
end

function fire()
 for i=0, 3 do
  add_fx(
   60+rnd(5)-2.5,
   60,
   30+rnd(15),
   0,
   -0.5,
   false,
   false,
   true,
   2,
   {8, 9, 10, 6, 6, 6}
  )
 end
end

function explosion(x,y)
 for i=1,30 do
  add_fx(
  x,
  y,
  60,
  rnd(3)-1.5,
  rnd(3)-1.5,
  false,
  false,
  true,
  5,
  {7, 8, 9, 10}
 )
 end
end

-->8
-- geklaute sachen

switch_state = true
switches = 0

-- borrowed from https://demobasics.pixienop.net/tweetcarts/pixtunnel
-- credits to daniel oaks (@pixienop)
function tunnel()
 st=time()/2
 
 for i=1,250 do
  st -= .001 + sin(st/5) * .003
  circ(64+sin(st) * 30,64 + cos(st)*30,i/2,(i*.044-time()*10)%11+1)
 end
 
 if (stat(53) == 1) switch_state = true
 if stat(53) == 31 and switch_state then
  switch("rectangles")
 end
end

c_rechtecke={0,1,2,8,14,15,7}

-- borrowed from https://demobasics.pixienop.net/tweetcarts/squaretunnel
-- credits to luca harris (@lucatron_)
function draw_rechtecke()
 function f(i)
  return c_rechtecke[flr(1.5+abs(6-i%12))]
 end

 fillp(0xa5a5)

 for w=3,68,.1 do
  a=4/w+time()/4
  k=145/w
  x=64+cos(a)*k
  y=64+sin(a)*k
  i=35/w+2+time()*3
  rect(x-w,y-w,x+w,y+w,f(i)*16+f(i+.5))
 end
 
 if (stat(53) == 1) switch_state = true
 if stat(53) == 31 and switch_state then
  switch("circles")
 end
 
 fillp()
end

function switch(s)
 switch_state = false
 switches += 1
  
 if switches > 4 then
  state = "outro"
 else
  state = s
 end
 
 apply_pal(switches)
end

pi=3.414592653
angle = -pi

function spiral()
  if (ticks%1!=0) return

  angle += 0.05
  if (angle>pi) angle=-pi

  x = cos(angle)
  y = sin(angle)
 
  add_fx(
   64,
   64,
   100,
   x,
   y,
   false,
   false,
   true,
   5,
   {1,2,3}
  )
  
  add_fx(
   64,
   64,
   100,
   -x,
   -y,
   false,
   false,
   true,
   5,
   {1,2,3}
  )
end
__gfx__
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000088000000000000000000000000000000000000000000888888888880000000000000000000000000000000000000000000
00000000000000000000000000000888880000000000000000000000000000000000000888888888888888880000000000000000000000000000000000000000
00000000000000000000000000008888888803000000000000000000000000000000088888888888888888888800000000000000000000000000000000000000
00000000000000000000000000008888888803300000300000000000000000000008888888888888888888888888000000000000000000000000000000000000
00000000000000000000000000088888888803330033300000000000000000000088888888888888888888888888800000000000000000000000000000000000
00000000000000000000000000088888888033333333300000000000000000008888888888888888888888888888888000000000000000000000000000000000
00000000000000000000000000888888888033333333000000000000000000088888889999999998889998888899988800000000000000000000000000000000
00000000000000000000000000880088888033333333000000000000000000088888899999999998899998888999988800000000000000000000000000000000
00000000000000000000000000001100888033333330000000000000000000888888999999999998999999889999988880000000000000000000000000000000
00000000000000000000000000011111000000333330000000000000000008888888aaaaaaaa9988aa999988aa99988888000000000000000000000000000000
0000000000000000000000000011111111090003330000000000000000000888888aaaaaaaaa9888aaa9998aaa99888888000000000000000000000000000000
0000000000000000000000000011111111099000009000000000000000008888888aaaaaaaa98888aaa999aaaa98888888800000000000000000000000000000
0000000000000000000000000111111111099900999000000000000000008888888aaa9999988888aaa999aaa988888888800000000000000000000000000000
0000000000000000000000000111111110999999999000000000000000008888888aaa9999999988aaa9aaaa9988888888800000000000000000000000000000
0000000000000000000000001111111110999999990000000000000000008888888aaa9999999998aaaaaaa99888888888800000000000000000000000000000
0000000000000000000000001100111110999999990000000000000000008888888aaaaaaaa99998aaaaaaa99888888888800000000000000000000000000000
0707070707070707070700000000001110999999900000000000000000008888888aaaaaaaaa9998aaaaaa999988888888800000000000000000000000000000
0070707070707070707000000000000000009999900000000000000000008888888aaaaaaaaa9998aaaaaaa99998888888800000000000000000000000000000
0000000000000000000000000000000000000999000000000000000000008888888888999aaa9998aaaaaaa99999888888800000000000000000000000000000
0700000000000707000000000007000000000000000000000800808880000888888889999aaa9998aaa9aaaa9999988888000000000000000000000000000000
0700000700000700000000000007000000000000000000000088008080000888888899999aaa9998aaa999aaa999988888000000000000000000000000000000
07000007000007070700000000070000000000000000007700880088800000888889aaaaaaaa9988aaa998aaaa99988880000000000000000000000000000000
0770007770007707077777007777007770070007000707000800808000000008888aaaaaaaaa9888aaa9888aaa99888800000000000000000000000000000000
0070007070007007070007077077077077070077700707000000000000000008888aaaaaaaa98888aa988888aa98888800000000000000000000000000000000
00700070700070070700070700070700070770707077077700000000000000008888888888888888888888888888888000000000000000000000000000000000
00770770770770070700070700070700070070707070000700000000000000000888888888888888888888888888800000000000000000000000000000000000
00077700077700070700070770770770770077707770000700000000000000000008888888888888888888888888000000000000000000000000000000000000
00007000007000070700070077700077700007000700077000000000000000000000088888888888888888888800000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000888888888888888880000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000888888888880000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00099999999900000000000000000000000000000000000009990000000000000000000000000000000000000000000000000000000000000000000000000000
00999999999900000000000000000000000000000000000099990000000000000000000000000000000000000000000000000000000000000000000000000000
099999999999000000000000000000000000000000000009aa999900000000000000000000000000000000000000000000000000000000000000000000000000
0aaaaaaaa990000000000000000000000999000000000099aa999900000000000000000000000000000000000000000000000000000000000000000000000000
aaaaaaaaa9000000000000000000000099990000000000aaaaaa9900000000000000000000000000000000000000000000000000000000000000000000000000
aaaaaaaa900000000000000000000000aa990000000000aaaaaa9000000000000000000000000000000000000000000000000000000000000000000000000000
aaa99999000000000999990009999990aa90009999999990aa990000000000000000000000000000000000000000000000000000000000000000000000000000
aaa999999990000099999900999999909999099999999990aa990000000000000000000000000000000000000000000000000000000000000000000000000000
aaa9999999990009aaaa9909aaaaa990aa990aaaaaaaa990aa990000000000000000000000000000000000000000000000000000000000000000000000000000
aaaaaaaa9999009aaaaa900aaaaaa900aa990aaaaaaaa990aa990000000000000000000000000000000000000000000000000000000000000000000000000000
aaaaaaaaa99909aaa900000aaa900000aa990aa9900aa990aa990000000000000000000000000000000000000000000000000000000000000000000000000000
aaaaaaaaa9990aaa9000000aa9900000aa990aa9900aa990aa990000000000000000000000000000000000000000000000000000000000000000000000000000
000999aaa9990aa99000000aa9900000aa990aa9900aa990aa990000000000000000000000000000000000000000000000000000000000000000000000000000
009999aaa9990aa99900000aa9900000aa990aa9999aa990aa999990000000000000000000000000000000000000000000000000000000000000000000000000
099999aaa9990aaa9999990aa9900000aa990aa9999aa990aaa99990000000000000000000000000000000000000000000000000000000000000000000000000
9aaaaaaaa99000aaa999990aa9900000aa990aaaaaaaa990aaaaa990000000000000000000000000000000000000000000000000000000000000000000000000
aaaaaaaaa900000aaaaa990aa9900000aa990aaaaaaaa9900aaaa900000000000000000000000000000000000000000000000000000000000000000000000000
aaaaaaaa00000000aaaa900aa9000000aa900aa99000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000aa99000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000aa99000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000aa99000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000aa99000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000aa99000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0000000000000000000000000000000000000aa90000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00999000009990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
09999000099990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
99999900999990000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
aa999900aa9990099900000009990000000999009990000000000000000000000000000000000000000000000000000000000000000000000000000000000000
aaa9990aaa9900999900000099990000009999099990000000000000000000000000000000000000000000000000000000000000000000000000000000000000
aaa999aaaa9000aa99000000aa99000000aa990aa990000000000000000000000000000000000000000000000000000000000000000000000000000000000000
aaa999aaa90000aa90000000aa99000000aa990aa900009999999000999999990000000000000000000000000000000000000000000000000000000000000000
aaa9aaaa9900009999000000aa99000000aa99099990099999999909999999990000000000000000000000000000000000000000000000000000000000000000
aaaaaaa9900000aa99000000aa99000000aa990aa9909aaaaaa9990aaaaaaa990000000000000000000000000000000000000000000000000000000000000000
aaaaaaa9900000aa99009999aa99009999aa990aa990aaaaaaaa990aaaaaaa900000000000000000000000000000000000000000000000000000000000000000
aaaaaa99990000aa99099999aa99099999aa990aa990aa9999aa990aa99999990000000000000000000000000000000000000000000000000000000000000000
aaaaaaa9999000aa990aaaaaaa990aaaaaaa990aa990aa9999aa990aa99999990000000000000000000000000000000000000000000000000000000000000000
aaaaaaa9999900aa990aaaaaaa990aaaaaaa990aa990aaaaaaaa900aaaaaaa990000000000000000000000000000000000000000000000000000000000000000
aaa9aaaa999990aa990aa990aa990aa990aa990aa990aaaaaaa0000aaaaaaa990000000000000000000000000000000000000000000000000000000000000000
aaa999aaa99990aa990aa999aa990aa999aa990aa990aa99999900099999aa990000000000000000000000000000000000000000000000000000000000000000
aaa990aaaa9990aa990aa999aa990aa999aa990aa990aa99999990099999aa990000000000000000000000000000000000000000000000000000000000000000
aaa9000aaa9900aa990aaaaaaa990aaaaaaa990aa990aaaaaaaa900aaaaaaa990000000000000000000000000000000000000000000000000000000000000000
aa900000aa9000aa900aaaaaaa900aaaaaaa900aa9000aaaaaa9000aaaaaaa900000000000000000000000000000000000000000000000000000000000000000
__label__
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cc7cc7cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccc77ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccc77ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccc7cccccccccccccccccccccccccccccc777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccc7cccc77777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccc7cccc777777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccccccc7777777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccccccc777777777c7cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccc7777777c7ccc77cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccccc777777c77cccccccccccccc777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccccccccc77777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccccccc77777777777777cccccccccccc77cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccc77777777777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccc77777777777777777777777ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccc7777777777777777777777777777c7ccc77cccccccccccccc7cccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccc7777777777777777777777777cccccccccccccccccccccccc77ccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccc777777777777777777777777cccccccccc7cccc7ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccc777777777777777777777c7cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
cccccccccccccccccccccccccccc7777777777777777777777ccccccccccccccccccccccccccccc77ccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccccccc77777777777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccccccccccccc77777777777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccc88ccccccccccccccccccccccccccccccccc7777777cccccccccccccccccccccc7cccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccccc88ccccccccccccccccccccccccccccccccccc7777cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
ccccc9977ffccccccccccccccccccc111111111111111111111111111111111111111111111111111111111111111111111ccccccccccccccccccccccccccccc
ccccc9977ffcccccccccccccccccc11177777117171771777177171717177177111117711717717117111111111111117871cccccccccccccccccccccccccccc
cccaa777777eecccccccccccccccc11177777117711711777171771771177117111117171717177171171111111111118781cccccccccccccccccccccccccccc
cccaa777777eecccccccccccccccc11177777117171711717171171717177171177717711717117117711111111111117871cccccccccccccccccccccccccccc
ccccc3377ddcccccccccccccccccc11111111111111111111111111111111111111111111111111111111111111111111111cccccccccccccccccccccccccccc
ccccc3377ddcccccccccccccccccc1777777779999999aaaaaabbbbbbb333333333333333333333333bbbbbaaaa9999777e1cccccccccccccccccccccccccccc
ccccccc11cccccccccccccccccccc177777777779999999aaaaaabbbbbbb333333333333333333333bbbbbaaaa9999777ee1cccccccccccccccccccccccccccc
ccccccc11cccccccccccccccccccc1eeee77777777999999aaaaaaabbbbbbb33333333333333333bbbbbbaaaa9999777eee1cccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccc1eeeeeee7777777999999aaaaaabbbbbbbbbb3333333333bbbbbbbaaaaa9999777eeec1cccccccccccccccccccccccccccc
ccccccccccccccccccccccccccccc1eeeeeeeee7777777999999aaaaaabbbbbbbbbbbbbbbbbbbbbbbbaaaaa9999777eeeec1cccccccccccccccccccccccccccc
ccccccccccceeeccccccccccccccc1cceeeeeeeee7777779999999aaaaaaabbbbbbbbbbbbbbbbbbbaaaaaa9999777eeeecc1cccccccccccccccccccccccccccc
cccccccccceeeeecccccccccccccc1ccccceeeeeeee777777999999aaaaaaaabbbbbbbbbbbbbbaaaaaaa999997777eeeccc1ccccccc777cccccccccccccccccc
cccccccccceeeeecccc77777777cc1cccccccceeeeeee777777999999aaaaaaaaaaabbbbbaaaaaaaaaa999997777eeecccb1cccccccccccccccccccccccccccc
cccccccccceeeeeccc777777777771cccccccccceeeeeee777777999999aaaaaaaaaaaaaaaaaaaaaa999997777eeeecccbb1cccccccccccc7ccccccccccccccc
cccceeeeeeeeeeeccccc7777777771bbbbcccccccceeeeee77777799999999aaaaaaaaaaaaaaaaa9999997777eeeecccbbb1cccccccccccccc777ccccccccccc
ccceeeeeeeeeeeeccccccc77777771bbbbbbbccccccceeeeee777777999999999aaaaaaaaaaa999999997777eeeecccbbba1cccccccccccccccccccccccccccc
cccebeeebeeeecccccccccc7777771bbbbbbbbbccccccceeeeee77777799999999999999999999999977777eeeecccbbbba1cccccccccccccccccccccccccccc
cccebbebbeecccccccccccc7777771aabbbbbbbbbccccccceeeeee77777779999999999999999999777777eeeecccbbbbaa1ccccccccccccccccccccccccc7cc
cccebebebeeccccccccccccc777771aaaaabbbbbbbbcccccceeeeee77777777799999999999997777777eeeeecccbbbbaaa1cccccccccccccccccccccccccccc
cccebeeebeeccccccccccccc777771aaaaaaaabbbbbbbcccccceeeeee77777777777799977777777777eeeeecccbbbbaaa91cccccccccccccccccccccccccccc
ccceeeeeeeccccccccccccccc77771aaaaaaaaaabbbbbbbcccccceeeeeee777777777777777777777eeeeeccccbbbbaaa991cccccccccccccccccccccccccccc
ccceeeeeecccccccccccccccc777719999aaaaaaaabbbbbbcccccceeeeeeee77777777777777777eeeeeeccccbbbbaaa9991cccccccccccccccccccccccccccc
ccceeeeeccccccccccccccccccc7719999999aaaaaaabbbbbbcccccceeeeeeeeee7777777777eeeeeeecccccbbbbaaa99981cccccc7ccccccccccccccccccccc
ccccccccccccccccccccccccccccc1999999999aaaaaaabbbbbbcccccceeeeeeeeeeeeeeeeeeeeeeeecccccbbbbaaa999981cccccccccccccccccccccccccccc
cccaaaacccccccccccccccccccccc188999999999aaaaaabbbbbbcccccccceeeeeeeeeeeeeeeeeeeccccccbbbbaaaa999881cccccc7ccc777ccccccccccccccc
cccaaaacccccccccccccccccccccc18888899999999aaaaaabbbbbbcccccccceeeeeeeeeeeeeeeccccccbbbbbaaaa9998881ccccccc77ccccccccccccccccccc
ccca999aaaacccccccccccccccccc1888888899999999aaaaaabbbbbbcccccccccceeeeeeecccccccccbbbbbaaaa99988831cccccccccccccccccccccccccccc
ccca9a9aaaacccccccccccccccccc18888888888999999aaaaaabbbbbbbccccccccccccccccccccccbbbbbbaaaa999888331ccc777777777777ccccccccccccc
ccca999aaaacccccccccccccccccc1338888888889999999aaaaaabbbbbbbcccccccccccccccccccbbbbbaaaaa9998888331cc777777777777777ccccccccccc
ccca9aaaaaacccccccccccccccccc13333388888888999999aaaaaabbbbbbbbbcccccccccccccbbbbbbbaaaaa99988883331cc77777777777777777ccccccccc
ccccccccccccccccccccccccccccc1333333338888888999999aaaaaabbbbbbbbbbbccccccbbbbbbbbbaaaaa9999888333b177777777777777777777cccccccc
ccccccccccccccccccccccccccccc13333333333888888999999aaaaaaabbbbbbbbbbbbbbbbbbbbbbaaaaaa9999888333bb177777777777777777777cccccccc
ccccccc222ccccccccccccccccccc1bb3333333338888888999999aaaaaaabbbbbbbbbbbbbbbbbbbaaaaaa99998883333bb1777777777777777777777ccccccc
ccccccc22cccccccccccccccccccc1bbbbb33333333888888999999aaaaaaaabbbbbbbbbbbbbbbaaaaaa999998888333bbb1777777777777777777ccc77ccccc
cccc22222cccccccccccccccccccc1bbbbbbb33333338888889999999aaaaaaaaabbbbbbbbbaaaaaaaa999998888333bbba17777777777777777cccccccccccc
ccc222222cccccccccccccccccccc1bbbbbbbbb3333333888888999999aaaaaaaaaaaaaaaaaaaaaaaa9999988883333bbba1777777777777777ccccccccccccc
ccc282222cccccccccccccccccccc1bbbbbbbbbb33333338888889999999aaaaaaaaaaaaaaaaaaaaa9999988883333bbbaa177777ccccccccccccccccccccccc
ccc28222ccccccccccccccccccccc1aaabbbbbbbbb3333338888889999999aaaaaaaaaaaaaaaaaa99999988888333bbbaaa17777cccccccccccc7777777777cc
ccc28822ccccccccccccccccccccc1aaaaabbbbbbbb33333388888899999999aaaaaaaaaaaaaaa999999888883333bbbaaa1cccc77ccccccccc777777777777c
ccc22222ccccccccccccccccccccc1aaaaaaabbbbbbb3333338888889999999999aaaaaaaaa99999999888883333bbbaaa91ccccccc7cccccc7777777777cccc
ccccccccccccccccccccccccccccc1aaaaaaaabbbbbbb3333338888888999999999999999999999999888883333bbbbaaa91cccccccccccccc7777777777c77c
ccccccccccccccccccccccccccccc1aaaaaaaaabbbbbbb333333888888899999999999999999999998888883333bbbaaa991cc7ccccccc77c777777777777c7c
ccccccccccccccccccccccccccccc1aaaaaaaaaaabbbbbb3333338888888999999999999999999998888883333bbbbaaa991ccccccccccccccccc777777777cc
ccccc111ccccccccccccccccccccc1999aaaaaaaaabbbbbb333333888888899999999999999999988888833333bbbaaaa991cc777ccccccccccccc7777777ccc
cccc17771cccccccccccccccccccc19999aaaaaaaabbbbbbb3333338888888899999999999999988888883333bbbbaaa99917777777ccccccccccccccccccc77
ccc1171111ccccccccccccccccccc1999999aaaaaaabbbbbb3333333888888889999999999999888888833333bbbaaaa99917777777cccccccc777cc77ccc77c
ccc1177711ccccccccccccccccccc19999999aaaaaaabbbbbb33333388888888899999999999888888883333bbbbaaa999717777777ccccccc77777cc77777cc
ccc1111711ccccccccccccccccccc199999999aaaaaaabbbbbb3333338888888888999999988888888833333bbbbaaa99971777777777cccc77777777ccccccc
cccc17771cccccccccccccccccccc199999999aaaaaaabbbbbb333333388888888888888888888888833333bbbbaaaa999717777777777ccc777777777777ccc
ccccc111cccccccccbbbbbbbbbbbb1999999999aaaaaaabbbbbb33333388888888888888888888888833333bbbbaaaa9997177777777777cc7777777777777cc
cccccccccccbbbbbbbbbbbbbbbbbb1999999999aaaaaaabbbbbb33333338888888888888888888888833333bbbbaaa999771777777777777c7775555555777cc
ccccccccbbbbbbbbbbbbbbbbbbbbb19999999999aaaaaabbbbbb33333338888888888888888888888333333bbbbaaa999771777777777777cc55555555555ccc
ccccccc3bbbbbbbbbbbbbbbbbbbbb19999999999aaaaaaabbbbbb333333388888888888888888888833333bbbbaaaa9997717777777777cc5555555555555ccc
ccccc333bbbbbbbbbbbbbbbbbbbbb19999999999aaaaaaabbbbbb333333388888888888888888888833333bbbbaaaa999771777c77ccccc55555555555555555
cccc3333bbbbbbbbbbbbbbbbbbbbb199999999999aaaaaabbbbbb333333388888888888888888888833333bbbbaaaa999771777cc7ccc5555555555555555555
cc33333333bbbbbbbbbbbbbbbbbbb199999999999aaaaaabbbbbb333333388888888888888888888333333bbbbaaaa9997713333ccccc5555555555555555555
33333333333bbbbbbbbbbbbbbbbbb199999999999aaaaaabbbbbb333333388888888888888888888333333bbbbaaaa9997713333333335555555555555555555
3333333333333bbbbbbbbbbbbbbbb19999999999aaaaaaabbbbbb333333388888888888888888888833333bbbbaaaa9997713333333333333333333333555555
333333333333333bbbbbbbbbbbbbb19999999999aaaaaaabbbbbb333333388888888888888888888833333bbbbaaaa9997713333333333333333333333333333
33333333333333333bbbbbbbbbbbb19999999999aaaaaaabbbbbb333333888888888888888888888833333bbbbaaaa9997713333333333333333333333333333
333333333333333333bbbbbbbbbbb19999999999aaaaaabbbbbb33333338888888888888888888888333333bbbbaaa9997713333333333333333333333333333
33333333333333333333bbbbbbbbb1999999999aaaaaaabbbbbb33333338888888888888888888888833333bbbbaaa9997713333333333333333333333333333
3333333333333333333333bbbbbbb1999999999aaaaaaabbbbbb33333388888888888888888888888833333bbbbaaaa999713333333333333333333333333333
333333333333333333333333bbbbb199999999aaaaaaabbbbbb333333388888888888898888888888883333bbbbaaaa999713333333333333333333333333333
333333333333333333333333333bb19999999aaaaaaabbbbbbb3333338888888888999999988888888833333bbbbaaa999713333333333333333333333333333
333333333333333333333333333331999999aaaaaaaabbbbbb33333388888888899999999999888888883333bbbbaaa999913333333333333333333333333333
33333333333333333333333333333199999aaaaaaaabbbbbb3333338888888889999999999999888888833333bbbaaaa99913333333333333333333333333333
3333333333333333333333333333319999aaaaaaaabbbbbbb3333338888888999999999999999988888883333bbbbaaa99913333333333333333333333333333
33333333333333333333333333333199aaaaaaaaabbbbbbb333333888888899999999999999999998888833333bbbaaaa9913333333333333333333333333333
333333333333333333333333333331aaaaaaaaaabbbbbbb3333338888888999999999999999999999888883333bbbbaaa9913333333333333333333333333333
333333333333333333333333333331aaaaaaaaabbbbbbb333333888888899999999999999999999999888883333bbbaaa991bbbbb33333333333333333333333
333333333333333333333333333331aaaaaaaabbbbbbb333333888888999999999999aaa9999999999988888333bbbbaaa91bbbbbbbbbbbb3333333333333333
333333333333333333333333333331aaaaaaabbbbbbb333333888888999999999aaaaaaaaaaa9999999988883333bbbaaa91bbbbbbbbbbbbbbbbbbbb33333333
333333333333333333333333333331aaaaabbbbbbbb33333388888899999999aaaaaaaaaaaaaaa999999988883333bbbaaa1bbbbbbbbbbbbbbbbbbbbbbbbbbbb
3333333333333333333333333333311111111111111111111111111111111111111111111111111111111111111111111111bbbbbbbbbbbbbbbbbbbbbbbbbbbb
33333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
3333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
333333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
3333333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
3333333333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
33333333333333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb
3333333333333333333333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb3
3333333333333333333333333333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb3333
333333333333333333333333333333333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb3333333333
3336666666633333333333333333333333333333333333333333333333333333333333333333333333333333333333bbbbbbbbbbbb3333333333333333333333
33336636363333333333333333333333333333333333333333333333333333333333333333333333335555555555555555553333333333333333333333333333
33336363663333333335555555555555555555555555555555555555333333333333333333555555553333333333333333335555533333333333333333333333
33336636363335555555333333333333333333333333333333333335555555555555555555333333333333333333333333333333355533333333333333333333
33336763663555333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333355555333333333333333
55556676363333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333555553333333333
33336767663333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333335555555533
33336676763333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333355
33336767663333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333
33336666663333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333
33333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333
33333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333
33333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333
bbbbbbbbbbbbbb11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111bbbbbbbbbbbbbbbbbbb
bb8bbbb6b6b6bb11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111b22b0099bbedbed6b6b
bbcabb6b6b6bbb11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111b2bb0099bbdebdbb6b6
bbbbbbbbbbbbbb11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111bbbbbbbbbbbbbbbbb00

__sfx__
000100000705007050070500705008050080500a0500b0500d0500e05010050110501305016050170501a0501d0501f050220502505027050290502d050310503305035050370503805039050390503a0503a050
34010000080550f0500c0550605006055070500a05510050130551805011055160501705508050080550a05010055120500a05515050140550e0500d05513050170550c0500a0550d0500e0550b0500805507050
180f00000c056000000c006000000e056000000c0060000010056000000c0060000011056000000c006000000c056000000c006000000e05600000100060000010056000000c0060000011056000001100600000
00010000026500165000650006500065001650036500365004650056500665007650096500a6500b6500e6500f650126501465017650196501e6502165025650296502b6502f65035650396503e6503f6503f650
000100000245001450014500145001450014500145001450014500145001450024500245004450054500545007450094500c4500e4500f45014450174501b4501f45021450254502b4502f45034450394503f450
0001000000550005500155003550045500655007550095500a5500c5500e5500f550115501355016550185501a5501c5501e55020550225502455026550285502a5502d5502f55033550375503a5503c5503e550
00010000007500075001750037500575007750097500c7500f75010750127501575018750197501c7501d7502075022750237502575027750297502b7502d7502f75030750327503475037750397503b7503e750
011000000c6601a0600e6601c0600c6601d0600e6601c0600c6601a0600e6601c0600c6601d0600e6601c0600c6601a0600e6601c0600c6601d0600e6601c0600c6601a0600e6601c0600c6601d0600e6601c060
00140000280560000000000000002d0560000000000000002f056000000000000000280560000000000000002b0560000000000000002f0560000000000000002905600000000000000028056000000000000000
001400000907300000000000000004073000000000000000020730000000000000000907300000000000000000073000000000000000040730000000000000000a07300000000000000009073000000000000000
0014000024056000000000000000290560000000000000002c05600000000000000024056000000000000000280560000000000000002b056000000000000000260560000000000000002d056000000000000000
001400002b0560000000000000003005600000000000000032056000000000000000370560000000000000002f056000000000000000320560000000000000002d0560000000000000002b056000000000000000
00140000180501c0501205000000180501a0501c05017000180501c050120501f000180501a0501c05000000180501c05012050000001a0501f0502305024000180501f0501205000000180501a0501c05000000
001400001c0501f05016050000001c0501d0501f050000001c0501f05016050000001c0501f05016050000001c0501f05016050000001c0501f05026050000001c0502105016050000001c0501d0501f05000000
001400000c073000000000000000246130000000000000000c073000000000000000246130000000000000000c0730000000000000002461300000000000c0730000000000000002461300000000000000000000
011400000f445124351442516415194450f435124251441516435194250c0000c1451b541275460c1411b7410344506435084250a4150d4450343506425084150a44519435000001b145275460c5411b14125745
001400000f0151e52514015225250d0151b52512015205251602519515181001b1001b100181001b100191001b0151e5252002522525250151b5251e025205152201525525181001b1001b1000c1001b10025100
0114000025125271252a1252c1262e1252512527125001002a1252c1272e1252a1262e1252a1252c12524100251252a1252c1252e126251252712725125001002a1252a1252c1252e1262e125311253312524100
0114000025225272252a2252c2262e2252522527255004002a2252c2252e2252a2262e2252a2252c22524200252252a2252c2252e226252252722525225002002a2252a2252c2252e22525225272252a22500000
001400003a42731421334232440000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011400000d5741b575125751457616575195750f575005001e575145741657512576165751e575145750c500195751257514574165760d5751b5750d5750c500125751257514575165740d5751b5751257530500
001400000344506435084250a4150d4450343506425084150a4450d4350c0111b111275260c0111b111314150344506435084250a4150d4450343506425084150a4450d4350c1111b511275260c1111b51125715
011400000f015125251402516515190250f5251201514525160150d5250c1001b100271000c1001b100311000f015125251402516525190150f525120251451516015195250c1001b100271000c1001b10025100
0114000031725277351e74514736367252e7351b7450d7353a7252c7351e7450f73731725277351e7450000038745277351e72514736367452e7351b7250d7353a7452c7351e7250f737317452c7352272524700
001400000205300000266530000002053000002665324000020530000026653000000205300000266530000002053000002665300000020530000026653000000205300000266530000002053000002665300000
011400003372233722387223a7223372236722317523375230002337523373236732387323a7323373230002387323a732367323a722367223372231722367223000233752337323a73238732317323373200002
01140000000520000027653000000005200000276532400000052240002e6532400000052240001e653240000005224000276532400001052240002a6532400000052240002e6532400000052240002765300000
0114000019446274352a42527445194362a4252c4452e4352c4252a44527435194262a4452c43524405304052c4252e4452a43519426274452c4352a4252e4452c4352a42519446274352a425244053040030400
011400000307300000060730000308073000000307300700010730000303073000030607300000030730070003073000000607300003030730000003073007000007300003030730000306073000000307300700
011400002e555205551e5552c55527555255552a555205551e555205552755525555240001a5451a545180002e5552c5552a5552055527555255551e555205551e55520555275552555524000185451a54500000
011a00002e0552c055270552c05500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011a00001402500000000000302500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011a00000f02500000000001602500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
011a00000a02500005000000f02500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
0014000033055270552e055000052c05527055330552e055000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001400000505000000000000000008050000000000003050000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001400000c0500000000000000000f05000000000000a050000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
00140000110500000000000000001405000000000000f050000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
01140000337552a7552e7552c7562a7552775525755277552c7552775625755307553000034755357553070032755297552d7553775629755267552b755267552b75526756247553175530000307003375534755
001400001007300000266430000000000000002664300000100730000026643000000000000000266430000010073000002664300000000000000026643000001007300000266430000000000000002664300000
011400000007300000246130000000073000000000024000000730000024613000000007300000000000000000073000002461300000000730000000000000000007300000246130000000073000000000000000
010600001007010070100701007010070100701007010070100701007010070100701007010070100701007010070100701007010070100701007010070100701007010070100701007010070100701007010070
010d00000f6400e67010610106200c6300e65010660116700e620106300e6600f6700e6400f650106200c6300e660106700c6400e650106200e6300f6500e6600f670106400e6500f6500e6600f670106200e630
011000002c05527055330552e05500000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000805000000000000305000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000000f05000000000000a05000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
001000001405000000000000f05000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
__music__
01 280f1011
00 280f1012
00 280f1014
00 280f1617
02 0e1d1a1c
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
03 0e1d1a1c
03 0e0f1018
01 0e1d1a1c
01 0e1a1918
00 0e1b1a18
02 0e181a1c
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
03 26270e1c
01 0e0f1011
00 0e0f1012
00 0e0f1014
02 0e0f1017
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
04 1e1f2021
04 22232425
00 2b2c2d2e
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 41424344
00 07000406

