;                               _____
;                              / ___ \
; fischinger v0.1 by nikhotmsk  /_o_\
;
; Demoscene is alive. (2022.10.14 01:38 GMT+3)
;
; I give a permission for everyone who is interested, forever, to port this
; demo to other 8-bit platforms of any kind.
;
; use this command to compile this thing:
; wine ../../sjasmplus-1.18.3.win/sjasmplus.exe fischinger.asm --lst=fischinger.lst --sym=fischinger.sym
;
; run in emulator:
; wine ../../../unreal_speccy/us0.38.1/unreal.exe fischinger.tap
;

;
; message for humans. If you want to learn Z80 assembly language, try
; this tutorial: https://www.chibiakumas.com/z80
;

	DEVICE ZXSPECTRUM128
	org $8000
	
code_start:
	ld (saved_iy), iy ; save IY register, because it is needed for rst #10
code_again:
	di
	; TODO make sure keyboard keys are released
	
	ld hl, 0
	ld (frame_counter), hl
	ld hl, draw_text_empty_byte
	ld (draw_text_pointer), hl
	ld hl, drawing_code_vault
	ld (drawing_code_vault_running_w), hl
	; turbo sound setting should survive
	; TODO cancel pause
	
	ld a, 0
	out (#FE),A      ; border black
	ld HL, #5800
	ld BC, 768       ; set background to black
	ld D, 0b01000111 ; set ink to white
	call fill_mem
	
	ld hl, vars
	ld bc, erase_queue_end - vars
	ld d, 0
	call fill_mem ; clear variables
	
	;ld ix, vars     ; put four dots
	;ld de, 0x0202	;
	;ld (ix+0), de	;    A-------B
	;ld de, 0x0214	;    |       |
	;ld (ix+2), de	;    |       |
	;ld de, 0x1414	;    |       |
	;ld (ix+4), de	;    D-------C
	;ld de, 0x1402	;
	;ld (ix+6), de
	
	ld a,2
	call $1601 ; select S channel for text
	
	di
	ld hl, im2_interrupt_block ; prepare interrupt mode 2
	ld a, h
	ld i, a
	;ld bc, 257 ; size of interrupt block
interrupt_setup_loop:
	;ld (hl), $80
	;inc hl
	;dec bc
	;ld a, b
	;or c
	;jr nz, interrupt_setup_loop
	im 2
	
	call initSong
	ld a, (skip_intro_byte)
	or a
	call nz, rewind_music
	ei
	call clear_slow
	jp code_main
saved_iy:	WORD 0
	
	; ORG ahead, do not put extra code here, because not much space

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt routine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	org #8080 ; interrupt routine here
	push af
	;ld a, 0b00000111 ; border white
	;out (#fe), a
	push bc
	push de
	push hl
	push ix
	push iy
	
	; frame counter here
	ld hl, (frame_counter)
	inc hl ; normal flow
	ld (frame_counter), hl
	
	jp interrupt_routine_continue

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt table
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	org #8100 ; hardcoded interrupt table here
im2_interrupt_block:
	.257 BYTE #80 ; this is an interrupt table (size 257 bytes)
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; interrupt_routine_continue
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
interrupt_routine_continue:
	; read keyboard
	ld bc, #7ffe ; keys b,n,m,sym,space
	in a, (c)
	and 0b00000001
	jr nz, interrupt_routine_no_break_key
interrupt_routine_goto_code_again:
	call player+8 ; mute
	ld de, code_again ; when used many times it will break the stack, but I do not care
	push de
	; ei
	reti ; start the program from the beginning
interrupt_routine_no_break_key:
	ld bc, #fdfe ; keys g,f,d,s,a
	in a, (c)
	ld b, a
	and 0b0000010 ; the 's' key
	jr nz, interrupt_routine_no_s_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 0
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_s_key:
	ld a, b
	and 0b0000001 ; the 'a' key
	jr nz, interrupt_routine_no_a_key
	ld a, (turbosound_setting_byte)
	and 0b11101111 ; disable turbosound, thus making normal AY
	ld (turbosound_setting_byte), a
	ld a, 1
	ld (turbosound_flip_modules), a
	jr interrupt_routine_goto_code_again
interrupt_routine_no_a_key:

	; draw text here
	ld hl, (draw_text_pointer)
	ld a, (hl)
	cp '$'
	jr z, interrupt_no_draw_text
	ld b, 30 ; speed of text drawing here
interrupt_draw_text_cycle:
	ld a, (hl)
	cp '$'
	jr z, interrupt_draw_text_end
	ld iy, (saved_iy)
	rst #10 ; output char
	inc hl
	dec b
	jr nz, interrupt_draw_text_cycle
interrupt_draw_text_end:
	ld (draw_text_pointer), hl
interrupt_no_draw_text:

	; erase thing
	ld hl, (frame_counter)
	ld a, l
	and 1
	jp z, interrupt_routine_no_erase_this_time
	
	ld b, erase_queue_size
	ld ix, erase_queue
interrupt_c0:
	ld hl, (ix+0)
	ld a, h
	or l
	jr z, interrupt_skip0
	ld de, (ix+2)
	push bc
	ld b, 0 ; draw black
	call call_de
	pop bc
	ld hl, 0
	ld (ix+0), hl ; mark this entry as empty
	
interrupt_skip0:
	ld de, 6 ; [hl register] [drawing code] [ret patch]
	add ix, de
	dec b
	jr nz, interrupt_c0


interrupt_routine_no_erase_this_time:
	; and now draw some figurines
	ld b, shedule_size
	ld ix, shedule
interrupt_c1:
	ld hl, (ix+0) ; [hl register] [drawing code] [ret patch] [enable] [frame number]
	ld a, h
	or l
	jp z, interrupt_skip1
	ld de, (ix+7) ; target frame number
	ld hl, (frame_counter) ; i will restore hl back
	or a ; clear carry flag
	sbc hl, de
	add hl, de
	jp c, interrupt_skip1
	ld hl, (ix+0) ; restore hl back
	
	ld de, (ix+2) ; load drawing code
	push bc
	;ld a, 0b00000010 ; border red
	;out (#fe), a
	ld b, #ff
	call call_de ; run drawing code
	;ld a, 0b00000111 ; border white again
	;out (#fe), a
	;.16 call busy_wait
	pop bc
	
	push bc
	ld b, erase_queue_size ; move iy to empty entry in erase_queue
	ld iy, erase_queue
interrupt_find_empty_c1:
	ld de, (iy+0)
	ld a, d
	or e
	jr z, interrupt_find_empty_skip1 ; found empty slot
	ld de, 6
	add iy, de ; move to next entry
	dec b
	jr nz, interrupt_find_empty_c1
	ld iy, erase_queue ; no space left, use first entry
interrupt_find_empty_skip1:
	pop bc
	
	; TODO enable clear enable draw
	ld de, (ix+0) ; [hl register] [drawing code] [ret patch]
	ld (iy+0), de
	ld de, (ix+2)
	ld (iy+2), de
	ld de, (ix+4)
	ld (iy+4), de ; put entry into erase_queue to be erased on next frame
	
	ld a, 0
	ld (ix+0), a
	ld (ix+1), a ; mark this entry empty
interrupt_skip1:
	; TODO check frame number
	ld de, shedule_entry_size
	add ix, de
	dec b
	jp nz, interrupt_c1
	
	call player+5 ; run music

	;ld a, 0b00000000 ; border black again
	;out (#fe), a
	; .6 call busy_wait
	pop iy
	pop ix
	pop hl
	pop de
	pop bc
	pop af
	ei
	reti

;;;;;;;;;;;;;;;;;
; rewind_music
;;;;;;;;;;;;;;;;;
skip_intro_byte: BYTE 0 ; FIXME
rewind_frame: EQU 950
rewind_music:
	ld bc, rewind_frame
	ld hl, (frame_counter)
	ld de, rewind_frame
	add hl, de
	ld (frame_counter), hl
rewind_music_loop:
	push bc
	call player+5
	pop bc
	dec bc
	ld a, b
	or c
	jr nz, rewind_music_loop
	ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;
; on screen display text
;;;;;;;;;;;;;;;;;;;;;;;;;;;
ctl_paper:	EQU $11
ctl_ink:	EQU $10
ctl_at:		EQU $16
ctl_bright:	EQU $13
text_nikhotmsk_presents: BYTE ctl_paper,0,ctl_ink,7,ctl_bright,1
	BYTE ctl_at,8, 6,'       _____'
	BYTE ctl_at,9, 6,'      / ___ \'
	BYTE ctl_at,10,6,'       /   \'
	BYTE ctl_at,11,6,'      /__O__\'
	BYTE ctl_at,13,6,'nikhotmsk  presents', '$'
text_chan1:	BYTE ctl_paper,0,ctl_ink,7,ctl_bright,1
			BYTE ctl_at,4,12,'AY chan 1', '$'
text_chan2: BYTE ctl_at,5,12,'AY chan 2', '$'
text_chan3: BYTE ctl_at,6,12,'AY chan 3', '$'
text_chan4: BYTE ctl_at,7,12,'AY chan 4', '$'
text_chan5: BYTE ctl_at,8,12,'AY chan 5', '$'
text_chan6: BYTE ctl_at,9,12,'AY chan 6', '$'
text_chan1b: BYTE ctl_at,4,12,'         ', '$'
text_chan2b: BYTE ctl_at,5,12,'         ', '$'
text_chan3b: BYTE ctl_at,6,12,'         ', '$'
text_chan4b: BYTE ctl_at,7,12,'         ', '$'
text_chan5b: BYTE ctl_at,8,12,'         ', '$'
text_chan6b: BYTE ctl_at,9,12,'         ', '$'
text_channel_fix: BYTE ctl_at,14,3,'Press [a] or [s] to escape'
				BYTE ctl_at,16,7,'NedoPC TurboSound', '$'
text_title1: BYTE ctl_at,9,11,'Fischinger', '$'
text_title2: BYTE ctl_at,12,5,'for ZX Spectrum 48/128', '$'
text_story1: BYTE ctl_at,0,11,'STORY 1/2:'
	BYTE ctl_at,2,0
	BYTE 'This demo is inspired  by  early'
	BYTE 'experimental abstract  animation'
	BYTE 'movies from the year 1920 or so.'
	BYTE 'It was the time when people used'
	BYTE 'their  mechanical   and  optical'
	BYTE 'skills to create unusual  visual'
	BYTE 'effects way before computer ani-'
	BYTE 'mation was  invented.  Also they'
	BYTE 'compete with each  other.  IMHO,'
	BYTE 'it was the DEMOSCENE back then. '
	BYTE '                                '
	       
	BYTE 'Oscar  Fischinger  was  a famous'
	BYTE 'animator who  worked on the idea'
	BYTE 'of visual music.  This demo is a'
	BYTE 'tribute  to him  (thus  the name'
	BYTE '"Fischinger") and it is made  in'
	BYTE 'his style.  Idea of VISUAL MUSIC'
	BYTE 'is simple.  First, you  have  to'
	BYTE 'pick a melody, then draw visuals' ; 19 lines
	BYTE '$'
	
text_story2: BYTE ctl_at,0,11,'STORY 2/2:'
	BYTE ctl_at,2,0
	BYTE 'that correspond to musical phra-'
	BYTE 'ses or so,  I duno, and then  it'
	BYTE 'all plays together. Easy, right?'
	BYTE '                                '
	BYTE 'This demo uses Rachmaninoff mus-'
	BYTE 'ic because there will be Rachma-'
	BYTE 'ninoffs anniversary soon,  also,'
	BYTE 'it is a cool thing to try.      '		    
	BYTE '                                '
	BYTE 'Scriabins Prometheus color music'
	BYTE 'experiment is  also a thing,  it'
	BYTE 'maps musical chords  to the col-'
	BYTE 'ors, and it should be here. (but'
	BYTE 'not today, because  color  logic'
	BYTE 'is not ready).  This demo is un-'
	BYTE 'der construction, it ends on the'
	BYTE 'frame 3895    (1 min 30 sec).  I'
	BYTE 'will  fix  all  this  in release'
	BYTE 'version.'
	BYTE '$' ; end of text
text_controls: BYTE ctl_at,4,11,'Controls:'
	BYTE ctl_at,7,0
	BYTE '[break] - play from beginning   '
	BYTE '                                '
	BYTE '[a] [s] - disable TurboSound    '
	BYTE '$'
text_music_by: BYTE ctl_at,7,13,'Music:'
	BYTE ctl_at,11,2
	BYTE '       Rachmaninoff',39,'s           ' ;
	BYTE '                                ' ;
	BYTE '       Concerto  No.1'
	BYTE '$'
	

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; shapes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
shape_froggy_right:
	BYTE 129,107,124,102
	BYTE 130,105,126,101
	BYTE 136,99,131,95
	BYTE 141,93,137,89
	BYTE 143,91,138,87
	BYTE 0,0,0,0

shape_froggy_center:
	BYTE 129,105,123,105
	BYTE 129,103,123,103
	BYTE 129,97,123,97
	BYTE 129,90,123,90
	BYTE 129,88,123,87
	BYTE 0,0,0,0
shape_froggy_left:
	BYTE 124,107,128,102
	BYTE 122,105,127,101
	BYTE 117,99,121,95
	BYTE 111,93,115,89
	BYTE 109,91,114,87
	BYTE 0,0,0,0


nikhotmsk_shape:
	BYTE 195,4,185,4
	BYTE 193,22,172,21
	BYTE 188,38,161,38
	BYTE 204,67,58,67 ; 3 frames
	BYTE 0,0,0,0
nikhotmsk_erase_shape:
	BYTE 40,141,56,142
	BYTE 43,132,68,134
	BYTE 49,121,76,123
	BYTE 49,100,94,103
	BYTE 72,91,97,92
	BYTE 91,109,109,109
	BYTE 103,115,127,116
	BYTE 97,101,133,102
	BYTE 98,70,146,71
	BYTE 132,79,160,80
	BYTE 134,94,186,95
	BYTE 139,119,195,120
	BYTE 163,113,198,113
	BYTE 182,83,208,83
	BYTE 197,69,207,68 ; 14 frames
	BYTE 0,0,0,0
shape_quicker_1:
	BYTE 110,181,121,181
	BYTE 108,144,125,143
	BYTE 105,107,129,107
	BYTE 101,92,131,93
	BYTE 0,0,0,0
shape_quicker_1_small:
	BYTE 118,179,132,180
	BYTE 112,151,139,151
	BYTE 102,139,149,140
	BYTE 0,0,0,0
shape_flyby_1:
	BYTE 10,115,14,119
	BYTE 40,82,44,87
	BYTE 118,51,119,59
	BYTE 189,66,185,70
	BYTE 198,114,192,112
	BYTE 160,132,162,125
	BYTE 126,113,134,110
	BYTE 130,83,135,88
	BYTE 199,71,201,63
	BYTE 224,105,234,107
	BYTE 186,149,187,154
	BYTE 120,137,112,143
	BYTE 114,100,108,96
	BYTE 143,64,141,54
	BYTE 211,71,219,66
	BYTE 212,128,220,132
	BYTE 164,148,160,156
	BYTE 151,111,142,114
	BYTE 177,55,172,50
	BYTE 225,23,218,17
	BYTE 0,0,0,0
shape_needle_1_phase_1:
	BYTE 221,172,223,169
	BYTE 192,156,196,152
	BYTE 0,0,0,0
shape_needle_1_phase_2:
	BYTE 162,136,164,133
	BYTE 134,118,137,114
	BYTE 0,0,0,0
shape_needle_1_phase_3:
	BYTE 71,79,74,76
	BYTE 44,62,47,58
	BYTE 0,0,0,0
shape_salute_small_left:
	BYTE 113,83,113,84
	BYTE 90,82,90,84
	BYTE 57,80,57,85
	BYTE 0,0,0,0
shape_salute_small_right:
	BYTE 121,83,121,84
	BYTE 139,83,139,84
	BYTE 177,83,177,85
	BYTE 0,0,0,0
shape_salute_small_up:
	BYTE 116,77,117,77
	BYTE 114,71,117,71
	BYTE 0,0,0,0
shape_salute_small_down:
	BYTE 116,88,118,88
	BYTE 116,97,119,97
	BYTE 0,0,0,0

shape_flyer_84_part_1:
	BYTE 103,97,104,95
	BYTE 93,94,93,91
	BYTE 79,91,80,89
	BYTE 69,91,68,89
	BYTE 60,102,58,102
	BYTE 69,126,67,128
	BYTE 113,129,114,132
	BYTE 142,120,143,123
	BYTE 158,120,157,122
	BYTE 162,127,160,127
	BYTE 159,131,157,129
	BYTE 151,132,151,129
	BYTE 133,127,134,126
	BYTE 123,118,122,116
	BYTE 115,121,114,119
	BYTE 97,124,99,122
	BYTE 89,114,91,114
	BYTE 91,105,96,106
	BYTE 98,98,119,99
	BYTE 113,91,122,90
	BYTE 120,84,122,84
	BYTE 117,80,118,77
	BYTE 105,81,105,78
	BYTE 99,87,96,84 ; 24
	BYTE 85,99,88,102
	BYTE 81,117,85,116
	BYTE 91,135,95,132
	BYTE 122,144,122,141
	BYTE 148,128,145,126
	BYTE 161,95,163,97
	BYTE 172,86,174,89
	BYTE 195,85,193,89
	BYTE 221,98,219,100 ; 64 frames, 32 phases
	BYTE 0,0,0,0
shape_flyer_84_part_2:
	BYTE 221,98,219,100
	BYTE 227,120,224,121
	BYTE 218,137,217,134
	BYTE 203,145,200,137
	BYTE 172,140,175,136
	BYTE 150,137,149,133
	BYTE 58,133,59,129
	BYTE 35,127,38,123
	BYTE 27,111,31,111
	BYTE 29,98,32,99
	BYTE 38,85,39,89
	BYTE 59,84,58,88 ; 44
	BYTE 107,89,108,86
	BYTE 134,92,136,89
	BYTE 183,101,183,97 ; 14 phases, 28 frames
	BYTE 0,0,0,0
shape_flyer_84_part_3:
	BYTE 183,101,183,97
	BYTE 214,107,217,105
	BYTE 211,133,214,136
	BYTE 183,140,184,144
	BYTE 130,138,130,143
	BYTE 77,137,77,141
	BYTE 35,129,34,134
	BYTE 27,112,22,113
	BYTE 37,88,33,85
	BYTE 58,86,59,82
	BYTE 86,87,87,83
	BYTE 120,80,119,75
	BYTE 151,80,153,75
	BYTE 179,83,179,79
	BYTE 197,86,198,82
	BYTE 211,92,216,92
	BYTE 209,111,214,113
	BYTE 199,121,200,126
	BYTE 172,129,173,134
	BYTE 160,144,166,148
	BYTE 150,153,150,159
	BYTE 132,153,131,157
	BYTE 118,151,118,155
	BYTE 102,152,102,156
	BYTE 88,152,85,156
	BYTE 84,140,80,140
	BYTE 83,99,78,98
	BYTE 100,55,96,53
	BYTE 151,61,150,56
	BYTE 187,66,191,63
	BYTE 189,113,196,111
	BYTE 189,143,197,144
	BYTE 176,150,176,156
	BYTE 93,142,93,147
	BYTE 68,131,64,133
	BYTE 73,115,47,118
	BYTE 107,105,47,97
	BYTE 118,84,58,77 ; 37 phases
	BYTE 0,0,0,0
shape_stairs_21:
	BYTE 23,31,30,31
	BYTE 24,39,29,40
	BYTE 24,47,28,47
	BYTE 23,58,29,58
	BYTE 27,67,72,67
	BYTE 70,73,74,72
	BYTE 71,78,75,78
	BYTE 72,84,75,84
	BYTE 72,90,108,92
	BYTE 77,97,113,98
	BYTE 84,104,124,105
	BYTE 120,111,130,112
	BYTE 122,117,128,117
	BYTE 126,123,130,123
	BYTE 127,129,131,129
	BYTE 130,133,176,135
	BYTE 151,141,177,141
	BYTE 175,146,179,145
	BYTE 177,152,181,153
	BYTE 177,158,183,157
	BYTE 176,162,184,164
	BYTE 180,170,186,169
	BYTE 0,0,0,0
shape_circle:
	BYTE 189,158,188,165
	BYTE 90,155,89,161
	BYTE 58,153,55,158
	BYTE 60,142,53,142
	BYTE 66,133,66,126
	BYTE 94,135,95,128
	BYTE 124,135,124,129
	BYTE 152,136,152,129
	BYTE 200,137,200,130
	BYTE 208,146,216,145
	BYTE 202,157,203,165
	BYTE 189,158,188,165
	BYTE 0,0,0,0


place_single:
	BYTE 1, 0, 0, 0, 0 ; [enable] [dY dX] [dFrame]
	BYTE 0 ; terminator
place_loop_22_4:
	BYTE 1, 0, 0,  0, 0
	BYTE 1, 0, 0, 22, 0
	BYTE 1, 0, 0, 44, 0
	BYTE 1, 0, 0, 66, 0
	BYTE 0
place_leftright_twice:
	BYTE 1, -5, 0, 12, 0
	BYTE 1, +5, 0, 12, 0
	; fallthrough
place_leftright:
	BYTE 1, -5, 0, 0, 0
	BYTE 1, +5, 0, 0, 0
	BYTE 0
place_one_by_one:
	BYTE 1, -7, 0, 0, 0
	BYTE 1, -4, 0, 8, 0
	BYTE 1,  0, 0, 16, 0
	BYTE 1,  4, 0, 24, 0
	BYTE 0
place_parapam:
	BYTE 1,  0, 0, 0, 0
	BYTE 1,  0, 0, 8, 0
	BYTE 1,  0, 0, #1c, 0
	BYTE 1,  0, 0, #22, 0
	BYTE 1,  0, 0, #2a, 0
	BYTE 1,  0, 0, #30, 0
	BYTE 0
place_sparkle_small_7:
	BYTE 1,  0, 0, 0, 0
	BYTE 1,  1,-6, 6, 0
	BYTE 1,  0,-2, 12, 0
	BYTE 1, -2, 0, 18, 0
	BYTE 1,  1, 0, 24, 0
	BYTE 1,  0,-3, 30, 0
	BYTE 1,  1,-2, 36, 0
	BYTE 0
place_four_times:
	BYTE 1,  1,-2, 0, 0
	BYTE 1, -2, 0, 8, 0
	BYTE 1,  0, 2, 16, 0
	BYTE 1,  2, 0, 24, 0
	BYTE 0

place_afraid_forward:
	BYTE 1, 0, 8, 0, 0
	BYTE 1, 0, 6, 30, 0
	BYTE 1, 0, 4, 60, 0
	BYTE 1, 0, 2, 100, 0
	BYTE 1, 0, 0, 120, 0
	BYTE 1, 0, 8, 150, 0
	BYTE 1, 0, 6, 165, 0
	BYTE 1, 0, 4, 180, 0
	BYTE 1, 0, 2, 195, 0
	BYTE 1, 0, 0, 210, 0
	BYTE 0

place_afraid_right:
	BYTE 1, 0, 8, 0, 0
	BYTE 1, 2, 6, 30, 0
	BYTE 1, 4, 4, 60, 0
	BYTE 1, 6, 2, 100, 0
	BYTE 1, 8, 0, 120, 0
	BYTE 1, 0, 8, 150, 0
	BYTE 1, 2, 6, 165, 0
	BYTE 1, 4, 4, 180, 0
	BYTE 1, 6, 2, 195, 0
	BYTE 1, 8, 0, 210, 0
	BYTE 0
place_afraid_left:
	BYTE 1, 0, 8, 0, 0
	BYTE 1,-2, 6, 30, 0
	BYTE 1,-4, 4, 60, 0
	BYTE 1,-6, 2, 100, 0
	BYTE 1,-8, 0, 120, 0
	BYTE 1, 0, 8, 150, 0
	BYTE 1,-2, 6, 165, 0
	BYTE 1,-4, 4, 180, 0
	BYTE 1,-6, 2, 195, 0
	BYTE 1,-8, 0, 210, 0
	BYTE 0

place_go_go_go:
	BYTE 1, 0, 0, 0, 0
	BYTE 1, 4, 3, 4, 0
	BYTE 1, 6, 2, 8, 0
	BYTE 1,-2,-2, 12, 0
	BYTE 1, 4,-3, 16, 0
	BYTE 1,-5, 0, 20, 0
	BYTE 1, 2,-3, 24, 0
	BYTE 1,-4, 2, 28, 0
	BYTE 1, 0,-2, 32, 0
	BYTE 1, 0, 5, 36, 0
	BYTE 1,-1,-4, 40, 0
	BYTE 1, 3, 0, 44, 0
	BYTE 1, 0,-4, 48, 0
	BYTE 1, 4,-6, 52, 0
	BYTE 1,-2, 2, 56, 0
	BYTE 1, 0, 0, 60, 0
	BYTE 1, 0,-4, 64, 0
	BYTE 1,-2, 4, 68, 0
	BYTE 1, 0, 2, 72, 0
	BYTE 1, 3, 0, 76, 0
	BYTE 0
place_go_go_go_wide:
	BYTE 1, 0, 0, 0, 0
	BYTE 1, 10, -1, 4, 0
	BYTE 1, 6, 4, 8, 0
	BYTE 1,-2,-7, 12, 0
	BYTE 1, 4,5, 16, 0
	BYTE 1,-5, 0, 20, 0
	BYTE 1, 2,6, 24, 0
	BYTE 1,11, 4, 28, 0
	BYTE 1, 6,-2, 32, 0
	BYTE 1,-4, 5, 36, 0
	BYTE 1,-6,-4, 40, 0
	BYTE 1,-2, 0, 44, 0
	BYTE 1, -5,-4, 48, 0
	BYTE 1,-4,-6, 52, 0
	BYTE 1,3, 2, 56, 0
	BYTE 1, -10, 0, 60, 0
	BYTE 1, 3,-4, 64, 0
	BYTE 1,-2, 4, 68, 0
	BYTE 1, 0, -7, 72, 0
	BYTE 1, 3, 0, 76, 0
	BYTE 0


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; main code
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
test_figurine_asm:	WORD 0

code_main:
	ei
	
	ld a, (skip_intro_byte)
	or a
	jp nz, code_main_skip_intro
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 0 CHANNEL CHECKER
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 40
	call wait_for_frame
	ld hl, text_chan1
	ld (draw_text_pointer), hl
	
	ld de, 50
	call wait_for_frame
	ld hl, text_channel_fix
	ld a, (turbosound_setting_byte)
	and 0b00010000
	jr z, text_channel_fix_no_turbosound
	ld (draw_text_pointer), hl
text_channel_fix_no_turbosound:
	
	ld de, 75
	call wait_for_frame
	ld hl, text_chan2
	ld (draw_text_pointer), hl
	
	ld de, 100
	call wait_for_frame
	ld hl, text_chan3
	ld (draw_text_pointer), hl
	
	ld de, 130
	call wait_for_frame
	ld hl, text_chan4
	ld (draw_text_pointer), hl
	
	ld de, 157
	call wait_for_frame
	ld hl, text_chan5
	ld (draw_text_pointer), hl
	
	ld de, 205
	call wait_for_frame
	ld hl, text_chan6
	ld (draw_text_pointer), hl
	
	ld de, 270
	call wait_for_frame
	ld hl, text_chan2b
	ld (draw_text_pointer), hl
	
	ld de, 283
	call wait_for_frame
	ld hl, text_chan1b
	ld (draw_text_pointer), hl
	
	ld de, 298
	call wait_for_frame
	ld hl, text_chan3b
	ld (draw_text_pointer), hl
	
	ld de, 318
	call wait_for_frame
	ld hl, text_chan4b
	ld (draw_text_pointer), hl
	
	ld de, 330
	call wait_for_frame
	ld hl, text_chan5b
	ld (draw_text_pointer), hl
	
	ld de, 347
	call wait_for_frame
	ld hl, text_chan6b
	ld (draw_text_pointer), hl
	
	ld de, 350
	call wait_for_frame
	call clear_slow
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 410 NIKHOTMSK PRESENTS
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld hl, nikhotmsk_shape
	ld de, 411 ; base frame number
	call shedule_add_shape
	
	ld de, 416
	call wait_for_frame
	ld hl, text_nikhotmsk_presents
	ld (draw_text_pointer), hl ; start typing text
	
	; wait for frame number and assembly some other figurines
	ld hl, nikhotmsk_erase_shape
	ld de, 511 ; base frame number
	call shedule_add_shape
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 560 TITLE
	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	ld de, 561
	call wait_for_frame
	ld hl, text_title1
	ld (draw_text_pointer), hl
	
	ld de, 601
	call wait_for_frame
	ld hl, text_title2
	ld (draw_text_pointer), hl
	
	;;;;;;;;;;;;;;;;;;;
	; FRAME 651 STORY
	;;;;;;;;;;;;;;;;;;;
	ld de, 651
	call wait_for_frame
	call clear_slow
	ld hl, text_story1
	ld (draw_text_pointer), hl
	
	ld de, 731
	call wait_for_frame
	call clear_slow
	ld hl, text_story2
	ld (draw_text_pointer), hl
	
	ld de, 811
	call wait_for_frame
	call clear_slow
	ld hl, text_controls
	ld (draw_text_pointer), hl
	
	ld de, 891
	call wait_for_frame
	call clear_slow
	ld hl, text_music_by
	ld (draw_text_pointer), hl
	
code_main_skip_intro:
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 1011 MUSIC START
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld hl, place_leftright_twice
	ld (add_shape_places_table), hl
	ld hl, shape_quicker_1
	ld de, 1011
	call shedule_add_shape ; assemble thing before clear and shedule it after clear
	
	ld hl, place_one_by_one
	ld (add_shape_places_table), hl
	ld hl, shape_quicker_1_small
	ld de, 1039
	call shedule_add_shape
	
	ld de, 979
	call wait_for_frame
	call clear_slow
	
	
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld hl, shape_flyby_1
	ld de, 1067
	call shedule_add_shape
	ld de, 1067
	call wait_for_frame
	
	
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld de, 1115
	call place_total_wipe
	ld de, 1115
	call wait_for_frame
	
	ld hl, place_parapam
	ld (add_shape_places_table), hl
	ld de, 1135
	ld hl, shape_quicker_1
	call shedule_add_shape
	
	ld hl, place_sparkle_small_7
	ld (add_shape_places_table), hl
	ld de, 1192
	;ld hl, shape_needle1
	;call shedule_add_shape
	call place_needle
	ld de, 1192
	call wait_for_frame
	
	ld hl, place_four_times
	ld (add_shape_places_table), hl
	ld de, 1241
	push de
	ld hl, shape_salute_small_left
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_right
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_up
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_down
	call shedule_add_shape
	pop de
	ld de, 1241
	call wait_for_frame
	
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld de, 1262
	ld hl, shape_flyer_84_part_1
	call shedule_add_shape ; long thing, 168 frames
	
	ld de, 1310
	call wait_for_frame
	ld de, 1326
	ld hl, shape_flyer_84_part_2
	call shedule_add_shape
	
	; add douet here
	ld de, 1326
	ld hl, shape_flyby_1
	call shedule_add_shape
	
	ld de, 1310
	call wait_for_frame
	ld de, 1354
	ld hl, shape_flyer_84_part_3
	call shedule_add_shape
	
	ld de, 1420
	call wait_for_frame
	ld hl, place_single
	ld (add_shape_places_table), hl
	ld de, 1430
	ld hl, shape_stairs_21
	call shedule_add_shape
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 1472 PATTERN 3
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld de, 1432
	call wait_for_frame
	ld hl, place_loop_22_4
	ld (add_shape_places_table), hl
	ld de, 1472
	ld hl, shape_circle
	call shedule_add_shape
	ld de, 1486
	push de
	ld hl, shape_salute_small_left
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_right
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_up
	call shedule_add_shape
	pop de
	push de
	ld hl, shape_salute_small_down
	call shedule_add_shape
	pop de
	
	ld hl, place_leftright_twice
	ld (add_shape_places_table), hl
	ld hl, shape_quicker_1
	ld de, 1556
	call shedule_add_shape
	
	
	;;;;;;;;;;;;;;;;;;;
	; FRAME 1620 fillers !!
	;;;;;;;;;;;;;;;;;;;
	
	ld hl, place_afraid_forward
	ld (filler_scary_table), hl
	ld hl, shape_froggy_center
	ld (filler_figurine), hl
	ld hl, 1619
	ld (filler_frame_number), hl
	call filler
	
	ld hl, place_afraid_right
	ld (filler_scary_table), hl
	ld hl, shape_froggy_right
	ld (filler_figurine), hl
	ld hl, 1619 + 576
	ld (filler_frame_number), hl
	call filler
	
	ld de, 1619 + 576 + 100
	call wait_for_frame
	ld hl, text_filler_huh
	ld (draw_text_pointer), hl
	
	ld de, 1619 + 576 + 576 + 180 - 50
	call wait_for_frame
	ld hl, text_filler_huh_clear
	ld (draw_text_pointer), hl
	
	ld hl, place_afraid_left
	ld (filler_scary_table), hl
	ld hl, shape_froggy_left
	ld (filler_figurine), hl
	ld hl, 1619 + 576 + 576 + 180
	ld (filler_frame_number), hl
	call filler
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 3736
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	
	
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	; FRAME 3895 END OF MUSIC
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	ld de, 3895
	call wait_for_frame
	call clear_slow
	ld hl, program_stop_text1
	ld (draw_text_pointer), hl
	ld de, 3995
	call wait_for_frame
	ld hl, program_stop_text2
	ld (draw_text_pointer), hl
	ld de, 4095
	call wait_for_frame
	ld hl, program_stop_text3
	ld (draw_text_pointer), hl
	ld de, 4195
	call wait_for_frame
	ld hl, program_stop_text4
	ld (draw_text_pointer), hl
	
	ld bc, 2000 ; 40 sec
code_loop:
	halt ; program autorestart
	dec bc
	ld a, b
	or c
	jr nz, code_loop
	jp interrupt_routine_goto_code_again

program_stop_text1:
	BYTE ctl_at, 4, 2,'well,'
	BYTE ctl_at,6, 2,'you',39,'ve got the idea (:','$'
program_stop_text2:
	BYTE ctl_at,9, 2,'I',39,'ll add more someday in'
	BYTE ctl_at,11, 2,'release version later.. ok?','$'
program_stop_text3:
	BYTE ctl_at,14, 2,'press [break] if you want to'
	BYTE ctl_at,16, 2,'watch this demo one more time','$'
program_stop_text4:
	BYTE ctl_at,19, 2,'kindly yours'
	BYTE ctl_at,21, 2,'nikhotmsk','$'
text_filler_huh:
	BYTE ctl_at,13, 7,'It',39,'s a filler, huh?','$'
text_filler_huh_clear:
	BYTE ctl_at,13, 7,'                   ','$'

;;;;;;;;;;;;;;;;;;;;;;;;;
; filler
;;;;;;;;;;;;;;;;;;;;;;;;;
filler_figurine: WORD shape_froggy_center
filler_frame_number: WORD 4000
filler_scary_table: WORD place_afraid_forward
filler:
	; this demo takes too long, and deadline is so near, I have to use filler
	
	ld hl, (filler_frame_number)
	ld de, -20
	add hl, de
	ex de, hl
	call wait_for_frame
	
	ld hl, (filler_scary_table)
	ld (add_shape_places_table), hl
	
	ld hl, (filler_frame_number)
	ld de, 0 ; offset 0
	add hl, de
	ex hl, de
	;ld de, 1619
	ld hl, (filler_figurine)
	call shedule_add_shape

	ld hl, (filler_frame_number)
	ld de, 221
	add hl, de
	ex de, hl
	call wait_for_frame

	ld hl, place_go_go_go
	ld (add_shape_places_table), hl
	
	ld hl, (filler_frame_number)
	ld de, 241
	add hl, de
	ex de, hl
	ld hl, (filler_figurine)
	call shedule_add_shape
	
	ld hl, (filler_frame_number)
	ld de, 321
	add hl, de
	ex de, hl
	call wait_for_frame
	ld hl, place_go_go_go_wide
	ld (add_shape_places_table), hl
	ld hl, (filler_frame_number)
	ld de, 336
	add hl, de
	ex de, hl
	ld hl, (filler_figurine)
	call shedule_add_shape
	
	; one more time
	ld hl, (filler_frame_number)
	ld de, 401
	add hl, de
	ex de, hl
	call wait_for_frame
	ld hl, place_go_go_go_wide
	ld (add_shape_places_table), hl
	ld hl, (filler_frame_number)
	ld de, 416
	add hl, de
	ex de, hl
	ld hl, (filler_figurine)
	call shedule_add_shape
	
	; and once more
	ld hl, (filler_frame_number)
	ld de, 481
	add hl, de
	ex de, hl
	call wait_for_frame
	ld hl, place_go_go_go_wide
	ld (add_shape_places_table), hl
	ld hl, (filler_frame_number)
	ld de, 496
	add hl, de
	ex de, hl
	ld hl, (filler_figurine)
	call shedule_add_shape
	
	ld hl, (filler_frame_number) ; keep time just to make sure
	ld de, 576
	add hl, de ; this is total length of this filler - 576 frames (11 sec)
	ex de, hl
	call wait_for_frame
	ret

;;;;;;;;;;;;;;;;;;;;;
; place_needle
;;;;;;;;;;;;;;;;;;;;;
place_needle:
	ld hl, shape_needle_1_phase_1
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_needle_1_phase_2
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_needle_1_phase_3
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ret



;;;;;;;;;;;;;;;;;;;
; place_total_wipe
;;;;;;;;;;;;;;;;;;;
place_total_wipe:
	ld hl, shape_wipe_phase1
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase2
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase3
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase4
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase5
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase6
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	ld hl, shape_wipe_phase7
	push de
	call shedule_add_shape
	pop de
	inc de
	inc de
	
	ret
	
shape_wipe_phase1:
	BYTE 3,13,48,5
	BYTE 2,21,77,8
	BYTE 0,0,0,0
shape_wipe_phase2:
	BYTE 3,32,119,5
	BYTE 160,8,5,41
	BYTE 0,0,0,0
shape_wipe_phase3:
	BYTE 7,65,170,24
	BYTE 174,29,22,68
	BYTE 0,0,0,0
shape_wipe_phase4:
	BYTE 61,105,208,53
	BYTE 210,59,66,108
	BYTE 0,0,0,0
shape_wipe_phase5:
	BYTE 116,119,225,114
	BYTE 121,127,224,123
	BYTE 0,0,0,0
shape_wipe_phase6:
	BYTE 148,160,215,154
	BYTE 216,160,155,164
	BYTE 0,0,0,0
shape_wipe_phase7:
	BYTE 160,178,221,172
	BYTE 222,178,161,183
	BYTE 0,0,0,0



;;;;;;;;;;;;;;;
; call_de
;;;;;;;;;;;;;;;
call_de:
	push de
	ret

;;;;;;;;;;;;;;;;;;;;;
; shedule_add_shape
; hl - shape coordinates
; de - base frame number
;;;;;;;;;;;;;;;;;;;;;
shedule_prev_line_a: WORD 0 ; X Y (like in memory)
shedule_prev_line_b: WORD 0
shedule_base_frame_number: WORD 0
add_shape_places_table: WORD place_single
shedule_add_shape:
	ld (shedule_base_frame_number), de
	ld ix, hl
	ld hl, 0
	ld (shedule_prev_line_a), hl ; reset prev_line
	ld (shedule_prev_line_b), hl
shedule_add_shape_cycle1:
	ld bc, (ix+0)
	ld a, b
	or c
	ret z ; sequence ready
	ld bc, (shedule_prev_line_a)
	ld de, (shedule_prev_line_b)
	ld a, b
	or c
	or d
	or e ; check if prev line empty
	jr nz, shedule_add_shape_draw ; do not draw, just remember prev line
	ld bc, (ix+0) ; c = X, b = Y ??
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de
	
	jr shedule_add_shape_cycle1
shedule_add_shape_draw:
	
	; silkscreen (do not forget to push ix)
	ld hl, vars
	ld bc, (ix+0) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (ix+2)
	ld (hl), c
	inc hl
	ld (hl), b ; fill vars with figurine parameters
	inc hl
	ld bc, (shedule_prev_line_b) ; c = Y, b = X
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	ld bc, (shedule_prev_line_a)
	ld (hl), c
	inc hl
	ld (hl), b
	inc hl
	
	push ix
	call silkscreen_figurine
	; call debug_lines
	; .8 call busy_wait
	
	call silkscreen.silkscreen_assembler ; (returns HL)
	pop ix
	; remember prev line
	ld bc, (ix+0)
	inc ix
	inc ix
	ld de, (ix+0)
	inc ix
	inc ix
	ld (shedule_prev_line_a), bc
	ld (shedule_prev_line_b), de ; also move ix forvard
	
	; put it in draw queue
	push ix
	call shedule_add_figurine_many_places
	pop ix
	ld de, (shedule_base_frame_number)
	inc de
	inc de
	ld (shedule_base_frame_number), de
	
	jp shedule_add_shape_cycle1
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine_many_places
; hl - drawing code
;;;;;;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine_many_places:
	ld ix, (add_shape_places_table)
shedule_add_figurine_many_places_cycle:
	ld a, (ix+0)
	or a
	ret z
	push hl
	ld hl, (shedule_base_frame_number)
	ld de, (ix+3) ; [enable] [dY dX] [dFrame]
	add hl, de
	ex de, hl
	ld bc, (ix+1)
	pop hl
	push ix
	call shedule_add_figurine
	pop ix
	inc ix
	inc ix
	inc ix
	inc ix
	inc ix
	jr shedule_add_figurine_many_places_cycle
	
	
	
	;call silkscreen_figurine
	;call debug_draw_silkscreen
	;call silkscreen.silkscreen_assembler ; returns hl
	;ld (test_figurine_asm), hl
	;call debug_lines
	
	;ld hl, (test_figurine_asm)
	;ld de, 41 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #0404 ; shift (Y X)
	;call shedule_add_figurine
	
	;ld de, 47 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #000c ; shift (Y X)
	;call shedule_add_figurine
	
	;ld de, 51 ; frame number
	;ld a, 3   ; drawing mode flags
	;ld bc, #060c ; shift (Y X)
	;call shedule_add_figurine


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; wait_for_frame
; de - frame number (function will hang if frame_counter is less then de)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
wait_for_frame:
	ld hl, (frame_counter)
	or a ; clear carry flag
	sbc hl, de
	add hl, de	; compare words
	ret nc		; carry is set if (hl < de)
	halt
	jr wait_for_frame

;;;;;;;;;;;;;;;;;;;;;
; shedule_add_figurine
; hl - drawing code
; de - frame numer (must not be even (because erase runs at 25 fps))
; bc - position shift
;;;;;;;;;;;;;;;;;;;;;
shedule_add_figurine:
	ld ix, shedule
	push bc
	push de
	ld b, shedule_size
	; di ; disable interrupt before searching empty slot ??
shedule_add_figurine_c1:
	; move ix to empty slot here
	ld de, (ix+0)
	ld a, d
	or e
	jr z, shedule_add_figurine_found_slot1
	ld de, shedule_entry_size
	add ix, de
	dec b
	jr nz, shedule_add_figurine_c1
	ld ix, shedule ; no space left, clobber the first entry
shedule_add_figurine_found_slot1:
	pop de
	pop bc
	
	ld (ix+7), de ; [hl register] [drawing code] [ret patch] [enable] [frame number]
	; de is frame number
	ld a, e
	or 0b00000001 ; force odd number
	ld e, a
	
	push hl
	push bc
	sla b
	sla b
	sla b ; multiply by 8
	ld a, b
	ld hl, (upper_point_lower_point)
	add h
	ld b, a ; add vertical shift
	ld a, (upper_point_x)
	ld c, a
	call Get_Pixel_Address ; returns hl
	pop bc
	ld a, l      ; add horizontal shift value
	add c
	ld l, a
	ld (ix+0), l ; screen address ready
	ld (ix+1), h
	pop hl
	ld (ix+2), l
	ld (ix+3), h ; drawing code address ready
	ei
	ret


;;;;;;;;;;;;;;;;;;
; empty_routine
;;;;;;;;;;;;;;;;;;
empty_routine:
	
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;
; clear screen data
;;;;;;;;;;;;;;;;;;;;;;;;;
clear_slow:
	ld HL, #4000
	ld BC, 6144      ; clear image data (slow and nice)
clear_slow_c1:
	xor a
	ld (hl), a
	inc hl
	dec bc
	ld a, c
	or a
	jr nz, clear_slow_skip1
	halt
clear_slow_skip1:
	or b
	jr nz, clear_slow_c1
	ret
	
;
; fill memory with constant byte
;
; D  - byte
; HL - start address
; BC - size
;
fill_mem:
  ld A, D
  ld (HL), A
  inc HL
  dec BC
  ld A,B
  or C
  jr nz, fill_mem
  ret


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; silkscreen_figurine
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
silkscreen_figurine:
	; TODO clear the header
	ld h, 255
	ld l, 0
	ld (upper_point_lower_point), hl ; reset upper point
	
	; clear the buffer
	ld c, 192
	ld hl, silk_data
	ld b, 255 ; these are the shape coordinates
	ld a, 0   ; they are invalid, so drawing code will fix them
silkscreen_figurine_c1:
	ld (hl), b
	inc hl
	ld (hl), a ; set second point to zero to mark it as disabled
	inc hl
	dec c
	jr nz, silkscreen_figurine_c1
	
	; do silkscreen drawing
	ld ix, vars
	ld bc, (ix+0) ; AB
	ld de, (ix+2)
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+2) ; BC
	ld de, (ix+4)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+4) ; CD
	ld de, (ix+6)
	
	call silkscreen.Draw_Line
	
	ld ix, vars
	ld bc, (ix+6) ; DA
	ld de, (ix+0)
	call silkscreen.Draw_Line
	
	
	ret
	

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_draw_silkscreen
;;;;;;;;;;;;;;;;;;;;;;;;
debug_draw_silkscreen:
	ld hl, silk_data
	ld c, 192 ; counter
	ld b, 0   ; Y coordinate
debug_draw_silkscreen_c1:
	push bc
	ld d, b ; make horisontal line
	ld c, (hl) ; load X left
	inc hl
	ld e, (hl) ; load X right
	inc hl
	push hl
	ld a, e ; check if the line is active
	or a
	jr z, debug_draw_silkscreen_s
	ld a, e ; check if line is valid
	cp c
	jr c, debug_draw_silkscreen_s
	jr z, debug_draw_silkscreen_s
	dec e ; last point is not included
	;call nz, Plot
	;ld b, d
	;ld c, e
	;call nz, Plot
	call Draw_Line
debug_draw_silkscreen_s:
	pop hl
	pop bc
	inc b
	dec c
	jr nz, debug_draw_silkscreen_c1
	ret

;;;;;;;;;;;;;;;;;;;;;;;;
; debug_lines
;;;;;;;;;;;;;;;;;;;;;;;;
debug_lines:
	ld ix, vars
	ld bc, (ix+0) ; AB
	ld de, (ix+2)
	call Draw_Line
	
	ld ix, vars
	ld bc, (ix+2) ; BC
	ld de, (ix+4)
	call Draw_Line
	
	ld ix, vars
	ld bc, (ix+4) ; CD
	ld de, (ix+6)
	call Draw_Line
	
	ld ix, vars
	ld bc, (ix+6) ; DA
	ld de, (ix+0)
	call Draw_Line
	ret
	
	
;
; this code comes from ChibiAkumas. Compute spectrum video address
;
; B  - X in bytes
; C  - Y
; return DE - mem pos in video memory
;;;;;;;;;;;;;;;;;;;;;;;;;
; get_video_pos
;;;;;;;;;;;;;;;;;;;;;;;;;
get_video_pos:
  ld a, c
  and %00111000
  rlca
  rlca
  or b
  ld e, a ; first byte is ready
  ld a, c
  and %00000111
  ld d, a
  ld a, c
  and %11000000
  rrca
  rrca
  rrca
  or d
  or #40
  ld d, a ; second byte is ready
  ret


;
; this code comes from ChibiAkumas too.
;
; DE - address in video mem
; returns DE - new address
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; get_next_line
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
get_next_line:
  inc d
  ld a, d
  and    %00000111 ; check bits Y5 Y4 Y3 overflow
  ret nz
  ld a, e
  add a, %00100000
  ld e, a
  ret c            ; check bits Y2 Y1 Y0 overflow
  ld a, d
  sub    %00001000 ; fix overflow bit Y6
  ld d, a
  ret


;;;;;;;;;;;;;;;;;;;;;;
; busy_wait
;;;;;;;;;;;;;;;;;;;;;;
busy_wait:
	push bc
	ld bc, 5000
busy_wait_loop:
	dec bc
	ld a, b
	or c
	jr nz, busy_wait_loop
	pop bc
	ret

;;;;;;;;;;;;;;;;;
; initSong
; hl,de - address of raw pt3 file
;;;;;;;;;;;;;;;;;
initSong:
	ld hl,music
	ld de,music + #496
	ld a, (turbosound_flip_modules)
	or a
	jr z, initSong_noflip
	ex de, hl
initSong_noflip:
	ld a, (turbosound_setting_byte)
	ld (player+10),a
	     ;set bit0, if you want to play without looping
	     ;(optional);
	     ;set bit1 for PT2 and reset for PT3 before
	     ;calling INIT;
	     ;bits2-3: %00-ABC, %01-ACB, %10-BAC (optional);
	     ;bits4-5: %00-no TS, %01-2 modules TS, %10-
	     ;autodetect PT3 TS-format by AlCo (PT 3.7+);
	     ;Remark: old PT3 TS-format by AlCo (PT 3.6) is not
	     ;documented and must be converted to new standard.
	     ;bit6 is set each time, when loop point of 2nd TS
	     ;module is passed (optional).
	     ;bit7 is set each time, when loop point of 1st TS
	     ;or of single module is passed (optional).
	call player+3
	ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	INCLUDE "vector.asm"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; vector_silkscreen.asm -- drawing routines
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
	MODULE silkscreen
	INCLUDE "vector_silkscreen.asm"
	ENDMODULE

;;;;;;;;;;;;;;;;;;;;;;;;
; music code here
;;;;;;;;;;;;;;;;;;;;;;;;
player:
	MODULE ptsplay
	include "PTSPlay.asm"
	ENDMODULE
music:
	incbin "r_496.pt3"

;;;;;;;;;;;;;;;;;;;;;;;;;
; prerecorded variables here
;;;;;;;;;;;;;;;;;;;;;;;;;

drawing_code_vault_running_w: WORD drawing_code_vault
frame_counter: WORD 0
draw_text_pointer: WORD draw_text_empty_byte
draw_text_empty_byte: BYTE '$'
turbosound_setting_byte: BYTE 00010001b ; turbosound enabled
turbosound_flip_modules: BYTE 0

;
; end of code
;
code_end:

; variables here
vars:
	; 8 bytes
upper_point_lower_point: EQU vars + 8
	; 2 bytes
upper_point_x: EQU upper_point_lower_point + 2
	; 1 byte
silk_header: EQU upper_point_x + 1
	; 2 bytes
silk_data: EQU silk_header + 2
	; 192*2 bytes
silk_end: EQU silk_data + 192*2
drawing_code_vault: EQU silk_end
	; 13384 bytes
wraparound_area: EQU drawing_code_vault + 13384
	; 16 bytes
drawing_code_vault_end: EQU wraparound_area + 16

shedule: EQU drawing_code_vault_end
shedule_size: EQU 100
shedule_entry_size: EQU 9
	; 9 * 100 bytes ; [hl register] [drawing code] [ret patch] [enable] [frame number]
erase_queue: EQU shedule + shedule_entry_size * shedule_size
erase_queue_size: EQU 32
	; 32 * 6 ; [hl register] [drawing code] [ret patch]
erase_queue_end: EQU erase_queue + erase_queue_size * 6

	
	ORG $4000
basic_loader:
  db $00,$0a,$15,$00,$f5 ; PRINT
  db $22,$63,$75,$73,$74,$6f,$6d,$20,$44,$49,$59,$20,$6c,$6f,$61,$64  ; "custom DIY load
  db $65,$72,$22,$0d,$00,$14,$07,$00,$20,$ef,$22,$22,$20,$af,$0d,$00  ;
  db $1e,$0f,$00,$20,$f9,$c0,$33,$32,$37,$36,$38,$0e,$00,$00,$00,$80  ; ... ..32768.....
  db $00,$0d,$80,$0d,$80,$80,$00,$00,$00,$00,$00,$36,$38,$0e,$00,$00  ; ...........68...
basic_loader_end:
  EMPTYTAP "fischinger.tap"
  SAVETAP "fischinger.tap",BASIC,"diy_loader",basic_loader,basic_loader_end - basic_loader, 10
  SAVETAP "fischinger.tap",CODE,"usr32768",$8000,code_end - $8000,$8000
  SAVEBIN "fischinger.bin",$8000,code_end - $8000
  
