	org $600
start

; ******************************
; CIO equates
; ******************************
ICHID equ    $0340
ICDNO equ    $0341
ICCOM equ    $0342
ICSTA equ    $0343
ICBAL equ    $0344
ICBAH equ    $0345
ICPTL equ    $0346
ICPTH equ    $0347
ICBLL equ    $0348
ICBLH equ    $0349
ICAX1 equ    $034A
ICAX2 equ    $034B
CIOV  equ    $E456
; ******************************
; Other equates needed
; ******************************
COLOR0 equ   $02C4
COLCRS equ   $55
ROWCRS equ   $54
ATACHR equ   $02FB
STORE1 equ   $CC
STOCOL equ   $CD

;;	lda #10
;	jsr GRAFIC
;;       PHA           ; Store on stack
       LDX #$60      ; IOCB6 for screen
       LDA #$C       ; CLOSE command
       STA ICCOM,X   ; in command byte
       JSR CIOV      ; Do the CLOSE
       LDX #$60      ; The screen again
       LDA #3        ; OPEN command
       STA ICCOM,X   ; in command byte
       LDA #NAME&255 ; Name is "S:"
       STA ICBAL,X   ; Low byte
       LDA #NAME/256 ; High byte
       STA ICBAH,X
;;       PLA           ; Get GRAPHICS n
		lda #10
       STA ICAX2,X   ; Graphics mode
;;       AND #$F0      ; Get high 4 bits
;;       EOR #$10      ; Flip high bit
;;       ORA #$C       ; Read or write
	lda #$1E
       STA ICAX1,X   ; n+16, n+32 etc.
       JSR CIOV      ; Setup GRAPHICS n
	
;	lda #$CF
;	sta 705

;	lda #0
;	ldx #0
;	ldy #0
;	jsr PLOT ; X=low byte X,A=High byte X,Y - position Y
;	
;	ldx #70
;	lda #0
;	ldy #70
;	jsr DRAWTO

;20 X=0:C=1:Y=0
	ldy #0
	STA COLCRS+1 ; no high coordinates
	sty $CB ; X
	sty $CC ; Y
	iny
	sty $CD ; C
	; $CE-counter I
L30
;30 COLOR C
	lda $CD
	sta STOCOL
	
	LDA #4
	sta $CE
;FOR I=0 TO 3
ILP1
;40   PLOT X,0
	ldx $CB
	ldy #0
	jsr PLOT ; X=low byte X Y - position Y
; DRAWTO 79-X,191
	ldy #191
	lda #79
	sec
	sbc $CB
	tax
	jsr DRAWTO
;41   X=X+1
	inc $CB
; NEXT I
;	pla
;	clc
;	adc #$FF
	dec $CE
	bne ILP1
;50 C=C+1:IF C=5 THEN C=1
	jsr inccol
;55 IF X<80 THEN 30
	lda $CB
	cmp #80
	bcc L30
;57 C=1 already =1
L61
;61 COLOR C
	lda $CD
	sta STOCOL

	lda #16
	sta $CE
; FOR I=0 TO 15
ILP2
;62   PLOT 79,Y
	ldx #79
	ldy $CC ;Y
	jsr PLOT ; X=low byte X Y - position Y
; DRAWTO 0,191-Y
	lda #191
	sec
	sbc $CC
	tay
	ldx #0
	jsr DRAWTO
;63   Y=Y+1
	inc $CC
; NEXT I
	dec $CE
	bne ILP2
;64 C=C+1:IF C=5 THEN C=1
	jsr inccol
;65 IF Y<192 THEN 61
	lda $CC
	cmp #192
	bcc L61

;70 P=7:POKE 705,$1F:POKE 706,$59:POKE 707,$59:POKE 708,$1F:PAUSE P
;71 POKE 705,$59:POKE 706,$1F:POKE 707,$1F:POKE 708,$59:PAUSE P
;72 POKE 705,$59:POKE 706,$59:POKE 707,$1F:POKE 708,$1F:PAUSE P

mm
 ldx #0
mm1
 ldy #5
dl ; wait_frame
RTCLOK      equ $0012
      lda RTCLOK+2
waits
      cmp RTCLOK+2
       beq waits
 dey
 bne dl
; copy colors
cc	lda colt,x
	sta 705,y
	sta $d013,y
	inx
	iny
	cpy #4
	bne cc
	cpx #12
	bne mm1
	beq mm



inccol
	ldx $CD
	inx
	cpx #5
	bne nolpc
	ldx #1
nolpc
	stx $CD
	rts

;https://www.atariarchives.org/alp/chapter_10.php
; ******************************
; The POSITION command
; ******************************
; Identical to the BASIC
; POSITION X,Y command.
; Since X may be greater than
; 255 in GRAPHICS 8, we need to
; use the accumulator for the
; high byte of X.
POSITN
       STX COLCRS    ; Low byte of X
;;       STA COLCRS+1  ; High byte of X
       STY ROWCRS    ; Y position
       RTS           ; All done
; ******************************
; The PLOT command f1ca
; ******************************
; We'll use the X,Y, and A just
; like in the POSITION command.
PLOT
       JSR POSITN    ; To store info
       LDX #$60      ; For the screen
       LDA #$B       ; Put record
       STA ICCOM,X   ; Command byte
       LDA #0        ; Special case of
       STA ICBLL,X   ;  I/O using the
       STA ICBLH,X   ;  accumulator
       LDA STOCOL    ; Get COLOR to use
       JMP CIOV      ; Plot the point
;;       JSR CIOV      ; Plot the point
;;       RTS           ; All done
; ******************************
; The DRAWTO command
; ******************************
; We'll use the X,Y, and A just
; like in the POSITION command
DRAWTO
       JSR POSITN    ; To store info
       LDA STOCOL    ; Get COLOR
       STA ATACHR    ; Keep CIO happy
       LDX #$60      ; The screen again
       LDA #$11      ; For DRAWTO
       STA ICCOM,X   ; Command byte
       LDA #$C       ; As in XIO
       STA ICAX1,X   ; Auxiliary 1
       LDA #0        ; Clear
       STA ICAX2,X   ; Auxiliary 2
       JMP CIOV      ; Draw the line
;       JSR CIOV      ; Draw the line
;       RTS           ; All done

V1 equ $1F
V2 equ $58
colt
; dta $1f,$59,$59,$1f
 dta V1,V2,V2,V1
 
; dta $59,$1f,$1f,$59
 dta V2,V1,V1,V2

; dta $59,$59,$1f,$1f
 dta V2,V2,V1,V1
; ******************************
; The screen's name
; ******************************
NAME   ;.BYTE "S:",$9B
 dta  c'S:',$9B
;-------------------------------------------------------------
;;	run start
