'use strict'

const textures = {
    default: {
        size: 2,
        data: [1,0,0,1]
    }
}

const failedTextureLookups = []

function getTexture (textureName) {
    const texture = textures[textureName]
    if (texture) {
        return texture
    } else {
        if (!failedTextureLookups.includes(textureName)) {
            console.error(`getTexture failed to find texture '${textureName}`)
            failedTextureLookups.push(textureName)
        }
        return textures['default']
    }
}


const TUNNEL_TEX_SIZE = 40
const tunnelTex = new Float32Array(TUNNEL_TEX_SIZE * TUNNEL_TEX_SIZE)
{
    let index = 0
    for (let y = 0; y < TUNNEL_TEX_SIZE; ++y) {
        const dy = (y + 0.5) - (TUNNEL_TEX_SIZE / 2)
        const dys = dy * dy
        for (let x = 0; x < TUNNEL_TEX_SIZE; ++x) {
            const dx = (x + 0.5) - (TUNNEL_TEX_SIZE / 2)
            const dxs = dx * dx
            const d = Math.sqrt(dxs + dys)
            let v = Math.max(1 - (d / TUNNEL_TEX_SIZE * 1.25), 0)
            if (y === 0 || y === TUNNEL_TEX_SIZE-1 ||
                x === 0 || x === TUNNEL_TEX_SIZE-1) {
                v = 0
            }
            tunnelTex[index++] = v * 1
        }
    }
}
textures['square'] = {
    size: TUNNEL_TEX_SIZE,
    data: tunnelTex
}


const BALL_SIZE = 13
const ball = new Float32Array(BALL_SIZE * BALL_SIZE)
{
    let index = 0
    for (let y = 0; y < BALL_SIZE; ++y) {
        const dy = (y + 0.5) - (BALL_SIZE / 2)
        const dys = dy * dy
        for (let x = 0; x < BALL_SIZE; ++x) {
            const dx = (x + 0.5) - (BALL_SIZE / 2)
            const dxs = dx * dx
            const d = Math.sqrt(dxs + dys)
            const v = Math.max(1 - (d / BALL_SIZE * 2.5), 0)
            ball[index++] = v
        }
    }
}
textures['ball'] = {
    size: BALL_SIZE,
    data: ball
}


const HOOP_SIZE = 15
const hoop = new Float32Array(HOOP_SIZE * HOOP_SIZE)
{
    let index = 0
    for (let y = 0; y < HOOP_SIZE; ++y) {
        const dy = (y + 0.5) - (HOOP_SIZE / 2)
        const dys = dy * dy
        for (let x = 0; x < HOOP_SIZE; ++x) {
            const dx = (x + 0.5) - (HOOP_SIZE / 2)
            const dxs = dx * dx
            const d = Math.sqrt(dxs + dys)
            let v = (Math.max(1 - (d / HOOP_SIZE * 2.5), 0))
            v = 1 - Math.pow((Math.abs(v - 0.5) + 0.5), 0.5)
            hoop[index++] = v
        }
    }
}
textures['hoop'] = {
    size: HOOP_SIZE,
    data: hoop
}


const BORDER_TEX_SIZE = 30
const borderTex = new Float32Array(BORDER_TEX_SIZE * BORDER_TEX_SIZE)
{
    let index = 0
    for (let y = 0; y < BORDER_TEX_SIZE; ++y) {
        for (let x = 0; x < BORDER_TEX_SIZE; ++x) {
            let v
            if (!(y <= 1 || y >= BORDER_TEX_SIZE-2 ||
                x <= 1 || x >= BORDER_TEX_SIZE-2)) {
                v = 0
            } else {
                v = 1
            }
            borderTex[index++] = v * 1
        }
    }
}
textures['border'] = {
    size: BORDER_TEX_SIZE,
    data: borderTex
}


const STRIPE_TEX_SIZE = 20
const HALF_STRIPE_TEX_SIZE = STRIPE_TEX_SIZE / 2
const stripeTex = new Float32Array(STRIPE_TEX_SIZE * STRIPE_TEX_SIZE)
{
    let index = 0
    for (let y = 0; y < STRIPE_TEX_SIZE; ++y) {
        for (let x = 0; x < STRIPE_TEX_SIZE; ++x) {
            const v = ((x + y) % HALF_STRIPE_TEX_SIZE) / HALF_STRIPE_TEX_SIZE
            stripeTex[index++] = v
        }
    }
}
textures['stripe'] = {
    size: STRIPE_TEX_SIZE,
    data: stripeTex
}


const GRADIENT_TEX_SIZE = 100
const gradientTex = new Float32Array(GRADIENT_TEX_SIZE * GRADIENT_TEX_SIZE)
{
    const rng = new Math.seedrandom('gradient')
    let index = 0
    for (let y = 0; y < GRADIENT_TEX_SIZE; ++y) {
        for (let x = 0; x < GRADIENT_TEX_SIZE; ++x) {
            let v = (1 - (x / GRADIENT_TEX_SIZE))
            v **= 9
            v += rng() * .05
            gradientTex[index++] = v
        }
    }
}
textures['gradient'] = {
    size: GRADIENT_TEX_SIZE,
    data: gradientTex
}
