'use strict'

modules['fixBuffer'] = {
    config: [
        ['multiply', 'float', 1],
        ['lift', 'float', 0],
        ['cap', 'float', 1000],
        ['fixBorder', 'boolean', false],
    ],

    render: async (frameTime, self, config) => {
        const {
            multiply,
            lift,
            cap,
            fixBorder,
        } = { ...config }

        const greyscaleBuffer = greyscaleBuffers[getOutputBufferId()]
        
        if (multiply !== 1 || lift !== 0 || cap !== 1000) {
            for (let i = 0; i < 640 * 480; ++i) {
                greyscaleBuffer[i] = Math.min(Math.max(greyscaleBuffer[i] * multiply + lift, 0), cap)
            }
        }
        
        if (fixBorder) {
            for (let i = 0; i < 640; ++i) {
                greyscaleBuffer[i] = greyscaleBuffer[i + 479*640] = 0
            }
            for (let i = 1; i < 479; ++i) {
                greyscaleBuffer[i*640] = greyscaleBuffer[i*640 + 639] = 0
            }
        }
    }
}
