'use strict'

modules['dust'] = {
    config: [
        ['brightness', 'float', 1],
        ['size', 'float', 1],
        ['amount', 'float', 1],
        ['wobble', 'float', 1],
        ['position', 'float2', [0, 0]],
        ['texture', 'string', 'default'],
    ],

    init: (self) => {
        const DUST_COUNT = 2000
        const dust = []
        const dustRnd = new Math.seedrandom('dust')
        for (let i = 0; i < DUST_COUNT; ++i) {
            const x = dustRnd() * 700
            const y = dustRnd() * 700
            const s = dustRnd() * 4 + 2
            const a = dustRnd() * 2 * Math.PI
            dust.push([x, y, s, a])
        }

        return {
            DUST_COUNT,
            dust
        }
    },

    render: async (time, self, config) => {
        const {
            brightness,
            size,
            amount,
            wobble,
            position,
            texture,
        } = { ...config }

        const balls = []
        for (let i = 0; i < self.DUST_COUNT * amount; ++i) {
            const [x, y, s, a] = self.dust[i]
            const ox = Math.sin(a + wobble) * 40
            const oy = Math.cos(a + wobble) * 40
            const fx = Math.floor((x + ox + position[0] + 10000) % 800)
            const fy = Math.floor((y + oy + position[1] + 10000) % 800)
            balls.push([fx, fy, brightness, s * size])
        }
        drawBallsNegative(balls, texture)
    }
}
