precision mediump float;
uniform vec3 projector_pos;
uniform mat4 projector_rot;
uniform float projector_range;
varying vec2 vTexcoord0;
varying vec3 vTexcoord1;
uniform samplerCube s_texture0;
uniform sampler2D s_texture1;

void main() {
	vec3 dir = vec3(vTexcoord0.xy - vec2(0.5), 0.0) * 10.0 - projector_pos;
	float dist = length(dir) / projector_range;
	dist = 1.0 - min(1.0, dist);
	
	vec4 color = texture2D(s_texture1, vTexcoord0);
	vec4 cube = textureCube(s_texture0, vTexcoord1);
	gl_FragColor = cube * color * dist;
}