#version 430

#include <shaders/materials/commons.glsl>

in vec2 vTexcoord0;
uniform sampler2D s_texture0;		// color
uniform usampler2D s_texture1;		// normal + materialid

uniform vec2 vResolution;
uniform vec2 vResolutionInv;

uniform float strength;
uniform float factor;
uniform float g_global_time;

// output for 2 buffers
layout(location = 0) out vec4 outColor;

float diff_edge(sampler2D sampler, vec2 pos)
{
	//return dot(vec3(0.0, 0.0, 0.5), texture(sampler, pos).xyz - 0.5);
	return texture(sampler, pos).z;
}

vec2 warp_coords(vec2 uv, float dist)
{
	//vec2 cc = coord - 0.5;
	//return coord + 2.0 * cc * amt;

	uv = uv * 2.0 - 1.0;
	// positive values of K1 give barrel distortion, negative give pincushion
	float barrelDistortion1 = 0.1 * dist; // K1 in text books
	float barrelDistortion2 = -0.025 * dist; // K2 in text books

	float r2 = dot(uv,uv);
	uv *= 1.0 + barrelDistortion1 * r2 + barrelDistortion2 * r2 * r2;
	//uv *= 1.0 + barrelDistortion1 * r2;
	
	// tangential distortion (due to off center lens elements)
	// is not modeled in this function, but if it was, the terms would go here
	return uv * 0.5 + 0.5;
}

#define RANGE 3.0
vec3 edgedetect(usampler2D normal_sampler, vec3 origin_sample, vec2 position)
{
	vec3 result = vec3(0.0);
#if 1  // less sensitive but maybe better?
	for(float y=-RANGE; y<= RANGE; y+=1.0)
	{
		for(float x=-RANGE; x<= RANGE; x+=1.0)
		{
			vec2 sample_pos = position + vec2(x, y) * vResolutionInv.xy;
			result.xyz += decode_normal(texture(normal_sampler, sample_pos.xy).r);
		}
	}	

	result *= 1.0/(((RANGE+1.0)*(RANGE+1.0)));
	result = normalize(result);

	return vec3(dot(result, origin_sample));// + (result - origin_sample) * 0.1;
#else
	float result_x = 0.0;
	float result_y = 0.0;
	result_x += 1.0 * diff_edge(normal_sampler, position + vec2(-1.0, -1.0) * vResolutionInv.xy);
	result_x += 2.0 * diff_edge(normal_sampler, position + vec2(-1.0,  0.0) * vResolutionInv.xy);
	result_x += 1.0 * diff_edge(normal_sampler, position + vec2(-1.0,  1.0) * vResolutionInv.xy);
	result_x -= 1.0 * diff_edge(normal_sampler, position + vec2( 1.0, -1.0) * vResolutionInv.xy);
	result_x -= 2.0 * diff_edge(normal_sampler, position + vec2( 1.0,  0.0) * vResolutionInv.xy);
	result_x -= 1.0 * diff_edge(normal_sampler, position + vec2( 1.0,  1.0) * vResolutionInv.xy);

	result_y += 1.0 * diff_edge(normal_sampler, position + vec2(-1.0, -1.0) * vResolutionInv.xy);
	result_y += 2.0 * diff_edge(normal_sampler, position + vec2( 0.0, -1.0) * vResolutionInv.xy);
	result_y += 1.0 * diff_edge(normal_sampler, position + vec2( 1.0, -1.0) * vResolutionInv.xy);
	result_y -= 1.0 * diff_edge(normal_sampler, position + vec2(-1.0,  1.0) * vResolutionInv.xy);
	result_y -= 2.0 * diff_edge(normal_sampler, position + vec2( 0.0,  1.0) * vResolutionInv.xy);
	result_y -= 1.0 * diff_edge(normal_sampler, position + vec2( 1.0,  1.0) * vResolutionInv.xy);

	float l = sqrt(result_x * result_x + result_y * result_y);
	l = clamp(l - 0.8, 0.0, 1.0);

	return vec3(1.0 - l);
#endif

}
 
void main()
{
	float f = factor;
	//vec2 uv = vTexcoord0;// warp_coords(vTexcoord0, -2.6);
	vec2 uv = warp_coords(vTexcoord0, f * -1.6);

	uint encoded_normal_material = texture(s_texture1, uv).r;

	vec4 base_color = texture(s_texture0, uv);
	vec3 base_normal = normalize(decode_normal(encoded_normal_material));
	float factor1 = 1.4 * sin(uv.y * 64.4 + g_global_time * 0.421);
	float factor2 = 1.0 * sin(uv.y * 11410.4 + g_global_time * 4.031217);
	float factor3 = 1.4 * sin(uv.y * 1410.4 + g_global_time * 5.031217);

	outColor.a = base_color.a;
	outColor.rgb = base_color.rgb + strength * (clamp(factor2 * 0.5, -1.0, 1.0) + clamp(1.5 + factor1 * factor3, 0.5 , 2.5) * clamp(vec3(1.0) - edgedetect(s_texture1, base_normal.xyz, uv), vec3(0.0), vec3(1.0)));

}
