precision mediump float;
varying vec2 vTexcoord0;
uniform sampler2D s_texture0;
uniform sampler2D s_texture1;
uniform sampler2D s_texture2;
uniform float timediff;
uniform float scale;

// tex0 - current particle position (x/y packed, 16bit signed int)
// tex1 - velocity buffer (x/y packed, 16bit signed int)

// all coords in range of -128/+128 with 16bit of precision

mediump vec2 unpack(mediump vec4 v4)
{	
	mediump vec2 uv1 = v4.xz;
	mediump vec2 uv2 = v4.yw * 255.0;
	uv1 += uv2 - 128.0;
	return uv1;
	//return (uv1 + uv2) - 128.0;
}

mediump vec4 pack(mediump vec2 v2)
{
	v2 += 128.0;
	mediump vec2 uv1 = fract(v2);
	mediump vec2 uv2 = (v2 - uv1) / 255.0; 
	return vec4(uv1.x, uv2.x, uv1.y, uv2.y);
}

vec4 EncodeFloatRGBA( float v ) {
  vec4 enc = vec4(1.0, 255.0, 65025.0, 16581375.0) * v;
  enc = fract(enc);
  enc -= enc.yzww * vec4(1.0/255.0,1.0/255.0,1.0/255.0,0.0);
  return enc;
}
float DecodeFloatRGBA( vec4 rgba ) {
  return dot( rgba, vec4(1.0, 1.0/255.0, 1.0/65025.0, 1.0/16581375.0) );
}

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main() {
	mediump vec2 pos = unpack(texture2D(s_texture0, vTexcoord0));
	//vec2 vel = unpack(texture2D(s_texture1, vTexcoord0)); // this is causing to always read velocity from same point and not using vector field 
	
	mediump vec2 fieldpos = (pos + 128.0) / 255.0;
	mediump vec2 vel = unpack(texture2D(s_texture1, fieldpos));
	mediump vec4 speed = texture2D(s_texture2, vTexcoord0);
	
	pos += vel * (timediff * speed.x);
	
	if (abs(pos.x) > 127.0) // leave that to overflow?
	{
		// this is a crappy new position generation but rand() is slow
		float r = rand(pos);
		pos.y = 100.0 * r;
		
		pos.x = -110.0 * sign(pos.x) + r * 15.0;
	}

	if (abs(pos.y) > 127.0) // leave that to overflow?
	{
		pos.y = -pos.y;
	}
	
	gl_FragColor = pack(pos);
	
	
}