precision mediump float;
uniform vec4 vColor;
varying vec2 vTexcoord0;
uniform sampler2D s_texture0;
uniform sampler2D s_texture1;
uniform sampler2D s_texture2;

uniform float fade;

// unit 0 blurred image
// unit 1 base image

void main() {
	// load depth from alpha component of blurred one

	vec4 fog = texture2D(s_texture2, vTexcoord0);
	vec4 blurred = texture2D(s_texture0, vTexcoord0);
	float shift = 12.0 / 256.0;
	vec4 blurred_shifted = texture2D(s_texture0, vTexcoord0 - shift);
	vec4 color = texture2D(s_texture1, vTexcoord0);

	float depth_diff = clamp(- (blurred_shifted.w - color.w), 0.0, 1.0);
	depth_diff = min(pow(depth_diff, 0.8), 0.1);

	// don't bleed to background. TODO: this is a hack. fix at blurring stage

	if (color.w > 0.95)
		depth_diff = 0.0;


	// fogging
	
	// try to isolate background without conditionals;)
	// this will also affect geometry very near the far clipping plane...
	float basedepth = color.w;
	float isbg = clamp((basedepth - 0.95) * 9.0, 0.0, 0.6);	// 1 = background. we want only little fog there
	
	float depth = 0.2;					// where do we start (reference depth)
	float noise = fog.r * 4.0 * 0.10;	// 4 to compensate for 0.25 in fog.fsh
	depth = depth - noise;
	
	//depth = clamp(depth, 0.0, 1.0);
	//depth = pow(depth, 1.3);

	float f = clamp((basedepth - depth) - 0.3 - isbg, 0.0, 4.5);
	vec2 foo = (vTexcoord0.xy - 0.5) * (vTexcoord0 - 0.5);
	float vi = 1.0 - sqrt(foo.x + foo.y);
	vi = vi * vi * 1.2;
	//gl_FragColor = vec4(depth_diff * 3.0);//vec4(blurred_shifted.w);
	gl_FragColor = vi * fade * ((f - depth_diff) + color + blurred.xyzw * 0.4);
}