#version 430

#include <shaders/materials/commons.glsl>

layout(std430) buffer VTXCoords {
	float coords[];
} vtx_coords;

vec3 vtx_coords_load(uint idx)
{
	return vec3(vtx_coords.coords[idx * 3 + 0], vtx_coords.coords[idx * 3 + 1], vtx_coords.coords[idx * 3 + 2]);
}

layout(std430) buffer VTXNormals {
	float normals[];
} vtx_normals;

vec3 vtx_normals_load(uint idx)
{
	return vec3(vtx_normals.normals[idx * 3 + 0], vtx_normals.normals[idx * 3 + 1], vtx_normals.normals[idx * 3 + 2]);
}

//uniform mat4 mModelview;
uniform mat4 mModel;
uniform vec4 vModelview[3];
uniform vec4 vModelviewInvTrans[3];
//uniform vec4 vProjection;
uniform mat4 mProjection;

// shadows
uniform mat4 mShadowMV;
uniform mat4 mShadowP;
out vec4 vShadowCoords;
out vec4 vCoords;

out vec3 vNorm;
out vec3 vWorldNorm;
out vec3 vLocalCoords;
out vec4 vWorldPos;

void main() {
	
	vec3 pos = vtx_coords_load(gl_VertexID);
	vec3 norm = vtx_normals_load(gl_VertexID);

	vLocalCoords = pos;

	//vPos = mModelview * vec4(pos, 1.0);
	
	vec4 vPos1 = vec4(pos, 1.0);
	vec4 vPos;
	vPos.x = dot(vModelview[0], vPos1);
	vPos.y = dot(vModelview[1], vPos1);
	vPos.z = dot(vModelview[2], vPos1);
	vPos.w = 1.0;
	vWorldPos = mModel * vPos1;
	vWorldNorm = (mModel * vec4(norm, 0.0)).xyz;

	vNorm.x = dot(vModelviewInvTrans[0].xyz, norm);
	vNorm.y = dot(vModelviewInvTrans[1].xyz, norm);
	vNorm.z = dot(vModelviewInvTrans[2].xyz, norm);
	vNorm = normalize(vNorm);//vNormal;

	//vPos = vec4(vProjection.x * vPos.x, vProjection.y * vPos.y, dot(vProjection.zw, vPos.zw), -vPos.z);	
	vPos = mProjection * vPos;
	gl_Position = vPos;

	//float bri = clamp(0.5 + (vAttribute1 - 0.5) * 100.0, 0.0, 1.0);
	//brightness = vBrightness;
	//overbright = bri;

	// shadows. mModel * vPos1 is in world coords!
	vShadowCoords = mShadowP * mShadowMV * mModel * vec4(vPos1.xyz, 1.0);
	//vShadowCoords = mShadowP * mShadowMV * vec4(vWorldPos.xyz, 1.0);
	//vWorldPos = mModel * vec4(vPos1.xyz, 1.0);
	vCoords = vPos;
}
