#version 430

#extension GL_NV_gpu_shader5 : enable

#include <shaders/materials/commons.glsl>
#include <shaders/commons_hlsl.glsl>
#include <shaders/materials/raytrace_buffers.glsl>
#include <shaders/materials/raytrace_commons.glsl>

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};

#ifndef PARTITION_VOXELIZE
out Vertex
{
	vec3 vCoords;
	f16vec3 vNorm;
	f16vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_output;
#else
out Vertex
{
	vec3 vLocalPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_output;
#endif

#ifdef VISUALIZE_RAYTRACE_GRID

vec3 get_vertex(uint idx)
{
	// in this mode we draw instanced triangle strips of 14 vertices. this should be ok for decent perf.

	uint voxel_idx = gl_InstanceID;
	vec3 voxel_p;
	voxel_p.x = float(voxel_idx % GRID_RES);
	voxel_p.y = float((voxel_idx / GRID_RES) % GRID_RES);
	voxel_p.z = float((voxel_idx / (GRID_RES * GRID_RES)) % GRID_RES);

	vec3 p = vec3((ivec3(0x287a, 0x2af, 0x31e3) >> idx) & 1);

	//float scale = in_buckets.sizes[voxel_idx] > 0 ? 0.2 : 0.0;
	float scale = in_buckets.sizes[voxel_idx] > 0 ? 0.9 : 0.0;

	//vec3 size = vec3(min(in_buckets.grid_size.x, min(in_buckets.grid_size.y, in_buckets.grid_size.z)));
	vec3 size = in_bbox_data.grid_size_raytrace.xyz;
	p = vec3(voxel_p) * in_bbox_data.grid_size_raytrace.xyz + in_bbox_data.bbox_raytrace_min.xyz + p * size * scale;

	return p;
}

vec3 get_vertex_normal(uint idx)
{
	return vec3(1.0, 1.0, 0.0);	// rebuild in ps
}

vec2 get_vertex_uv0(uint idx)
{
	return vec2(0.0);
}

vec4 get_vertex_color(uint idx)
{
	return vec4(0.1);
}

#elif defined(VISUALIZE_VOXELIZATION_GRID)

uniform sampler3D s_voxel_colors;
uniform sampler3D s_voxel_colors_filtered;
uniform sampler3D s_voxel_occupancy;
uniform sampler3D s_voxel_occupancy_filtered;

vec3 get_vertex(uint idx)
{
	// in this mode we draw instanced triangle strips of 14 vertices. this should be ok for decent perf.

	uint voxel_idx = gl_InstanceID;
	vec3 voxel_p;
	voxel_p.x = float(voxel_idx % GRID_RES);
	voxel_p.y = float((voxel_idx / GRID_RES) % GRID_RES);
	voxel_p.z = float((voxel_idx / (GRID_RES * GRID_RES)) % GRID_RES);

	vec3 p = vec3((ivec3(0x287a, 0x2af, 0x31e3) >> idx) & 1);

	float scale = texelFetch(s_voxel_occupancy, ivec3(voxel_p), 0).r * 0.8;

	//vec3 size = vec3(min(in_buckets.grid_size.x, min(in_buckets.grid_size.y, in_buckets.grid_size.z)));
    vec3 size = in_bbox_data.grid_size_voxelize.xyz;
    p = vec3(voxel_p) * in_bbox_data.grid_size_voxelize.xyz + in_bbox_data.bbox_voxelize_min.xyz + p * size * scale;

	return p;
}

vec3 get_vertex_normal(uint idx)
{
	return vec3(1.0, 1.0, 0.0);	// rebuild in ps
}

vec2 get_vertex_uv0(uint idx)
{
	return vec2(0.0);
}


vec4 get_vertex_color(uint idx)
{
	uint voxel_idx = gl_InstanceID;
	vec3 voxel_p;
	voxel_p.x = float(voxel_idx % GRID_RES);
	voxel_p.y = float((voxel_idx / GRID_RES) % GRID_RES);
	voxel_p.z = float((voxel_idx / (GRID_RES * GRID_RES)) % GRID_RES);

	vec4 color;
	color.rgb = color_convert_rgbm_rgb(textureLod(s_voxel_colors_filtered, (voxel_p + 0.5) / float(GRID_RES), 0.0));
	color.a = 1.0;
	return color.xyzw + 0.1;
}

#else

vec3 get_vertex(uint idx)
{
    return rt_get_vertex(idx);
}

vec3 get_vertex_normal(uint idx)
{
	return rt_get_vertex_normal(idx);
}

vec2 get_vertex_uv0(uint idx)
{
	return rt_get_vertex_uv0(idx);
}

vec4 get_vertex_color(uint idx)
{
	return vec4(1.0, 0.0, 1.0, 1.0);
}

#endif

void main() {
	
#if defined(PROXY_PASS_STENCIL_PRIMID) && defined(RAYTRACE_PASS)

	// emit 2 fullscreen triangles
	vec3 pos = vec3(0.0);
	if (gl_VertexID == 0)
	{
		pos = vec3(-1.0, 1.0, 0.0);
	}
	if (gl_VertexID == 1)
	{
		pos = vec3( 1.0, 1.0, 0.0);
	}
	if (gl_VertexID == 2)
	{
		pos = vec3(1.0, -1.0, 0.0);
	}
	if (gl_VertexID == 3)
	{
		pos = vec3(-1.0, -1.0, 0.0);
	}
	vec3 norm = vec3(0.0, 0.0, -1.0);

	vtx_output.vLocalPos = pos;

	vec4 vPos1 = vec4(pos, 1.0);
	vtx_output.vWorldPos = vPos1.xyz;
	vtx_output.vWorldNorm = f16vec3(norm);

	vtx_output.vNorm.x = float16_t(dot(transform_params.mModelViewInvTrans[0].xyz, norm));
	vtx_output.vNorm.y = float16_t(dot(transform_params.mModelViewInvTrans[1].xyz, norm));
	vtx_output.vNorm.z = float16_t(dot(transform_params.mModelViewInvTrans[2].xyz, norm));
	vtx_output.vNorm = normalize(vtx_output.vNorm);//vNormal;

	vtx_output.vCoords = vPos1.xyz;
	gl_Position = vPos1;
	vtx_output.vColor = f16vec4(1.0);
	vtx_output.vUV0 = f16vec2(0.0);

#else

	vec3 pos = get_vertex(gl_VertexID);
	vec3 norm = get_vertex_normal(gl_VertexID);

	vtx_output.vLocalPos = pos;
	//vPos = mModelview * vec4(pos, 1.0);
	vec4 vPos1 = vec4(pos, 1.0);
	vec3 vPos = vector_transform_by_mat43(pos, transform_params.mModelView);

#ifndef PARTITION_VOXELIZE
	
	vtx_output.vWorldPos = vector_transform_by_mat43(pos, transform_params.mModel);
	vtx_output.vWorldNorm = f16vec3(transform_params.mModel * vec4(norm, 0.0)).xyz;

	vtx_output.vNorm.x = float16_t(dot(transform_params.mModelViewInvTrans[0].xyz, norm));
	vtx_output.vNorm.y = float16_t(dot(transform_params.mModelViewInvTrans[1].xyz, norm));
	vtx_output.vNorm.z = float16_t(dot(transform_params.mModelViewInvTrans[2].xyz, norm));
	vtx_output.vNorm = normalize(vtx_output.vNorm);//vNormal;
#endif

#if defined(PROXY_PASS) || defined(RAYTRACE_PASS)
	// in proxy pass we can do culling for parts which are not raytraced but only reflected
	int face_material = rt_get_triangle_material(gl_VertexID / 3);
	if ((materials.material_properties[face_material].flags & MaterialFlag_Raytrace) == 0)
		vPos = vec3(0.0);

	vtx_output.vCoords = vPos.xyz;
#endif

	//vPos = vec4(vProjection.x * vPos.x, vProjection.y * vPos.y, dot(vProjection.zw, vPos.zw), -vPos.z);	
	gl_Position = transform_params.mProjection * vec4(vPos, 1.0);
	vtx_output.vColor = f16vec4(get_vertex_color(gl_VertexID));
	vtx_output.vUV0 = f16vec2(get_vertex_uv0(gl_VertexID));

#endif
}

