#version 430

#extension GL_NV_gpu_shader5 : enable

uniform sampler2D s_LTC1;
uniform sampler2D s_LTC2;
uniform sampler2DArray s_BlueNoise;

#include <shaders/materials/commons.glsl>
#include <shaders/materials/commons_sampling.glsl>
#include <shaders/materials/raytrace_buffers.glsl>
#include <shaders/materials/raytrace_commons.glsl>

#include <shaders/deferred/lighting_support.glsl>

flat in int vOrientationIndex;
in vec3 vGridCoords;
in f16vec2 vUV0;
flat in vec3 vTriCoords[3];
flat in f16vec3 vTriNormal;  // this normal is for the scaled (nonuniform) coords, not real triangle normal

#include <shaders/materials/partition_commons.glsl>
#include <shaders/deferred/support/ltc_quad.glsl>

// ------------------------------------------------------------------------------------------------------------------

vec3 calculate_lighting_world(LightProperties light, in vec3 pos, in vec3 normal, in vec3 light_pos, in float NdotL)
{
	float d = NdotL;
	if (d < 0.0)
		d = 0.0;
	return vec3(vec3(d) * light.diffuse.xyz);
}

// ------------------------------------------------------------------------------------------------------------------

// 1 : mark cell as used
// 2 : if the cell was unmarked then initilize linked list. consume some constant amount of indices from the buffer
// 3 : if the cell was initialized then calculate brick in the cell and insert new triangle into it

// orientation index is to transform triangle into original coors space (0, 1, 2 -> YZ, XZ, XY)

// Thick mode has a problem that is overwrites cells which are shadowed. We should probably
// go with the 'min' mode for color and 'max' for occlusion

#define FRACTIONAL_OCCLUSION
#define FRACTIONAL_OCCLUSION_THICK

void main()
{
	vec3 pos = vGridCoords;

	uint cx = uint(gl_FragCoord.x);
	uint cy = uint(gl_FragCoord.y);
	uint cz = uint(gl_FragCoord.z * GRID_RES);

	vec3 gc = gl_FragCoord.xyz / vec3(1.0, 1.0, 1.0/GRID_RES) + vec3(0.0, 0.0, 0.0);
    //gc.xy += 0.5;
	//vec3 gc = vGridCoords;

	// triangle bbox

	ivec3 mi = ivec3(floor(min(vTriCoords[0], min(vTriCoords[1], vTriCoords[2]))));
	ivec3 ma = ivec3(ceil(max(vTriCoords[0], max(vTriCoords[1], vTriCoords[2]))));
	
    //mi = ivec3(0,0,0);
    //ma = ivec3(GRID_RES-1,GRID_RES-1,GRID_RES-1);

	mi = clamp(mi, ivec3(0), ivec3(GRID_RES-1));
	ma = clamp(ma, ivec3(0), ivec3(GRID_RES-1));

	ivec3 stepDir = ivec3(0);
	uvec3 stepStart = uvec3(0);
	int steps;

	if (vOrientationIndex == 0)
	{
		cy = uint(gc.x);
		cz = uint(gc.y);
		cx = uint(gc.z);
		stepDir = ivec3(1, 0, 0);
		stepStart = uvec3(mi.x, cy, cz);
		steps = ma.x - mi.x;
	}
	else if (vOrientationIndex == 1)
	{
		cz = uint(gc.x);
		cx = uint(gc.y);
		cy = uint(gc.z);

		stepDir = ivec3(0, 1, 0);
		stepStart = uvec3(cx, mi.y, cz);
		steps = ma.y - mi.y;
	}
	else
	{
		cx = uint(gc.x);
		cy = uint(gc.y);
		cz = uint(gc.z);

		stepDir = ivec3(0, 0, 1);
		stepStart = uvec3(cx, cy, mi.z);
		steps = ma.z - mi.z;
	}

	// NOTE: Conservative raster is not enough to properly fill the grid... We need to 
	// Actually trace through the triangle in 'depth' also to make it fully conservative in all dimensions
	// TODO: Conservative raster actually makes it produce a bit too many faces. We might want to optimize this
	// by also calculating triangle distance

	uvec3 storeStepStart = stepStart;
	int stepMin = -1;
	int stepCount = 0;
	int stepIdx = 0;

	do
	{
		vec3 cellPos = vec3(stepStart);
		vec3 cellSize = vec3(1.0);

		if (checkTriCellOverlap(vTriCoords[0], vTriCoords[1], vTriCoords[2], vTriNormal, cellPos + cellSize * 0.5, cellSize * 0.5))
		{
			if (stepMin == -1)
				stepMin = stepIdx;

			uint ccx = stepStart.x;
			uint ccy = stepStart.y;
			uint ccz = stepStart.z;

			// store occlusion information. cell center distance to the triangle. use non-uniform normal and lets see
			// how it works

			#ifdef FRACTIONAL_OCCLUSION
				float d = -dot(vTriNormal, vTriCoords[0]);
				float distance = dot(vTriNormal, cellPos + cellSize * 0.5) + d;
				rt_store_voxel_occlusion(ccx, ccy, ccz, 1.0 - clamp(0.5 + distance, 0.0, 1.0));

				#ifdef FRACTIONAL_OCCLUSION_THICK
					if (vOrientationIndex == 0)
						ccx = ccx - int(sign(vTriNormal.x));
					else if (vOrientationIndex == 1)
						ccy = ccy - int(sign(vTriNormal.y));
					else if (vOrientationIndex == 2)
						ccz = ccz - int(sign(vTriNormal.z));
					ccx = clamp(ccx, 0, uint(GRID_RES - 1));
					ccy = clamp(ccy, 0, uint(GRID_RES - 1));
					ccz = clamp(ccz, 0, uint(GRID_RES - 1));
					rt_store_voxel_occlusion(ccx, ccy, ccz, 1.0);
				#endif
			#else
				rt_store_voxel_occlusion(ccx, ccy, ccz, 1.0);
			#endif

			stepCount++;
		}

		stepStart += stepDir;
		steps--;
		stepIdx++;
	} while(steps > 0);

	if (stepCount == 0)
		return;

	stepStart = storeStepStart + stepDir * stepMin;

	// calculate color only once
	vec3 voxel_color = vec3(0.0);

	{
		int materialIndex = rt_get_triangle_material(gl_PrimitiveID);
		MaterialPropertiesGPU material = materials.material_properties[materialIndex];

		float roughness = material.roughness;

		// calculate basic lighting for voxelization. position is center of the voxel. not optimal, but we will see
		// maybe try projecting voxel center to the actual face? How?
		// If projecting then project to the side where the normal points towards. Should fix some errors
		// NOTE: This world position calculation might be wonky, as we just take first martching voxel

		// TODO/NOTE: We are not using proper interpolated normal!!! This has to be fixed!!!

		vec3 world = (vec3(stepStart)) * in_bbox_data.grid_size_voxelize.xyz + in_bbox_data.bbox_voxelize_min.xyz;

		// project on triangle plane
		vec3 pplane = vTriCoords[0] * in_bbox_data.grid_size_voxelize.xyz + in_bbox_data.bbox_voxelize_min.xyz;
		world = world - dot(world - pplane, vTriNormal) * vTriNormal + vTriNormal * 0.2;
			
		// albedo color. This is very simplistic and should be unified with normal shader
		// TODO: Make fragment shader modifiers pluggable (properly) so we can share them here
		vec3 base_albedo = vec3(1.0);
		vec3 base_emissive = vec3(1.0);
		if (material.albedo_sampler >= 0 && material.albedo_sampler < 16)
			base_albedo.rgb = textureLod(material_textures[material.albedo_sampler], vUV0, 2.0).rgb;
		if (material.emissive_sampler >= 0 && material.emissive_sampler < 16)
			base_emissive.rgb = textureLod(material_textures[material.emissive_sampler], vUV0, 2.0).rgb;

		// iterate through lights. no specular component, only diffuse
		for(int light_idx = 0; light_idx < g_lights_num; light_idx++)
		{
			LightProperties light = lights.light_properties[light_idx];
			vec3 light_color = vec3(0.0);
			f16vec4 projector_color = f16vec4(0.0);

			vec3 pointToLight = light.position.xyz - world.xyz;
			if ((light.type & LightType_Directional) != 0)
				pointToLight = -light.direction.xyz;

			float NdotL = dot(vTriNormal, normalize(pointToLight));
			vec3 lighting = material.diffuse.rgb * calculate_lighting_world(light, world, vTriNormal, light.position.xyz, NdotL);
		
			float shadow = 0.0;
			if (NdotL <= 0.0)
			{
				shadow = 1.0;
			}
			else
			{
				bool calculate_shadows = ((material.flags & MaterialFlag_ShadowReceive) != 0)
				  && ((light.type & LightType_Shadowcasting) != 0);

				if ((light.type & (LightType_Spot | LightType_Directional)) != 0 && calculate_shadows)
				{
					// shadows. NOTE: Here we actually reduce the penumbra as we use simpler sampling
					// NOTE: Might want to include contact shadows for all lights. This greatly reduces
					// leaking...

					float penumbra_scaling_factor = 0.5;

					vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world.xyz, 1.0);
		
					// TODO: Make this configurable, same as in normal lighting
					float penumbraSampleNoise = 0.0;
					float penumbra = PenumbraFromOccluderSearch(
						LightShadowmapSamplers[light.shadowmap_sampler0],
						penumbraSampleNoise,
						vShadowCoords,
						penumbra_scaling_factor * roughness * light.roughness_modifier / 1024.0,
						4,
						materials.material_properties[material].shadowmap_bias);

					float in_frustum = 0.0;
					//shadow = sampleShadow(LightShadowmapCmpSamplers[light.shadowmap_sampler0], vShadowCoords, in_frustum, projector_color);
					shadow = sampleShadowPCF(
						LightShadowmapCmpSamplers[light.shadowmap_sampler0],
						vShadowCoords,
						in_frustum,
						3,
						penumbra_scaling_factor * roughness * penumbra * light.roughness_modifier / 1024.0);

				}
			}

			lighting = lighting * light.diffuse.rgb * light.intensity;
			light_color = vec3(vec3(1.0 - shadow)) * lighting;

			if ((light.type & (LightType_Spot | LightType_Attenuating)) == (LightType_Spot | LightType_Attenuating))
			{
				float attenuation = light_calculate_spot_attenuation(light, world.xyz);
				light_color.xyz *= attenuation;
			}

			if (light.is_area != 0)
			{
				Rect rect;
				InitRect(light, rect);

				vec3 points[4];
				InitRectPoints(rect, points);

				float ltc_roughness = roughness;
				float ltc_intensity = light.intensity;

				vec3 lcol = vec3(ltc_intensity);
				vec3 dcol = vec3(light.diffuse.rgb);

				vec3 col = vec3(0.0);
				vec3 pos = world.xyz;

				vec3 N = vTriNormal;
				vec3 V = vec3(0.0, 0.0, 1.0);

				float ndotv = clamp(dot(N, V), 0.05, 1.0);

				vec2 uv = vec2(ltc_roughness, sqrt(1.0 - ndotv));
				uv = uv*LUT_SCALE + LUT_BIAS;

				vec4 t1 = texture(s_LTC1, uv);
				vec4 t2 = texture(s_LTC2, uv);
		#if 0 // line handling
				ltc_Minv = mat3(
					vec3(t1.x, 0, t1.y),
					vec3(  0,  1,    0),
					vec3(t1.z, 0, t1.w)
				);

				vec3 spec = LTC_Evaluate(N, V, pos);
				// BRDF shadowing and Fresnel
				spec *= scol*t2.x + (vec3(1.0) - scol)*t2.y;

				ltc_Minv = mat3(1);
				vec3 diff = LTC_Evaluate(N, V, pos);
				col  = lcol*(spec + dcol*diff);
				col /= 2.0*PI;
		#else // quad handling

				vec3 diff = LTC_Evaluate_DiffuseOnly(N, pos, mat3(1), points, twoSided);
				col  = lcol * (dcol * diff);
		#endif
		
				light_color.rgb = col;

				if ((light.type & (LightType_Attenuating)) == (LightType_Attenuating))
				{
					float attenuation = light_calculate_area_attenuation(light, world.xyz);
					light_color.rgb *= attenuation;
				}
			}

			voxel_color.rgb += vec3(light_color);
		}

		voxel_color.rgb *= base_albedo;
		voxel_color.rgb += material.emissive.rgb * base_emissive * material.emissive_factor;
		//voxel_color.rgb = vec3(1.0);

		// debugging of the voxel tracing
		//voxel_color.rgb = vec3(vUV0, 0.0);
	}

	stepStart = storeStepStart + stepDir * stepMin;

	while(stepCount-- > 0)
	{
		uint ccx = stepStart.x;
		uint ccy = stepStart.y;
		uint ccz = stepStart.z;

		//if (rt_get_voxel_color(ccx, ccy, ccz).a == 0.0)
		{
			rt_store_voxel_color(ccx, ccy, ccz, vec4(voxel_color, 1.0));
			//rt_store_voxel_normal(int(ccx), int(ccy), int(ccz), vTriNormal);
		}

		#ifdef FRACTIONAL_OCCLUSION
		#ifdef FRACTIONAL_OCCLUSION_THICK

		if (vOrientationIndex == 0)
			ccx = ccx - int(sign(vTriNormal.x));
		else if (vOrientationIndex == 1)
			ccy = ccy - int(sign(vTriNormal.y));
		else if (vOrientationIndex == 2)
			ccz = ccz - int(sign(vTriNormal.z));

		ccx = clamp(ccx, 0, uint(GRID_RES - 1));
		ccy = clamp(ccy, 0, uint(GRID_RES - 1));
		ccz = clamp(ccz, 0, uint(GRID_RES - 1));
		rt_store_voxel_color(ccx, ccy, ccz, vec4(voxel_color, 1.0));

		#endif
		#endif

		stepStart += stepDir;
		steps--;
	}

}

