#version 430

#extension GL_NV_gpu_shader5 : enable

uniform sampler2DArray s_BlueNoise;

#include <shaders/materials/commons.glsl>
#include <shaders/materials/raytrace_buffers.glsl>
#include <shaders/materials/raytrace_commons.glsl>
#include <shaders/deferred/lighting_support.glsl>

flat in int vOrientationIndex;
in vec3 vGridCoords;

flat in vec3 vTriCoords[3];
flat in f16vec3 vTriNormal;   // this normal is for the scaled (nonuniform) coords, not real triangle normal

layout(r32ui, binding = 0) uniform uimage3D imTarget0;
layout(r32ui, binding = 1) uniform uimage3D imTarget2;

#include <shaders/materials/partition_commons.glsl>

// ------------------------------------------------------------------------------------------------------------------

vec3 calculate_lighting_world(LightProperties light, in vec3 pos, in vec3 normal, in vec3 light_pos, in float NdotL)
{
	float d = NdotL;
	if (d < 0.0)
		d = 0.0;
	return vec3(vec3(d) * light.diffuse.xyz);
}

// ------------------------------------------------------------------------------------------------------------------

// 1 : mark cell as used
// 2 : if the cell was unmarked then initilize linked list. consume some constant amount of indices from the buffer
// 3 : if the cell was initialized then calculate brick in the cell and insert new triangle into it

// orientation index is to transform triangle into original coors space (0, 1, 2 -> YZ, XZ, XY)

void main()
{
	vec3 pos = vGridCoords;

	uint cx = uint(gl_FragCoord.x);
	uint cy = uint(gl_FragCoord.y);
	uint cz = uint(gl_FragCoord.z * GRID_RES);

	vec3 gc = gl_FragCoord.xyz / vec3(1.0, 1.0, 1.0/GRID_RES) + vec3(0.0, 0.0, 0.0);
    //gc.xy += 0.5;
	//vec3 gc = vGridCoords;

	// triangle bbox

	ivec3 mi = ivec3(floor(min(vTriCoords[0], min(vTriCoords[1], vTriCoords[2]))));
	ivec3 ma = ivec3(ceil(max(vTriCoords[0], max(vTriCoords[1], vTriCoords[2]))));
	
    //mi = ivec3(0,0,0);
    //ma = ivec3(GRID_RES-1,GRID_RES-1,GRID_RES-1);

	mi = clamp(mi, ivec3(0), ivec3(GRID_RES-1));
	ma = clamp(ma, ivec3(0), ivec3(GRID_RES-1));

	ivec3 stepDir = ivec3(0);
	uvec3 stepStart = uvec3(0);
	int steps;

	if (vOrientationIndex == 0)
	{
		cy = uint(gc.x);
		cz = uint(gc.y);
		cx = uint(gc.z);
		stepDir = ivec3(1, 0, 0);
		stepStart = uvec3(mi.x, cy, cz);
		steps = ma.x - mi.x;
	}
	else if (vOrientationIndex == 1)
	{
		cz = uint(gc.x);
		cx = uint(gc.y);
		cy = uint(gc.z);

		stepDir = ivec3(0, 1, 0);
		stepStart = uvec3(cx, mi.y, cz);
		steps = ma.y - mi.y;
	}
	else
	{
		cx = uint(gc.x);
		cy = uint(gc.y);
		cz = uint(gc.z);

		stepDir = ivec3(0, 0, 1);
		stepStart = uvec3(cx, cy, mi.z);
		steps = ma.z - mi.z;
	}

	// NOTE: Conservative raster is not enough to properly fill the grid... We need to 
	// Actually trace through the triangle in 'depth' also to make it fully conservative in all dimensions
	// TODO: Conservative raster actually makes it produce a bit too many faces. We might want to optimize this
	// by also calculating triangle distance

	uvec3 storeStepStart = stepStart;
	int stepMin = -1;
	int stepCount = 0;
	int stepIdx = 0;

	do
	{
		vec3 cellPos = vec3(stepStart);
		vec3 cellSize = vec3(1.0);

		if (checkTriCellOverlap(vTriCoords[0], vTriCoords[1], vTriCoords[2], vTriNormal, cellPos + cellSize * 0.5, cellSize * 0.5))
		{
			if (stepMin == -1)
				stepMin = stepIdx;

			stepCount++;
		}

		stepStart += stepDir;
		steps--;
		stepIdx++;
	} while(steps > 0);

	if (stepCount == 0)
		return;

	stepStart = storeStepStart + stepDir * stepMin;

	while(stepCount-- > 0)
	{
		uint ccx = stepStart.x;
		uint ccy = stepStart.y;
		uint ccz = stepStart.z;

		uint list_index = ccx + ccy * GRID_RES + ccz * GRID_RES * GRID_RES;
		link_list_push_value(list_index, gl_PrimitiveID);
		mark_high_level_cell_occupied(ccx, ccy, ccz);

		imageAtomicAdd(imTarget0, ivec3(ccx, ccy, ccz), 1);
		//imageStore(imTarget0, ivec3(ccx, ccy, ccz), ivec4(1));
		imageStore(imTarget2, ivec3(ccx/4, ccy/4, ccz/4), ivec4(1));

		stepStart += stepDir;
	};

}
