#version 430

in vec3 vPosition;
in vec3 vNormal;
in vec4 vColor;

//uniform mat4 mModelview;
uniform mat4 mModel;
uniform vec4 vModelview[3];
uniform vec4 vModelviewInvTrans[3];
uniform mat4 mProjection;

out vec4 vCoords;

out vec3 vNorm;
out vec3 vWorldNorm;
out vec3 vLocalPos;
out vec4 vWorldPos;
out vec4 vsColor;
out vec3 vsTexCoords;

uniform vec3 vCameraPosition;

void main() {
	
	vec3 pos = vPosition;
	vec3 norm = vNormal;

	vLocalPos = pos;
	//vPos = mModelview * vec4(pos, 1.0);
	
	vec4 vPos1 = vec4(pos, 1.0);
	vec4 vPos;
	vPos.x = dot(vModelview[0], vPos1);
	vPos.y = dot(vModelview[1], vPos1);
	vPos.z = dot(vModelview[2], vPos1);
	vPos.w = 1.0;
	vWorldPos = mModel * vPos1;
	vWorldNorm = (mModel * vec4(norm, 0.0)).xyz;

	vNorm.x = dot(vModelviewInvTrans[0].xyz, norm);
	vNorm.y = dot(vModelviewInvTrans[1].xyz, norm);
	vNorm.z = dot(vModelviewInvTrans[2].xyz, norm);
	vNorm = normalize(vNorm);//vNormal;

	//vPos = vec4(vProjection.x * vPos.x, vProjection.y * vPos.y, dot(vProjection.zw, vPos.zw), -vPos.z);	
	//vsTexCoords = normalize(reflect(normalize(vWorldPos.xyz - vCameraPosition), normalize(vWorldNorm)));
	vsTexCoords = normalize(reflect(normalize(vec3(0.0, 0.0, 1.0)), normalize(vWorldNorm)));
	vPos = mProjection * vPos;
	gl_Position = vPos;

	//float bri = clamp(0.5 + (vAttribute1 - 0.5) * 100.0, 0.0, 1.0);
	//brightness = vBrightness;
	//overbright = bri;

	//vWorldPos = mModel * vec4(vPos1.xyz, 1.0);
	vCoords = vPos;

	vsColor = vColor;
}