#version 430

#extension GL_NV_gpu_shader5 : enable

#include <shaders/materials/commons.glsl>
#include <shaders/particles/particles_commons.glsl>

layout(std140, row_major) uniform TransformParamsBuffer{
	EntityTransformParams transform_params;
};

layout(std430) buffer RibbonPositionsData {
	vec4 position[];
} prt_position_snapshots;

struct ParticleRibbonState
{
	float generation_id;
	uint segments;
	uint _pad0;
	uint _pad1;
};

layout(std430) buffer RibbonStatesData {
	ParticleRibbonState states[];
} prt_states_snapshots;

struct RibbonRenderParams
{
	int max_segments;
	int base_idx;
	int base_segment;
	int particles_per_segment;
	float thickness;
};

layout(std140) uniform RibbonRenderParamsBuffer {
	RibbonRenderParams ribbon_render_params;
};

out Vertex
{
	vec3 vCoords;
	f16vec3 vNorm;
	f16vec3 vWorldNorm;
	vec3 vLocalPos;
	vec3 vWorldPos;
	f16vec4 vColor;
	f16vec2 vUV0;
} vtx_output;

vec3 hsv2rgb(vec3 c) {
	vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
	vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
	return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec3 rgb2hsv(vec3 c)
{
	vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
	vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
	vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

	float d = q.x - min(q.w, q.y);
	float e = 1.0e-10;
	return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

// NOTE: this is new version using triangle strips and not lines as lines with thickness
// stopped being supported:()

int calculate_vidx_for_ribbon_segment(int ribbon_id, int ribbon_segment)
{
	ribbon_segment = ribbon_render_params.base_segment - ribbon_segment;
	if (ribbon_segment < 0)
		ribbon_segment += ribbon_render_params.max_segments;
	int vidx = ribbon_segment * ribbon_render_params.particles_per_segment + ribbon_id + ribbon_render_params.base_idx;
	return vidx;
}

void main() {
	
	// fetch input data
	int ribbon_id = gl_InstanceID;
	int odd_even = (gl_VertexID & 1) == 0 ? 1 : -1;
	int ribbon_segments = max(0, min(ribbon_render_params.max_segments, int(prt_states_snapshots.states[ribbon_id].segments)) - 1);
	int ribbon_segment = min(int(gl_VertexID) / 2, ribbon_segments);

	int vidx = calculate_vidx_for_ribbon_segment(ribbon_id, ribbon_segment);

	vec3 vInstPosition = prt_position_snapshots.position[vidx].xyz;
	vec3 vInstNormal = vec3(1.0, 0.0, 0.0);

	bool is_last = ribbon_segment >= ribbon_segments;

	vec4 ribbon_color = prt_get_color(ribbon_id);

	//if (!is_last)
    {
		int next_vidx = calculate_vidx_for_ribbon_segment(ribbon_id, ribbon_segment + 1);
        vec3 nextPosition = prt_position_snapshots.position[next_vidx].xyz;
		vec3 dir = cross(-normalize(vInstPosition - nextPosition), vInstNormal);
		if (length(vInstPosition - nextPosition) < 0.001)
		{
			dir = vec3(1.0, 0.0, 0.0);
		}
        vInstPosition.xyz += vec3(odd_even) * dir * ribbon_render_params.thickness;
    }
	//else
	{
	}

	vec3 pos = vInstPosition;
	
	vtx_output.vLocalPos = pos;
	
	vec3 vPos1 = pos;
	vec3 vPos = vector_transform_by_mat43(vPos1, transform_params.mModelView);
	vtx_output.vWorldPos = vector_transform_by_mat43(vPos1, transform_params.mModel);

    // calculate displacement. this sucks as it will not be perpendicular to camera:()
    #if 0
    {
        int next_vidx = (vidx + 1) % RIBBON_LENGTH;
        vec3 nextPosition = vec3(indata.verts[next_vidx].px, indata.verts[next_vidx].py, indata.verts[next_vidx].pz);
        vec3 vNextPos;
        vNextPos.x = dot(transform_params.mModelView[0], vec4(nextPosition, 1.0));
	    vNextPos.y = dot(transform_params.mModelView[1], vec4(nextPosition, 1.0));
	    vNextPos.z = dot(transform_params.mModelView[2], vec4(nextPosition, 1.0));

        vec3 dir = cross(vec3(0.0, 1.0, 0.0), normalize(vPos.xyz - vNextPos));
        vPos.xyz += vec3(odd_even) * dir * 0.0075;
    }
    #endif

	// skew the normals so we dont get so much black lighting
	vtx_output.vWorldNorm.x = float16_t(vidx);
	vtx_output.vWorldNorm.y = float16_t(gl_VertexID);
	vtx_output.vWorldNorm.z = float16_t(gl_InstanceID);
	vtx_output.vWorldNorm.xyz = f16vec3(vInstPosition);

	vtx_output.vNorm = f16vec3(vInstNormal);

	gl_Position = transform_params.mProjection * vec4(vPos, 1.0);

	vtx_output.vCoords = vPos.xyz;
	vtx_output.vColor.a = 1.0;
	vtx_output.vColor.rgb = f16vec3(ribbon_color.rgb);

}

