#version 430

#include <shaders/materials/commons.glsl>

layout(std430) buffer VTXCoords {
	float coords[];
} vtx_coords;

vec3 vtx_coords_load(uint idx)
{
	return vec3(vtx_coords.coords[idx * 3 + 0], vtx_coords.coords[idx * 3 + 1], vtx_coords.coords[idx * 3 + 2]);
}

layout(std430) buffer VTXUV0 {
	float uv0[];
} vtx_uv0;

vec2 vtx_uv0_load(uint idx)
{
	return vec2(vtx_uv0.uv0[idx * 2 + 0], vtx_uv0.uv0[idx * 2 + 1]);
}

out vec4 posPos;
out vec4 texcoord;

uniform mat4 mModelview;
uniform mat4 mProjection;

uniform float FXAA_SUBPIX_SHIFT; // = 1.0/4.0;
uniform float width; // = 1280.0; 
uniform float height; // = 720.0;

void main(void)
{
	gl_Position = mProjection * mModelview * vec4(vtx_coords_load(gl_VertexID), 1.0);
	vec2 uv0 = vtx_uv0_load(gl_VertexID);

	texcoord = vec4(uv0, 0.0, 0.0);
	vec2 rcpFrame = vec2(1.0/width, 1.0/height);
	posPos.xy = uv0.xy;
	posPos.zw = uv0.xy - (rcpFrame * (0.5 + FXAA_SUBPIX_SHIFT));
}
