precision mediump float;
varying vec2 vTexcoord0;
uniform sampler2D s_texture0;  // final rendering 
uniform sampler2D s_texture1;  // overlay to be applied to final rendering
uniform float fade;            // how everything goes to black
uniform float brightness0;     // background brightness
uniform float brightness1;     // overlay brightness

void main() {

	vec4 col0 = texture2D(s_texture0, vTexcoord0) * brightness0; // yeah, overlay is biased (allows for bit more control)
	vec4 col1 = texture2D(s_texture1, vTexcoord0) + (brightness1 - 1.0); // 0 is still black, 1.0 unmodified

	float blend = col1.w;
	blend = clamp(blend, 0.0, 1.0);

	vec4 col = mix(col0, col1, blend); // blend according to overlay alpha
	col = col * fade;

	gl_FragColor = col;
}