#version 430

in vec2 vTexcoord0;

uniform sampler2D s_texture0;		// depth
#define sTextureDepth s_texture0

uniform mat4 mProjection;
uniform mat4 mModel;
uniform vec3 vCameraPosition;
uniform vec4 vCameraProjectionParams;	// width, height of frustum
uniform vec4 vNearFarPlane; // min, max, 2*min*max, max-min

uniform vec2 vResolution;
uniform vec2 vResolutionInv;

float linearize_depth(in float d)
{
	return vNearFarPlane.z / (vNearFarPlane.y + vNearFarPlane.x - d * vNearFarPlane.w);
}

layout(location = 0) out vec4 outColor;

void main() {

	// basic world pos reconstruction
	vec2 tex_coord = vec2(gl_FragCoord.xy) * vResolutionInv;
	float depth = linearize_depth(texture(sTextureDepth, tex_coord).r);
	outColor = vec4(depth);
}