#version 430

// bind light setup to buffer 1
#define LIGHT_PROPERTIES_BINDING 1

// point light doesnt handle shadows. shadows are handled by multiple spotlights

uniform sampler2D s_texture0;	// depth
uniform sampler2D s_texture1;	// normal (8bit)
uniform sampler2D s_texture2;	// color

uniform sampler2D s_LTC1;
uniform sampler2D s_LTC2;

in vec2 vTexcoord0;
in vec4 vFrustum;
in vec4 vFrustumLocal;

uniform vec4 vNearFarPlane;

uniform vec3 vCameraPosition;

// output

out vec4 outColor;

#include <shaders/materials/commons.glsl>

//#define ENABLE_FILTERING
#define INCLUDE_LIGHTING
#define ENABLE_FALLOFF

float linearizeDepth(float d)
{
	return vNearFarPlane.z / (vNearFarPlane.y + vNearFarPlane.x - d * vNearFarPlane.w);
}

vec3 positionFromDepth(vec4 vDirection, float depth)
{
	return vCameraPosition.xyz + (vDirection.xyz * depth);
}

// all the positions are in world coords
vec4 calculate_lighting_world(LightProperties light, in vec3 pos, in vec3 normal, in vec3 light_pos, in vec3 cam_pos, in float NdotL)
{
	float d = NdotL;
	if (d < 0.0)
		d = 0.0;
	
	vec3 specular = vec3(0.0);
	if (d > 0.0)
		specular = pow(max(0.0, dot(reflect(-normalize(pos - light_pos), normalize(normal)), -normalize(cam_pos - pos))), 14.0) * light.diffuse.rrr;

	return vec4(vec3(d) * light.diffuse.xyz + specular, 1.0);
	//return vec4(vec3(d) * colorDiffuse.xyz, 1.0);
}


void main() {

	outColor = vec4(0.0);

	vec4 vNormalMaterial = texture(s_texture1, vTexcoord0).rgba;
	int materialId = int(vNormalMaterial.a * 255.0);
	vec3 vNorm = (vNormalMaterial.xyz - 0.5) * 2.0;

	float depth = linearizeDepth(texture(s_texture0, vTexcoord0).r);

	vec3 world = positionFromDepth(vFrustum, depth);

	// iterate through lights
	for(int light_idx = 0; light_idx < g_lights_num; light_idx++)
	{
		LightProperties light = lights.light_properties[light_idx];

		float NdotL = dot(normalize(vNorm), normalize(world - light.position.xyz));

		// for particles don't include directional component
		if ((materialId & MATERIAL_ID_MASK_ATTR) == ATTR_PARTICLE)
			NdotL = 1.0;
		
		vec4 lighting = calculate_lighting_world(light, world, vNorm, light.position.xyz, vCameraPosition.xyz, NdotL);
	
		if (NdotL <= 0.0)
			lighting = vec4(0.0);

	#ifdef INCLUDE_LIGHTING

		vec3 l = light.position.xyz - world;
		float dist = length(l);
		
		if (dist < light.range)
			outColor.rgb = lighting.xyz * (1.0 - dist / light.range);
		else
			outColor = vec4(0.0, 0.0, 0.0, 0.0);
	
	#else
		outColor = vec3(vec3(0.1 - shadow * 0.1), 0.0);
	#endif
	}
		
	//outColor = vec4(0.5, 0.5, 0.5, 0.0);//outColor * colorDiffuse;
	//outColor = vec4(real_fact);
	//outColor = vec4(0.0);
	//outColor = vec4(texture(s_texture0, vTexcoord0).r);
	//outColor = vec4(world.x);

}