#version 430

// bind light setup to buffer 1
#define LIGHT_PROPERTIES_BINDING 1

#define DUMP_PREPROCESSED 1

uniform sampler2D s_texture0;	// depth
uniform usampler2D s_texture1;	// normal + material (encoded)
uniform sampler2D s_texture2;	// color

uniform sampler2D s_LTC1;
uniform sampler2D s_LTC2;

in vec2 vTexcoord0;
in vec4 vFrustum;

uniform vec4 vNearFarPlane; // min, max, 2*min*max, max-min
uniform vec3 vCameraPosition;

uniform float g_global_time;

//#define VISUALIZE_CASCASES
#define INCLUDE_LIGHTING

// flags set from the engine
//#define CALCULATE_VOLUMETRIC

// output

#include <shaders/materials/commons.glsl>

out vec4 outColor;

float linearizeDepth(float d)
{
	return vNearFarPlane.z / (vNearFarPlane.y + vNearFarPlane.x - d * vNearFarPlane.w);
}

vec3 positionFromDepth(vec4 vDirection, float depth)
{
	return vec3(vCameraPosition.xyz) + (vDirection.xyz * depth);
}

// cascade idx is 1...n
// sampling range os bogus i think as this is in screenspace. for now compensate a bit with scaling based on cascade
float sampleShadowPCF(sampler2DShadow sampler, vec4 coords, float cascade)
{
	const float spreadscale = 1.0 / (1.0 * 1024.0);
	float fact = 0.0;
	float x, y;
	
	// NOTE: just shifting here works (as opposed to the spot lights) because we use 
	//       ortho projection matrix which makes W == 1.0 thus no need for the divide
	//coords = coords * vec4(0.5, 0.5, 0.5, 1.0) + vec4(0.5, 0.5, 0.5, 0.0);
	coords = coords * vec4(0.5, 0.5, 1.0, 1.0) + vec4(0.5, 0.5, 0.0, 0.0);
	
	vec3 samp = coords.xyz / coords.w;
	
	//if (coords.w < 1.0)
	//	return 0.0;
	
	const float sample_div = 1.0 / 64.0;
	for(x=-1.5; x<1.5; x+=3.0/8.0)
	{
		for(y=-1.5; y<1.5; y+=3.0/8.0)
		{
			float shadow = textureProj(sampler, coords + vec4(x * spreadscale * coords.w, y * spreadscale * coords.w, 0.0, 0.0));
			fact += shadow;
		}
	}
	
	return fact * sample_div;
}

float sampleShadow(sampler2DShadow sampler, vec4 coords)
{	
	coords.xy = coords.xy * vec2(0.5, 0.5) + vec2(0.5, 0.5);
	return textureProj(sampler, coords);
}


#ifdef ENABLE_SHADOWS
float calculate_shadow_for_position_pcf(in LightProperties light, vec3 world, float depth, out vec4 cascadeColor)
{
	// shadows
	float fact = 0.0;

	// choose cascade
	if (depth > light.cascade_distance2)
	{
		vec4 vShadowCoords = light.mat_shadow_mvp[3] * vec4(world.xyz, 1.0);
		cascadeColor = vec4(1.0, 0.1, 0.1, 1.0);
		fact = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler3], vShadowCoords, 1.0);
	}
	else if (depth > light.cascade_distance1)
	{
		vec4 vShadowCoords = light.mat_shadow_mvp[2] * vec4(world.xyz, 1.0);
		cascadeColor = vec4(0.1, 1.0, 0.1, 1.0);
		fact = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler2], vShadowCoords, 1.0);
	}
	else if (depth > light.cascade_distance0)
	{
		vec4 vShadowCoords = light.mat_shadow_mvp[1] * vec4(world.xyz, 1.0);
		cascadeColor = vec4(0.1, 0.1, 1.0, 1.0);
		fact = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler1], vShadowCoords, 1.0);
	}
	else
	{
		vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world.xyz, 1.0);
		cascadeColor = vec4(1.0);
		fact = sampleShadowPCF(LightShadowmapCmpSamplers[light.shadowmap_sampler0], vShadowCoords, 1.0);
	}

	return fact;
}
#else
float calculate_shadow_for_position_pcf(in LightProperties light, vec3 world, float depth, out vec4 cascadeColor)
{
	return 0.0;
}
#endif

float calculate_shadow_for_position(in LightProperties light, vec3 world, float depth, out vec4 cascadeColor, out vec4 projector_color)
{
	// shadows
	float fact = 0.0;

	// choose cascade
	if (depth > light.cascade_distance2)
	{
		vec4 vShadowCoords = light.mat_shadow_mvp[3] * vec4(world.xyz, 1.0);
		cascadeColor = vec4(1.0, 0.1, 0.1, 1.0);
		fact = sampleShadow(LightShadowmapCmpSamplers[light.shadowmap_sampler3], vShadowCoords);
	}
	else if (depth > light.cascade_distance1)
	{
		vec4 vShadowCoords = light.mat_shadow_mvp[2] * vec4(world.xyz, 1.0);
		cascadeColor = vec4(0.1, 1.0, 0.1, 1.0);
		fact = sampleShadow(LightShadowmapCmpSamplers[light.shadowmap_sampler2], vShadowCoords);
	}
	else if (depth > light.cascade_distance0)
	{
		vec4 vShadowCoords = light.mat_shadow_mvp[1] * vec4(world.xyz, 1.0);
		cascadeColor = vec4(0.1, 0.1, 1.0, 1.0);
		fact = sampleShadow(LightShadowmapCmpSamplers[light.shadowmap_sampler1], vShadowCoords);
	}
	else
	{
		vec4 vShadowCoords = light.mat_shadow_mvp[0] * vec4(world.xyz, 1.0);
		cascadeColor = vec4(1.0);
		fact = sampleShadow(LightShadowmapCmpSamplers[light.shadowmap_sampler0], vShadowCoords);
	}

	return fact;
}

// dummy. only for the spots
float calculate_shadow_dist_for_position(in LightProperties light, vec3 world, float depth, out vec4 cascadeColor, out vec4 projector_color, out float shadow_dist)
{
	return 0.0;
}

#include <shaders/materials/noise/noise3d.glsl>
#include "support/volumetric_component.glsl"

// all the positions are in world coords
vec4 calculate_lighting_world(in LightProperties light, in vec3 pos, in vec3 normal, in vec3 light_pos, in float NdotL)
{
	float d = NdotL;
	if (d < 0.0)
		d = 0.0;

	return vec4(vec3(d) * light.diffuse.xyz, 1.0);
}

void main() {

	uint encoded_normal_material = texture(s_texture1, vTexcoord0).r;
	
	int materialId = decode_material(encoded_normal_material);
	vec3 vNorm = decode_normal(encoded_normal_material);

	float depth = linearizeDepth(texture(s_texture0, vTexcoord0).r);

	vec3 world = positionFromDepth(vFrustum, depth);

	// iterate through lights
	for(int light_idx = 0; light_idx < g_lights_num; light_idx++)
	{
		LightProperties light = lights.light_properties[light_idx];

		float NdotL = dot(normalize(vNorm), normalize(world - light.position.xyz));

		// for particles don't include directional component
		if ((materialId & MATERIAL_ID_MASK_ATTR) == ATTR_PARTICLE)
			NdotL = 1.0;

		vec4 lighting = calculate_lighting_world(light, world, vNorm, light.position.xyz, NdotL);
	
		// shadows
		vec4 cascadeColor;
		float shadow;
	
		if ((materialId & MATERIAL_ID_MASK_ATTR) == ATTR_BACKGROUND) // TODO: stencil could do this perfectly fine..
		{
			shadow = 0.0;
			lighting = vec4(1.0);
			NdotL = 1.0;
		}
		else
		{
			shadow = calculate_shadow_for_position_pcf(light, world.xyz, depth, cascadeColor);
			//shadow = calculate_shadow_for_position(world.xyz, depth, cascadeColor);

			shadow = clamp(shadow, 0.0, 1.0);
	
			if (NdotL <= 0.0)
				shadow = 1.0;
		}

	#ifdef INCLUDE_LIGHTING
		if (shadow < 1.0)
		{
			outColor = vec4(vec3(1.0 - shadow), 1.0) * lighting;
		}
	#else
		outColor = vec4(0.1 - shadow * 0.1);
	#endif

		// just output cascade color
	#ifdef VISUALIZE_CASCASES
		outColor = outColor + cascadeColor * 0.1;
	#endif

		//outColor = vec4(0.0);
		//outColor.rgb = cascadeColor.xyz;
	
	#ifdef CALCULATE_VOLUMETRIC

		// experimental lightshafts (volumetric)
		outColor.a = volumetric_sample_shadow(light, vFrustum, depth, cascadeColor) * light.diffuse.a;
	
	#else
		outColor.a = 0.0;
	#endif
	}

}