#version 430

#include <shaders/materials/commons.glsl>

layout(std430) buffer VTXCoords {
	float coords[];
} vtx_coords;

vec3 vtx_coords_load(uint idx)
{
	return vec3(vtx_coords.coords[idx * 3 + 0], vtx_coords.coords[idx * 3 + 1], vtx_coords.coords[idx * 3 + 2]);
}

layout(std430) buffer VTXUV0 {
	float uv0[];
} vtx_uv0;

vec2 vtx_uv0_load(uint idx)
{
	return vec2(vtx_uv0.uv0[idx * 2 + 0], vtx_uv0.uv0[idx * 2 + 1]);
}

uniform mat4 mModelview;
uniform mat4 mProjection;
out vec2 vTexcoord0;

void main() {
	gl_Position = mProjection * mModelview * vec4(vtx_coords_load(gl_VertexID), 1.0);
	gl_Position.zw = vec2(0.9999, 1.0);	// only blit it to clear portion of a display
	vTexcoord0.xy = vtx_uv0_load(gl_VertexID).xy;
}
