#version 430

#include <shaders/materials/commons.glsl>
#include <shaders/materials/commons_deferred.glsl>

layout(std430) buffer VTXCoords {
	float coords[];
} vtx_coords;

vec3 vtx_coords_load(uint idx)
{
	return vec3(vtx_coords.coords[idx * 3 + 0], vtx_coords.coords[idx * 3 + 1], vtx_coords.coords[idx * 3 + 2]);
}

layout(std430) buffer VTXUV0 {
	float uv0[];
} vtx_uv0;

vec2 vtx_uv0_load(uint idx)
{
	return vec2(vtx_uv0.uv0[idx * 2 + 0], vtx_uv0.uv0[idx * 2 + 1]);
}

layout(std430) buffer VTXDeferredProjectionPlane {
	float plane[];
} vtx_projection_plane;

vec3 vtx_projection_plane_load(uint idx)
{
	return vec3(vtx_projection_plane.plane[idx * 3 + 0], vtx_projection_plane.plane[idx * 3 + 1], vtx_projection_plane.plane[idx * 3 + 2]);
}

uniform int vtx_builtin_buffers = 0;

layout(std140, row_major) uniform BasicDeferredParamsBuffer{
	BasicDeferredParams basic_params;
};

out vec2 vTexcoord0;
out vec4 vFrustum;
out vec4 vFrustumLocal;

void main() {

	vec3 plane = vtx_projection_plane_load(gl_VertexID);
	vec3 frustum = vec3(plane.x, plane.y * 1.0, -plane.z);

	gl_Position = basic_params.mProjection * basic_params.mModelview * vec4(vtx_coords_load(gl_VertexID), 1.0);
	//vFrustum = vec4(frustum, 0.0);// mCameraModelview * vec4(frustum, 0.0);	// only rotation!
	vFrustum = basic_params.mCameraModelview * vec4(frustum, 0.0);	// only rotation!
	//vFrustum = vec4(frustum, 0.0);	// only rotation!
	vFrustumLocal = vec4(frustum, 1.0);	// only rotation!
	vTexcoord0.xy = vtx_uv0_load(gl_VertexID).xy;
}