; assemble with:    yasm -f bin -o tree1.com tree1.asm

bits 16
org 100h

    mov si, @data
    mov dx, 100h - 25  ; scratch memory: use end of PSP (overwrite command line)

@loop:
    lodsb           ; load next data byte into AX, clearing the MSBs
    xor ah, ah
    or al, al
    js @end         ; terminator reached? then quit
    push ax         ; save data byte for later

    ; generate whitespace
    mov di, dx      ; load scratch memory address
    mov cx, 25      ; count = (25 - data_byte) / 2
    sub cx, ax
    shr cx, 1
    mov al, ' '     ; fill with space
    rep stosb

    ; generate stars
    pop cx          ; restore data byte as counter
    mov al, '*'     ; fill with stars
    rep stosb

    ; finish 
    mov ax, 0A0Dh   ; add CRLF
    stosw
    mov ax, 0924h   ; add '$' terminator *and* pre-load AH with 09h
    stosb
    int 21h         ; call DOS function "write string"
    jmp @loop       ; next line please!

@data:
    db 1, 3, 5, 7, 3, 7, 11, 15, 5, 11, 17, 23, 3, 3

@end:
    ret             ; end of program -- also serves as a data terminator
