\ Tree

\ For Electron, BBC, Master
\ Routine 'dotree' outputs 4 lines of tree starting at the width given in A.
\ If A=0 it only outputs two lines of length 3. 

width=&70
growth=&71

ORG &900

.start
LDY#3				\ Set pointer
.loop
LDA data,Y			\ Load data byte
STA width
JSR dotree			\ Plot
DEY					\ Get ready for next one
BPL loop			\ If last one wasn't zero do it again
RTS

.data
EQUB 0
EQUB 5
EQUB 3
EQUB 1

.dotree
BEQ trunk
CLC
STA growth
INC growth			\ growth=width+1
LDX #4				\ Initialise Line counter
.loop2
JSR doline			\ Draw line
CLC
LDA width
ADC growth			\ Add growth value
STA width
DEX					\ Decrement counter
BNE loop2
RTS

.trunk
LDA#3
STA width
JSR doline
JSR doline
RTS

.doline
TXA:PHA
TYA:PHA
SEC
LDA#40
SBC width
LSR A
TAY					\ Save number of spaces in Y
LDA #9				\ Forward cursor
.loop3	
JSR $FFEE			\ Print forward cursor char
DEY
BNE loop3
LDY width
LDA #'*'
.loop4
JSR $FFEE			\ Print star
DEY
BNE loop4
LDA#13
JSR $FFEE			\ CR
LDA#10
JSR $FFEE			\ CR
PLA:TAY
PLA:TAX
RTS
.code_end

SAVE "tree", &900, code_end, &900
