PrintChar equ &BB5A	; Firmware call to print character in a to location
Locate equ &BB75	; Firmware call, directly equiv to LOCATE xy in hl
Asterix equ 42
org &1200
 ld c, 1	; Set counter to start
 ld ix, xpos	; Begin by pointing to first entry
MainLoop:
; work out x position as 20 - (#stars / 2)
 ld a, 20
 ld e, (ix)
 sra e		; divide by 2
 sub e
; The firmware LOCATE call expects x in h and y in l with
; origin of 1,1 top-right
 ld h, a
 ld l, c
 call Locate
 ld b, (ix)		; Grab the number of stars and use this for loop
 ld a, Asterix		; PrintChar firmware expects chr in a
InnerRepeat:
 call PrintChar
 djnz, InnerRepeat	; And loop the print 
; Move on to the next row. If we're on row 15, return otherwise NEXT
 inc c
 ld a, 15
 cp c
 ret z
 inc ix
 jr MainLoop	; NEXT

xpos: db 1,3,5,7,3,7,11,15,5,11,17,23,3,3
