import 'package:flutter/material.dart';
import 'package:flutter_gifimage/flutter_gifimage.dart';

void main() => runApp(MyApp());

class MyApp extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      debugShowCheckedModeBanner: false,
      title: 'Useless box',
      home: MyHomePage(title: 'This took way to much work'),
    );
  }
}

class MyHomePage extends StatefulWidget {
  MyHomePage({Key key, this.title}) : super(key: key);

  final String title;

  @override
  _MyHomePageState createState() => _MyHomePageState();
}

class _MyHomePageState extends State<MyHomePage> with TickerProviderStateMixin {
  GifController controller;

  @override
  void initState() {
    // TODO: implement initState
    controller = GifController(
        vsync: this,
        duration: Duration(
          milliseconds: 2000,
        ));
    controller.value = 7;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        backgroundColor: Colors.white,
        appBar: AppBar(
          title: Text(widget.title),
          centerTitle: true,
        ),
        body: Center(
          child: Padding(
            padding: const EdgeInsets.fromLTRB(0, 100, 0, 0),
            child: Column(
              children: [
                GifImage(
                    controller: controller,
                    image: AssetImage("lib/images/useless_box.gif")),
                Padding(
                  padding: const EdgeInsets.fromLTRB(0, 10, 0, 0),
                  child: FloatingActionButton(
                      onPressed: () {
                        controller.value = 0;
                        controller.animateTo(7);
                      },
                      child: Text("Push")),
                ),
              ],
            ),
          ),
        ));
  }
}
