let canvas;
let ctx;
let tilesetContainers = [];
let tilesetSelectors = [];
let selTile = {t: 0, l: 0};
let selTiles = [0,0,0]  ;
let tileGfxSize = 16;
let tileScale = 1;

let sprites = [];
let entities = [];

let layerButtons = [];
let layerState = [];

let shiftKey = false;

let player = null;

let infoInput = null;
//~ console.log(infoInput);

/// offset in screen widths/heights 
let screenx = 0;
let screeny = 0;

let goHome = false;

class Dialog
{
  setup()
  {
    this.text = "Test";
    this.visible = 0;
    console.log(this.text);
  }

  draw()
  {
    if (this.visible)
    {
      ctx.font = "bold 10px Arial";
      ctx.textAlign = 'center';
      ctx.fillStyle = 'white';
      ctx.strokeStyle = 'black';
      ctx.strokeText(this.text, 160, 230);
      ctx.fillText(this.text, 160, 230);
    }
  }
  
  update()
  {
    if (this.visible) this.visible--;
  }

  showText(text)
  {
    this.text = text;
    this.visible = 300;
  }
}

class Vector {
  constructor(x,y)
  {
    this.x = x;
    this.y = y;
  }
}

class Sprite
{
  constructor(imgfile, width, height)
  {
    this.image = new Image();
    this.image.src = imgfile;
    this.width = width;
    this.height = height;
  }

  draw(x,y,px,py,fx,fy)
  {
    x -= screenx * 19;
    y -= screeny * 14;
    //~ ctx.drawImage(this.image, this.f*(this.width+1), this.anim*(this.height+1), this.width, this.height, x-this.width/2, y-this.height/2, this.width, this.height);
    ctx.drawImage(this.image, fx*16, fy*16, 16, 16, x*16*tileScale-8*tileScale+px*tileScale, y*16*tileScale-8*tileScale+py*tileScale, 16*tileScale, 16*tileScale);
  }
}

class Entity
{
  constructor (x,y,r,sprite)
  {
    this.pos = new Vector(x,y);
    this.sprite = sprite;
    this.r = r;
    this.mode = 'stand';
    this.type = sprite;   /// option to override later
    
    if (this.type == 'duck')
      //~ this.dir = Math.floor(Math.random(2));
      this.dir = 0;
    else
      this.dir = 3;
    this.dx = 0;
    this.dy = 0;
    this.fdelay = 0;
    this.movement = -1;

    this.startx = x;
    this.starty = y;
  }

  setPosition(x,y)
  {
    this.pos.x = x;
    this.pos.y = y;
  }

  move (x,y)
  {
    if (this.movement == -1 || this.movement == 16)
    {
      if (x == -1)
        this.dir = 1;
      else if (x == 1)
        this.dir = 0;
      else if (y == -1)
        this.dir = 2;
      else if (y == 1)
        this.dir = 3;
     
     
      if (level.getTile(this.pos.x+x,this.pos.y+y,3) != 1)
      {
        this.mode = 'walking';
        this.movement = 0;
        this.dx = x;
        this.dy = y;
      }
    }
  }

  update()
  {
    //~ this.fdelay++;
    //~ if (this.fdelay == 2)
    //~ {
      if (this.mode != 'stand')
        ++this.movement;
      //this.fdelay = 0;

      if (Math.abs(this.movement) == 16)
      {
        this.pos.x += this.dx;
        this.pos.y += this.dy;
        this.movement = -1;
        this.mode = 'stand';

        if (this.type == 'girl0')
        {
          if (this.dx == 1 && this.pos.x % 19 == 1)
          {
            screenx++;
            goHome = true;
          }
          if (this.dx == -1 && this.pos.x % 19 == 0)
          {
            screenx--;
          }
          if (this.dy == 1 && this.pos.y % 14 == 1)
          {
            screeny++;
          }
          if (this.dy == -1 && this.pos.y % 14 == 0)
          {
            screeny--;
          }
        }

        this.dx = 0;
        this.dy = 0;
      }
    //~ }

    if (this.type == 'duck')
    {
      if (this.mode == 'stand' && this.movement == -1)
      {
        if (Math.floor(Math.random()*1000) > 960)
        {
          this.mode = 'walking';
          if (Math.floor(Math.random()*2) == 1)
            this.dx = Math.floor(Math.random()*2) == 1 ? 1 : -1;
          else
            this.dy = Math.floor(Math.random()*2) == 1 ? 1 : -1;
          if (this.dx == 1) this.dir = 0;
          if (this.dx == -1) this.dir = 1;
          this.movement = 0;
                    
          if (Math.abs(this.pos.x + this.dx - this.startx) > 3)
          {
            this.dx = -this.dx;
            this.dir = 1 - this.dir;
          }
          if (Math.abs(this.pos.y + this.dy - this.starty) > 3)
            this.dy = -this.dy;

          if(level.getTile(this.pos.x + this.dx, this.pos.y + this.dy, 3) == 1)
          {
            this.dx = 0;
            this.dy = 0;
            this.movement = -1;
          }
        }
      }
    }
  }

  draw()
  {
    var fx = 0;
    var fy = 0;
    if (this.mode == 'stand')
    {
      fx = 0;
    }
    if (this.mode == 'walking')
    {
      fx = 1 + Math.floor(this.movement / 4) % 4;
    }

    fy = this.dir;

    sprites[this.sprite].draw(this.pos.x, this.pos.y, this.dx * this.movement, this.dy * this.movement, fx, fy);
  }
}

class Tileset
{
  constructor(imgfile, tilesize)
  {
    this.tileDrawSize = tilesize*tileScale;
    console.log(this.tileDrawSize)
    this.image = new Image();
    this.image.src = imgfile;
    
    this.tw = 0;
    this.th = 0;
    
    this.image.onload = () =>
    {
      this.imageDims();
    }
    this.tilesize = tilesize;
    this.layers = 0;
  }

  imageDims()
  {
    this.tw = Math.floor(this.image.width / this.tilesize);
    this.th = Math.floor(this.image.height / this.tilesize);
    console.log('tw ' + this.tw + ' th ' + this.th);
  }

  drawTile(tilen, x, y)
  {
    if (this.tw == 0 || this.th == 0) return;
    let tx = tilen % this.tw;
    let ty = Math.floor(tilen / this.tw);
    
    //~ let tileDrawSize = tileScale * this.tilesize;
    ctx.setTransform(2,0,0,2,0,0);
    ctx.drawImage(this.image, tx * this.tilesize, ty * this.tilesize, this.tilesize, this.tilesize, x * this.tileDrawSize-this.tileDrawSize/2, y * this.tileDrawSize-this.tileDrawSize/2, this.tileDrawSize, this.tileDrawSize);
  }
}

class Level
{
  constructor(width, height)
  {
    this.height = height;
    this.width = width;
    this.tiles = null;
    this.filename = null;

    let w = 0;

    this.lev = loadlevelfile('level01.txt');
    this.lev = document.getElementById('levelfile');
    //~ this.lev.src = 'level01.txt';
    if (this.lev != null)
    {
      this.lev.onload = () =>
      {
        levelarr = leveldata.split(',');
        this.width = parseInt(levelarr[0]);
        this.height = parseInt(levelarr[1]);
        this.layers = parseInt(levelarr[2]);
        this.tiles = new Array(4).fill(-1).map(() => new Array(this.width).fill(-1).map(() => Array(this.height).fill(-1)));

        var layersize = this.width*this.height;

        for (let ll = 0; ll < this.layers; ++ll)
        {
          for (let lx = 0; lx < this.width; ++lx)
          {
            for (let ly = 0; ly < this.height; ++ly)
            {
              var t = levelarr[ll*layersize + (lx) + ((ly)*this.width) + 3];
              //~ console.log(t);
              this.tiles[ll][lx][ly] = parseInt(t);
            }
          }
        }
        //~ console.log('a');
        //~ console.log(leveldata);      
      }
    }
  }

  new()
  {
    this.width = 61;
    this.height = 46;
    this.layers = 4;
    this.tiles = new Array(4).fill(-1).map(() => new Array(this.width).fill(-1).map(() => Array(this.height).fill(-1)));
    
    for (let ll = 0; ll < this.layers; ++ll)
    {
      for (let lx = 0; lx < this.width; ++lx)
      {
        for (let ly = 0; ly < this.height; ++ly)
        {
          this.tiles[ll][lx][ly] = 0;
        }
      }
    }
  }

  setTile(x,y,l,t)
  {
    console.log(l);
    if (l < 3)
    {
      this.tiles[l][x][y] = t;
    }
    else
    {
      //~ let v = parseInt(infoInput.value);
      this.tiles[l][x][y] = t;
    }
  }
  
  getTile(x,y,l)
  {
    return this.tiles[l][x][y];
  }

  draw()
  {
    if (this.tiles == null) return;
    
    //~ this.lev.src = 'level02.txt';

    for (let ll = 0; ll < this.layers; ++ll)
    {
      for (let lx = 0; lx < level.width; ++lx)
      {
        for (let ly = 0; ly < level.height; ++ly)
        {
          //~ this.tiles[lx][ly] == 1 ? ctx.fillStyle = '#aa00dd' : ctx.fillStyle = '#00aadd';
          
          if (ll < 3)
          {
            if (this.tiles[ll][lx][ly] != -1)
              tilesets[ll].drawTile(this.tiles[ll][lx][ly], lx-screenx*19, ly-screeny*14);
          }
          else
          {
            if (layerButtons[3].value == "ON")
            {
              ctx.font = "8px Arial";
              ctx.fillText(this.tiles[ll][lx][ly], (lx-screenx*19)*16-2, (ly-screeny)*16+2);
            }
          }
          //~ ctx.beginPath();
          //~ this.floodfillmap[lx][ly] > 0 ? ctx.fillStyle = '#ffffff88' : ctx.fillStyle = '#00000000';
          //~ ctx.fillRect(lx*32+4 - 16,ly*32+4 - 16,24,24);
          //~ ctx.closePath();
          
          //~ ctx.beginPath();
          //~ ctx.fillStyle = '#000000ff';
          //~ ctx.font = '15px Arial';
          //~ ctx.fillText(this.floodfillmap[lx][ly].toString(), lx*32+4-8,ly*32+4);
          //~ ctx.closePath();
        }
      }
    }
  }

  save()
  {
    //~ var data = [];
    //~ levelarr[0] = this.width;
    //~ levelarr[1] = this.height;
    //~ levelarr[2] = this.layers;
    var data = 'leveldata = "' + '\\\n';
    data += this.width.toString() + ',' + this.height.toString() + ',' + this.layers.toString() + ',\\\n';

    let ll, lx, ly;

    //~ console.log(this.tiles[0][0][0])
    for (ll = 0; ll < this.layers; ++ll)
    {
      for (ly = 0; ly < this.height; ++ly)
      {
        for (lx = 0; lx < this.width; ++lx)
        {
          //~ levelarr[ll*layersize + lx + (ly*this.width) + 3] = this.tiles[ll][lx][ly];
          data += this.tiles[ll][lx][ly].toString() + ',';
        }
        data += '\\\n';
        //~ console.log('lx ' + lx);
      }
      //~ console.log('ly' + ly);
    }
    data += '";';
    //~ console.log(data);
    var blob = new Blob([data],
                        { type: "text/plain;charset=utf-8" });
    saveAs(blob, "level01.txt");
  }
}

let level = new Level(1280/tileGfxSize/2+1, 960/tileGfxSize/2+1);
let tileset1 = new Tileset('bkg1.png', tileGfxSize);
let dialog = new Dialog;
dialog.setup();
dialog.showText('It is a nice day. I will go for a walk.');
dialog.visible = 1000;

let tilesets = new Array(3).fill(null);

let canvasMouseDown = false;

function loadTilesets(n)
{
  for (let ll = 0; ll < n; ++ll)
  {
    var fn = 'bkg'+ll.toString()+'.png';
    console.log(fn);
    tilesets[ll] = new Tileset(fn, 16);
  }
}

loadTilesets(3);

window.onload = init;

function getCoords(e, o, s)
{
  const {x, y} = e.target.getBoundingClientRect();
  const mouseX = e.clientX + o - x;
  const mouseY = e.clientY + o - y;
  return [Math.floor(mouseX / tileGfxSize/s), Math.floor(mouseY / tileGfxSize/s)];
}

function selectTile(l, t)
{
  
}

function init()
{
  canvas = document.getElementById('canvas');
  ctx = canvas.getContext('2d');
  //~ ctx.scale(2.0, 2.0);
  ctx.imageSmoothingEnabled = false;
  window.requestAnimationFrame(gameLoop);
  document.addEventListener('keydown', globalKeypressed);
  
  infoInput = document.getElementById('info');
  console.log(infoInput);
  
  tilesetSelector = document.getElementById('tilesetSelector');
  
  /// SPRITE STUFF

  sprites['girl0'] = new Sprite('girl0.png', 16, 16);
  player = new Entity(10,10,16,'girl0');
  entities.push(player);

  sprites['duck'] = new Sprite('duck.png', 16, 16);
  entities.push(new Entity(18,10, 16, 'duck'));
  entities.push(new Entity(28,6, 16, 'duck'));
  entities.push(new Entity(4, 4, 16, 'duck'));
  //~ entities.push(new Entity(28,6, 16, 'duck'));

  /// /SPRITE STUFF

  for (let l = 0; l < 4; ++l)
  {

    layerButtons[l] = document.getElementById('layer'+(l+1).toString());
    layerButtons[l].addEventListener('click', clickButton);

    layerState[l] = false;
    //~ console.log(layerButtons[l]);


    if (l < 3)
    {
      tilesetSelectors[l] = document.getElementById('tilesetSelector'+l.toString());

      tilesetContainers[l] = document.getElementById('tilesetContainer'+l.toString());
      tilesetContainers[l].addEventListener('mousedown', (event) =>
      {
        coords = getCoords(event, 0, 1);
        var bx = tilesetContainers[l].getBoundingClientRect().left;
        var by = tilesetContainers[l].getBoundingClientRect().top;

        var cx = coords[0];
        var cy = coords[1];

        //~ selTile.l = parseInt(tilesetContainers[l].getAttribute('n'));
        selTiles[l] = cx + cy * tilesets[l].tw;
        
        cx *= 16; cx += bx;
        cy *= 16; cy += by;
        
        //~ console.log(parseInt(tilesetContainers[l].getAttribute('n')) + ' ' + cx + ' , ' + cy);
        //~ console.log(' t: ' + selTile.t + ' l: ' + selTile.l); 
        
        console.log('t: ' + selTiles[l]);
      
        tilesetSelectors[l].style.left = (cx + 'px');
        tilesetSelectors[l].style.top = (cy + 'px');
      })
    }
  }

  document.body.addEventListener('mouseup', (event) =>
  {
    canvasMouseDown = false;
  })

  canvas.addEventListener('mousemove', (event) =>
  {
    if (event.buttons != 1) canvasMouseDown = false;
    if (canvasMouseDown == true)
    {
      coords = getCoords(event, 16, 2);
      var cx = coords[0] + screenx * 19;
      var cy = coords[1] + screeny * 14;

      for (let l = 0; l < 4; ++l)
      {
        if (layerState[l] === true)
        {
          if (l < 3)
            level.setTile(cx,cy, l, selTiles[l]);
          else
            level.setTile(cx,cy,l,parseInt(infoInput.value));
        }
      }
    }    
  })

  canvas.addEventListener('mousedown', (event) =>
  {
    let l;
    coords = getCoords(event, 16, 2);
    var cx = coords[0] + screenx * 19;
    var cy = coords[1] + screeny * 14;
    if (event.buttons == 1)
    {
      canvasMouseDown = true;

      //~ level.setTile(cx, cy, selTile.l, selTile.t);
      for (l = 0; l < 4; ++l)
      {
        if (layerState[l] === true)
        {
          if (l < 3)
            level.setTile(cx,cy, l, selTiles[l]);
          else
            level.setTile(cx,cy,l,parseInt(infoInput.value));
        }
      }
    }
    
    if(event.buttons == 2)
    {
      for (l = 0; l < 3; ++l)
      {
        if (layerState[l] === true)
        {
          //~ selTile.l = l;
          //~ selTile.t = level.getTile(cx,cy,l);
          selTiles[l] = level.getTile(cx,cy,l);
          var bx = tilesetContainers[l].getBoundingClientRect().left;
          var by = tilesetContainers[l].getBoundingClientRect().top;
          
          var tx = (selTiles[l] % 12)*16 + bx;
          var ty = (selTiles[l] / 12)*16 + by;
          
          tilesetSelectors[l].style.left = (tx + 'px');
          tilesetSelectors[l].style.top = (ty + 'px');
        }
      }
    }
  })
}



//~ function toggleButton(button)
//~ {
  //~ if (button.value == "OFF")
  //~ {
    //~ button.value = "ON";
    //~ button.style.borderStyle = 'outset';
    //~ button.style.color = "#000000";
  //~ }
  //~ else
  //~ {
    //~ button.value = "OFF";
    //~ button.style.borderStyle = 'inset';
    //~ button.style.color = "#cc0000";
  //~ }
//~ }

function clickButton(e)
{
  var button = e.target || e.srcElement;
  var n = parseInt(button.getAttribute('n'));
  for (l = 0; l < 4; ++l)
  {
    if (e.shiftKey || shiftKey)
    {
      if (l == n)
      {
        layerState[l] = !layerState[l];
      }
    }
    else
    {
      if (l == n)
      {
        layerState[l] = true;
      }
      else
      {
        layerState[l] = false;
      }
    }
    
    if (layerState[l] === true)
    {
      layerButtons[l].value = "ON";
      layerButtons[l].style.borderStyle = 'inset';
      layerButtons[l].style.color = "#cc0000";
    }
    else
    {
      layerButtons[l].value = "OFF";
      layerButtons[l].style.borderStyle = 'outset';
      layerButtons[l].style.color = "#000000";
    }
  }
  shiftKey = false;
}

function globalKeypressed(e)
{
  //~ console.log("Pressed " + e.keyCode);
  var k = e.keyCode;
  //~ k -= 49;
  if (k - 49 >= 0 && k - 49 <= 2)
  {
    if (e.shiftKey) shiftKey = true;
    layerButtons[k-49].click();
  }

  if (player)
  {
    if (k == 37)
    {
      player.move(-1,0);
    }
    if (k == 38)
    {
      player.move(0,-1);
    }
    if (k == 39)
    {
      player.move(1,0);
    }
    if (k == 40)
    {
      player.move(0,1);
    }
  
    if (k == 90) // Z
    {
      let thing = '';
      let n = level.getTile(player.pos.x, player.pos.y, 3);
      if (n == 5)
        dialog.showText('That is a nice duck.');
      else if (n == 6)
        dialog.showText('These are nice flowers.');
      else if (n == 7)
        dialog.showText('These are nice trees.');
      else if (n == 8)
        dialog.showText('This is a nice lake.');
      else if (n == 0)
        dialog.showText('This is a nice walk.');
      else if (n == 9)
        dialog.showText('This is a nice house.');
      else if (n == 10)
        dialog.showText('I like that boulder. That is a nice boulder.');
      else if (n == 11 && goHome)
        dialog.showText('That was a nice walk.');
      //~ console.log('That is a nice thing.');
    }
  }
}

function newLevel()
{
  level.new();
}

function saveLevel()
{
  level.save();
}

function draw()
{
  level.draw();
  for (let ls = 0; ls < entities.length; ++ls)
  {
    entities[ls].draw();
  }  
  dialog.draw();
}

function gameLoop(timeStamp)
{
  shiftKey = false;
  for (l = 0; l < entities.length; ++l)
  {
    entities[l].update();
    dialog.update();
  }
  draw();
  window.requestAnimationFrame(gameLoop);
}
