//------------------------------------------------------------------------
//	gr9 effect by SuN 2021 grzegorzsun@gmail.com
//------------------------------------------------------------------------
RTCLOCK  equ $0012;
WSYNC   equ $D40A
RANDOM  equ $D20A
VCOUNT  equ $D40B

GPRIOR		= $26f		; GTIA modes: $40=9,$80=10,$c0=11
CHBAS		= $2f4		; character base
GRAFP0   	= $d00d
SIZEP0      	= $d008
HPOSP0      	= $d000
SDMCTL	= $022f

Timer equ 552
VTimr equ 538
col   equ $80
tmr   equ $81
font	= $4000
sinewave	= $0600		; to $06ff

	org $82
			
	lda #$50
	sta GPRIOR
           
;    lda #%00100010;
;	sta SDMCTL;    lda #16; one line

	ldy #$6f
	sty SIZEP0
	sty HPOSP0

	lda #>font
	sta CHBAS
			
; generate 17 fonts

			ldy #0
			sty col
			tya
f_all
			ldx #7
f_char
			sta font,y
			iny
			dex
			bpl f_char
			clc
			adc #$11
			bcc f_all
; fake sine vawe
		ldy #$7f
		sty SIZEP0
make_sine
value_lo
		lda #0
  		clc
delta_lo
  		adc #0
  		sta value_lo+1
value_hi
  		lda #0
delta_hi
  		adc #0

  		sta value_hi+1 
 		sta sinewave+$80,y
  		eor #$7f
 		sta sinewave+$00,y
 
  		lda delta_lo+1
  		adc #4
  		sta delta_lo+1
  		bcc nothi
   		inc delta_hi+1
nothi
  		inx
  		dey
 		bpl make_sine
			
;fill screen
    ldx #3; 3 loops $ff chars
fill_screen
    ldy #$ff
;    ldy #39; 40 znakw
fill_block
	tya
	and #15
ekr equ *+1
	sta $bc40,y; screen mem
	dey
	bne fill_block
;    adw ekr #40; add 40 chars to screen address
    adw ekr #$ff; add $ff to screen address
    dex
	bpl fill_screen 

; roll font
    lda #20
    ldx <roll
    ldy >roll
    stx Timer
    sty Timer+1
    sta Vtimr

vco 
    lda vcount
    bne vco
	tay

;    lda col
;    cmp #$ff
;    beq skip
    inc col
skip	
    ldx col

next_char

    lda font_offsets,y
    sta font_lo+1
	
colorloop	
    dex
font_lo
	lda $e100
    sta wsync
	sta GRAFP0

	txa
    sta $d01f;consol;
	and #%11110000
    sta wsync
	sta $d01a

    lda vcount
	adc 20
	tax
	lda sinewave,x

    adc #48
	sta HPOSP0

	inc font_lo+1
	lda font_lo+1
	and #7
	bne font_lo

	iny
	cpy #21
	bne next_char
	beq vco

; vtimer
roll 
   lda #2;
   sta VTimr

roll2
    ldy #0
fnt
	lda font,y
	clc
adcsbc 
	adc #$11
	sta font,y
	iny
	cpy #(16*8)
	bne fnt
    
    inc tmr
	lda tmr
	bne quit

    lda adcsbc
	eor #$80; adc/sbc
	sta adcsbc
quit
	rts

font_offsets
; spacje
		dta $f6,$f6,$f6,$f6,$f6,$f6,$f6
; s i l l y
		dta $98,$48,$60,$60,$c8,$f6,$f6
; v e n t u r e
		dta $b0,$28,$70,$a0,$a8,$90,$28
	
// kolejne wiersze logosa :)
/*
     org $bc40
logo equ *
;	 dta $01,$02,$03,$04,$05,$06,$07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f
	 dta $10,$10,$10,$04,$05,$06,$07,$09,$10,$10,$0b,$10,$10,$10,$0f
;     org $bc40+40
;	 dta $02,$03,$04,$05,$06,$07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f,$01
	 dta $10,$10,$04,$10,$10,$10,$10,$10,$10,$10,$0c,$10,$10,$10,$01
;     org $bc40+80
;	 dta $03,$04,$05,$06,$07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f,$01,$02
	 dta $10,$10,$05,$10,$10,$10,$10,$10,$10,$10,$0d,$10,$10,$10,$02
;     org $bc40+120
;	 dta $04,$05,$06,$07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f,$01,$02,#03
	 dta $10,$10,$10,$07,$08,$09,$0a,$10,$10,$10,$0e,$10,$10,$10,$03
;     org $bc40+160
;	 dta $05,$06,$07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f,$01,$02,$03,$04
	 dta $10,$10,$10,$10,$10,$10,$10,$0c,$10,$10,$10,$01,$10,$03,$10
;     org $bc40+200
;	 dta $06,$07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f,$01,$02,$03,$04,$05
	 dta $10,$10,$10,$10,$10,$10,$10,$0d,$10,$10,$10,$02,$10,$04,$10
;     org $bc40+240
;	 dta $07,$08,$09,$0a,$0b,$0c,$0d,$0e,$0f,$01,$02,$03,$04,$05,$06
	 dta $10,$10,$09,$0a,$0b,$0c,$0d,$10,$10,$10,$10,$10,$04,$10,$10
*/