#version 460
#extension GL_EXT_shader_atomic_int64 : enable
#extension GL_NV_shader_atomic_int64 : enable
#extension GL_ARB_gpu_shader_int64 : enable
#extension GL_NV_gpu_shader5 : enable
layout(local_size_x = 32, local_size_y = 1) in;

#define USE_RANDOM 1
#define USE_MARCHER 1
#define USE_SPAWN_POINTS 1
#define USE_SHADING_HANDLER 1
#define USE_MATERIAL_HANDLER 1

float scene_with_grad(vec3 p, out int material, out float gradmag);
void scene_init();

#define SCENE_WITH_GRAD scene_with_grad
#define SCENE_INIT scene_init

#includelib

uniform sampler2D texRockDiffuse;
uniform sampler2D texRockNormals;
uniform sampler2D texRockRoughness;

// vec3 CSize = 0.7*vec3(1., 1., 1.); //;slider[(-2,-2,-2),(0,0,0),(2,2,2)]
// float Size = 0.8; //;slider[-2,0.70968,2]
// float DEfactor = 1.; //;slider[0,1,10]
// float TwiddleRXY = 0.92784; //;slider[-2,0.92784,2]
// int Iter = 10;//;slider[0,9,100]

struct BioCubeParams {
    float Scale; // slider[0.00,1.5,4.00]
    int Iterations; //  slider[0,2,50]
    vec3 Offset; // slider[(-1,-1,-1),(0,1,1),(1,1,1)]
    vec3 Offset2; // slider[(-1,-1,-1),(1,-0.3,-0.3),(1,1,1)]
    float Qube; // slider[-1,0.1,1]
    float Angle1; // slider[-180,0,180]
    vec3 Rot1; // slider[(-1,-1,-1),(1,1,1),(1,1,1)]
    bool fold;
    float foldSym;
    float foldAsym;

};

BioCubeParams islandCube =
{
    1.45,
    13,
    vec3(-0.00825446, 0.9, 1.),
    vec3(1., -0.2361111, -0.494444),
    0.0451,
    1.5,
    vec3(1., 1., 1.),
    true,
    0.5,
    0.
};

BioCubeParams cubep = islandCube;

// Return rotation matrix for rotating around vector v by angle
mat3 rotationMatrix3(vec3 v, float angle)
{
    float c = cos(radians(angle));
    float s = sin(radians(angle));

    return mat3(c + (1.0 - c) * v.x * v.x, (1.0 - c) * v.x * v.y - s * v.z, (1.0 - c) * v.x * v.z + s * v.y,
            (1.0 - c) * v.x * v.y + s * v.z, c + (1.0 - c) * v.y * v.y, (1.0 - c) * v.y * v.z - s * v.x,
            (1.0 - c) * v.x * v.z - s * v.y, (1.0 - c) * v.y * v.z + s * v.x, c + (1.0 - c) * v.z * v.z
            );
}

mat3 cubeFracRotation1 = cubep.Scale * rotationMatrix3(normalize(cubep.Rot1), cubep.Angle1);

vec3 recFold(inout vec3 p) {
    float t;
    p.xy=abs(p.xy);
    t=p.x;
    p.x=p.x+p.y - cubep.foldSym;
    p.y=t-p.y - cubep.foldAsym;
    t=p.x;
    p.x = p.x+p.y;
    p.y = t-p.y;
    return p;
}

// BioCube fractal by DarkBeam
float biocube(vec3 z)
{
    float t; int n = 0;
    float scalep = 1.0;

    // if (cubep.fold) {
    //     z = recFold(z);
    // }

    vec3 z0=z;
    z = abs(z);

    if (z.y>z.x) z.xy =z.yx;
    if (z.z>z.x) z.xz = z.zx;
    if (z.y>z.x) z.xy =z.yx;
    float DE1 =1.0-z.x;
    z = z0;

    // Folds.
    //Dodecahedral
    while (n < cubep.Iterations) {
        z *= cubeFracRotation1;
        z = abs(z);
        z -= cubep.Offset;
        if (z.y>z.x) z.xy =z.yx;
        if (z.z>z.x) z.xz = z.zx;
        if (z.y>z.x) z.xy =z.yx;
        z -= cubep.Offset2;
        if (z.y>z.x) z.xy =z.yx;
        if (z.z>z.x) z.xz = z.zx;
        if (z.y>z.x) z.xy =z.yx;

        n++;  scalep *= cubep.Scale;
        DE1 = abs(min(cubep.Qube/float(n)-DE1,(+z.x)/scalep));
    }

    //Distance to the plane going through vec3(Size,0.,0.) and which normal is plnormal
    return DE1;
}

float scene_biocube(vec3 p, out int material) {
    material = MATERIAL_ISLAND;
    p.y = abs(p.y);
    p.y += 0.80;
    //vec2 cells = pMod2(p.xz, vec2(2.1, 2.1));

    //p.xz = rot2d(p.xz, PI/4.);
    p.xy = rot2d(p.xy, PI/4.);
    p.yz = rot2d(p.yz, PI/4.);
    //p.yz = rot2d(p.yz, sin(cells.x)*0.05);
    //p.xy = rot2d(p.xy, sin(cells.y)*0.05);

    orbitTrap = vec4(1e4);
    float d = biocube(p);
    return d;
}

float scene_with_grad(vec3 p, out int material, out float gradmag)
{
    return scene_biocube(p * .2, material);
}

// Parametric shapes

vec3 makeBlade(float span, float height, vec3 vnormal, float xspan, vec3 push)
{
    vec3 vp = span * (height * vnormal) + 0.01 * xspan * push;
    vec3 droop = -pow(span, 2.) * 0.6 * height * vec3(0., 1., 0.);
    //vp += droop;
    return vp;
}

void spawnGrassPoints(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    float voxelSize = 256;
    ivec3 quant = ivec3(surf.p * voxelSize);
    float vegs = fbm(quant);
    float wetness = max(0., 1.0 - surf.p.y);

    bool crowded = false; //surf.ambient < 0.5;

    if (!crowded && vegs > 0.3 && surf.normal.y > 0.9) {
        vec3 quantp = vec3(quant + vec3(.5)) / voxelSize;
        vec3 vnormal = evalnormal_sized(quantp, 1/voxelSize);
        if (dot(vnormal, surf.normal) < 0) {
            vnormal *= -1.;
        }

        vnormal = vec3(0., 1., 0.); // HACK

        vec3 up = abs(vnormal.y) < 0.999 ? vec3(0., 1., 0.) : vec3(0., 0., 1.);
        vec3 tangent_x = normalize(cross(up, vnormal));
        vec3 tangent_y = cross(vnormal, tangent_x);

        vec3 outside = quantp + vnormal * 0.01;
        vec3 vo = outside;
        for (int i=0;i<3;i++) {
            int tempmat;
            vo += -vnormal * scene(vo, tempmat);
        }

        bool isFloating = length(vo - quantp) >= 2./voxelSize;
        if (isFloating)
            return;

        //float height = 0.09 * .5 * (noise(quant) + noise(quant+ivec3(999,123,-3)));
        float height = 0.01 + 0.02 *  pow(noise(quant), 2.);

        // offset grid
        vec2 uv = vec2(-.5) + vec2(noise(quant+ivec3(0, 1, 2)), noise(quant+ivec3(2, 0, 1)));
        vo += (uv.x * tangent_x + uv.y * tangent_y) / voxelSize;

        vnormal.xz += 0.5*uv;
        vnormal = normalize(vnormal);

        float phi = noise(quant) * 2 * 3.1416;
        // phi = 0.; // HACK!
        vec3 push = cos(phi) * tangent_x + sin(phi) * tangent_y;
        vec3 push2 = cos(phi+3.1416) * tangent_x + sin(phi+3.1416) * tangent_y;
        //if (push.x < 0) push2 = push2 * vec3(1, 1., 1);

        float dist = length(quantp - surf.campos);
        float projRadius = (voxelSize / (dist + cone.proj_plane_dist)) / cone.pixelwidth;
        float projAreaInPixels = PI * (projRadius * projRadius);


        for (int i=ZERO;i<5;i++) {
            float span = rand();
            float xspan = rand();
            float bladeshape = 1. - span;

            if (xspan > bladeshape) continue;

            float thickness = voxelSize * 1e-3;

            vec3 vp = makeBlade(span, height, vnormal, -.5 + .5*xspan, push);
            // vec3 pdiff = makeBlade(span + 0.05, height, vnormal, xspan, push) - vp;

            vec3 bladenormal = tangent_y; // cross(push2, normalize(pdiff));
            vp += vo;

            float wraplight = .5 + .5*dot(bladenormal, surf.toLight);
            vec3 grassColor = surf.baseColor * mix(0.01, 0.03, surf.sun) * vec3(0.5, 1., 0.10);

            vec3 vcolor = mix(surf.color * 0.95, grassColor, .3 * pow(1. - span, 0.25));
            // vcolor *= wraplight;

            // vcolor = vec3(.5) + sin(vec3(projAreaInPixels) + vec3(0., 1., 2.));
            // vcolor = vec3(projAreaInPixels > 1e10 ? 1: 0);
            //vcolor = vec3(projRadius / 1920. * 1e-4);

            addPoint(vp, vec4(vcolor, 1.0), bladenormal, 0.8, surf.sun, span);
            //addPoint(vp, vec4(vcolor, 1.), bladenormal, pow(span, 0.25) * 0.8, surf.sun, span);
        }
    }
}

void spawnIslandForest(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    float voxelDensity = 8.;
    vec3 quantp;
    ivec3 quant = getQuantizedPoint(surf.p, voxelDensity, quantp);
    float density = fbm(quant + ivec3(-99, 31, 44));
    //float roughDensity = (fbm_lowfreq(quant) - minDensity) / (1. - minDensity);
    float dryness = saturate(quantp.y / 10.);
    //float score = saturate(density - 3.0 * dryness);
    float score = density;

    if (score > 0.3) {
        uint quanth = hash(uvec3(quant));
        uint plantID = quanth & 0xff;
        vec4 uniq = unpackUnorm4x8(quanth); // four unique [0,1] values for this plant

        // pick tree type based on altitude
        float numSlots = impostorAltitudeTtable.length;
        float slotOffset = (uniq.y - .5) * (numSlots * .5);
        int slot = int(floor(saturate(quantp.y / 2.) * numSlots + slotOffset ));
        slot = clamp(slot, 0, impostorAltitudeTtable.length - 1);

        const int ID = impostorAltitudeTtable[slot];
        vec2 treeSize = impostorSizes[ID];
        float height = treeSize.x * 0.8 + 1.5 * treeSize.y * pow(noise(quant), 2.);
        //float height = treeSize.x + treeSize.y * pow(noise(quant), 2.);

        float uprightness = max(0.9, saturate(quantp.y / 1.));
        //uprightness = 0.2;
        vec3 normal = getOrientedNormal(quantp, surf.normal, voxelDensity);

        if (normal.y < 0.0) {
            return;
        }

        normal = normalize(mix(normal, vec3(0., 1., 0.), uprightness));
        vec3 tangent_x, tangent_y;
        makeOrthoFrame(normal, tangent_x, tangent_y);

        vec3 vo = snapPointToSurface(quantp, normal);

        bool isFloating = length(vo - quantp) >= 2./voxelDensity;
        if (isFloating)
            return;

        // push plants near the shore down to water
        vo.y -= saturate((1.-quantp.y)/2.) * 1. * height;

        vec2 uv = offsetGridPoint(quant, voxelDensity, tangent_x, tangent_y, vo);

        const float maxShadowDist = 10.;
        vec2 shadowResult = shadowMarch(vo + normal*height, surf.toLight, 50, 9e-2, 5e-3, maxShadowDist);
        float sun = shadowResultToSun(shadowResult, maxShadowDist);

        vec3 basisx, basisz;
        float rotationOfs = uv.x * 0.2;
        makeBillboardbasis(cam.pos - quantp, rotationOfs, normal, tangent_x, tangent_y, basisx, basisz);
        basisz = -basisz;

        float mip = pickMip(textureSize(impostors[ID].color, 0).xy, height, quantp, cone, surf.campos);

        // number of samples is proportional to world space area of the thing
        // note that our "voxel" spawning system already takes care of distance based LOD
        const int numSamples = int(floor(height * height * 60.));

        vec3 basisy = normal;
        basisy *= height;
        basisx *= height;
        basisz *= height;

        MaterialInfo matInfo;
        matInfo.tint = hsv2rgb(vec3(0.05 + uniq.z*0.25, 0.0 + uniq.w*0.5, 1.0));
        matInfo.tint *= 0.6;
        matInfo.shininess = 0.5;

        //matInfo.tint = hsv2rgb(vec3(float(slot)/float(numSlots-1.), 1., 0.1));

        spawnImpostor(ID, plantID, mip, surf, numSamples, vo, basisx, basisy, basisz, matInfo, sun, 1.);
        //spawnCubeImpostor(ID, plantID, mip, surf, numSamples, vo, basisx, basisy, basisz, matInfo, sun);
    }
}

bool spawnPoints(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    if (surf.material == MATERIAL_ISLAND) {
        spawnIslandForest(surf, cone, cam);
    }

    return true;
}

void scene_init()
{
    switch (prop_geometry) {
        case GEOMETRY_ISLANDCUBE:
            cubep = islandCube;
            break;
    }
}

const float rockScale = 0.5;

void shadingHandler(in vec3 p, in float t, in int hitmat, in CameraParams cam, inout vec3 normal, inout vec3 roughNormal, inout vec3 to_light, inout vec3 to_camera, inout float maxShadowDist)
{
    /*
    if (hitmat == MATERIAL_ISLAND) {
        // "p" point apply texture to
        // "n" normal at "p"
        // "k" controls the sharpness of the blending in the
        //     transitions areas.
        // "s" texture sampler
        vec4 tex = boxmap( texRockNormals, p * rockScale, normal, 1.0 );
        vec3 nor = tex.xyz * vec3(2., 2., 2.) + vec3(-1, -1, -1.);
        //vec3 nor = tex.xyz * vec3(2., 2., 1.) + vec3(-1, -1, 0.);
        nor = mix(vec3(0., 0., 1.), nor, 1.);

        vec3 tangent_x, tangent_y;

        //makeOrthoFrame(normal, tangent_x, tangent_y);
        //vec3 warped_normal = nor.x * tangent_x + nor.y * tangent_y + nor.z * normal;
        vec3 warped_normal = normal + 0.25 * nor.xyz;
        normal = normalize(warped_normal);
    }
    */
}

void materialHandler(in SurfaceInfo surf, inout vec3 base, inout float shininess, inout float ambient, inout float sun,
inout float facing, inout vec3 suncol)
{
    //float roughness = boxmap( texRockRoughness, surf.p * rockScale, surf.normal, 1.0 ).r;
    //vec3 diffuse = boxmap( texRockDiffuse, surf.p * rockScale, surf.normal, 1.0 ).rgb;

    base = vec3(0.02) * vec3(1., 0.5, 0.5);
    shininess = 0.1;
    //base = vec3(0.02) * diffuse * diffuse; //vec3(1., 0.5, 0.5);
    //shininess = mix((1. - roughness), 1., 0.0);
}


