#version 460
#extension GL_NV_shader_atomic_int64 : enable
#extension GL_ARB_gpu_shader_int64 : enable
layout(local_size_x = 32, local_size_y = 1) in;

#define USE_RANDOM 1
#define USE_MARCHER 1
#define USE_SPAWN_POINTS 1

float scene_jungle(vec3 p, out int material, out float gradmag);
void scene_init();

#define SCENE_WITH_GRAD scene_jungle
#define SCENE_INIT scene_init

#includelib

float scene_jungle(vec3 p, out int material, out float gradmag) {
    vec3 p2 = p;
    p2.y = abs(p2.y);
    const float scale = 0.1;
    const float height = scale * 10.0;
    const float riverdepth = scale * 30.0;
    vec3 h = fbmd_9(p2.xz * 0.05/scale) * height;
    //h.x += scale * 40.;
    //vec3 h = vec3(0.);
    float width = scale * 28.;
    float spread = saturate(abs((p.x + scale * 50 * sin(-p.z / (scale * 80.))) - width) / width);
    spread = 1.-spread;
    spread *= spread;
    h.x -= riverdepth * spread;

    float d = p2.y - h.x - height * 0.7;
    material = MATERIAL_JUNGLEFLOOR;
    gradmag = length(h.yz);
    return d;
}

void spawnSmallPalms(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    float voxelDensity = 16.;
    vec3 quantp;
    ivec3 quant = getQuantizedPoint(surf.p, voxelDensity, quantp);
    float density = fbm(quant);
    const float minDensity = 0.2;
    //float roughDensity = (fbm_lowfreq(quant) - minDensity) / (1. - minDensity);

    bool crowded = false; //surf.ambient < 0.5;

    if (!crowded && density > minDensity && surf.normal.y > 0.0) {
        vec3 vnormal, tangent_x, tangent_y;
        getQuantizedFrame(quantp, surf.normal, voxelDensity, vnormal, tangent_x, tangent_y);
        vec3 vo = snapPointToSurface(quantp, vnormal);
        //vo += vnormal * 0.1 * noise(quant+ivec3(-9, 5, 123)) * saturate(quantp.y / 1.);

        bool isFloating = length(vo - quantp) >= 2./voxelDensity;
        if (isFloating)
            return;

        float height = 0.15 + 0.4 *  pow(noise(quant), 2.);
        height *= 0.4;

        vec2 uv = offsetGridPoint(quant, voxelDensity, tangent_x, tangent_y, vo);

        vnormal.xz += 0.5*uv;
        vnormal = normalize(vnormal);

        const float maxShadowDist = 10.;
        vec2 shadowResult = shadowMarch(vo + vnormal*height, surf.toLight, 50, 9e-2, 5e-3, maxShadowDist);
        float sun = shadowResultToSun(shadowResult, maxShadowDist);

        vec3 basisx, basisz;
        float rotationOfs = uv.x * 0.3;
        makeBillboardbasis(cam.pos - quantp, rotationOfs, vnormal, tangent_x, tangent_y, basisx, basisz, 8.);

        const int ID = IMPOSTOR_SMALL_PALM;
        //const int ID = IMPOSTOR_CURRY_TREE1 + int(4. * round(noise(quant + ivec3(-91, 23, -99))));

        float mip = pickMip(textureSize(impostors[ID].color, 0).xy, height, quantp, cone, surf.campos);

        // number of samples is proportional to world space area of the thing
        // note that our "voxel" spawning system already takes care of distance based LOD
        const int numSamples = int(floor(height * height * 200.));

        vec3 basisy = vnormal;
        basisy *= height;
        basisx *= height;
        basisz *= height;
        MaterialInfo matInfo;
        matInfo.tint = vec3(1.);
        matInfo.shininess = 0.5;
        spawnImpostor(ID, 0, mip, surf, numSamples, vo, basisx, basisy, basisz, matInfo, sun, 1.);
    }
}

void spawnBigPalms(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    float voxelDensity = 16.;
    vec3 quantp;
    ivec3 quant = getQuantizedPoint(surf.p, voxelDensity, quantp);
    float density = fbm(quant + ivec3(-99, 31, 44));
    //float roughDensity = (fbm_lowfreq(quant) - minDensity) / (1. - minDensity);
    float dryness = saturate(quantp.y / 10.);
    float score = saturate(density - 5.0 * dryness);

    bool crowded = false; //surf.ambient < 0.5;

    if (!crowded && score > 0.2 && surf.normal.y > 0.8) {
        vec3 vnormal, tangent_x, tangent_y;
        getQuantizedFrame(quantp, surf.normal, voxelDensity, vnormal, tangent_x, tangent_y);
        vec3 vo = snapPointToSurface(quantp, vnormal);

        bool isFloating = length(vo - quantp) >= 2./voxelDensity;
        if (isFloating)
            return;

        float height = 0.20 + 0.2 *  pow(noise(quant), 2.);
        height *= 1.0;

        vec2 uv = offsetGridPoint(quant, voxelDensity, tangent_x, tangent_y, vo);

        vnormal.xz += 0.5*uv;
        vnormal = normalize(vnormal);

        const float maxShadowDist = 10.;
        vec2 shadowResult = shadowMarch(vo + vnormal*height, surf.toLight, 50, 9e-2, 5e-3, maxShadowDist);
        float sun = shadowResultToSun(shadowResult, maxShadowDist);

        vec3 basisx, basisz;
        makeBillboardbasis(cam.pos - quantp, uv.x * 0.3, vnormal, tangent_x, tangent_y, basisx, basisz, 8.);

        const int ID = IMPOSTOR_SMALL_PALM;

        float mip = pickMip(textureSize(impostors[ID].color, 0).xy, height, quantp, cone, surf.campos);

        // number of samples is proportional to world space area of the thing
        // note that our "voxel" spawning system already takes care of distance based LOD
        const int numSamples = int(floor(height * height * 100.));

        vec3 basisy = vnormal;
        basisy *= height;
        basisx *= height;
        basisz *= height;
        MaterialInfo matInfo;
        matInfo.tint = vec3(1.);
        matInfo.shininess = 0.5;
        spawnImpostor(ID, 0, mip, surf, numSamples, vo, basisx, basisy, basisz, matInfo, sun, 1.);
    }
}


void spawnRainforest(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    float voxelDensity = 8.;
    vec3 quantp;
    ivec3 quant = getQuantizedPoint(surf.p, voxelDensity, quantp);
    float density = fbm(quant + ivec3(-99, 31, 44));
    //float roughDensity = (fbm_lowfreq(quant) - minDensity) / (1. - minDensity);
    float dryness = saturate(quantp.y / 10.);
    //float score = saturate(density - 3.0 * dryness);
    float score = density;

    if (score > 0.2) {
        uint quanth = hash(uvec3(quant));
        uint plantID = quanth & 0xff;
        vec4 uniq = unpackUnorm4x8(quanth); // four unique [0,1] values for this plant

        // pick tree type based on altitude
        float numSlots = impostorAltitudeTtable.length();
        float slotOffset = (uniq.y - .5) * (numSlots * .5);
        int slot = int(floor(saturate(quantp.y / 2.) * numSlots + slotOffset ));
        slot = clamp(slot, 0, impostorAltitudeTtable.length() - 1);

        int ID = impostorAltitudeTtable[slot];
        vec2 treeSize = impostorSizes[ID];
        float height = treeSize.x + treeSize.y * pow(noise(quant), 2.);

        float uprightness = max(0.9, saturate(quantp.y / 1.));
        //uprightness = 0.2;
        vec3 normal = getOrientedNormal(quantp, surf.normal, voxelDensity);
        normal = normalize(mix(normal, vec3(0., 1., 0.), uprightness));
        vec3 tangent_x, tangent_y;
        makeOrthoFrame(normal, tangent_x, tangent_y);

        vec3 vo = snapPointToSurface(quantp, normal);

        bool isFloating = length(vo - quantp) >= 2./voxelDensity;
        if (isFloating)
            return;

        // push plants near the shore down to water
        vo.y -= saturate((1.-quantp.y)/2.) * 1. * height;

        vec2 uv = offsetGridPoint(quant, voxelDensity, tangent_x, tangent_y, vo);

        const float maxShadowDist = 10.;
        vec2 shadowResult = shadowMarch(vo + normal*height, surf.toLight, 50, 9e-2, 5e-3, maxShadowDist);
        float sun = shadowResultToSun(shadowResult, maxShadowDist);

        vec3 basisx, basisz;
        float rotationOfs = uv.x * 0.2 - prop_marcher_impostor_angle;
        //makeBillboardbasis(cam.pos - quantp, rotationOfs, normal, tangent_x, tangent_y, basisx, basisz, 8.);
        makeBillboardbasis(cam.startPos - quantp, rotationOfs, normal, tangent_x, tangent_y, basisx, basisz, 8.);

        float mip = pickMip(textureSize(impostors[ID].color, 0).xy, height, quantp, cone, surf.campos);

        // number of samples is proportional to world space area of the thing
        // note that our "voxel" spawning system already takes care of distance based LOD
        const int numSamples = int(floor(height * height * 150.));

        vec3 basisy = normal;
        basisy *= height;
        basisx *= height;
        basisz *= height;

        MaterialInfo matInfo;
        matInfo.tint = hsv2rgb(vec3(0.15 + uniq.z*0.15, 0.0 + uniq.w*0.5, 1.0));
        matInfo.tint *= 1.0;
        //matInfo.tint = vec3(1.0);
        matInfo.shininess = 0.6;
        surf.ambient *= 120.;
        surf.ambient += 0.0;

        //matInfo.tint = hsv2rgb(vec3(float(slot)/float(numSlots-1.), 1., 0.1));

        spawnImpostor(ID, plantID, mip, surf, numSamples, vo, basisx, basisy, basisz, matInfo, sun, 1.);
        //spawnCubeImpostor(ID, plantID, mip, surf, numSamples, vo, basisx, basisy, basisz, matInfo, sun);
    }
}

bool spawnPoints(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    if (surf.material == MATERIAL_JUNGLEFLOOR) {
        //spawnSmallPalms(surf, cone, cam);
        //spawnBigPalms(surf, cone, cam);
        spawnRainforest(surf, cone, cam);
    }

    return true;
}

void scene_init()
{
}




