#version 460
#extension GL_NV_shader_atomic_int64 : enable
#extension GL_ARB_gpu_shader_int64 : enable
layout(local_size_x = 32, local_size_y = 1) in;

#define USE_RANDOM 1
#define USE_MARCHER 1
#define USE_SHADING_HANDLER 1
#define USE_MATERIAL_HANDLER 1
#define USE_SPAWN_POINTS 1

//#define NO_SHADOWS 1
#define AMBIENT_STEPS 10

float scene_with_grad(vec3 p, out int material, out float gradmag);
void scene_init();

#define SCENE_WITH_GRAD scene_with_grad
#define SCENE_INIT scene_init

#includelib

uniform sampler2D texRockDiffuse;
uniform sampler2D texRockNormals;
uniform sampler2D texRockRoughness;

const vec3 statuePos = vec3(-0.01, 0.050, 1.990);

// mandelbox distance function by Rrola (Buddhi's distance estimation)
// http://www.fractalforums.com/index.php?topic=2785.msg21412#msg21412

const float SCALE = 2.30;
const float MR2 = 0.5;
vec4 mbox_scalevec = vec4(SCALE, SCALE, SCALE, abs(SCALE)) / MR2;
float mbox_C1 = abs(SCALE-1.0);

float mandelbox2(vec3 position, int iters) {
    const float SCALE = 2.60;
    const float MR2 = 0.1;
    const vec4 mbox_scalevec = vec4(1, 1, 1.1, 1) * vec4(SCALE, SCALE, SCALE, abs(SCALE)) / MR2;
    const float mbox_C1 = abs(SCALE-1.0);

    float mbox_C2 = pow(abs(SCALE), float(1-iters));
	// distance estimate
	vec4 p = vec4(position.xyz, 1.0), p0 = vec4(position.xyz, 1.0);  // p.w is knighty's DEfactor
	for (int i=ZERO; i<iters; i++) {
		p.xyz = clamp(p.xyz, -1.0, 1.0) * 2.0 - p.xyz;  // box fold: min3, max3, mad3
		float r2 = dot(p.xyz, p.xyz);  // dp3
		p.xyzw *= clamp(max(MR2/r2, MR2), 0.0, 1.0);  // sphere fold: div1, max1.sat, mul4
		p.xyzw = p*mbox_scalevec + p0;  // mad4
	}
	float d = (length(p.xyz) - mbox_C1) / p.w - mbox_C2;
    return d;
}

float mandelbox(vec3 position, int iters) {
    float mbox_C2 = pow(abs(SCALE), float(1-iters));
	// distance estimate
	vec4 p = vec4(position.xyz, 1.0), p0 = vec4(position.xyz, 1.0);  // p.w is knighty's DEfactor
	for (int i=ZERO; i<iters; i++) {
		p.xyz = clamp(p.xyz, -1.0, 1.0) * 2.0 - p.xyz;  // box fold: min3, max3, mad3
		float r2 = dot(p.xyz, p.xyz);  // dp3
		p.xyzw *= clamp(max(MR2/r2, MR2), 0.0, 1.0);  // sphere fold: div1, max1.sat, mul4
		p.xyzw = p*mbox_scalevec + p0;  // mad4
	}
	float d = (length(p.xyz) - mbox_C1) / p.w - mbox_C2;
    return d;
}


float scene_rotated_brot(vec3 p, out int material) {
	material = MATERIAL_STONE;
    p.y = abs(p.y);
    p.y -= prop_mandelbox_height;

    float cylradius = 0.10;
    float cylheight = -prop_mandelbox_height + cylradius + 1e-2;
    float cyl = length(p.xy - vec2(0., cylheight)) - cylradius;

    //vec2 cells = pMod2(p.xz, vec2(15.0, 15.0));
    float cell = pMod1(p.z, 8.0);
    p.zy = p.yz;
    p.xz = rot2d(p.xz, prop_mandelbox_roll);

	float d = mandelbox(p, prop_mandelbox_iters);

    d = max(d, -cyl);
    return d;
}

float scene_hall(vec3 p, out int material) {
    //float ball = length(p - (statuePos + vec3(0.0, 0.3, 0.))) - 0.1;

    p.y = abs(p.y);
    p.y -= prop_mandelbox_height;

	material = MATERIAL_STONE;

    //float cylradius = 1.00;
    //float cylheight = -prop_mandelbox_height + cylradius + 1e-2;
    //float cyl = length(p.xz - vec2(0., cylheight)) - cylradius;

    //vec2 cells = pMod2(p.xz, vec2(15.0, 15.0));
    float cell = pMod1(p.z, 8.0);
    p.zy = p.yz;
    p.xz = rot2d(p.xz, prop_mandelbox_roll);

	float d = mandelbox2(p, prop_mandelbox_iters);
    //d = max(d, -cyl);
    //d = min(d, ball);
    //float d =ball;

    return d;
}


float scene_brot(vec3 p, out int material) {
	material = MATERIAL_STONE;
    vec3 p2 = p;
    p2.y = abs(p2.y);
    p2.y -= prop_mandelbox_height;
    p2.yz = rot2d(p2.yz, 0.5);
	return mandelbox(p2, prop_mandelbox_iters);
}
float scene_with_grad(vec3 p, out int material, out float gradmag) {
    if (prop_geometry == GEOMETRY_CAVE) {
        return scene_rotated_brot(p, material);
    } else if (prop_geometry == GEOMETRY_CAVE2) {
        return scene_hall(p, material);
    }
}

void scene_init()
{
}

const float rockScale = 8.;

void shadingHandler(in vec3 p, in float t, in int hitmat, in CameraParams cam, inout vec3 normal, inout vec3 roughNormal, inout vec3 to_light, inout vec3 to_camera, inout float maxShadowDist)
{
    if (hitmat == MATERIAL_STONE) {
        // "p" point apply texture to
        // "n" normal at "p"
        // "k" controls the sharpness of the blending in the
        //     transitions areas.
        // "s" texture sampler
        vec4 tex = boxmap( texRockNormals, p * rockScale, normal, 1.0 );
        vec3 nor = tex.xyz * vec3(2., 2., 2.) + vec3(-1, -1, -1.);
        //vec3 nor = tex.xyz * vec3(2., 2., 1.) + vec3(-1, -1, 0.);
        nor = mix(vec3(0., 0., 1.), nor, 1.);

        vec3 tangent_x, tangent_y;

        //makeOrthoFrame(normal, tangent_x, tangent_y);
        //vec3 warped_normal = nor.x * tangent_x + nor.y * tangent_y + nor.z * normal;
        vec3 warped_normal = normal + 0.3 * nor.xzy;
        normal = normalize(warped_normal);

        vec3 lightPosition = (cam.pos - vec3(0., 0.05, 0.0)*normalize(cam.up));

        //if (rand() < 0.9) { lightPosition = statuePos; }

        vec3 pointToLight = lightPosition - p;
        const float lightDist = length(pointToLight);
        maxShadowDist = lightDist;

        to_light = pointToLight / lightDist;
        //to_light = normalize(to_camera + 0.03*vec3(0., -1., 0.)/(t+.1));
        //to_light = to_camera;
    }
}

void materialHandler(in SurfaceInfo surf, inout vec3 base, inout float shininess, inout float ambient, inout float sun,
inout float facing, inout vec3 suncol)
{
    float roughness = boxmap( texRockRoughness, surf.p * rockScale, surf.normal, 1.0 ).r;
    vec3 diffuse = boxmap( texRockDiffuse, surf.p * rockScale, surf.normal, 1.0 ).rgb;

    //sun = 0.1;
    //base = diffuse * max(0.1, ambient) * 4.;
    base = diffuse * max(0.1, ambient);
    //base *= vec3(0.3, 1., 0.9);
    //base = vec3(.5) + .5* surf.normal;
    shininess = mix((1. - roughness), 1., 0.4);

    // blend towards roughness when far away
    shininess = mix(shininess, 0., saturate(length(surf.p - surf.campos) / 3.));

    //ambient = 0.; // no actual ambient light
    //facing = 1.;
}


// Parametric shapes

vec3 makeBlade(float span, float height, vec3 vnormal, float xspan, vec3 push)
{
    vec3 vp = span * (height * vnormal) + 0.01 * xspan * push;
    vec3 droop = -pow(span, 2.) * 0.6 * height * vec3(0., 1., 0.);
    //vp += droop;
    return vp;
}

void spawnGrassPoints(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    float voxelSize = 256;
    ivec3 quant = ivec3(surf.p * voxelSize);
    float vegs = fbm(quant);
    float wetness = max(0., 1.0 - surf.p.y);

    bool crowded = false; //surf.ambient < 0.5;

    if (!crowded && vegs > 0.3 && surf.normal.y > -0.1) {
        vec3 quantp = vec3(quant + vec3(.5)) / voxelSize;
        vec3 vnormal = evalnormal_sized(quantp, 1/voxelSize);
        if (dot(vnormal, surf.normal) < 0) {
            vnormal *= -1.;
        }

        vnormal = vec3(0., 1., 0.); // HACK

        vec3 tangent_x, tangent_y;
        makeOrthoFrame(vnormal, tangent_x, tangent_y);

        //vec3 up = abs(vnormal.y) < 0.999 ? vec3(0., 1., 0.) : vec3(0., 0., 1.);
        //vec3 tangent_x = normalize(cross(up, vnormal));
        //vec3 tangent_y = cross(vnormal, tangent_x);

        vec3 outside = quantp + vnormal * 0.01;
        vec3 vo = outside;
        for (int i=0;i<3;i++) {
            int tempmat;
            vo += -vnormal * scene(vo, tempmat);
        }

        bool isFloating = length(vo - quantp) >= 2./voxelSize;
        if (isFloating)
            return;

        //float height = 0.09 * .5 * (noise(quant) + noise(quant+ivec3(999,123,-3)));
        float height = 0.01 + 0.02 *  pow(noise(quant), 2.);
        height *= 0.1;

        // offset grid
        vec2 uv = vec2(-.5) + vec2(noise(quant+ivec3(0, 1, 2)), noise(quant+ivec3(2, 0, 1)));
        vo += (uv.x * tangent_x + uv.y * tangent_y) / voxelSize;

        //vnormal.xz += 0.5*uv;
        //vnormal = normalize(vnormal);

        float phi = noise(quant) * 2 * 3.1416;
        // phi = 0.; // HACK!

        vec3 push = cos(phi) * tangent_x + sin(phi) * tangent_y;
        vec3 push2 = cos(phi+3.1416) * tangent_x + sin(phi+3.1416) * tangent_y;
        //if (push.x < 0) push2 = push2 * vec3(1, 1., 1);

        float dist = length(quantp - surf.campos);
        float projRadius = (voxelSize / (dist + cone.proj_plane_dist)) / cone.pixelwidth;
        float projAreaInPixels = PI * (projRadius * projRadius);


        for (int i=ZERO;i<5;i++) {
            float span = rand();
            float xspan = rand();
            float bladeshape = 1. - span;

            if (xspan > bladeshape) continue;

            float thickness = voxelSize * 1e-3;

            vec3 vp = makeBlade(span, height, vnormal, -.5 + .5*xspan, push);
            // vec3 pdiff = makeBlade(span + 0.05, height, vnormal, xspan, push) - vp;

            vec3 bladenormal = tangent_y; // cross(push2, normalize(pdiff));
            bladenormal = normalize(cam.pos - surf.p);
            vp += vo;

            float wraplight = .5 + .5*dot(bladenormal, surf.toLight);
            vec3 grassColor = surf.baseColor * mix(0.01, 0.03, surf.sun) * vec3(0.5, 1., 0.10);

            vec3 vcolor = mix(surf.color * 0.95, grassColor, .3 * pow(1. - span, 0.25));
            // vcolor *= wraplight;

            // vcolor = vec3(.5) + sin(vec3(projAreaInPixels) + vec3(0., 1., 2.));
            // vcolor = vec3(projAreaInPixels > 1e10 ? 1: 0);
            //vcolor = vec3(projRadius / 1920. * 1e-4);

            //vcolor = vec3(1.0);
            vcolor *= 0.1;
            addPoint(vp, vec4(vcolor, 1.0), bladenormal, 0.8, surf.sun, span, 0.);
            //addPoint(vp, vec4(vcolor, 1.), bladenormal, pow(span, 0.25) * 0.8, surf.sun, span, 0.);
        }
    }
}

void spawnStatues(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    float height = 0.30;

    vec3 loc = statuePos;
    vec3 normal = vec3(0., 1., 0.);
    vec3 tangent_x, tangent_y;
    makeOrthoFrame(normal, tangent_x, tangent_y);
    //tangent_x = -tangent_x;
    //tangent_y = -tangent_y;

    const float maxShadowDist = 10.;
    vec2 shadowResult = shadowMarch(loc + normal*height, surf.toLight, 50, 9e-2, 5e-3, maxShadowDist);
    float sun = shadowResultToSun(shadowResult, maxShadowDist);

    vec3 basisx, basisz;
    float rotationOfs = 0.;
    makeBillboardbasis(cam.pos - loc, rotationOfs, normal, tangent_x, tangent_y, basisx, basisz, 8.);
    basisx = -basisx;
    //basisy = -basisy;
    //basisz = -basisz;

    const int ID = IMPOSTOR_STATUE;

    //float mip = pickMip(textureSize(impostors[ID].color, 0).xy, height, loc, cone, surf.campos);
    float mip = 0.;

    // number of samples is proportional to world space area of the thing
    // note that our "voxel" spawning system already takes care of distance based LOD
    const int numSamples = int(ceil(height * height * 10.));

    vec3 basisy = normal;
    basisx *= height;
    basisy *= height;
    basisz *= height;

    MaterialInfo matInfo;
    matInfo.tint = 1e-4 * vec3(0.5, 1., 0.7);
    matInfo.tint *= 25.;
    matInfo.shininess = 0.2;

    sun = 1.;
    surf.sun = 1.;
    const float yDarken = 0.;

    //matInfo.tint = hsv2rgb(vec3(float(slot)/float(numSlots-1.), 1., 0.1));

    spawnImpostor(ID, 0, mip, surf, numSamples, loc, basisx, basisy, basisz, matInfo, sun, yDarken);
    //spawnCubeImpostor(ID, 0, mip, surf, numSamples, loc, basisx, basisy, basisz, matInfo, sun);
}
bool spawnPoints(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    if (prop_geometry == GEOMETRY_CAVE2) {
        if (surf.material == MATERIAL_STONE) {
            // spawnGrassPoints(surf, cone, cam);
            spawnStatues(surf, cone, cam);
        }
    }

    return true;
}


