#version 460
#extension GL_NV_shader_atomic_int64 : enable
#extension GL_ARB_gpu_shader_int64 : enable
layout(local_size_x = 32, local_size_y = 1) in;

#define USE_RANDOM 1
#define USE_MARCHER 1
#define USE_SPAWN_POINTS 1

float scene_with_grad(vec3 p, out int material, out float gradmag);
void scene_init();

#define SCENE_WITH_GRAD scene_with_grad
#define SCENE_INIT scene_init

#includelib

// vec3 CSize = 0.7*vec3(1., 1., 1.); //;slider[(-2,-2,-2),(0,0,0),(2,2,2)]
// float Size = 0.8; //;slider[-2,0.70968,2]
// float DEfactor = 1.; //;slider[0,1,10]
// float TwiddleRXY = 0.92784; //;slider[-2,0.92784,2]
// int Iter = 10;//;slider[0,9,100]

struct BioCubeParams {
    float Scale; // slider[0.00,1.5,4.00]
    int Iterations; //  slider[0,2,50]
    vec3 Offset; // slider[(-1,-1,-1),(0,1,1),(1,1,1)]
    vec3 Offset2; // slider[(-1,-1,-1),(1,-0.3,-0.3),(1,1,1)]
    float Qube; // slider[-1,0.1,1]
    float Angle1; // slider[-180,0,180]
    vec3 Rot1; // slider[(-1,-1,-1),(1,1,1),(1,1,1)]
    bool fold;
    float foldSym;
    float foldAsym;

};

BioCubeParams brokenCube =
{
    1.40,
    11,
    vec3(-0.08025446, 1.05, 0.95),
    vec3(1., -0.2361111, -0.394444),
    0.0451,
    1.1,
    vec3(1., 1., 1.),
    true,
    0.5,
    0.
};


BioCubeParams cubep = brokenCube;

// void init() {
// 	//fracRotation2 = rotationMatrix3(normalize(Rot2), Angle2);
// 	fracRotation1 = Scale* rotationMatrix3(normalize(Rot1), Angle1);
// }

// Return rotation matrix for rotating around vector v by angle
mat3 rotationMatrix3(vec3 v, float angle)
{
    float c = cos(radians(angle));
    float s = sin(radians(angle));

    return mat3(c + (1.0 - c) * v.x * v.x, (1.0 - c) * v.x * v.y - s * v.z, (1.0 - c) * v.x * v.z + s * v.y,
            (1.0 - c) * v.x * v.y + s * v.z, c + (1.0 - c) * v.y * v.y, (1.0 - c) * v.y * v.z - s * v.x,
            (1.0 - c) * v.x * v.z - s * v.y, (1.0 - c) * v.y * v.z + s * v.x, c + (1.0 - c) * v.z * v.z
            );
}

mat3 cubeFracRotation1 = cubep.Scale * rotationMatrix3(normalize(cubep.Rot1), cubep.Angle1);

vec3 recFold(inout vec3 p) {
    float t;
    p.xy=abs(p.xy);
    t=p.x;
    p.x=p.x+p.y - cubep.foldSym;
    p.y=t-p.y - cubep.foldAsym;
    t=p.x;
    p.x = p.x+p.y;
    p.y = t-p.y;
    return p;
}

// BioCube fractal by DarkBeam
float biocube(vec3 z)
{
    float t; int n = 0;
    float scalep = 1.0;

    // if (cubep.fold) {
    //     z = recFold(z);
    // }

    vec3 z0=z;
    z = abs(z);

    if (z.y>z.x) z.xy =z.yx;
    if (z.z>z.x) z.xz = z.zx;
    if (z.y>z.x) z.xy =z.yx;
    float DE1 =1.0-z.x;
    z = z0;

    // Folds.
    //Dodecahedral
    while (n < cubep.Iterations) {
        z *= cubeFracRotation1;
        z = abs(z);
        z -= cubep.Offset;
        if (z.y>z.x) z.xy =z.yx;
        if (z.z>z.x) z.xz = z.zx;
        if (z.y>z.x) z.xy =z.yx;
        z -= cubep.Offset2;
        if (z.y>z.x) z.xy =z.yx;
        if (z.z>z.x) z.xz = z.zx;
        if (z.y>z.x) z.xy =z.yx;

        n++;  scalep *= cubep.Scale;
        DE1 = abs(min(cubep.Qube/float(n)-DE1,(+z.x)/scalep));
    }

    //Distance to the plane going through vec3(Size,0.,0.) and which normal is plnormal
    return DE1;
}

float scene_biocube(vec3 p, out int material) {
	material = MATERIAL_SILVERSCREEN;
    vec3 p2 = p;
    p2.y = abs(p2.y);
    p2.y -= 1.0;
    // vec2 cells = pMod2(p2.xz, vec2(3.0, 3.0));

    float skyplane_dist = p2.y - 1.;

    //p2.yz = rot2d(p2.yz, sin(cells.x)*0.05);
    //p2.xy = rot2d(p2.xy, sin(cells.y)*0.05);

    orbitTrap = vec4(1e4);
    float d = biocube(p2);
    // d = max(d, skyplane_dist);
    return d;
}

float scene_with_grad(vec3 p, out int material, out float gradmag)
{
    return scene_biocube(p * .5, material);
}

bool spawnPoints(in SurfaceInfo surf, in ConeSetup cone, in CameraParams cam)
{
    if (surf.material == MATERIAL_GRASSLAND) {
        // spawnGrassPoints(surf, cone, cam);
    }

    return true;
}

void scene_init()
{
}




