org 100h

start:
    push    0A000h - 70     ; modified to center to 160,100
    aas                     ; make aspect ratio float of ~1.24
    mov     cx, bx

    pop     es              ; ES -> ScreenPointer
    mov     al, 13h
    int     10h             ; mode 13h

main_loop:
    ;------------------------------------------------------------
    ; Fake inplace buffer swap
    ;------------------------------------------------------------
    mov     al, [es:di]     ; load pixel
    and     ax, 16
    dec     ax
    xor     al, ah
    and     ax, 15
    stosb                   ; AL -> pixel, increment DI

    ; iterate over screen and increment timer
    and     di, di
    jnz     main_loop
    inc     cx

    ;------------------------------------------------------------
    ; Render section
    ;------------------------------------------------------------
    pusha

    %define  _T  si-12
    %define  _X  si-16
    %define  _Y  si-20

    ; update timer
    mov     fs, di              ; set fs to 0
    fild    dword [fs:0x46c]    ; get frame count
    fidiv   word [_Speed]
    fstp    dword [_T]

    mov     cx, word [_8]
outer_loop:
    push	cx  ; 'a
    and     cx, 7
    mov     ax, cx
    shr     al, 1
    xor     ax, cx

    ; reset FPU
    fninit

    ; generate t vector
    mov     cl, 3
t_vec_loop:
    fild    word [_Scale]   ; push scale
    test    al, 1           ; check last bit
    je      skip_fchs       ; skip
    fchs                    ; change sign
skip_fchs:
    shr     al, 1
    loop    t_vec_loop      ; tx  ty  tz

    ; rotate t vector (method taken from gopher)
    mov		cl, 2
rot_loop:                   ; x   y   z
    fxch	st2             ; z   y   x
    fld     dword [_T]      ; t   z   y   x
    fsincos                 ; c   s   z   y   x
    fld 	st2             ; z   c   s   z   y   x
    fmul 	st0, st1        ; zc  c   s   z   y   x
    fld 	st4             ; y   zc  c   s   z   y   x
    fmul 	st0, st3        ; ys  zc  c   s   z   y   x
    fsubp 	st1, st0        ; y'  c   s   z   y   x
    fxch 	st3             ; z   c   s   y'  y   x
    fmulp 	st2, st0        ; c   zs  y'  y   x
    fmulp 	st3, st0        ; zs  y'  cy  x
    faddp 	st2, st0        ; y'  z'  x
    loop	rot_loop        ; x'  y'' z'  (after both iterations)

    ; just take the last two
    fstp                    ; tx  ty

    ; compute sx and sy
    fld     dword [_Y]      ; y   tx  ty
    fsubr   st0, st2        ; sy  tx  ty
    fld     dword [_X]      ; x   sy  tx  ty
    fsubr   st0, st2        ; sx  sy  tx  ty
    fld     st1
    fmul    st0, st0        ; sy2 sx  sy  tx  ty
    fld     st1
    fmul    st0, st0        ; sx2 sy2 sx  sy  tx  ty
    faddp                   ; sm  sx  sy  tx  ty

    ; safety checks
    fist    word [si]
    mov     ax, word [si]
    shr     ax, 2
    test    ax, ax
    jz      skip_line

    ; normalize sx and sy
    fsqrt                   ; sm  sx  sy  tx  ty
    fdiv    st1, st0
    fdiv    st2, st0        ; sm  sx' sy' tx  ty

    ; modulate line length
    fld1                    ; 1   sm  sx  sy  tx  ty
    fild    word [esp]      ; i   1   sm  sx  sy  tx  ty
    fild    word [_8]       ; 8   i   1   sm  sx  sy  tx  ty
    fdivp                   ; i/8 1   sm  sx  sy  tx  ty
    fld     dword [_T]
    faddp                   ; t'  1   sm  sx  sy  tx  ty
    fprem                   ; ft  1   sm  sx  sy  tx  ty
    fstp    st1             ; ft  sm  sx  sy  tx  ty
    fmulp                   ; sm' sx  sy  tx  ty

    ; get iteration count
    fistp   word [si]       ; sx  sy  tx  ty
    mov     cx, word [si]   ; cx := sm
    cmp     cx, 2
    jl      forward_line

line_loop:
    ; update x and y
    fld     dword [_Y]
    fadd    st0, st2        ; y'  sx  sy  tx  ty
    fst     dword [_Y]
    fld     dword [_X]
    fadd    st0, st2        ; x'  y'  sx  sy  tx  ty
    fst     dword [_X]

    ; compute pixel index
    fxch                    ; y   x   sx  sy  tx  ty
    frndint
    fild    word [_Width]   ; w   y   x   sx  sy  tx  ty
    fmulp                   ; w'  x   sx  sy  tx  ty
    faddp                   ; i   sx  sy  tx  ty
    fistp   word [si]       ; sx  sy  tx  ty
    mov     di, word [si]   ; di := i
    add     di, 7d00h

    ; write pixel
    mov     al, [es:di]
    or      al, 16
    stosb

    loop    line_loop

forward_line:
    ; double-pop stack
    fcompp                  ; tx  ty

    ; set x and y to end
    fstp    dword [_X]      ; ty
    fstp    dword [_Y]

skip_line:
    pop     cx  ; 'a
    dec     cx
    test    cx, cx
    jnz     outer_loop

    popa

    ;------------------------------------------------------------
    ; NOT OPTIONAL: check for ESC
    ;------------------------------------------------------------
    in      al, 60h
    dec     al
    jnz     main_loop

    ;------------------------------------------------------------
    ; OPTIONAL: switch back to text mode
    ;------------------------------------------------------------
    mov     al, 03      ; AH must be 00h
    int     10h         ; mode 03h

    ;------------------------------------------------------------
    ; exit
    ;------------------------------------------------------------
   ret

_Data:
  _Speed:
  _Scale:   dw  52
  _Width:   dw  320
  _8:       dw  8
