//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
sizey equ 12
//======================================================== FX_INIT
EFF_INI_
	ei
	halt

	ld	a,#17
	call	PAGER
/*
	;--- clr
	ld	a,0
	out	(#fe),a
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),0
	ldir

	;--- grid
	xor a
	ld	hl,#4000
	ld	de,#4001
	ld	c,6
grid1	;-
	ld	b,4
grid2
	ld	(hl),a
	inc	l
	jp	nz,grid2
	inc	h
	djnz	grid2
	cpl
	dec	c
	jp	nz,grid1
	ld	hl,#4000
	ld	de,#c000
	ld	bc,6912
	ldir
*/
	call	makepal

	ei
	halt
	call	nextfrm
	call	mapping1

	ei
	halt
	call	mapping2

	;--- set im2 routine
	ld  hl,fxim2
	ld  (IM2CALL),hl

	ret

makepal
	;--- make palette
	ld	hl,pal1
	ld	bc,palette
	call	mkpl0
	ld	hl,pal2
	ld	bc,palette+256
mkpl0
	ld	d,h
	ld	e,l
	ld	hx,16
mkpl2
	push	hl
	ld	lx,16
	ld	a,(de)
	and	7
	add a,a:add a,a:add a,a
	ld	ly,a
mkpl1
	ld	a,ly
	or	(hl)
	ld	(bc),a
	inc	c
	inc	hl
	dec	lx
	jp	nz,mkpl1
	pop	hl
	inc	de
	dec	hx
	jp	nz,mkpl2
	ret
//======================================================== FX_MAINLOOP
EFF_RUN_
	ei
	halt

	xor a:out (#fe),a
	
	ld	a,1
firstrun equ $-1
	dec	a
	jp	nz,1f

	ld	(firstrun),a

	call	yclear
	ei
	halt

1
	
	
	
	
	;ld	a,1:out (#fe),a
	call	movebuff
	call	nextfrm
	call	mapping1
	;ld	a,0:out (#fe),a
	
	ei
	halt
	;ld	a,1:out (#fe),a
	call	mapping2
	;ld	a,4:out (#fe),a
	call	yclear
	;ld	a,0:out (#fe),a
	
	ret
//======================================================== FX_PROCEDURES
yclear
	ld	a,(PAGE)
	or	7
	call	PAGER

	ld	hl,yclear_1
	ld	de,yclear_2
	and	#08
	jr	nz,1f
	ex	de,hl
1	push	hl
	push	de
	ret


yclear_1
	ld	(sohrsp4),sp

	ld	sp,#db00
	ld	hl,#0000
	ld	de,#0052
	ld	ix,#527f
	ld	bc,#7f7f
	ld	iy,#5252
	ld	a,24
yclear1
	dup	5
	push	hl
	edup
	
	push	de
	push	ix
	push	bc
	push	bc
	push	iy
	push	hl

	dup	5
	push	hl
	edup
	dec	a
	jp	nz,yclear1

	ld	sp,0
sohrsp4 equ $-2
	ret

yclear_2
	ld	(sohrsp5),sp
	
	ld	sp,#5b00
	ld	hl,#0000
	ld	de,#1200
	ld	ix,#1212
	ld	bc,#3f3f
	ld	iy,#3f12

	ld	a,24
yclear2
	dup	5
	push	hl
	edup
	
	push	de
	push	ix
	push	bc
	push	iy
	push	de
	push	de
	
	dup	5
	push	hl
	edup
	dec	a
	jp	nz,yclear2

	ld	sp,0
sohrsp5 equ $-2
	ret

;-----------------------
fxim2
	ld	a,(PAGE)
	xor	#08
	call	PAGER
	jp  IM2CALL_RET

nextfrm
	ld	a,(dxdy)
	add	a,2
	ld	(dxdy),a


	ld	hl,0
sinadr	equ $-2
	ld	bc,293*2
	add	hl,bc
	ld	a,h
	cp	64
	jr	nc,1f
	add	a,64
	ld	h,a
1

	ld	(sinadr),hl
	ld	l,h
	ld	h,#7f
	ld	a,(hl)

;	ld	a,0
;mapdya	equ $-1
	;inc	a
	;and	63
	;ld	(mapdya),a

	cp	32
	jr	c,1f
	ld	b,a
	ld	a,64
	sub	b
1
	ld	h,0
	ld	l,a
	add	hl,hl
	add	hl,hl
	ld	b,0
	ld	c,a
	add	hl,bc
	ld	bc,mapdy
	add	hl,bc

	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl

	ld	a,(hl)
	inc	hl
	ld	(dxdy+1),a
	
	ld	hl,mapdata_b
	add	hl,bc
	ld	(map_b_adr),hl

	ld	hl,mapdata_f
	add	hl,bc
	ld	(map_f_adr),hl	

	ld	hl,#5800
	add	hl,de
	ld	(attr1adr),hl
	ld	hl,#d800
	add	hl,de
	ld	(attr2adr),hl

	ret

mapping1
	ld	a,(PAGE)
	and	%11111000
	call	PAGER

	ld	(sohrsp2),sp
	
	ld	sp,mapdata_b
map_b_adr equ $-2
	ld	bc,0
dxdy	equ $-2
	ld	lx,sizey
	exx
	ld	hl,buff1
	exx
lp1	ld	e,0	;7
	;---
	dup	64
	;-
	pop	hl	;10
	add	hl,bc	;11
	ld	d,(hl)	;7
	ld	a,(de)	;7
	inc	e	;4
	exx		;4
	ld	(hl),a	;7
	inc	l	;4
	exx		;4 /58
	;-
	edup
	;-
	org $-2
	inc hl:exx
	;---
	dec	lx
	jp	nz,lp1
	;--------
	ld	sp,0
sohrsp2	equ $-2
	ret


mapping2
	ld	a,(PAGE)
	and	%11111000
	call	PAGER

	ld	(sohrsp3),sp

	lua ALLPASS
	  colors1 = {1,7*16,8*16,9*16,9*16,9*16,10*16,10*16,10*16,10*16,10*16,10*16,11*16,11*16,11*16,11*16,11*16,11*16,11*16,11*16,11*16,10*16,10*16,10*16,10*16,10*16,10*16,9*16,9*16,9*16,8*16,7*16}
	  colors2 = {1,7,8,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,10,10,10,10,10,10,9,9,9,8,7}
	  cidx = 1
	endlua

	ld	sp,mapdata_f
map_f_adr equ $-2
	ld	bc,(dxdy)
	ld	lx,sizey
	exx
	ld	hl,buff1
	ld	de,buff2
	exx
lp2	;---
	dup	32
	;---
	pop	hl	;10
	add	hl,bc	;11
	ld	a,(hl)	;7
	rra		;4
	exx		;4
	;-
	lua ALLPASS
	  _pc("ld c," .. tostring(colors1[cidx]))
	  if (sj.get_define("adr1") == nil) then
		sj.insert_define("adr1", sj.current_address - 1)
	  end
	endlua
	;ld	c,...	;7
	jr	nc,$+3	;12/7
	ld	c,(hl)	;7	//19 or 21
	;-
	inc	l	;4
	exx		;4
	;---
	pop	hl	;10
	add	hl,bc	;11
	ld	a,(hl)	;7
	rra		;4
	exx		;4
	;-
	lua ALLPASS
	  _pc("ld a," .. tostring(colors2[cidx]))
	  if (sj.get_define("adr2") == nil) then
		sj.insert_define("adr2", sj.current_address - 1)
	  end
	  cidx = cidx + 1
	endlua
	;ld	a,...	;7
	jr	nc,$+3	;12/7
	ld	a,(hl)	;7	//19 or 21
	;-
	or	c
	ld	(de),a	;7
	inc	e	;4
	inc	l	;4
	exx		;4
	;---
	edup
lp2end	;---
	org	$-3
	inc de:inc hl:exx
	;---
	dec	lx
	jp	nz,lp2
	;-----------
	ld	sp,0
sohrsp3	equ $-2
	ret

;----------------------------------------------
movebuff
	ld	a,(PAGE)
	or	7
	call	PAGER

	ld	h,palette/256
	ld	de,#5800
attr1adr equ $-2
	exx
	ld	h,palette/256 + 1
	ld	de,#d800
attr2adr equ $-2
	ld	a,(PAGE)
	and	#08
	jr	nz,mvbf2
	exx
mvbf2
	call	mvbf0
	exx
mvbf0	ld	(sohr_sp1),sp
	ld	sp,buff2
	ld	a,sizey
mvbf1	;--
	dup	16
	pop	bc	;10
	ld	l,c	;4
	ldi		;16
	ld	l,b	;4
	ldi		;16 /50
	edup
	;--
	dec	a
	jp	nz,mvbf1
	;-----
	ld	sp,0
sohr_sp1 equ $-2
	ret

lp2sz	equ (lp2end - lp2)/32
	;ld	hl,adr1
	;ld	bc,lp2sz

//======================================================== FX_INCLUDE_DATA
mapdata_b include "bin/map-back.asm"
mapdata_f include "bin/map-front.asm"
mapdy include "bin/map-dy-move.asm"

pal1	db	#00,#00			;0,1
	db	#02,#00,#02,#02,#07	;2-6
	db	#06,#02,#06,#07,#47	;7-11
	db	0,0,0,0

pal2	db	#40,#40 
	db	#40,#42,#42,#47,#47
	db	#42,#46,#46,#46,#47
	db	0,0,0,0

	align 256
t_back	equ $/256

	dup	11
	db	#10,#01
	edup
	db	#20,#02,#30,#03,#40,#04,#50,#05,#60,#06
	db	#60,#06
	db	#60,#06,#50,#05,#40,#04,#30,#03,#20,#02
	dup	10
	db	#10,#01
	edup

	align 256
tttfront equ $
t_front equ $/256
	db	#10,#01
	db	#70,#07,#40,#04
	db	#30,#03,#30,#03,#30,#03
	db	#20,#02,#20,#02,#20,#02,#20,#02,#20,#02
	db	#10,#01,#10,#01,#20,#02,#30,#03,#40,#04
	db	#50,#05
	db	#40,#04,#30,#03,#20,#02,#10,#01,#10,#01
	db	#20,#02,#20,#02,#20,#02,#20,#02,#20,#02
	db	#30,#03,#30,#03,#30,#03
	db	#70,#07,#40,#04

palette	equ	tttfront + 256
buff1	equ	palette + 512
buff2	equ	buff1 + 1536


	display "palette ", /A, palette
	display "buff1 ", /A, buff1
	display "buff2 ", /A, buff2
	
	display "t_back ", /A, t_back
	display "t_front ", /A, t_front

	display "firstrun", /A, firstrun