//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
//======================================================== FX_INIT
EFF_INI_
	EI
	HALT
	ld	a,#17
	call	PAGER
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),l
	ldir

	ld	hl,#4000
	ld	de,#4001
	ld	bc,6143
	ld	(hl),l
	ldir
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),#42
	ldir
	ld	hl,#C000
	ld	de,#C001
	ld	bc,6144
	ld	(hl),l
	ldir
	ld	(hl),#07
	ld	bc,767
	ldir

	;--- ini buff
	ld	hl,buff
	ld	de,buff + 1
	ld	(hl),l
	ld	bc,192*34
	ldir

	ret

//======================================================== FX_MAINLOOP
EFF_RUN_
	ei
	halt
	ld	a,#10 + #08
	call	PAGER

	call	anima
	call	nextfrm
	call	draw_text

	ei
	halt
	ld	a,#17
	call	PAGER

	;ld a,1:out (#fe),a
	call	movetext
	;ld a,1:out (#fe),a
	
	jp	EFF_RUN_
//======================================================== FX_PROCEDURES
movetext
	ld	(sohrsp1),sp
	;-------------------
	ld	sp,scrtbl+192
scrtbl_adr equ $-2
	ld	hl,buff
	ld	bc,34-1
	ld	a,96
iniscr1
	pop	de
	ld	(hl),e
	inc	hl
	ld	(hl),d
	add	hl,bc
	dec	a
	jp	nz,iniscr1
	
	;ld	a,3:out (#fe),a
	;-------------------
	ld	sp,buff
	ld	b,32*3
lpp1	pop	hl
	;----
	dup	16
	pop	de
	ld	(hl),e
	inc	l
	ld	(hl),d
	inc	l
	edup
	org	$-1
	;----
	djnz	lpp1
	;----
	ld	sp,0
sohrsp1 equ $-2
	ret

;-------------------------------- draw text
draw_text
	;ld a,0:out (#fe),a
	ld	de,buff0
buff_adr equ $-2
	ld	bc,text
text_adr equ $-2
	ld	lx,16
tlp1
	ld	a,(bc)
	inc	bc
	exx
	ld	h,fonttbl / 256
	ld	l,a
	ld	e,(hl)
	inc	l
	ld	d,(hl)
	ld	hl,0
bitlp	equ	$-2
	add	hl,de
	push	hl
	exx
	pop	hl
	ld	a,(hl)
	ld	(de),a
	inc	l
	inc	e
	ld	a,(hl)
	ld	(de),a
	inc	de
	dec	lx
	jp	nz,tlp1
	ret

;---------------------------- nextfrm	
nextfrm
	ld	a,0
frmw2 equ $-1
	inc	a
	and	1
	ld	(frmw2),a
	ret	nz

ynum equ 96
buff0 equ buff + 2
	ld	de,(scrtbl_adr)
	dec	de
	dec	de
	ld	hl,(buff_adr)
	ld	bc,34
	add	hl,bc
	ld	a,ynum
scrtbla	equ $-1
	dec	a
	jp	nz,1f
	;--
	ld	de,scrtbl+192
	ld	a,ynum
	ld	hl,buff0
1	;--
	ld	(scrtbla),a
	ld	(buff_adr),hl
	ex	de,hl
	ld	(scrtbl_adr),hl
	;----
	ld	a,(bitlp)
	add	a,2
	and	15
	ld	(bitlp),a
	ret	nz
	
	ld	hl,(text_adr)
	ld	bc,16
	add	hl,bc
	ld	a,text_lines
tla equ $-1
	dec	a
	jp	nz,1f
	ld	a,text_lines
	ld	hl,text
1
	ld	(text_adr),hl
	ld	(tla),a

	ret
;--------------------------
anima
	ld	(sohrsp2),sp

	;ld a,1:out (#fe),a
	ld	hl,fadetbl
fd_hl equ $-2
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	inc	hl
	ld	a,(hl)
	ld	ly,a
	inc	hl
	ld	a,(hl)
	ld	hy,a

	ld	a,0
frma equ $-1
	add	a,a
	ld	e,a
	ld	d,0
	ld	hl,frametbl
	add	hl,de
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	ld	sp,hl

	ld	de,#410a
	ld	lx,8*3
alp1
	dup	6

	pop	hl
	;--
	ld	a,(hl)
	and	c
	ld	(de),a
	inc	l
	inc d:inc d
	;-
	ld	a,(hl)
	and	b
	ld	(de),a
	inc	l
	inc d:inc d
	;-
	ld	a,(hl)
	and	ly
	ld	(de),a
	inc	l
	inc d:inc d
	;-
	ld	a,(hl)
	and	hy
	ld	(de),a
	inc	e
	;--------
	pop	hl
	;--
	ld	a,(hl)
	and	c
	ld	(de),a
	dec	l
	dec d:dec d
	;-
	ld	a,(hl)
	and	b
	ld	(de),a
	dec	l
	dec d:dec d
	;-
	ld	a,(hl)
	and	ly
	ld	(de),a
	dec	l
	dec d:dec d
	;-
	ld	a,(hl)
	and	hy
	ld	(de),a
	inc	e
	edup

	ld	a,e
	add	a,32-12
	ld	e,a
	jr	nc,1f
	ld	a,8
	add	a,d
	ld	d,a
1

	dec	lx
	jp	nz,alp1

	;ld a,0:out (#fe),a

	ld	sp,0
sohrsp2 equ $-2

	;--- anima frame wait
	ld	a,0
frmw1 equ $-1
	inc	a
	and	1
	ld	(frmw1),a
	ret	nz
	;--- anima frame
	ld	a,(frma)
	inc	a
	cp	20
	jr	nz,1f
	xor	a
1	ld	(frma),a

	ld	a,0
frmw3 equ $-1
	inc	a
	and	1
	ld	(frmw3),a
	ret	nz

	ld	a,16
fd_a equ $-1
	or	a
	ret	z
	dec	a
	ld	(fd_a),a
	ld	hl,(fd_hl)
	inc	hl
	inc	hl
	inc	hl
	inc	hl
	ld	(fd_hl),hl

	ret

//======================================================== FX_INCLUDE_DATA
//======================================================== FX_TABLES
fadetbl

	db	%00000000
	db	%00000000
	db	%00000000
	db	%00000000

	db	%10000000
	db	%00000000
	db	%00000000
	db	%00000000

	db	%10001000
	db	%00000000
	db	%00000000
	db	%00000000

	db	%10001000
	db	%00000000
	db	%00100010
	db	%00000000

	db	%10101010
	db	%00000000
	db	%00100010
	db	%00000000

	db	%10101010
	db	%00000000
	db	%10101010
	db	%00000000

	db	%10101010
	db	%01000100
	db	%10101010
	db	%00000000

	db	%10101010
	db	%01000100
	db	%10101010
	db	%00010001

	db	%10101010
	db	%01010101
	db	%10101010
	db	%00010001

	db	%10101010
	db	%01010101
	db	%10101010
	db	%01010101

	db	%11101110
	db	%01010101
	db	%10101010
	db	%01010101

	db	%11101110
	db	%01010101
	db	%10111011
	db	%01010101

	db	%11111111
	db	%01010101
	db	%10111011
	db	%01010101

	db	%11111111
	db	%01010101
	db	%11111111
	db	%01010101

	db	%11111111
	db	%11011101
	db	%11111111
	db	%01010101

	db	%11111111
	db	%11011101
	db	%11111111
	db	%01110111

	db	%11111111
	db	%11111111
	db	%11111111
	db	%11111111

;-------------------
font	incbin "bin/font.bin"
font_qty equ ($-font) / 16
;-------------------
	align	16
text	
	incbin "bin/text.bin"
text_lines equ ($ - text) / 16

	align	256
wavpgtbl
	db	#11,#02
	db	#13,#04
	db	#10,#00
fonttbl	;--- begin 3 (6)
;-------------------	
fontn=0
	dup	font_qty
	dw	font + fontn
fontn=fontn+16
	edup
;-------------------
scrtbl	dw	#56e0

	;---
	dup	2
	;---
scrt=0
	dup	3
scrn=0
	dup	8
	dw	#C000 + scrn + scrt
	dw	#c200 + scrn + scrt
	dw	#C400 + scrn + scrt
	dw	#C600 + scrn + scrt
scrn=scrn+#20
	edup
scrt=scrt+#0800
	edup
	;---
	edup
	display "scrtbl sz ", /A, $-scrtbl
;-------------------
	align	256
buff	

	display "EFF_USE_END ", /A, buff + 192*34
	
	display "scrtbl ", /A, scrtbl
	display "scrtbl ", /A, scrtbl+192

	
