//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
//======================================================== FX_INIT
EFF_INI_
	ei
	halt
	ld	a,#17
	call	PAGER

	;--- clr
	ld	a,0
	out	(#fe),a
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),0
	ldir
	
	call	movpoints

	;--- grid
	xor a
	ld	hl,#4000
	ld	de,#4001
	ld	c,6
grid1	;-
	ld	b,4
grid2
	ld	(hl),a
	inc	l
	jp	nz,grid2
	inc	h
	djnz	grid2
	cpl
	dec	c
	jp	nz,grid1
	ld	hl,#4000
	ld	de,#c000
	ld	bc,6912
	ldir
	
	call	sprfade
    
    ;--- make palette
    ld  hl,PAL1
    ld  bc,palette0
    call mkpl0
    ld  hl,PAL2
    ld  bc,palette1
mkpl0
    ld  d,h
    ld  e,l
    ld  hx,16
mkpl2
    push    hl
    ld  lx,16
    ld  a,(de)
    and	7
    add a,a:add a,a:add a,a
    ld  ly,a
mkpl1
    ld  a,ly
    or (hl)

    ld  (bc),a
    inc c
    inc hl
    dec lx
    jp  nz,mkpl1
    pop hl
    inc de
    dec hx
    jp  nz,mkpl2 

  
	ret
//======================================================== FX_MAINLOOP
EFF_RUN_

	ei
	halt

	if SHOW_FRAMES = 1
	  ld	a,(FRAMES_QTY)
	  ;out	(#fe),a
	  xor	a
	  ld	(FRAMES_QTY),a
	endif
	
	ld	a,0
faze	equ $-1
	or	a
	jp	z,text
	dec	a
	jp	z,scrini
	dec	a
	jp	z,scrout

	jp	metaballs

fx_ret
	if SHOW_FRAMES = 1
	  xor	a
	  ;out	(#fe),a
	endif
	ret

metaballs_ini
	ld	a,#17
	call	PAGER
	ld	a,7
	out	(#fe),a
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),7*8+7
	ldir

	ld	hl,#5800
	ld	de,#d800
	ld	bc,768
	ldir

	ld	hl,#c000
	ld	de,#4000
	ld	bc,6144
	ldir

	ld	hl,buff
	ld	de,buff+1
	ld	bc,767
	ld	(hl),16*11+11
	ldir

	ld	hl,faze
	inc	(hl)

	ei:halt
	
	;--- set im2 routine
	ld	hl,fxim2
	ld	(IM2CALL),hl

	ei:halt
	ret

metaballs
	ld	a,7
border	equ $-1
	out	(#fe),a
	xor	a
	ld	(border),a
	
	call	calc_buff
	call	tits
	call	movatr
	call	movpoints
	ret

movpoints
    ;--- move points
    ld  ix,points
    ld  b,3
pointlp
    push    bc
    ;---
    ld  a,(ix)
    add a,(ix+1)
    ld  (ix),a
    ld  h,cosx / 256
    ld  l,a
    ;---
    ld  a,(ix+2)
    add a,(ix+3)
    ld  (ix+2),a
    ld  d,cosy / 256
    ld  e,a
    ;---
    ld  c,(ix+4)
    ld  b,(ix+5)
    ;---
    ld  a,(de)
    sub 5
    ld  (ix+6),a
    add a,(hl)
    ld  (bc),a
    inc bc
    ;-
    ld  a,(hl)
    ld  (ix+7),a
    add a,#c0
    ld  (bc),a
    ;-
    ld  bc,8
    add ix,bc
    ;---
    pop bc
    djnz    pointlp

    ret
    
;ballList[1] = {ax: 0, ay:0, axStep: 4, ayStep: 3};
;ballList[2] = {ax: 64, ay:64, axStep: 3, ayStep: 5};
;ballList[3] = {ax: 128, ay:128, axStep: 4, ayStep: 3};

points
    db  0,  4
    db  0,  3
    dw  point1
    db  0,0 ;y,x

    db  64,  3
    db  64,  5
    dw  point2
    db  0,0 ;y,x

    db  128,  4
    db  128,  3
    dw  point3
    db  0,0 ;y,x
    
    
//======================================================== FX_PROCEDURES
fxim2
    ld  a,(PAGE)
    xor #08
    call PAGER
    jp  IM2CALL_RET
    



movatr
    ld  a,(PAGE)
    or  7
    call PAGER
    and #08
    ld  hl,#5800
    ld  de,#d800
    ld  bc,palette0 + (palette1 / 256)
    jr  nz,swp1mv
    ex  de,hl
    ld  bc,palette1 + (palette0 / 256)
swp1mv
    ld  (atradr1),hl
    ld  (atradr2),de
    ld  a,b
    ld (atrpal1),a
    ld  a,c
    ld (atrpal2),a
    ld	h,palette0 / 256
atrpal1 equ $-1
    ld  de,#5800
atradr1 equ $-2
    call    movatr0
    ld  h,palette1 / 256
atrpal2 equ $-1
    ld  de,#d800
atradr2 equ $-2
movatr0
    ld  (sohrsp),sp
    ld  sp,buff    ;buff
    ld  a,24
movatr1
    dup 16

    pop bc      ;10
    ld  l,c     ;4
    ldi         ;16
    ld  l,b     ;4
    ldi         ;16 /50

    edup

    dec a
    jp  nz,movatr1
    ;---
    ld  sp,0
sohrsp equ $-2
    ret

;----------------------
calc_buff
    ld  a,(PAGE)
    and %11111000
    call    PAGER

    ld  bc,#c000    ;point1
point1_dx equ $-1
point1_dy equ $-2
point1 equ $-2
    ld  hl,#d030    ;point2
point2_dx equ $-1
point2_dy equ $-2
point2 equ $-2
    ld  de,buff
    push    bc
    push    hl
    exx
    ld  hl,#e010    ;point3
point3_dx equ $-1
point3_dy equ $-2
point3 equ $-2
    ld  d,clrtop / 256       ;sum_top
    ld  b,clrbott / 256      ;sum_bott
    push    hl
    exx
    ld  lx,24
lpp1
    ;-----------------
    dup 31
    ;---
    ld  a,(bc)      ;7
    add a,(hl)      ;7
    inc c           ;4
    inc l           ;4
    exx             ;4
    add a,(hl)      ;7
    inc l           ;4
    ld  e,a     ;4
    exx         ;4
    ;---
    ld  a,(bc)      ;7
    add a,(hl)      ;7
    inc b           ;4
    inc h           ;4
    exx             ;4
    add a,(hl)      ;7
    inc h           ;4
    ld  c,a     ;4
    ex  de,hl   ;4
    ld  a,(bc)  ;7
    or  (hl)    ;7
    ex  de,hl   ;4
    exx         ;4
    ;---
    ld  (de),a  ;7
    inc e       ;4
    ;---
    edup
    ;-------------
    ld  a,(bc)      ;7
    add a,(hl)      ;7
    inc c           ;4
    inc l           ;4
    exx             ;4
    add a,(hl)      ;7
    inc l           ;4
    ld  e,a     ;4
    exx         ;4
    ;---
    ld  a,(bc)      ;7
    add a,(hl)      ;7
    exx             ;4
    add a,(hl)      ;7
    ld  c,a     ;4
    ex  de,hl   ;4
    ld  a,(bc)  ;7
    or  (hl)    ;7
    ex  de,hl   ;4
    pop hl: inc l:inc l
    exx         ;4
    ;---
    pop hl: inc l:inc l
    pop bc: inc c:inc c
    push bc
    push hl
    exx
    push hl
    exx
    ;---
    ld  (de),a  ;7
    inc de       ;6
    ;-------------
    dec lx
    jp  nz,lpp1
    ;---
    pop bc:pop bc:pop bc
    ret


tits
    ld  hl,(points+6+8)
    ld  a,48-9
    sub l
    ld  l,a
    ld  a,32
    sub h
    ld  h,a        
    call tits1

    ld  hl,(points+6)
    call tits1

    ld  hl,(points+6+16)
tits1
    ld  de,titoutt
    bit 0,l
    jr  nz,tits2
    ld  de,titoutb
tits2
    ld  a,h
    cp  3
    jr  nc,tits3
    inc de:inc de
    cp  2
    jr  nc,tits3
    inc de:inc de
    cp  1
    jr  nc,tits3
    inc de:inc de
tits3

    cp  #1f
    jr  c,tits4
    dec de:dec de
    cp  #20
    jr  c,tits4
    dec de:dec de
    cp  #21
    jr  c,tits4
    dec de:dec de

tits4
    ;---
    ld  c,h
    ld  a,l
    and %11111110
    add a,8
    
    ld  l,a
    ld  h,0
    add hl,hl
    add hl,hl
    add hl,hl
    add hl,hl
    ld  b,buff/256
    add hl,bc
    ex de,hl
    ld  a,(hl)
    inc hl
    ld  h,(hl)
    ld  l,a
    jp  (hl)
    ret




;----------------
    dw  0
    dw  0
    dw  0
    dw  titouttr2
    dw  titouttr1
titoutt
    dw  titoutt_all
    dw  titoutt2
    dw  titoutt1
    dw  titoutt0
    dw  0
    dw  0
    dw  0
;----------------
    dw  0
    dw  0
    dw  0
    dw  titoutbr2
    dw  titoutbr1
titoutb
    dw  titoutb_all
    dw  titoutb2
    dw  titoutb1
    dw  titoutb0
    dw  0
    dw  0
    dw  0
;----------------
titout_none
    ret
    
    
titoutt_all
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    dec l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#23
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc

    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret
    
titoutt2
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),#23
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret
    
titoutt1
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    ld  (hl),#23
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret

titoutt0
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret

    
titouttr1
    ex de,hl
    ld  de,#3313
    
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    dec l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#23
    inc l
    ld  (hl),d

    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc

    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    
    ret

titouttr2
    ex de,hl
    ld  de,#3313
    
    dec hl
    ld  (hl),d
    dec l
    ld  (hl),d
    ld  bc,0-32
    add hl,bc

    dec l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#23
    add hl,bc

    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a

    ret


;----------------
titoutb_all
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d

    add hl,bc
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#32
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    
    add hl,bc
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    
    ret

titoutb2
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    add hl,bc
    
    ld  (hl),d
    inc l
    ld  (hl),#32
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    
    add hl,bc
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    
    ret

titoutb1
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),#22
    add hl,bc
    
    ld  (hl),#32
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    dec hl
    ld  (hl),d
    dec l
    ld  (hl),d
    
    ret
    
titoutb0
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    ld  (hl),d
    inc l
    ld  a,(hl): and d:or e: ld (hl),a
    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),d
    add hl,bc
    
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    dec hl
    ld  (hl),d
    
    ret



titoutbr1
    ex de,hl
    ld  de,#3331
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    dec hl
    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d

    add hl,bc

    ld  (hl),d
    dec l
    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d

    add hl,bc
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#32
    inc l
    ld  (hl),d
    
    add hl,bc
    ld  (hl),d
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d
    
    ret

titoutbr2
    ex de,hl
    ld  de,#3331
    dec hl
    ld  a,(hl): and d:or e: ld (hl),a
    dec l
    ld  a,(hl): and d:or e: ld (hl),a
    ld  bc,0-32
    add hl,bc

    dec hl
    ld  a,(hl): and d:or e: ld (hl),a
    inc l
    ld  (hl),d
    inc l
    ld  (hl),d
    add hl,bc

    ld  (hl),#22
    dec l
    ld  (hl),d
    dec l
    ld  (hl),d

    add hl,bc
    ld  (hl),d
    inc l
    ld  (hl),d
    inc l
    ld  (hl),#32
    
    add hl,bc
    ld  (hl),d
    dec l
    ld  (hl),d

    
    ret


text
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),l
	ldir

	ld	hl,tbl
tbladr equ $-2
	ld	a,(hl)
	inc	hl
	or	a
	jp	z,lp2
	ld	b,a
lp1
	ld	c,(hl)
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	a,(hl)
	ld	lx,a
	inc	hl
	ld	a,(hl)
	ld	hx,a
	inc	hl
	call	sprout
	djnz	lp1
	
	call	sprfade

lp2	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	inc	hl
	ex	de,hl

	ld	hl,(MUSPOS)
	and	a
	sbc	hl,bc
	jp	c,fx_ret

	ld	a,fadenumber
	ld	(sprout_fade),a
	ld	(tbladr),de
	ld	a,(de)
	or	a
	jp	nz,fx_ret
	ld	hl,faze
	inc	(hl)

	jp	fx_ret

sprfade
	push	hl
	ld	a,fadenumber
sprout_fade equ $-1
	sub	1
	adc	a,0
	ld	(sprout_fade),a
	ld	de,#0000
	cp	2*12
	jp	nc,sprfade0
	rra
	and	%00001111
	add	a,a
	ld	e,a
	ld	d,0
	ld	hl,sprfade_de
	add	hl,de
	ld	e,(hl)
	inc	hl
	ld	d,(hl)

sprfade0
	ld	hl,sprfade_tbl+#40
	ld	(hl),0
	ld	hl,sprfade_tbl
	ld	(hl),0

	ld	a,#40+7
	call	sprfade1
	ld	a,#00+7
	call	sprfade1
	ld	a,#40+7*8
	call	sprfade1
	ld	a,#00+7*8
	call	sprfade1
	ld	a,#40+7*8+7
	call	sprfade1
	ld	a,#00+7*8+7
	call	sprfade1

	ld	a,#40+3
	call	sprfade1
	ld	a,#00+3
	call	sprfade1
	ld	a,#40+3*8
	call	sprfade1
	ld	a,#00+3*8
	call	sprfade1

	ld	a,#40+7*8+3
	call	sprfade1
	ld	a,#40+3*8+7
	call	sprfade1
	ld	a,#00+7*8+3
	call	sprfade1
	ld	a,#00+3*8+7
	call	sprfade1

	pop	hl
	ret
sprfade1
	ld	l,a
	and	#40
	ld	c,a
	;---
	ld	a,l
	and	7
	jr	z,2f
	cp	7
	jr	z,1f
	sub	e
	jr	2f
1	sub	d
2	ld	b,a
	;---
	ld	a,l
	rra
	rra
	rra
	and	7
	jr	z,2f
	cp	7
	jr	z,1f
	sub	e
	jr	2f
1	sub	d
2	add	a,a
	add	a,a
	add	a,a
	or	b
	or	c
	ld	(hl),a
	ret

sprout	push	bc
	push	hl

	push	ix
	pop	hl
	ex	de,hl

	ld	a,c
	ld	(spox),a

	ld	lx,3
spo2	;---
	ld	b,sprfade_tbl/256
	ld	hx,0
spox equ $-1
	push	hl
spo1	;---
	ld	a,(de)
	ld	c,a
	ld	a,(bc)
	ld	(hl),a
	inc	l
	inc	de
	dec	hx
	jp	nz,spo1
	pop	hl
	ld	bc,32
	add	hl,bc
	dec	lx
	jp	nz,spo2

	pop	hl
	pop	bc
	ret
	
scrini
	ld	hl,#5800
	ld	de,#5801
	ld	bc,767
	ld	(hl),l
	ldir
	
	ld	hl,scrdata
	ld	de,#4000
	ld	bc,6144
	ldir

	ld	hl,faze
	inc	(hl)
	
	jp	fx_ret

scrout
	ld	a,224
scrouta equ $-1
	sub	1
	adc	a,0
	ld	(scrouta),a
	jp	z,metaballs_ini

	ld	hl,tblscr1
	cp	112+32+7*5
	jr	nc,scrout0
	cp	112-32+7*9
	jr	c,scrout1
	
	and	4
	jr	z,scrout0

scrout1
	ld	hl,tblscr2
scrout0
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	inc	hl

	ld	a,0
swpa	equ	$-1
	xor	#ff
	ld	(swpa),a
	jr	z,swp1
	push	bc
	pop	de

swp1	push	hl
	ex	de,hl
	ld	de,#5800
	ld	bc,768
	ldir
	
	pop	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ex	de,hl
	ld	b,9
scrdiff
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	dup	8
	ld	a,(hl)
	ld	(de),a
	inc	hl
	inc	d
	edup
	djnz	scrdiff

	jp	fx_ret

tblscr1
	dw	attr_restrict_0
	dw	attr_restrict_1
	dw	diff_restrict
tblscr2
	dw	attr_allow_0
	dw	attr_allow_1
	dw	diff_allow

//======================================================== FX_INCLUDE_DATA
;PAL1	DB	0,7,2,2,0,1,1,5,3,3,0,0,0,0,0,0
;PAL2	DB	0,2,0,2,0,0,3,3,3,0,0,0,0,0,0,0

PAL1	DB	#00,#07,#02,#02,#04,#05,#04,#05,#06,#07,#02,#07,#00,#00,#00,#00
PAL2	DB	#00,#42,#00,#42,#41,#45,#45,#46,#47,#47,#00,#07,#00,#00,#00,#00

;PAL1	DB	0,7,2,2,1,1,4,1,6,7,2,0,0,0,0,0
;PAL2	DB	0,2,0,2,0,1,1,5,5,7,0,0,0,0,0,0


sprfade_de
	dw	#0703
	dw	#0703
	dw	#0703
	dw	#0703
	dw	#0703
	dw	#0603
	dw	#0502
	dw	#0402
	dw	#0301
	dw	#0200
	dw	#0100
	dw	#0000


//======================================================== FX_TABLES
    align   256
cosx include "bin/cosx.asm"
cosy include "bin/cosy.asm"
clrtop include "bin/clr-bott.asm"
clrbott include "bin/clr-top.asm"
palette0 ds  256,0
palette1 ds  256,0
sprfade_tbl ds 256,0
buff

fadenumber equ 64+16

tbl	
	db	0
	dw	112*0 + 28 + 224

	db	1
	db	32
	dw	#5920
	dw	attr_demarche
	dw	112*1 + 28 + 224

	db	2
	db	23
	dw	#58e0 + 4
	dw	attr_invites
	db	11
	dw	#5980 + 10
	dw	attr_you
	dw	112*2 + 28 + 224

	db	2
	db	31
	dw	#58e0 + 0
	dw	attr_to_a_real

	db	19
	dw	#5980 + 6
	dw	attr_mans
	dw	112*3 + 28 + 224

	db	1
	db	29
	dw	#5920 + 2
	dw	attr_paradise
	dw	112*4 + 28 + 224

	db	0
	dw	#ffff


attr_demarche	incbin "bin/attr-demarche.bin"
attr_invites	incbin "bin/attr-invites.bin"
attr_you	incbin "bin/attr-you.bin"
;attr_tothe	incbin "bin/attr-tothe.bin"
;attr_paradize	incbin "bin/attr-paradize.bin"
;attr_for	incbin "bin/attr-for.bin"
;attr_realman	incbin "bin/attr-realman.bin"

attr_to_a_real	incbin	"bin/attr_to_a_real.bin"
attr_mans	incbin	"bin/attr_mans.bin"
attr_paradise	incbin	"bin/attr_paradise.bin"


scrdata	incbin "bin/ooc-restrict_pix_0.bin"

attr_restrict_0	incbin "bin/ooc-restrict_attr_0.bin"
attr_restrict_1	incbin "bin/ooc-restrict_attr_1.bin"
diff_restrict	include "bin/diff_restrict.asm"

attr_allow_0	incbin "bin/ooc-allow_attr_0.bin"
attr_allow_1	incbin "bin/ooc-allow_attr_1.bin"
diff_allow	include "bin/diff_allow.asm"
