<?
$imgPal = imagecreatefrompng(__DIR__ . '/bar-palette-fade.png');
$pal = array();
for ($y = 0; $y < 16; $y++) {
    for ($x = 0; $x < 16; $x++) {
        $clr = imagecolorat($imgPal, $x, $y);
        if (!isset($pal[$clr])) {
            $pal[$clr] = array(
                floor($y/2) + ($y%2 == 0 ? 0 : 0x40),
                floor($x/2) + ($x%2 == 0 ? 0 : 0x40)
            );
        }
    }
}

$asm = '';
for ($y = 0; $y < 6; $y++) {
    $pal1 = array();
    $pal2 = array();
    for ($x = 0; $x < 16; $x++) {
        $clr = imagecolorat($imgPal, $x+16, $y);
        if (!isset($pal[$clr])) {
            echo 'ERROR: ' . $clr; die();
        } else {
            $pal1[] = asHex($pal[$clr][0]);
            $pal2[] = asHex($pal[$clr][1]);
        }
    }
    $asm .= "pal1_" . $y . "\tdb\t" . implode(", ", $pal1) . "\r\n";
    $asm .= "pal2_" . $y . "\tdb\t" . implode(", ", $pal2) . "\r\n";
}
file_put_contents(__DIR__ . "/bar-palette.asm", $asm);

$imgPal = imagecreatefrompng(__DIR__ . '/bump-palette-fade.png');
$asm = '';
for ($y = 0; $y < 6; $y++) {
    $pal1 = array();
    $pal2 = array();
    for ($x = 0; $x < 16; $x++) {
        $clr = imagecolorat($imgPal, $x+16, $y);
        if (!isset($pal[$clr])) {
            echo 'ERROR: ' . $clr; die();
        } else {
            $pal1[] = asHex($pal[$clr][0]);
            $pal2[] = asHex($pal[$clr][1]);
        }
    }
    $asm .= "pal1_" . $y . "\tdb\t" . implode(", ", $pal1) . "\r\n";
    $asm .= "pal2_" . $y . "\tdb\t" . implode(", ", $pal2) . "\r\n";
}
file_put_contents(__DIR__ . "/bump-palette.asm", $asm);



function asHex($num) {
    $result = dechex($num);
    if (strlen($result) < 2) {
        $result = '0' . $result;
    }
    return '#' . $result;
}



$img = imagecreatefrompng(__DIR__ . '/bar96x48.png');
$clrList = array(
    0x000000 => 1,

    0x000073 => 2,
    0x00009D => 3,
    0x0073E6 => 4,
    0x009DE6 => 5,

    0x9D0000 => 6,
    0xE60000 => 7,
    0xE67300 => 8,
    0xE6E600 => 9,
    0xE69D9D => 10,
    0xE6E6E6 => 11,
    
    0x007300 => 12,
    0x009D00 => 13,
    0xE600E6 => 14,

);

$zxpage = array();
for ($y = 0; $y < 48; $y++) {
    $zxpage[$y] = array();
    for ($x = 0; $x < 256; $x++) {
        $zxpage[$y][$x] = 0;
    }
}

for ($y = 0; $y < 48; $y++) {
    for ($x = 0; $x < 92; $x++) {
        $clr = imagecolorat($img, $x, $y);
        $zxpage[$y][floor($x/2)] += $x%2 == 0
            ? $clrList[$clr]
            : 16 * $clrList[$clr];
        $clr = imagecolorat($img, $x+1 < 92 ? $x+1 : 0, $y);
        $zxpage[$y][floor($x/2) + 128] += $x%2 == 0
            ? $clrList[$clr]
            : 16 * $clrList[$clr];
    }
}

$f = fopen('bar_texture.bin','wb');
for ($y = 0; $y < 48; $y++) {
    for ($x = 0; $x < 256; $x++) {
        if ($x < 46 && ($zxpage[$y][$x] == 0 || $zxpage[$y][$x+128] == 0)) {
            echo 'error: zero' . "\r\n";
        }
        if ($x < 46 && ($zxpage[$y][$x] == 255 || $zxpage[$y][$x+128] == 255)) {
            echo 'error: 255' . "\r\n";
        }        
        fputs($f, chr($zxpage[$y][$x]), 1);
    }
}
fclose($f);



echo 'CONVERTED' . "\r\n";