-- title:  claws of the tenticle
-- author: mantratronic / RiFT
-- desc:   demo for battlegrounds 2021
-- script: lua

--[[ 

    Abandon all hope or read no futher.
    (this is not pretty code.)

--]]

debug = 0
playmusic = 1

texts={
	{"BOSSMAN"},
	{"CRANKSY"},
	{"DECCA"},
	{"MANTRATRONIC"},
	{" "}

}

greets={
	{"5711",1},
    {"ALCATRAZ",-1},
    {"AVENA",-2},
	{"AICE",-1},
	{"BAUKNECHT",-1},
	{"BITBENDAZ",-2},
	{"BITSHIFTERS ",0},
    {"BROWN ART",-3},
    {"DEFEKT",0},
    {"HOOY-PROGRAM",0},
    {"INSANE",-1},
	{"JUMALAUTA",-4},
    {"LAZARUS",-5},
    {"LEGO",-2},
    {"LOGICOMA",0},
    {"LOONIES",-3},
	{"MARQUEE DESIGN",-2},
    {"MISTIGRIS",2},
    {"PLANET JAZZ",-2},
    {"PROGEN",0},
    {"PROXIMA",-3},
	{"PT ALLSTARS",-3},
	{"RBBS",-3},
    {"REBELS",-1},
    {"RESERVOIR GODS",0},
    {"QUADTRIP",-2},
	{"SLIPSTREAM",-2},
    {"TORMENT",-4},
    {"UP ROUGH",0},
	{"YOU",-3},
	{" "}

}

t=0

--- high colour effect test
hce_palettes={}
function hce_init()
	for i=0,20 do
		hce_palettes[i] = mixPalette2(palettes[3],aqua,i/20)
	end
end
function hce_update(ft)
	currentLP={}
	hce_palettes={}
	for i=0,80 do
		hce_palettes[i] = mixPalette2(palettes[23],palettes[15],i/80)
	end
	for i=0,135 do
		table.insert(currentLP,hce_palettes[(1+ft)//2%#hce_palettes])
	end
end
function hce_draw(ft)
	spr(0,0,0,-1,1,0,0,16,16)
	spr(256,128,1,-1,1,0,0,16,16)
	activeScan=1
end

-- group logo
function hc_group_update(ft,len)
	currentLP={}
	hce_palettes={}

	for i=0,80 do
		hce_palettes[i] = mixPalette2(palettes[4],palettes[25],i/80)
	end
    local top=ft/len * #hce_palettes
    local ftt=(ft/80)^2
	for i=0,135 do
        local lp = (1+math.sin(i/135*bassfreq+ftt))/2* top
		table.insert(currentLP,hce_palettes[(lp//1)%#hce_palettes])
	end
end

function hc_group_draw(ft,background)
	spr(0,0,0,background,1,0,0,16,16)
	spr(256,128,1,background,1,0,0,16,16)
	activeScan=1
end

--- cloud explosion
ce_data={}
ce_rend={}
ce_size=99
function ce_init()
	for i=0,ce_size do
		ce_data[i]={x=4-8*math.random(), y=4-8*math.random(), z=20*math.random()}
	end
	for i=0,ce_size do
		ce_rend[i] = ce_data[i]
	end
end

function ce_update(ft)
	ce_rend={}
	for i=0,ce_size do
		x=ce_data[i].x
		y=ce_data[i].y
		z=(ce_data[i].z+ft)%20

		-- rotate
		t2=(1-z/9)
		X=x*math.cos(t2)-y*math.sin(t2)
		Y=y*math.cos(t2)+x*math.sin(t2)
		Z=z

		ce_rend[i] = {x=X,y=Y,z=Z}
	end

	-- zsort?
	for i=1,#ce_rend do
	 	local j = i
	 	while j > 1 and zsort(ce_rend[j-1],ce_rend[j]) do
			ce_rend[j-1],ce_rend[j] = ce_rend[j],ce_rend[j-1]
	  		j = j-1
	 	end
	end
end

function ce_update2(ft)
	ce_rend={}
	for i=0,ce_size do
		x=ce_data[i].x
		y=ce_data[i].y
		z=(ce_data[i].z+ft)%20

		-- rotate
		t2=(1-z/9)
		X=x*math.cos(t2)-z*math.sin(t2)
		Y=y
		Z=z*math.cos(t2)+x*math.sin(t2)

		ce_rend[i] = {x=X,y=Y,z=Z}
	end

	-- zsort?
	for i=1,#ce_rend do
	 	local j = i
	 	while j > 1 and zsort(ce_rend[j-1],ce_rend[j]) do
			ce_rend[j-1],ce_rend[j] = ce_rend[j],ce_rend[j-1]
	  		j = j-1
	 	end
	end
end


function ce_draw(ft)
	for i=0,ce_size do
		circ(120+ce_rend[i].x*ce_rend[i].z,68+ce_rend[i].y*ce_rend[i].z,20-ce_rend[i].z,15*(1-ce_rend[i].z/20))
		if i%5==1 then 
			line(120+ce_rend[i].x*ce_rend[i].z,68+ce_rend[i].y*ce_rend[i].z,120+ce_rend[i-1].x*ce_rend[i].z,68+ce_rend[i-1].y*ce_rend[i].z,12) 
		end
	end
end

function ce_draw2(ft)
	for i=0,ce_size do
		circ(80+ce_rend[i].x*ce_rend[i].z,68+ce_rend[i].y*ce_rend[i].z,20-ce_rend[i].z,15*(1-ce_rend[i].z/20))
	end
end

--- circles touching
ct_data={}
ct_lft=0
function ct_init()
    -- one starting circle
    local ci = {x=120,y=68,r=(5+16*math.random())//1,c=1+14*math.random()}
    ct_data[1]=ci
end

function ctouching(ici)
    for i=1,#ct_data do
        local lci = ct_data[i]
        -- check if new circle overlaps
        if math.sqrt(math.abs(ici.x-lci.x)^2 + math.abs(ici.y-lci.y)^2) < (ici.r+lci.r) then
            return false
        end
    end
    return true
end

function ct_update(ft, speed)
    -- if change in ft >= speed add a circle
    if (ft-ct_lft > speed) then
        -- random size, and angle, placed to the side of the last?
        local ci={}
        local count=0
        repeat
            local lci = ct_data[1+#ct_data*math.random()//1]
            local angle = 2*math.pi*math.random()
            ci = {x=0,y=0,r=(2+10*math.random()),c=1+14*math.random()}
            ci.x = (1+ lci.x + math.sin(angle)*(lci.r+ci.r))
            ci.y = (1+ lci.y + math.cos(angle)*(lci.r+ci.r))
            count = count +1
        until (ctouching(ci)==true) --or (count > 10)
        ct_data[#ct_data + 1] = ci
        -- change in ft = 0
        ct_lft = ft
    end

    -- add motion? 
    for i=1,#ct_data do
        local lci = ct_data[i]
        local dif = 0.2
        lci.x=lci.x-dif
        lci.y=lci.y-dif
        lci.r=lci.r-dif
        ct_data[i] = lci
    end

end
function ct_draw(ft)
    local ci
    for i=1,#ct_data do
        ci = ct_data[i]
        circb(ci.x,ci.y,ci.r,ci.c)
    end
end

function tit_init0()
    local numblocks = 12
    local numsides = 6

    local sz=10
    local tau=2*math.pi
    local la
    local ia = tau * 1/numsides
    local cx = 120
    local cy = 8
    for j=0,numblocks-1 do
        local djx = j%2-1
        local djy = (j)%3%2-1
        local bx = cx + djx*sz*(numsides/2)*math.abs(math.sin(ia))
        local by = cy + j*sz*(numsides/2)*math.abs(math.cos(ia))
        for i=1,numsides do
            ltit={}
            la = tau * i/numsides
            ltit.cx=bx + sz*math.sin(la)
            ltit.cy=by + sz*math.cos(la)
            ltit.angle=la-math.pi
            ltit.ia=ia
            ltit.size=sz
            tit_data[i+j*numsides] = ltit
        end
    end
end
function tit_update0(ft)
    local la=.01
    local sa=math.sin(la)
    local ca=math.cos(la)
    for i=1,#tit_data do
        local ltit=tit_data[i]
        ltit.cx = 120+(ltit.cx-120)*ca-(ltit.cy-68)*sa
        ltit.cy = 68+(ltit.cx-120)*sa+(ltit.cy-68)*ca
        ltit.angle = ltit.angle - la
    end
end
function tit_draw0(ft)
    local dx=ft/50
    local dy=0---ft/50
    local da=0
    for i=1,#tit_data do
        local ltit=tit_data[i]
        local po={x=ltit.cx,y=ltit.cy}
        local p1,p2,p3
        local sa1,ca1
        local sa2,ca2
        local sa3,ca3
        local sdif = (1+math.sin(ft/10+i/3))/2 * ltit.size - .01*ltit.size
        local ia = ltit.ia

        sa1 = math.sin(ltit.angle +da)
        ca1 = math.cos(ltit.angle +da)

        sa2 = math.sin(ltit.angle +math.pi+ia +da)
        ca2 = math.cos(ltit.angle +math.pi+ia +da)

        sa3 = math.sin(ltit.angle +math.pi-ia +da)
        ca3 = math.cos(ltit.angle +math.pi-ia +da)

        -- get three points, size/innersize away from cx,cy, point 1 at angle, point 2 at angle + 120o, point 3 at angle + 240o
        p1 = {x=po.x + sdif * sa1 + dx, y=po.y + sdif * ca1 + dy}
        p2 = {x=po.x + sdif * sa2 + dx, y=po.y + sdif * ca2 + dy}
        p3 = {x=po.x + sdif * sa3 + dx, y=po.y + sdif * ca3 + dy}
        -- draw tri
        local c = 14
        if (i%2 == 0) then c = 2 end
        tri(p1.x,p1.y,p2.x,p2.y,p3.x,p3.y,c)

        -- get three points, size away from cx,cy, point 1 at angle, point 2 at angle + 120o, point 3 at angle + 240o
        p1 = {x=po.x + ltit.size * sa1 + dx, y=po.y + ltit.size * ca1 + dy}
        p2 = {x=po.x + ltit.size * sa2 + dx, y=po.y + ltit.size * ca2 + dy}
        p3 = {x=po.x + ltit.size * sa3 + dx, y=po.y + ltit.size * ca3 + dy}
        -- draw trib
        trib(p1.x,p1.y,p2.x,p2.y,p3.x,p3.y,12)

    end
end
--- triangles in triangles
tit_data={}
function tit_init()
    local numblocks = 12
    local numrows = 5
    local numsides = 6

    local sz=10
    local tau=2*math.pi
    local la
    local ia = tau * 1/numsides
    local cx = 0
    local cy = 0
    for j=0,numblocks-1 do
        local djx = j%2-1
        local djy = (j)%3%2-1
        local bx = cx + djx*sz*(numsides/2)*math.abs(math.sin(ia))
        local by = cy + j*sz*(numsides/2)*math.abs(math.cos(ia))
        for k=0,numrows do
            local kx = bx + k*53
            for i=1,numsides do
                ltit={}
                la = tau * i/numsides
                ltit.cx=kx + sz*math.sin(la)
                ltit.cy=by + sz*math.cos(la)
                ltit.angle=la-math.pi
                ltit.ia=ia
                ltit.size=sz
                table.insert(tit_data,ltit)
            end
        end
    end
end
function tit_update(ft)
end
function tit_draw(ft,lc,lpart)
    local dx=0--ft/50
    local dy=0---ft/50
    local da=0
    for i=1,#tit_data do
        local ltit=tit_data[i]
        local po={x=ltit.cx,y=ltit.cy}
        local p1,p2,p3
        local cd = math.sqrt((120-po.x)^2 + (68-po.y)^2)
        local an = math.atan((120-po.x),(68-po.y))
        local sdif = (1+math.sin(ft/10+cd/10))/2 * ltit.size - .01*ltit.size
        local ia = ltit.ia

        local c = 14
        c=cd/10+ft/10

        if lpart < 1 then
        elseif lpart < 2 then
            sdif = (1+math.sin(cd/10+an+ft/10))/2 * ltit.size - .01*ltit.size
            c=cd/10+an
        elseif lpart < 3 then
            sdif = (1+math.sin(an*3+ft/10))/2 * ltit.size - .01*ltit.size
        else
            sdif = (1+math.sin(an*5+ft/10+cd/10))/2 * ltit.size - .01*ltit.size
        end


        sa1 = math.sin(ltit.angle +da)
        ca1 = math.cos(ltit.angle +da)

        sa2 = math.sin(ltit.angle +math.pi+ia +da)
        ca2 = math.cos(ltit.angle +math.pi+ia +da)

        sa3 = math.sin(ltit.angle +math.pi-ia +da)
        ca3 = math.cos(ltit.angle +math.pi-ia +da)

        -- get three points, size/innersize away from cx,cy, point 1 at angle, point 2 at angle + 120o, point 3 at angle + 240o
        p1 = {x=po.x + sdif * sa1 + dx, y=po.y + sdif * ca1 + dy}
        p2 = {x=po.x + sdif * sa2 + dx, y=po.y + sdif * ca2 + dy}
        p3 = {x=po.x + sdif * sa3 + dx, y=po.y + sdif * ca3 + dy}
        -- draw tri

        tri(p1.x,p1.y,p2.x,p2.y,p3.x,p3.y,c%16)

        -- get three points, size away from cx,cy, point 1 at angle, point 2 at angle + 120o, point 3 at angle + 240o
        p1 = {x=po.x + ltit.size * sa1 + dx, y=po.y + ltit.size * ca1 + dy}
        p2 = {x=po.x + ltit.size * sa2 + dx, y=po.y + ltit.size * ca2 + dy}
        p3 = {x=po.x + ltit.size * sa3 + dx, y=po.y + ltit.size * ca3 + dy}
        -- draw trib
        trib(p1.x,p1.y,p2.x,p2.y,p3.x,p3.y,lc)

    end
end

function loadSpritePix(sprite, wide, high, bank)
    wide = wide or 1
    high = high or 1
    bank = bank or 0

    local retdata = {}

    if bank == 0 then
    else
        sync(35,bank,false)
    end

    local fd2c=1
    -- load the sprite into memory, x,y,c
    for i=0,high-1 do
        local imem = i*1024
        for j=0,wide-1 do
            local jmem = j*64
            for l=0,7 do
                y=l + i*8
                    
                for k=0,7 do
                    local pixi = peek4(0x8000+sprite*64+imem+jmem+(l*8)+k)
                    x=k + j*8

                    -- colour 0 = tranparent
                    if (pixi ~= 0) then
                        retdata[fd2c] = {x, y, pixi}
                        fd2c = fd2c + 1
                    end
                end
            end
        end
    end

    return retdata
end

--- fairlight dissolve
fd_data={}
fd_data2={}
fd_data3={}
fd_data4={}
fd_data5={}
fd_data6={}
fd_line=0
function fd_init_old()
    -- bank 2, sprite 1, 8 wide+high
    local bank = 0
    local sprite = 400
    local wide = 6
    local high = 3

    fd_data2 = loadSpritePix(400,6,3,0)
end
function fd_init()
    -- bank 2, sprite 1, 8 wide+high
    local bank = 0
    local sprite = 400
    local wide = 6
    local high = 3

    fd_data2 = loadSpritePix(256,11,3,2)
    fd_data3 = loadSpritePix(268,4,3,2)
    fd_data4 = loadSpritePix(304,6,3,2)

    for i=1,#fd_data4 do
        local lp = fd_data4[i]
        lp[1] = lp[1] + 48
        table.insert(fd_data3,lp)
    end

    fd_data5 = loadSpritePix(312,8,3,2)
    fd_data6 = loadSpritePix(355,8,3,2)
    for i=1,#fd_data6 do
        local lp = fd_data6[i]
        lp[1] = lp[1] + 63
        table.insert(fd_data5,lp)
    end
end

function fd_update(ft)
    -- move down the image, top line becomes particles
    ylimit = ft/10
    -- move particles with fluid movement
    for i=1,#fd_data2 do
        cp = fd_data2[i]
        if cp[2] < ylimit then
            cp[1]=cp[1]+0.03*ylimit*(math.sin(ylimit*cp[2]/17)+.5*math.cos((ft-i)/100))+(ft-i/2)/300
            cp[2]=cp[2]+0.008*ylimit*math.sin(ylimit*i/19)*(math.cos(cp[1]/17))
        end
    end
end

function fd_update2(ft)
    -- move down the image, top line becomes particles
    ylimit = mscurrent/100
    -- move particles with fluid movement
    if ft<.33 then
        ylimit=ft*66
        for i=1,#fd_data2 do
            cp = fd_data2[i]
            if cp[2] < ylimit then
                cp[1]=cp[1]+4+math.sin(ylimit+i/17)--+.5*math.cos((ft-i)/10))+(ft-i)/100
                cp[2]=cp[2]-.6+math.cos(ylimit+i/19)--+0.08*ylimit*math.sin(ylimit*i/19)*(math.cos(cp[1]/17))
            end
        end
    elseif ft <.66 then
        ylimit=(ft-.33)*66
        for i=1,#fd_data3 do
            cp = fd_data3[i]
            if cp[2] < ylimit then
                cp[1]=cp[1]+4+math.sin(ylimit+i/17)--+.5*math.cos((ft-i)/10))+(ft-i)/100
                cp[2]=cp[2]-.8+math.cos(ylimit+i/19)--+0.08*ylimit*math.sin(ylimit*i/19)*(math.cos(cp[1]/17))
            end
        end
    elseif ft < 2 then
        ylimit=(ft-.66)*66
        for i=1,#fd_data5 do
            cp = fd_data5[i]
            if cp[2] < ylimit then
                cp[1]=cp[1]+3+1*(math.sin(ylimit+i/17))--+.5*math.cos((ft-i)/10))+(ft-i)/100
                cp[2]=cp[2]-.8+1*(math.cos(ylimit+i/19))--+0.08*ylimit*math.sin(ylimit*i/19)*(math.cos(cp[1]/17))
            end
        end
    end
end

fddx=-4
fddy=-11

function fd_draw(ft)
    -- draw sprite - lines that have dissolved
    if ft<.33 then
        spr(0,50,0,0,1,0,0,16,12)
        for i=1,#fd_data2 do
            cp = fd_data2[i]
            pix(fddx+70+cp[1],fddy+40+cp[2],cp[3])
        end
        spr(268,50+32,53,0,1,0,0,4,3)
        spr(304,50+80,53,0,1,0,0,7,3)
        spr(312,50+15,77,0,1,0,0,8,3)
        spr(355,50+78,77,0,1,0,0,8,3)
        spr(384,50+128,64,0,1,0,0,3,8)
        spr(449,50+128+8,128,0,1,0,0,2,3)
    elseif ft <.66 then
        spr(0,50,0,0,1,0,0,16,12)
        spr(384,50+128,64,0,1,0,0,3,8)
        spr(449,50+128+8,128,0,1,0,0,2,3)
        for i=1,#fd_data3 do
            cp = fd_data3[i]
            pix(fddx+86+cp[1],fddy+64+cp[2],cp[3])
        end
        spr(312,50+15,77,0,1,0,0,8,3)
        spr(355,50+78,77,0,1,0,0,8,3)
    else
        spr(0,50,0,0,1,0,0,16,12)
        spr(384,50+128,64,0,1,0,0,3,8)
        spr(449,50+128+8,128,0,1,0,0,2,3)
        for i=1,#fd_data5 do
            cp = fd_data5[i]
            pix(fddx+69+cp[1],fddy+88+cp[2],cp[3])
        end
        spr(405,fddx+114,fddy+83,0,1,0,0,6,3)
    end


--[[
    for i=1,#fd_data2 do
        cp = fd_data2[i]
        pix(100+cp[1],80+cp[2],cp[3])
    end
--]]
end

function fnd_draw(ft)
    spr(0,50,0,0,1,0,0,16,12)
    spr(256,66,29,0,1,0,0,11,3)
    spr(268,50+32,53,0,1,0,0,4,3)
    spr(304,50+80,53,0,1,0,0,7,3)
    spr(312,50+15,77,0,1,0,0,8,3)
    spr(355,50+78,77,0,1,0,0,8,3)
    spr(384,50+128,64,0,1,0,0,3,8)
    spr(449,50+128+8,128,0,1,0,0,2,3)
end



CRalpha = 1.0	
function GetT(ft,ip1,ip2)
	return ft + ((ip2.x-ip1.x)^2 +(ip2.y-ip1.y)^2 +(ip2.z-ip1.z)^2)^(CRalpha*0.5)
end

function Vec3Add(ip1,ip2)
	return {x=ip1.x+ip2.x,y=ip1.y+ip2.y,z=ip1.z+ip2.z}
end
function Vec3Mul(ft,ip)
	return {x=ip.x*ft,y=ip.y*ft,z=ip.z*ft}
end

function Vec2Mul(ft,ip)
	return {x=ip.x*ft,y=ip.y*ft}
end

function CatMullRom(numPoints, inputPoints)
	local retPoints = {}
	local t0 = 0
	local t1 = GetT(t0,inputPoints[1],inputPoints[2])
	local t2 = GetT(t1,inputPoints[2],inputPoints[3])
	local t3 = GetT(t2,inputPoints[3],inputPoints[4])

	--trace("t0"..t0.." t1"..(t1//1).." t2"..(t2//1).." t3"..(t3//1))

	local cnt = (t2-t1)/numPoints

	for i=t1,t2,cnt do
		local A1 = Vec3Add(Vec3Mul((t1-i)/(t1-t0),inputPoints[1]), Vec3Mul((i-t0)/(t1-t0),inputPoints[2]))
		local A2 = Vec3Add(Vec3Mul((t2-i)/(t2-t1),inputPoints[2]), Vec3Mul((i-t1)/(t2-t1),inputPoints[3]))
		local A3 = Vec3Add(Vec3Mul((t3-i)/(t3-t2),inputPoints[3]), Vec3Mul((i-t2)/(t3-t2),inputPoints[4]))

		local B1 = Vec3Add(Vec3Mul((t2-i)/(t2-t0),A1), Vec3Mul((i-t0)/(t2-t0),A2))
		local B2 = Vec3Add(Vec3Mul((t3-i)/(t3-t1),A2), Vec3Mul((i-t1)/(t3-t1),A3))

		local C = Vec3Add(Vec3Mul((t2-i)/(t2-t1),B1), Vec3Mul((i-t1)/(t2-t1),A2))

		table.insert(retPoints,C)
	end

	return retPoints
end

--- rollercoaster template
rc_data={}
rc_data2={}
-- points for the spline gen, d=number of sections per that part of track
rc_dir={{x=1,y=0,z=1,d=16},
        {x=0,y=0,z=2,d=16},
		{x=1,y=1,z=1,d=32},
        {x=2,y=0,z=0,d=8},
		{x=1,y=2,z=1,d=32},
		{x=0,y=1,z=2,d=32},
		{x=-1,y=0,z=1,d=16},
		{x=-0.5,y=-1,z=0,d=16},
		{x=0,y=-2,z=-1,d=16}
} 

function rc_init()
	local i1 = 0
	local i2 = 0
	local i3 = 0
	local i4 = 0

	-- build a track of p3 pair
	for i=1,#rc_dir do
		holdrco = {}

		i1 = i
		if (i+1) <= #rc_dir then i2 = (i + 1) else i2 = (i + 1) - #rc_dir end
		if (i+2) <= #rc_dir then i3 = (i + 2) else i3 = (i + 2) - #rc_dir end
		if (i+3) <= #rc_dir then i4 = (i + 3) else i4 = (i + 3) - #rc_dir end
		holdrci = {rc_dir[i1],rc_dir[i2],rc_dir[i3],rc_dir[i4]}

		--trace("i1 "..i1.." i2 "..i2.." i3 "..i3.." i4 "..i4)
		holdrco = CatMullRom(rc_dir[i].d,holdrci)
		
		for j=2,#holdrco do
			table.insert(rc_data2,holdrco[j])
		end
		--trace("#hrc "..#holdrco.." #rc2 "..#rc_data2)
	end
end

function rc_update(ft)
	rc_data={}
	ycale=100  
	xcale=300+bassfreq*2
	zcale=100

	fx = math.cos(ft/20)
	fy = -40 - math.sin(ft/30)*math.sin(ft/50) * ycale
	wid=20

	--fx = rc_data2[1].x
	--fy = -40 - rc_data2[1].y

	px = fx
	py = fy
	pz = zcale
	
	-- build a track of p3 pair
	for i=1,20 do
		local curx = math.cos(i/20 + ft/20) * xcale*i/10
		local cury = -20 - math.sin(i/5 + ft/30)*math.sin(i/6 + ft/50) * ycale
		local curz = i*zcale

		--local curx = rc_data2[i].x
		--local cury = rc_data2[i].y
		--local curz = rc_data2[i].z

		-- line (or rect) across
		local left = {x=-wid+curx-fx,y=cury-fy,z=curz}
		local right = {x=wid+curx-fx,y=cury-fy,z=curz}
		local leftf = {x=-wid+px-fx,y=py-fy,z=pz}
		local rightf = {x=wid+px-fx,y=py-fy,z=pz}
		local leftd = {x=-wid+curx-fx,y=ycale-fy,z=curz}
		local rightd = {x=wid+curx-fx,y=ycale-fy,z=curz}

		local across = {p1=left, p2=right}
		table.insert(rc_data,across)		

		-- lines forward
		if i > 1 then
			local fl = {p1=left, p2=leftf}
			table.insert(rc_data,fl)		
			local fr = {p1=right, p2=rightf}
			table.insert(rc_data,fr)		
		end
		-- lines down
		local dl = {p1=left, p2=leftd}
		table.insert(rc_data,dl)		
		local dr = {p1=right, p2=rightd}
		table.insert(rc_data,dr)	

		px = curx
		py = cury
		pz = curz	
	end
	-- camera movement?
end

function rc_update2(ft)
	rc_data={}
	ycale=300
	xcale=400
	zcale=50

	wid=50

	pos = (ft)%#rc_data2//1+1
	pos2 = (ft+1)%#rc_data2//1+1
	fx = rc_data2[pos].x*xcale
	fy = -(rc_data2[pos].y)*ycale-50

	-- fy need to change on dir of travel
	dy = (rc_data2[pos].y-rc_data2[pos2].y)*40

	px = fx
	py = fy
	pz = rc_data2[pos].z*zcale
	
	-- build a track of p3 pair
	for j=1,#rc_data2 do
		i = (j+ft)%#rc_data2//1+1

		local curx = rc_data2[i].x*xcale
		local cury = -(rc_data2[i].y)*ycale
		local curz = (rc_data2[i].z+j)*zcale

		-- line (or rect) across
		local left = {x=-wid+curx-fx,y=cury-fy-(dy*j),z=curz}
		local right = {x=wid+curx-fx,y=cury-fy-(dy*j),z=curz}
		local leftf = {x=-wid+px-fx,y=py-fy-(dy*j),z=pz}
		local rightf = {x=wid+px-fx,y=py-fy-(dy*j),z=pz}
		local leftd = {x=-wid+curx-fx,y=cury+ycale*curz/2,z=curz}
		local rightd = {x=wid+curx-fx,y=cury+ycale*curz/2,z=curz}

		local across = {p1=left, p2=right}
		table.insert(rc_data,across)		

		-- lines forward
		if j > 1 then
			local fl = {p1=left, p2=leftf}
			table.insert(rc_data,fl)		
			local fr = {p1=right, p2=rightf}
			table.insert(rc_data,fr)		
		end

		if(i%40)==1 then
			-- lines down
			local dl = {p1=left, p2=leftd}
			table.insert(rc_data,dl)		
			local dr = {p1=right, p2=rightd}
			table.insert(rc_data,dr)
		end	

		px = curx
		py = cury
		pz = curz	
	end
	-- camera movement?
end


function rc_draw(ft)
	local localline = {}
	for i = #rc_data,1,-1 do
		local lp1 = p2d(rc_data[i].p1)
		local lp2 = p2d(rc_data[i].p2)
		line(lp1.x,lp1.y,lp2.x,lp2.y,15-i/#rc_data*15)
	end
end

function CMdra(ft)
	for i=1,#rc_data2 do
		pix(rc_data2[i].x*10 + 20, rc_data2[i].y*10 + 68, 12)
	end
	red = rc_data2[(ft)%#rc_data2//1+1]
	pix(red.x*10 + 20, red.y*10 + 68, 2)
end

tts_num = 30
tts_circs={} -- x, y, z, c, s
tts_circs2={} -- x, y, z, c, s
function tts_init()
    -- make tentacle from points 
    for i=1,tts_num do
        tts_circs[i] = {x=40,y=-i*2,z=30,c=i/tts_num*15,s=15-(i/tts_num)^2*15}
    end

end	

tents=5
function tts_update(ft)
    local rc

    tts_circs2={}

    -- twist and rotate/multiply and zoom    
    for i=1,tents do
        rott = ft/50 + 2*math.pi*i/tents
        for j=1,#tts_circs do
            -- funny in a line brott=rott+math.cos(j/100)
            brott=rott+math.cos(ft/40+j/50)
            local d=20*(.8*math.cos(ft/100))+30*math.sin(j/10)
            rx = (tts_circs[j].x+d) * math.cos(brott) - (tts_circs[j].z+d) * math.sin(brott) 
            rz = (tts_circs[j].x+d) * math.sin(brott) + (tts_circs[j].z+d) * math.cos(brott)
            table.insert(tts_circs2, {x=rx, y=tts_circs[j].y, z=rz, s=tts_circs[j].s, c=tts_circs[j].c})
        end
    end
    -- zsort?
	for i=1,#tts_circs2 do
        local j = i
        while j > 1 and (tts_circs2[j-1].z<tts_circs2[j].z) do
            tts_circs2[j-1],tts_circs2[j] = tts_circs2[j],tts_circs2[j-1]
            j = j-1
        end
    end
end

function tts_update2(ft,addt)
    local rc

    tts_circs2={}
    local fft=ft+addt

    -- twist and rotate/multiply and zoom    
    for i=1,tents do
        rott = ft/50 + 2*math.pi*i/tents
        for j=#tts_circs,1,-1 do
            brott=rott+math.cos(j/100)
            --brott=rott+math.cos(ft/40+j/50)
            local d=10*math.sin(j/10+(fft/(bassfreq/2)))
            rx = (tts_circs[j].x+d) - (100-10*i)*(i%2) 
            ry = 40+tts_circs[j].y - i*40+fft/10
            rz = tts_circs[j].z+d*j/#tts_circs +fft/20
            table.insert(tts_circs2, {x=rx, y=ry, z=rz, s=tts_circs[j].s+(5-i), c=tts_circs[j].c})
        end
    end
    --
	for i=1,#tts_circs2 do
        local j = i
        while j > 1 and (tts_circs2[j-1].c>tts_circs2[j].c) do
            tts_circs2[j-1],tts_circs2[j] = tts_circs2[j],tts_circs2[j-1]
            j = j-1
        end
    end
    --]]
end

function tts_draw(ft)
	local c = {}
	for i=1,#tts_circs2 do
		c = tts_circs2[i]
        local cz = c.z+50/10
		circ(120+c.x,100+c.y-cz/2,c.s,c.c)
    end
end

---fonts
-- font data {"A", sprite number, page?, num sprites x, y, width (px), height}
fontd={	{0,0,2,2,15,16},{2,0,2,2,15,16},{4,0,2,2,15,16},{6,0,2,2,15,16},{8,0,2,2,15,16},{10,0,2,2,15,16},{12,0,2,2,15,16},{14,0,2,2,15,16},
		{128,0,1,2,6,16},{130,0,2,2,15,16},{132,0,2,2,15,16},{134,0,2,2,15,16},{136,0,2,2,15,16},{138,0,2,2,15,16},{140,0,2,2,15,16},{142,0,2,2,15,16},
		{256,0,2,2,15,16},{258,0,2,2,14,16},{260,0,2,2,15,16},{262,0,2,2,15,16},{264,0,2,2,15,16},{266,0,2,2,15,16},{268,0,2,2,15,16},{270,0,2,2,15,16},
		{384,0,2,2,15,16},{386,0,2,2,15,16},{388,0,2,2,13,16},{390,0,2,2,9,16},{392,0,2,2,13,16},{394,0,2,2,13,16},{396,0,2,2,13,16},{398,0,2,2,13,16},
		{512,0,2,2,13,16},{514,0,2,2,13,16},{516,0,2,2,13,16},{518,0,2,2,13,16},{520,0,2,2,13,16},{522,0,2,2,8,16},{524,0,2,2,8,16},{526,0,2,2,9,16},
		{640,0,2,2,7,16},{642,0,2,2,13,16},{644,0,2,2,15,16},{646,0,2,2,15,16},{648,0,2,2,9,16},{650,0,2,2,9,16},{652,0,2,2,16,16},{654,0,2,2,15,16}
	}

-- this could be useful for compression later
font = {}
chars="ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-.:/!?<>,\'# "

function font_init()
	for i=1,#fontd do
		font[string.sub(chars,i,i)] = fontd[i]
	end
end

function flength(txt,kx)
	kx = kx or 1
	pcx = 0
	letter ={}
	for i=1,string.len(txt) do
		letter = font[string.sub(txt,i,i)]
		-- update kerning
		pcx = pcx + letter[5] + kx
	end
	return pcx
end

-- fprint ("text", x, y, [x kerning = 1],[y kerning = 1], [colour = 15])
function fprint(txt,tx,ty,kx,ky,tc)
	kx = kx or 1
	ky = ky or 1
	tc = tc or 15
	pcx = 0
	pcy = 0
	letter ={}
	-- set to blit segment (8 = BG-1)
	poke4(2*0x03ffc,8)
	-- set colour
	poke4(2*0x03FF0 + 1, tc)
	-- print each letter
	for i=1,string.len(txt) do
		letter = font[string.sub(txt,i,i)]
		spr(letter[1],tx+pcx,ty+pcy,0,1,0,0,letter[3],letter[4])

		-- update kerning
		pcx = pcx + letter[5] + kx
	end
	poke4(2*0x03ffc,2)
	poke4(2*0x03FF0 + 1, 1)
end

function loadSpritePix1bpp(txt)

    local retdata = {}

    local fd2c=1
    local pcount =1

	--[[
    -- put the sprite on the screen
	pcx = 0
    -- set to blit segment (8 = BG-1)
	poke4(2*0x03ffc,8)
	-- set colour
	poke4(2*0x03FF0 + 1, 15)
	-- print each letter
	for i=1,string.len(txt) do
        cls()
        pcount=1
		letter = font[string.sub(txt,i,i)]
		spr(letter[1],pcx,0,0,1,0,0,letter[3],letter[4])

        -- load the sprite into memory from the screen, x,y,c
        for k=0,letter[3]*8-1 do
            for j=0,letter[4]*8-1 do
                c=pix(k,j)
                
                if c > 0 then 
                    retdata[pcount]={x=k+(i-2)*letter[3]*8,y=j,c}
                    pcount=pcount+1
                end
            end
        end
    end
	--]]

	-- print letters
	cls()
	width = flength(txt,1)
	letter = font[string.sub(txt,1,1)]
	height = letter[4] * 8
	fprint(txt,0,0)

	-- load the sprite into memory from the screen, x,y,c
	for k=0,width do
		for j=0,height-1 do
			c=pix(k,j)
			
			if c > 0 then 
				retdata[pcount]={x=k,y=j,c}
				pcount=pcount+1
			end
		end
	end

	-- reset to blit segment (8 = BG-1)
	poke4(2*0x03ffc,2)
	-- set colour
	poke4(2*0x03FF0 + 1, 1)

    return retdata
end

--- word slice effect
ws_data={5,6,7,8,9,10,11}
wsh_data={}
function ws_init()
    for i=1,#greets-1 do
        local wstb = greets[i]
        local wst=wstb[1]

        local isOdd = #wst%2
        local firsthalf="ER"
        local secondhalf="ER"
        local mid=""

        if isOdd == 1 then
            firsthalf=string.sub(wst,1,#wst//2)
            secondhalf=string.sub(wst,#wst//2+2,#wst)
            mid = string.sub(wst,#wst//2+1,#wst//2+1)
        else
            firsthalf=string.sub(wst,1,#wst//2-1)
            secondhalf=string.sub(wst,#wst//2+2,#wst)
            mid = string.sub(wst,#wst//2,#wst//2+1)
        end
        cls()
        table.insert(wsh_data,{firsthalf,secondhalf,isOdd,mid,d=loadSpritePix1bpp(mid)})

    end
end 

function ws_update(ft)
end
function ws_draw(ft)
    local ww = (ft//100)%(#wsh_data)+1
    local wstb = greets[ww]
    local wst=wstb[1]
    local nudge=wstb[2]
    local halves=wsh_data[ww]
    local fh = halves[1]
    local sh = halves[2]
    local fhl = flength(fh,1)
    local shl = flength(sh,1)
    local letterp={}

	local dt=(ft)%100
    local ldt = 4*dt
    ldt2=math.max(dt-25,0)

    local linestartx = 216
    local linestarty = -32

    dt=math.max(dt-50,0)

    line(linestartx-4*ldt//1,linestarty+4*ldt//1,linestartx-2*ldt//1,linestarty+2*ldt//1,15)

    local wslen = flength(wst,1)
    --trace(wslen.."|"..wst)
    --fprint(wst,120-wslen/2,60) 
    --we're odd 
    if halves[3] == 1 then
        local mid = halves[4]
        local midlen = flength(mid)
    	-- draw letters not in middle to the left/right with y changing on ft
		fprint(fh,nudge+120-fhl-midlen/2-dt,60+dt)
        fprint(sh,nudge+120+midlen/2+dt,60-dt)

    	-- draw middle sprite pixel by pixel, cut down middle, left/right with y changing on ft
		letterp = halves.d
        for i=1,#letterp do
            if(letterp[i].x + letterp[i].y) < midlen then
                pix(nudge+letterp[i].x +120-midlen/2-dt,letterp[i].y+60+dt,15)
            else
                pix(nudge+letterp[i].x +120-midlen/2+dt,letterp[i].y+60-dt,15)
            end
        end

		--line(120-dt -10,60+dt+18,120+dt+16,60-dt-8,15)
    else
        --fprint(fh,120-wslen/2,90)
        --fprint(sh,120,90)
        local mid = halves[4]
        local midlen = flength(mid)
    	-- draw letters not in middle to the left/right with y changing on ft
		fprint(fh,nudge+120-fhl-midlen/2-dt,60+dt)
        fprint(sh,nudge+120+midlen/2+dt,60-dt)

    	-- draw middle sprite pixel by pixel, cut down middle, left/right with y changing on ft
		letterp = halves.d
        for i=1,#letterp do
            if(letterp[i].x + letterp[i].y) < midlen*.66 then
                pix(nudge+letterp[i].x +120-midlen/2-dt,letterp[i].y+60+dt,15)
            else
                pix(nudge+letterp[i].x +120-midlen/2+dt,letterp[i].y+60-dt,15)
            end
        end
		--line(120-dt-12,60+dt+18,120+dt+14,60-dt-8,15)
    end

    -- draw line for cut
end

--- credits
crd_data={1,2,3,4}
function crd_init()
end
function crd_update(ft)
end
function crd_draw(ft)
    local ww = (ft)%#crd_data+1
    local wstb = texts[crd_data[ww]]
    local word=wstb[1]
    local midlen = flength(word,1)
    fprint(word,120-midlen/2,60)
end


------- sound stuff

function getPatternD(track,order)
	start = track*51+0x13e64+order*3
	value = peek(start+2)<<16|peek(start+1)<<8|peek(start)
	return {value&0x00003f,
	(value&0x000fc0)>>6,
	(value&0x03f000)>>12,
	(value&0xfc0000)>>18}
end
	
function getRowD(pattern,row)
	start = pattern*3*64 + row*3 + 0x11164
	value = peek(start+2)<<16|peek(start+1)<<8|peek(start)
	return {note=value&0x00000f, 
			octave=(value&0xe00000)>>21,
			instruement=(value&0x1f8000)>>15,
			command=(value&0x007000>>12),
			param1=(value&0x000f00>>8),
			param2=(value&0x0000f0>>4)}
end
	
function noteString(note)
	if note == 1 then
	return "--"
	elseif (note <= 3) then
	return "00"
	elseif (note == 4) then
	return "C-"
	elseif (note == 5) then
	return "C#"
	elseif (note == 6) then
	return "D-"
	elseif (note == 7) then
	return "D#"
	elseif (note == 8) then
	return "E-"
	elseif (note == 9) then
	return "F-"
	elseif (note == 10) then
	return "F#"
	elseif (note == 11) then
	return "G-"
	elseif (note == 12) then
	return "G#"
	elseif (note == 13) then
	return "A-"
	elseif (note == 14) then
	return "A#"
	elseif (note == 15) then
	return "B-"
	else
	return "XX"
	end
end

function noteFreq(note,octave,current)
	octave = octave+1
	if note == 1 then
	return 0
	elseif (note <= 3) then
	return current
	elseif (note == 4) then
	return 32.7*octave
	elseif (note == 5) then
	return 34.6*octave
	elseif (note == 6) then
	return 36.7*octave
	elseif (note == 7) then
	return 38.9*octave
	elseif (note == 8) then
	return 41.2*octave
	elseif (note == 9) then
	return 43.6*octave
	elseif (note == 10) then
	return 46.2*octave
	elseif (note == 11) then
	return 49*octave
	elseif (note == 12) then
	return 51.9*octave
	elseif (note == 13) then
	return 55*octave
	elseif (note == 14) then
	return 58.3*octave
	elseif (note == 15) then
	return 61.7*octave
	else
	return current
	end
end
	
function getFreq()
	statetrack=peek(0x13ffc)
	statepattern=peek(0x13ffd)
	staterow=peek(0x13ffe)
	patterns=getPatternD(statetrack,statepattern)
	row2=getRowD(patterns[2],staterow)
	row3=getRowD(patterns[3],staterow)
	--return noteFreq(math.max(row2.note,row3.note),math.max(row2.octave,row2.octave),bassfreq)
	return math.max(noteFreq(math.max(row2.note,row3.note),math.max(row2.octave,row2.octave),bassfreq),40)
end

-------------------------
-- p3d.tic demo code ----
cx=120
cy=68
cz=100
pivot={x=0,y=0,z=0}
light={x=0,y=0,z=1}
angle=0

function p2d(p3d)
	local fov = 180
	local x0 = p3d.x
	local y0 = p3d.y
	local z0 = p3d.z + cz
	local x2d = fov * x0 / z0
	local y2d = fov * y0 / z0
	local po = {}
	
	x2d = x2d + cx
	y2d = y2d + cy
	
	po = {x = x2d, y = y2d}
	return po
end

-- with my optimizing

function zsort(p1,p2)
	return p1.z>p2.z
end

------------------ useful math
-- take in an array of tri's {x,y,z,m}, return sorted
function zsort(ps)
	for i=1,#ps do
	 local j = i
	 while j > 1 and zsortp(ps[j-1],ps[j]) do
	  ps[j-1],ps[j] = ps[j],ps[j-1]
	  j = j-1
	 end
	end
   end
   
function zsortp(t1,t2)
	return (t1.p1.z+t1.p2.z+t1.p3.z)<(t2.p1.z+t2.p2.z+t2.p3.z)
end
function zsort2p(t1,t2)
	for i=1,#ps do
        local j = i
        l1 = ps[j-1]
        l2 = ps[j]
        while j > 1 and (l1.p1.z+l1.p2.z)<(l2.p1.z+l2.p2.z) do
         ps[j-1],ps[j] = ps[j],ps[j-1]
         j = j-1
        end
       end
end
  
-------------------------
--- utils
--------PALETTE CRAP

function palspread(sr,sg,sb,er,eg,eb,twist)
	twist = twist or 0 -- 0: no twist, 1: twist red, 2: twist green, 4: twist blue
	dr = (er - sr)/16
	dg = (eg - sg)/16
	db = (eb - sb)/16
	if twist == 0 then 
		for i=0,15 do
			i3=i*3
			currentP[(i*3)+1]=sr+(dr*i)
			currentP[(i*3)+2]=sg+(dg*i)
			currentP[(i*3)+3]=sb+(db*i)
		end
	else
		for i=0,15 do
			iexp=(i/15)*(i/15)*(i/15)*15
			ctwist=twist
			if ctwist >= 4 then
				ib = db * iexp
				ctwist = ctwist-4
			else
				ib = (db*i)
			end
			if ctwist >= 2 then
				ig = dg * iexp
				ctwist = ctwist-2
			else
				ig = (dg*i)
			end
			if ctwist >= 1 then
				ir = dr * iexp
			else
				ir = (dr*i)
			end
			currentP[(i*3)+1]=sr+ir
			currentP[(i*3)+2]=sg+ig
			currentP[(i*3)+3]=sb+ib
		end
	end
end

function palmid(mr,mg,mb)
	dr = mr/8
	dg = mg/8
    db = mb/8
    for i=0,7 do
        i3=i*3
        currentP[(i*3)+1]=dr*i
        currentP[(i*3)+2]=dg*i
        currentP[(i*3)+3]=db*i
    end
	dr = (255-mr)/8
	dg = (255-mg)/8
    db = (255-mb)/8
    for i=8,15 do
        i3=i*3
        currentP[(i*3)+1]=mr+(dr*(i-8))
        currentP[(i*3)+2]=mg+(dg*(i-8))
        currentP[(i*3)+3]=mb+(db*(i-8))
    end
end

function mixPalette(a,b,ratio)
	outP = {}
	ap = palettes[a]
	bp = palettes[b]
	for i=1,48 do
		outP[i]=ap[i]*(1-ratio) + bp[i]*ratio
	end
	return outP
end
function mixPalette2(a,b,ratio)
	outP = {}
	ap = a
	bp = b
	for i=1,48 do
		outP[i]=ap[i]*(1-ratio) + bp[i]*ratio
	end
	return outP
end

function invertP(a)
	outP = {}
	ap = palettes[a]
	for i=1,48 do
		outP[i]=255-ap[i]
	end
	return outP
end

function setPalette(p)
	for i=0,15 do
		for j=0,2 do
			poke(0x03FC0 + (i*3) + j,p[(i*3) + j+1])
		end
	end
end
   
function putPalette(p,s,n)
	for i=0,n do
		for j=0,2 do
			poke(0x03FC0 + ((i+s)*3) + j,p[(i*3) + j +1])
		end
	end
end

sweetie16={0x1A,0x1C,0x2C,
		   0x5D,0x27,0x5D,
		   0xB1,0x3E,0x53,
		   0xEF,0x7D,0x57,
		   0xFF,0xCD,0x75,
		   0xA7,0xF0,0x70,
		   0x38,0xB7,0x64,
		   0x25,0x71,0x79,
		   0x29,0x36,0x6F,
		   0x3B,0x5D,0xC9,
		   0x41,0xA6,0xF6,
		   0x73,0xEF,0xF7,
		   0xF4,0xF4,0xF4,
		   0x94,0xB0,0xC2,
		   0x56,0x6C,0x86,
		   0x33,0x3C,0x57}

sinclair16={0x00,0x00,0x00,
		   0x22,0x22,0x11,
		   0x55,0x22,0x00,
		   0x22,0x33,0x44,
		   0x55,0x33,0x22,
		   0x55,0x44,0x44,
		   0x88,0x44,0x22,
		   0x55,0x66,0x55,
		   0x99,0x66,0x55,
		   0x77,0x77,0x66,
		   0x88,0x88,0x77,
		   0xcc,0x88,0x77,
		   0x99,0x99,0x99,
		   0xbb,0xaa,0xaa,
		   0xdd,0xbb,0xaa,
		   0xee,0xee,0xee}
-- aqua palette
aqua = {0,0,0, 
		0,16,32,
		0,32,64,
		0,48,96,
		0,64,128,
		0,80,160,
		0,96,192,
		0,112,224,
		0,128,255,
		32,144,255,
		64,160,255,
		96,176,255,
		128,192,255,
		160,208,255,
		192,224,255,
		255,255,255}

gray = {}
palettes={}

--- overlay stuff

-- debug stuff
debug1=""
debug2=""
currentOP={}
function OVR()
    rendero()

	setPalette(currentOP)
end

activeScan=0
currentP={}
currentLP={}
function SCN(l)
	if activeScan == 1 then
		setPalette(currentLP[l+1])
	elseif (l==0) then
		setPalette(currentP)
	end
end

scene={} -- cut out num effects data?
overlay={} -- take the effects where id > 127

function loadscene(s)
	scene={}
	overlay={}

	scene[1] = s[1]

	for i=2,#s do
		sc = s[i]
		if sc[1] < 128 then
			table.insert(scene,sc)
		else
			table.insert(overlay,sc)
		end
	end
end

--- stream
st_data={}
function st_init()
end 

function st_g(h,ft)
    w=(60+math.sin(ft/5+h/5)*10)
    return {x=(w)*math.sin(h/3+ft)+120,y=(60-w)*(h%2+math.cos(h/3+ft))+60}
end

function st_update(ft)
    st_data={}
    local a,b,d
    for i=0,80 do
        a=st_g(i-1,ft)
        b=st_g(i,ft)
        d=st_g(i+1,ft)
        table.insert(st_data,{a,b,d})
    end
    
end

function st_draw(ft)
    local a,b,d, trp
    for i=1,#st_data do
        k=i-25
        trp=st_data[i]
        a=trp[1]
        b=trp[2]
        d=trp[3]
        tri(a.x,a.y+k,b.x,b.y+k,d.x,d.y+k,i/#st_data*15)
    end
end

function st_g2bork(h,ft)
    w=(40+math.sin(ft/5+h/5)*5)
    return {x=240*math.sin(h/3+ft),y=136*(h%2+math.cos(h/3+ft))}
end

function st_g2(h,ft)
    return {x=120+100*math.sin(h/10+ft),y=48+15*(h%2+math.sin(h/9+ft))+40*(math.cos(h/10+ft))}
end

function st_update2(ft)
    st_data={}
    local a,b,d

    for i=0,60 do
        a=st_g2(i-1,ft)
        b=st_g2(i,ft)
        d=st_g2(i+1,ft)
        table.insert(st_data,{a,b,d})
    end
    
end

function st_update3(ft)
    st_data={}
    local a,b,d

    for i=0,40 do
        a=st_g2bork(i-1,ft)
        b=st_g2bork(i,ft)
        d=st_g2bork(i+1,ft)
        table.insert(st_data,{a,b,d})
    end
    
end


function st_draw2(ft)
    local a,b,d, trp
    for i=1,#st_data do
        k=(i*bassfreq+ft)%30
        trp=st_data[i]
        a=trp[1]
        b=trp[2]
        d=trp[3]
        tri(a.x,a.y+k,b.x,b.y+k,d.x,d.y+k,(i/(#st_data/5)) * 15)
    end
end

function fsin(sfin)
    if sfin == math.huge then return sint[1] end
    return sint[(STSIZE*sfin//1)%STSIZE+1]
end

--- effect template
sea_data={}
function sea_init()
end
function sea_G(h,Y,ft)
    return {x=h*9+5*math.sin(ft+h),y=(h%2+math.sin(ft+h))*Y+5}
end
function sea_update(ft)
    sea_data={}
    local a,b,d,I,Y
    for i=-10,100,10 do
        I=15*fsin(i/13)
        Y=10+3*fsin(ft/30+I/5)
        for j=0,150 do
            a=sea_G(j-1,Y,ft)
            b=sea_G(j,Y,ft)
            d=sea_G(j+1,Y,ft)
            table.insert(sea_data,{a,b,d,I})
        end
    end
end
function sea_draw(ft)
    local a,b,d,I,trp,seac
    for i=1,#sea_data do
        trp=sea_data[i]
        a=trp[1]
        b=trp[2]
        d=trp[3]
        I=trp[4]
        seac=math.sin(i+ft/9)
        ii=i//10 * .8
        tri(a.x-I,a.y+ii,b.x-I,b.y+ii,d.x-I,d.y+ii,8+8*seac)
    end
end

--- bg1 effect -- diamond
bg1_data={}
function bg1_init() 
end
function bg1_update(ft)
end
function bg1_draw(ft)
    local start_x
    for y=0,135 do
        start_x = (math.abs(y-68)+ft)%40
        for i=-40,180,40 do
            line(120+start_x+i,y,120+start_x+40+i,y,i/40)
            line(120-start_x-i,y,120-start_x-40-i,y,i/40)
        end 
        --for i=280,120,-40 do
        --    line(start_x+i+ft%40,y,math.max(120,start_x+40-ift%40),y,i/40)
        --end 
    end
end
--- bg2 effect
bg2_data={}
function bg2_init()
end
function bg2_update(ft)
end

function bg2_line(x,y)
    -- go down from center
    local locy=math.abs(120-x)
    local period = y/136 * 20
    locy = locy + (locy%period-period/2)
    return locy
end
function bg2_draw(ft)
    for x=0,239 do
        for y=-145,145,10 do
            local locy = bg2_line(x,y+ft)
            line(x,y+locy-10,x,y+locy,y/10)
        end
    end
end
function bg2_draw2(ft)
    for x=0,239 do
        for y=0,145,10 do
            local locy = bg2_line(x,y+ft)
            line(x,y+locy-10,x,y+locy,y/10)
        end
    end
end
--- bg3 effect
bg3_data={}
function bg3_init()
end
function bg3_update(ft)
end
function bg3_draw(ft)
    local start_x
    for y=48,88,10 do
        start_x = bassfreq*math.cos(math.abs(y-68)+ft)
        for i=-130,130,40 do
            line(120+start_x+i,y+i+start_x,120+start_x+10+i,y-i-start_x,i/15)
            line(120-start_x-i,y-i-start_x,120-start_x-10-i,y+i+start_x,i/15)
        end 
    end
end

--- bg1 effect
bg4_data={}
function bg4_init()
end
function bg4_update(ft)
end
function bg4_draw(ft)
    for x=0,239 do
        for y=-145,5,10 do
            local locy = bg2_line(120-x,136-y+ft/3)
            line(x,y+locy-10,x,y+locy,20-y/30)
        end
    end
end
function bg5_draw(ft)
    for x=0,239 do
        for y=-145,145,10 do
            local locy = bg2_line(120-x,y+ft/3)
            line(x,y+locy-10,x,y+locy,20-y/10)
        end
    end
end

--- bg6 effect
bg6_data={}
function bg1_init()
end
function bg1_update(ft)
end
function bg6_line(x,y)
    -- go down from center
    local locy=x
    local period = (68-y)/136 * 1.1*y
    locy = locy - (locy%period-period/2)
    return locy
end
function bg6_draw(ft)
    for x=0,119 do
        for y=0,145,10 do
            local locy = bg6_line(x,y+ft)
            line(x,y+locy-10,x,y+locy,y/10)
            line(x,136-y-locy+10,x,136-y-locy,y/10)
            line(240-x,y+locy-10,240-x,y+locy,y/10)
            line(240-x,136-y-locy+10,240-x,136-y-locy,y/10)
        end
    end
end

function bg7_line(x,y)
    -- go down from center
    local locy=math.abs(120-x)
    local period = (136-y)/136 * 20
    locy = locy + (locy%period-period/2)
    return locy
end
function bg7_draw(ft)
    for x=0,239 do
        for y=0,145,10 do
            local locy = bg6_line(x,y+ft)
            line(x,y+locy-10,x,y+locy,y/10)
            line(x,136-y-locy+10,x,136-y-locy,y/10)
        end
    end
end

function bg8_draw(ft)
    for y=0,10 do
        local cyc = (y+(ft/10)%1)^2
        line(0,68,119,68-cyc,y)
        line(240,68,119,68-cyc,y)
        line(0,68,119,68+cyc,y)
        line(240,68,119,68+cyc,y)
    end
end

function bg9_draw(ft)
    local arr = "< "

    for y=0,10 do
        local tarr = ""
        local ay = math.abs(y-5)
        for i=1,1+5-ay do
            tarr = tarr..arr
        end
        fprint(tarr, 50-ft+ay*10, 10+y*10)
    end
end

function text1_draw(ft)
    fprint("RIFT", 120-(flength("RIFT")/2), 60)
end

function text2_draw(ft)
    fprint("BASS", 1, 80)
    fprint("IS THE", 1, 95)
    fprint("PLACE", 1, 110)
end

function text3_draw(ft)
    fprint("FEAR THE CLAW", 120-(flength("FEAR THE CLAW")/2), 40)
    fprint("IT HAS NO FEAR", 120-(flength("IT HAS NO FEAR")/2), 80)
end

function text4_draw(ft)
    fprint("BACK", 120-(flength("BACK")/2), 60)
end

function text5_draw(ft)
    fprint("FORTH", 120-(flength("FORTH")/2), 60)
end

--[[
--- bg1 effect
bg1_data={}
function bg1_init()
end
function bg1_update(ft)
end
function bg1_draw(ft)
end
--]]

--- clive
foo_data={}
function ssc_init()
    
end
function ssc_update(ft)
end
function ssc_draw(ft)
	--sync(35,3,false)
	spr(0,0,0,-1,1,0,0,16,16)
	spr(256,0,128,-1,1,0,0,16,1)
	spr(272,110,40,0,1,0,0,16,6)
end

scenes={
	--	time	bank        clear	shake   palette		effect
-- my test
--          {640,	            {0,0},	{1,0},  {2,15},	{55},	{41} 				},
--            {640,	{3,0,0},            {0,0},	{1,0},  {2,15}, {55},	{132,2},	{152} 				}
--        {256,	           {0,0},	{1,0},  {2,27},		{15} 				}
--        {256,	{3,35,2},    {0,0},	{1,0},  {2,14},		{51},           {132,1},    {143}				}
--        {256,	{3,0,0},            {0,0},	{1,0},  {2,15},		{15}, {132,2},{161} 				}
--        {256,	{3,35,2},   {0,0},	{1,0},  {2,14},		{51},           {132,1},    {143} 				},
--		{256,	{3,35,2},    {0,0},	{1,0},  {2,16},		{59},           {142} 				}
--[[]]   
        {0},
		{128,	{3,35,1},   {0,14},	{1,0},  {2,25},		{21,1200,-1} 				},
		{64,	            {0,0},	{1,0},  {2,1},		{50},           {20,15} 				},
		{64,	{3,35,2},   {0,0},	{1,0},  {2,14},		{51},           {132,1},    {143} 				},
		{128,	            {0,0},	{1,0},  {2,16},		{59},           {142} 				},
		{64,	{3,0,0},    {0,0},	{1,0},  {2,19},		{34,0} 				},
		{64,	            {0,0},	{1,0},  {2,20},		{34,500},       {132,2},    {140} 				},
		{64,	            {0,0},	{1,0},  {2,22},		{50},           {34,1000}		},
		{64,	            {0,0},	{1,0},  {2,23},		{57},{40,200} 				},
		{64,	            {0,0},	{1,0},  {2,24},		{40,50},        {31,.1} 				},
		{64,	            {0,0},	{1,0},  {2,16},		{51},           {31,.1}, 			},
		{128,	            {0,0},	{1,0},  {2,15},		{15}, {161} 				},
		{64,	            {0,0},	{1,0},  {2,18},		{55} 				},
		{64,	            {0,0},	{1,0},  {2,17},		{55},           {132,15},   {150} 				},
		{32,	            {0,0},	{1,8},  {2,20},		{45,100} 				},
		{32,	            {0,0},	{1,8},  {2,20},		{45,-75}, {162} 				},
		{32,	            {0,0},	{1,0},  {2,19},		{45,75}, {163} 				},
		{32,	            {0,0},	{1,0},  {2,18},		{45,200} 				},
		{64,	            {0,0},	{1,0},  {2,20},		{54},           {132,16},   {151} 				},
		{64,	            {0,0},	{1,0},  {2,24},		{60}, {33} 				},
		{64,	            {0,0},	{1,0},  {2,18},		{32,1} 				},
		{64,	            {0,0},	{1,0},  {2,15},		{41} 				},
		{256,	            {0,0},	{1,0},  {2,1},		{35,0,0},         {141}				},
		{64,	            {0,0},	{1,0},  {2,19},		{57},{33} 				},
		{64,	            {0,0},	{1,0},  {2,17},		{51}, 			{132,22},	{150}	},
		{64,	            {0,0},	{1,0},  {4,15,4,64},{51},{160} 				},
		{64,	{3,35,3},   {0,0},	{1,0},  {4,4,27,64},{25} 				},
		{128,	{3,35,3},   {0,0},	{1,0},  {2,27},		{25} 				},
		{64,	{3,35,3},   {0,0},	{1,0},  {4,27,4,64},{25} 				}
--]]
--[[
        {64,	{0,0},	{1,0},  {2,21},		{15} 				},
		{64,	{0,0},	{1,0},  {2,22},		{32} 				},
		{64,	{0,0},	{1,0},  {2,23},		{33} 				},
		{64,	{0,0},	{1,0},  {2,24},		{45,100} 				},
		{64,	{0,0},	{1,0},  {2,25},		{41} 				},
		{64,	{0,0},	{1,0},  {2,26},		{32} 				},
		{64,	{0,0},	{1,0},  {2,14},		{45,100} 				},
		{64,	{0,0},	{1,0},  {2,15},		{41} 				}
--]]
} 

-- scene {duration in beats, num effects, [effect, effect param ..], .. }
-- effect {id, num parameters}
effects = {
	{clearscreen = 0, 1},		-- clear screen, 1 param (color)
    {shake = 1,1},              -- screen shake
	{palettebg = 2,1},			-- change palette (which palette)
    {setbank = 3,2},            -- set the memory bank for sprites+tiles
	{palettefadebg = 4,3},		-- change palette (start,end palettes,beats)

	-- 3d effects/scenes
    {rollercoaster = 14,0},     -- rollercoaster
    {rollercoaster2 = 15,0},     -- rollercoaster

	-- image effects
    {highcoloureffect = 20,1},	-- example hicolour
    {highcolourgroup = 21,2},	-- fade in/etc RiFT
    {fairlightdissolve = 22},    -- disolve an image into fluid particles
    {wordslice = 23,0},
    {fairlightnodissolve = 24},    -- disolve an image into fluid particles
    {sinclair = 25},

	-- random shite
    {cloudexplosion = 30,0},	-- exploding clouds
    {circlestouching = 31,1},	-- circles touching
    {triintri = 32,1},			-- triangles in triangles
    {tenticles = 33,0},			-- circles touching
    {tenticles_line = 34,1},			-- circles touching
    {triintri = 35,1},			-- triangles in triangles
    {cloudrotation = 36,0},	-- rotating clouds
    {triintri2 = 37,1},			-- triangles in triangles

    {streamer = 40,0},          -- streamer
    {streamer2 = 41,0},          -- streamer
    {streamer3 = 42,0},          -- streamer

    {sea = 45,1},               -- sea

    {bg1 = 50,0},               -- bg1
    {bg2 = 51,0},               -- bg1
    {bg3 = 52,0},               -- bg1
    {bg4 = 53,0},               -- bg1
    {bg5 = 54,0},               -- bg1
    {bg6 = 55,0},               -- bg1
    {bg7 = 56,0},               -- bg1
    {bg8 = 57,0},               -- bg1
    {bg9 = 58,0},               -- bg1
    {bg2a = 59,0},               -- bg1

    {text3=60,0},

    {palettefg = 132,1},		-- change palette (which palette)
    {credits = 140,0},
    {wordslice = 141,0},
    {fairlightdissolve = 142},    -- disolve an image into fluid particles
    {fairlightnodissolve = 143},    -- disolve an image into fluid particles
    {cloudexplosion = 150,0},	-- exploding clouds
    {cloudrotation = 151,0},	-- exploding clouds
    {rollercoaster = 152,0},     -- rollercoaster

    {text1=160,0},
    {text2=161,0},
    {text4=162,0},
    {text5=163,0},

	{overlay = 210,2}			-- overlay, (sprites id, text id)
}

function render()
	for i=2,#scene do
		fect = scene[i]

		if fect[1] == 0 then
			cls(fect[2])
		elseif fect[1] == 1 then
            if fect[2] == 1 then
                --shake the screen a bit
                offsetx = last_ox + (2*math.random()-1)
                offsety = last_oy + (2*math.random()-1)
                poke(0x3ff9,offsetx)
                poke(0x3ffa,offsety)
                last_ox = offsetx
                last_oy = offsety
            else
                last_ox = 0
                last_oy = 0
                offsetx = 0
                offsety = 0
                poke(0x3ff9,offsetx)
                poke(0x3ffa,offsety)
            end
		elseif fect[1] == 2 then
			currentP=palettes[fect[2]]
		elseif fect[1] == 3 then
			sync(fect[2],fect[3],false)
		elseif fect[1] == 4 then
			local ratio = mscurrent / (fect[4] * msperbeat)
			if ratio > 1 then ratio = 1 end
			currentP=mixPalette(fect[2],fect[3],ratio)   
        elseif fect[1] == 14 then
            rc_update(mscurrent/(bassfreq/4))
            rc_draw(mscurrent/(bassfreq/4))
        elseif fect[1] == 15 then
            rc_update2(mscurrent/(msperbeat/2))
            rc_draw(mscurrent/(msperbeat/2))
			--CMdra(ts/40)		
        elseif fect[1] == 20 then
			hce_update(mscurrent/(msperbeat/8))
			hc_group_draw(mscurrent/100,fect[2])
        elseif fect[1] == 21 then
			hc_group_update(mscurrent/10,fect[2])
			hc_group_draw(mscurrent/10,fect[3])
        elseif fect[1] == 22 then
			fd_update(mscurrent/10)
			fd_draw(mscurrent/(msperbeat*128))
        elseif fect[1] == 23 then
			ws_update(mscurrent/10)
			ws_draw(mscurrent/10)
        elseif fect[1] == 24 then
			fd_draw(mscurrent/10)
        elseif fect[1] == 25 then
			ssc_draw(mscurrent/10)
        elseif fect[1] == 30 then
			ce_update(ts/100)
			ce_draw(ts/100)
        elseif fect[1] == 31 then
			ct_update(ts/100,fect[2])
			ct_draw(ts/100)
        elseif fect[1] == 32 then
			tit_update(mscurrent/10)
			tit_draw(mscurrent/10,fect[2],0)
        elseif fect[1] == 33 then
			tts_update(mscurrent/10)
			tts_draw(mscurrent/10)
        elseif fect[1] == 34 then
			tts_update2(mscurrent/10,fect[2])
			tts_draw(mscurrent/10)
        elseif fect[1] == 35 then
			tit_update(mscurrent/10)
			tit_draw(mscurrent/10,fect[2],mscurrent/(msperbeat*89))
        elseif fect[1] == 36 then
			ce_update2(ts/100)
			ce_draw2(ts/100)

        elseif fect[1] == 40 then
			st_update(mscurrent/fect[2])
			st_draw(mscurrent/fect[2])
        elseif fect[1] == 41 then
			st_update2(mscurrent/400)
			st_draw2(mscurrent/400)
        elseif fect[1] == 42 then
			st_update3(mscurrent/500)
			st_draw2(mscurrent/500)
        elseif fect[1] == 45 then
			sea_update(mscurrent/fect[2])
			sea_draw(mscurrent/fect[2])
        elseif fect[1] == 50 then
			bg1_draw(mscurrent/bassfreq)
        elseif fect[1] == 51 then
			bg2_draw(mscurrent/bassfreq)
        elseif fect[1] == 52 then
			bg3_draw(mscurrent/bassfreq)
        elseif fect[1] == 53 then
			bg4_draw(mscurrent/bassfreq)
        elseif fect[1] == 54 then
			bg5_draw(-1000 + mscurrent/5)
        elseif fect[1] == 55 then
			bg6_draw(mscurrent/bassfreq)
        elseif fect[1] == 56 then
			bg7_draw(mscurrent/bassfreq)
        elseif fect[1] == 57 then
			bg8_draw(mscurrent/25)
        elseif fect[1] == 58 then
			bg9_draw(mscurrent/20)
        elseif fect[1] == 59 then
			bg2_draw2(mscurrent/bassfreq)
        elseif fect[1] == 60 then
			text3_draw(mscurrent/10)
		else
		end
	end
end
function rendero()
	for i=1,#overlay do
		fect = overlay[i]
		if fect[1] == 132 then
			currentOP=palettes[fect[2]]
		elseif fect[1] == 140 then
            crd_draw(beatcurrent//16)
        elseif fect[1] == 141 then
			ws_update(mscurrent/8)
			ws_draw(mscurrent/8)
        elseif fect[1] == 142 then
			fd_update2(mscurrent/(msperbeat*160))
			fd_draw(mscurrent/(msperbeat*160))
        elseif fect[1] == 143 then
			fnd_draw(mscurrent/10)
        elseif fect[1] == 150 then
			ce_update(ts/100)
			ce_draw(ts/100)
        elseif fect[1] == 151 then
			ce_update2(ts/100)
			ce_draw2(ts/100)
        elseif fect[1] == 152 then
            rc_update(mscurrent/20)
            rc_draw(mscurrent/20)
        elseif fect[1] == 160 then
			text1_draw(mscurrent/10)
        elseif fect[1] == 161 then
			text2_draw(mscurrent/10)
        elseif fect[1] == 162 then
			text4_draw(mscurrent/10)
        elseif fect[1] == 163 then
			text5_draw(mscurrent/10)
		else
		end
	end
end

-- debug timing

tt=1
ttt=1
tto=1
ts=0
te=0
to=0


mstime = 0
beattime = 0
mscurrent = 0
beatcurrent = 0
msstart = 0
beatstart = 0
msperbeat=0
scenecurrent=1
loop = 0

last_ox=0
last_oy=0

loading = 2
trackcurrent = 1
begin = 1
musicorder={2,0,1,3}

bassfreq = 0

function TIC()
    if (loading > 0) then
        --trace(loading)
        if loading == 2 then
            fd_init()
        elseif loading == 1 then
            -- reset bank
            --sync(0,0,false)
        end
        loading = loading - 1
        cls(0)
        print("loading",110,60,12)
    else

    -- check if music should play
	if playmusic == 1 then
		if begin == 1 then
			music(musicorder[trackcurrent],-1,-1,false)
			begin = 0
            elseif peek(0x13ffc) == 255 then 
                trackcurrent = trackcurrent + 1
                if trackcurrent > 4 then exit() end
                music(musicorder[trackcurrent],-1,-1,false)
			beatstart = 0--beatstart - beatcurrent
        else

		end 
        -- update timing (ms + beat)
    	mstime = time()-- use only ts later
    	ts=time()
    	beattime=(peek(0x13ffd)+loop*10)*64+peek(0x13ffe)
    	msperbeat=(1/peek(0x13e94))*1000
        if beatstart == 255 then beatstart=0 end
        beatcurrent=beattime - beatstart

	

		-- get bass frequency, assuming channel 1 is always the bass
		--bassfreq = (peek(0xff9c+18*2+1)&0x0f)<<8|peek(0xff9c+18*2+1)
		bassfreq=getFreq()

    else
        music()
    	if beatstart == 255 then beatstart=0 end
    	beatcurrent=beattime - beatstart
	end
    debug2="tc: "..trackcurrent.." bc: "..beatcurrent.." bs: "..beatstart.." bt: "..beattime

	-- if we are in the same scene, render
	if(beatcurrent >= scene[1]) then
		-- load new scene into scene/overlay
		if scenecurrent < #scenes then scenecurrent = scenecurrent +1 else exit() end
		loadscene(scenes[scenecurrent])
		-- update start timings
		beatstart = beattime
		beatcurrent = 0
		msstart = time()
		--reset activeScan
		activeScan = 0

        --reset camerashake
        last_ox=0
        last_oy=0
	end

    debug1="part "..scenecurrent

	mscurrent = mstime - msstart

	-- render
	render()

    to=time()
	end
end

paletteName={sweetie16 = 1,gray = 2,greengray = 3,black = 4}
sint={}
STSIZE = 1000
HSTS = math.floor(STSIZE/2)
QSTS = math.floor(STSIZE/4)
function init()
    math.randomseed(1337)

	local col
	-- precalc sine table
	for i=0,STSIZE do
		sint[i]=math.sin((i/HSTS)*math.pi)
	end

	-- make some palettes
	for i=0,16 do
		col=i*16
		gray[1+(i*3)]=col
		gray[1+(i*3)+1]=col
		gray[1+(i*3)+2]=col
	end

	table.insert(palettes,sweetie16)
	table.insert(palettes,gray)
	palspread(0,0,0,255,255,255,5)
	table.insert(palettes,currentP)
	currentP={}
	palspread(0,0,0,0,0,0,0)
	table.insert(palettes,currentP)
	currentP={}
	palspread(0,0,0,0,128,255,0)
	table.insert(palettes,currentP)
    currentP={}
    palmid(255,0,128)
	table.insert(palettes,currentP)
    currentP={}
    palmid(128,255,0)
	table.insert(palettes,currentP)
    currentP={}
    palmid(255,128,0)
	table.insert(palettes,currentP)
    currentP={}
    palmid(192,192,0)
	table.insert(palettes,currentP)
    currentP={}
    palmid(63,127,255)
	table.insert(palettes,currentP)
    currentP={}
    palmid(127,255,63)
	table.insert(palettes,currentP)
    currentP={}
    palmid(191,127,31)
	table.insert(palettes,currentP)
    currentP={}
    palmid(255,31,16)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x5d,0x27,0x5d)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0xb1,0x3e,0x53)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0xef,0x7d,0x57)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0xff,0xcd,0x75)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0xa7,0xf0,0x70)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x38,0xb7,0x64)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x25,0x71,0x79)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x29,0x36,0x6f)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x3b,0x5d,0xc9)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x41,0xa6,0xf6)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x73,0xef,0xf7)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x94,0xb0,0xc2)
	table.insert(palettes,currentP)
    currentP={}
    palmid(0x56,0x6c,0x86)
	table.insert(palettes,currentP)
    currentP={}
	table.insert(palettes,sinclair16)
  
	currentP=palettes[1]
	currentOP=palettes[2]

	-- init the effects
	font_init()
	ce_init()
	ct_init()
    tit_init()
    rc_init()
	tts_init()
    ws_init()

	-- unload timing from map

	loadscene(scenes[1])

end

init()


-- <TILES>
-- 000:fff0fff0fff3fff3fff3fff3fff7fff700c7f1c78ff7f1c7eff7fff3eff7fff0
-- 001:eff3fff0fff3fff3fff3fff3fff3fff7f100f1c7f100f1c7f100f1c7f100f1c7
-- 002:fff08ff7fff3eff7fff3eff7fff7fff7f1c7f100f1c7f100fff7ff70fff3ff70
-- 003:8ff7f100eff7f100eff7f100fff7fff0f1c7fff3f1c7fff3fff7fff7eff7f1c7
-- 016:fff7fff3f1c7f1c7f1c7f1c7fff7fff7eff7eff3eff7eff38ff78ff000000000
-- 017:f100f1c7f100f1c7f100f1c7fff7fff7eff7fff7eff7fff78ff7fff300000000
-- 018:fff3ff70fff0ff70f100f100fff7f100eff7f100eff7f1008ff7f10000000000
-- 019:eff7f1c78ff7f1c700c7f1c7fff7f1c7fff3f1c7fff3f1c7fff0f1c700000000
-- 032:e3000ff7f3000ff7f3000ff7f3000ff7000000c7e30000c7f30000c7f30000c7
-- 033:f100f100f1c7f100f1c7f100f1c7f100f1c7f100f1c7f100fff7f100fff3f100
-- 034:8ff7fff0eff7fff3eff7fff3fff7fff7fdd7f1c7fdd7f1c7fdd7f1c7fdd7f1c7
-- 035:8ff38ff0eff7eff3eff7eff3fff7fff7f1c7f1c7f1c7f1c7f1c7f1c7f1c7fff7
-- 048:f30000c7f30000c7f30000c7f300fff7f300fff3f300fff3f300fff000000000
-- 049:fff0f100fff3f100f1c7f100f1c7fff7f1c7eff7f1c7eff7f1c78ff700000000
-- 050:f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c700000000
-- 051:f1c7fff3f1c7fff3f1c7fff0fff7f100fff3f100fff3f100eff0f10000000000
-- 064:8ff38ff3eff7eff3eff7eff3fff7fff3f1c7f100f1c7f100f1c7f100fdd7f100
-- 065:8ff7f100eff7f100eff7f100fff7fff0f100fff0fff0fff0eff3fff0eff3f100
-- 066:f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7
-- 067:f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7f1c7fff7f1c7eff3fdd78ff0
-- 080:fdf7f100fdf7f100f9f7f100fff3f100fff7f100fff7f100ef77f10000000000
-- 081:8ff7f10000c7f10000c7f100fff7fff7fff7eff7fff7eff7fff38ff700000000
-- 082:f1c7f1c7f1c7f1c7f1c7f1c7fff7fff7eff7fff3eff7fff38ff7fff000000000
-- 083:fdd7eff3fdd7f1c7fdd7f1c7fff7f1c7eff7f1c7eff7f1c78ff3f1c700000000
-- 096:e1c7fff7f1c7fff7f1c7fff7f1c7fff7f1c700c7f1c78ff7fff7eff3eff7eff3
-- 097:8ff0ff00eff1ff10eff1ff10fff1ff10f1f10f10f9f10f10fdf10f10fff10f10
-- 098:fff0fff0fff1fff1fff1fff1fff1fff100f100f18ff18ff1eff08ff1eff08ff0
-- 099:f1f1fff1f1f1fff1f1f1fff1f1f1fff1f1f1f100f1f1ff30fff1fff0eff1fff0
-- 112:eff7fff08ff7f10000c7f100fff7fff7fff3fff7fff3fff7fff0fff700000000
-- 113:f7f10f10f3f10f10f1f10f10fff10f10fff00f10fff00f10ef300f1000000000
-- 114:ff308ff1f10000f1f10000f1fff1fff1fff1fff0fff1fff0fff1ff3000000000
-- 115:eff1fff18ff100f100f100f100f1fff100f1fff100f1fff100f1fff000000000
-- 128:8ff1ff30eff1fff0eff1fff0fff1fff1f10000f1ff300ef1fff00ef1fff00ef1
-- 129:8ff08ff0eff1eff3eff1eff3fff1fff3f1f1f1f3fff1f1f3fff1fff3eff0fff3
-- 130:000000000000000000000000000000000000000000000000cff00000eff00000
-- 131:00008f000000cf000000cf00c700c700e700c700e700c700e700e700e300e700
-- 144:fff10ef1f1f100f1f1f100f1fff100f1eff000f1eff000f18f3000f100000000
-- 145:fff1fff3f1f1eff3f1f100f3fff1fff3fff0fff0fff0fff0ef30ff3000000000
-- 146:eff00000ef7000000000c7000000e7000000e7000000e7000000e30000000000
-- 147:0000e7000000e300c700e300e700e300e700f300e700f300e300f10000000000
-- 160:e300ef70e300eff0e300eff0e300eff0e30008f0e3000ef0e3008f70e3008f70
-- 161:00000000000000000c0008100e0008300f0008708ff3eff0cff7fff1eff7fff3
-- 162:0000cf000000cf000000cf000000e7000000e7000000e7000000000000000000
-- 163:07e1000087e1000087e10000eff70000eff70000eff7000087e1000087e10000
-- 176:e300cf10e300c70000000000e300c700e300c700e300c700e300c70000000000
-- 177:eff7fff3cff7fff18ff3eff00f0008700e0008300c0008100000000000000000
-- 178:00000000cf000000cf000000cf000000e7000000e7000000e700000000000000
-- 179:87e10000eff70000eff70000eff7000087e1000087e1000087e0000000000000
-- </TILES>

-- <TILES1>
-- 000:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 001:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 002:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 003:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 004:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 005:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 006:ffffffffffffffffffffffffffffffdaffffd610fff80005fa3006aa7005ab73
-- 007:ffffffffffffffffffcaa88a620000000024555489abababca54444378455556
-- 008:ffffffffffffffffacffffff0049dfff10002affba71006fabab7003a537ba10
-- 009:ffffffffffffffffffffffffffffffffffffffffffffffffffffffff2fffffff
-- 010:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 011:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 012:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 013:fffffffffffffffffffffffffffffffffffffffffffffffcfffff950ffc71000
-- 014:fffffffffffffffffffffffaffffc820fda400007200027c0004adee17beedcd
-- 015:fffccffffc718fff50008fff00007fff69107fffec005fffe7006fffd3005fff
-- 016:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 017:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 018:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 019:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 020:fffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffd
-- 021:ffffffd3fffffb00ffff9007fff8008cff8009b4f9009b45b008b455006b4545
-- 022:009b83544ca44655c735655554555555555555555545555645a755568cd84557
-- 023:8755554887555649865565698655557986556498865555968555579485564875
-- 024:a46449b28456539c655554b9465639a445646b685654b86a6548a5a7555b5888
-- 025:05ffffff008fffff600bffffe704ffff9b10cfff6c705fff79b00dff77b50aff
-- 026:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 027:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 028:fffffffffffffffcffffffb0fffffc00fffff100ffff6007fffc004afff60078
-- 029:f700004910002aee0028a9bc06aa767c7b76776ab7677769767777696777776a
-- 030:deecccdddccccccecccccccecccccccddbcbcbdbccbcbcd9cbcbcbd5ccbbbcc2
-- 031:c0005ff690006f5060002300200000000000000a0000008e000005eb00001cdb
-- 032:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 033:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 034:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 035:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 036:fffffff3ffffff70fffffb00fffff106ffff8029fffd0077fff50384ffc00758
-- 037:04b5546a1b6448bc98349cdb944adccb54accccc4acb9bccabaaaaccba9aaaac
-- 038:dcd84556ccc94557bcda5557bccb5557bbcb6457bbcc6557bacc8457cbbd8457
-- 039:85555865755568567554875575557654755675476557655a6557639765674894
-- 040:63b76977489597785a588787a75978789497878757887878597787878878777a
-- 041:87b804ff788a01df878a20bf787b508f878c607f799b703f9979803f977a802f
-- 042:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 043:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 044:ffd00586ff900ba7ff503cb7ff105d97fc008ca6fb009ba8f702bb97f505bb86
-- 045:7777768b777767787777877677699777777896776779b866767aba9877789abc
-- 046:c99bbcb089abad8068bbbc50779bbc1076aaca0069bcc600acb73000a7200000
-- 047:00008dbb0001ccab0006daba000acaab003cbaba006caba7008baa86009b9a77
-- 048:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 049:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 050:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 051:fffffffffffffffffffffffffffffffffffffffffffffffffffffffdfffffff9
-- 052:ff60377bfd0067aaf70278b9f1058a99a0169a99403899990069a89802798989
-- 053:a9a9a9ab9a9a9a9aa9a9a9a99999999999999999999999999898999889899879
-- 054:dbbd9457ccad9557bcbcb5569cbbc7799adba65589c710009a500000a5000000
-- 055:6576595755658559566674976658478868945987036588780007978800049888
-- 056:8787789878788987878897877889787888878787887878788787878878788888
-- 057:7789800c7879800c8779801d787a703f8779703f787b602f888a503f887a302f
-- 058:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 059:fffffffffffffffffffffffffffffffffffffffffffffffdfffffffafffffff8
-- 060:f106ba96c008aaa99019a999603b9987306bb841009a51000150000000000000
-- 061:76768ba678986500bb83000063000001000000010000000000000017000017ae
-- 062:10000000000000000000000000000000000000001000000092100000b3110000
-- 063:01aaaa8602aa9a9803a999a904a9999903a99999039989890298989802998888
-- 064:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 065:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 066:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 067:fffffff4ffffffd0ffffffb0ffffff70ffffff50fffffd10fffffb00fffffa00
-- 068:0399889806898888178888882888888838878888487878786887878768777778
-- 069:9899977a89877999885137a48822179188633650787423008732320085133200
-- 070:7000000000000000000000000000000000000000000000000000000000000acd
-- 071:0000888700005978000049870000397800003887000039780000488790005878
-- 072:8788888788887878878787877878787887878787787878788787878778787877
-- 073:8789103f7898002f87a6004f77a4006f88a1008f7a70006f7a5000af8a0000bf
-- 074:fffffffffffffffffffffffffffffffffffffffffffffffffffffffdfffffffb
-- 075:fffffff4fffffff2fffffff3fffffb50fff93000c7100005100016aa0028aa75
-- 076:00000000000000000000006900027aa8038aa7549a9645568545655545555555
-- 077:0038ba8a49aa643ab9645569545655795555548755565486555556a355576891
-- 078:80000000500005a63003bff80009fff70008fff70008fff80007fffa000afffb
-- 079:0188888801898888007888880069787800588787003978770028877700077778
-- 080:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 081:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 082:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 083:fffff800fffff901fffff901fffff902fffff902fffff902fffff901fffff900
-- 084:7777777777777778877777777767676786767677776767677676667657666644
-- 085:7333410073233100742331007523310062323000634654007775560036631610
-- 086:0001dfff000cffff00afffff05ffffff0dffffff9fffffffcffffffc8ffffff3
-- 087:f9006877fb017877f8038777f3057767c0167676502867670057767602776666
-- 088:7777777677777777777777786777776976767686676767837676776066666820
-- 089:a70000cfa30001ff900004ff300007ff000009ff00000dff00003fff00007fff
-- 090:fffffff8fffffff6fffffff3ffffffd0ffffffb0ffffff80ffffff60ffffff30
-- 091:0089745502754655037555650565565505655555065556672656766537665555
-- 092:6555555555555567555566765667665576755555665555555555555556555555
-- 093:6677678077554860655558505655582055657710555577005555950056668400
-- 094:000dfffb003ffffd006fffff009fffff00cfffff01dfffff04ffffff07ffffff
-- 095:0005877700037777200177741000685250005742600037337000263290000633
-- 096:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 097:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 098:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 099:fffff900fffff900fffff900fffff900fffff900fffff900fffff800fffffb00
-- 100:4766632227675233166652330566532304756422026656540165655500565522
-- 101:2243253033331540333544703236668223566584456655766655657735555558
-- 102:5fffff901ffffc000bfff20008ff500805f80069027005950000496520039645
-- 103:0576666627666666976666668556566655656565565656566565656655555653
-- 104:6666750066676100666730005665000066600000661000005100000000000001
-- 105:0000cfff0003ffff0009ffff001fffff00afffff004544590000000034344310
-- 106:fffffd00fffffb00fffff900fffff702fffff303cfffd10406ffc005002fa006
-- 107:4765555556565555656555556555555565655565655557776555777756567778
-- 108:555555655555565655655655565686556549d5555649c6556548c6556548c645
-- 109:6556810055577000556750005653000065000000740000008400000074000003
-- 110:0affffff0dffffff2fffffff5fffffff8fffffffbfffffffdfffffffffffffff
-- 111:b0000552d0000463f2000175f5000156f7000056fa000036fc000026ff100005
-- 112:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 113:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 114:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 115:ffffff30ffffff60ffffffa0ffffffc0fffffff3fffffff7fffffffafffffffd
-- 116:0046632300265422001555540005555500036555000255550000555500004555
-- 117:3355555835555547555555565555555754555454554545555554555455455555
-- 118:5039645575864555c95455558545555554555555554545555555545555555545
-- 119:5555520055443457555557875555544455555555454545455555545455555555
-- 120:0134668878887766655444544555554555555457455554685555458855554788
-- 121:88a999984788788b788788658878864587886465788546568754655575465656
-- 122:30054026c4000036a80000464830004657500165575002315760000058400000
-- 123:6555677655567765556777755557787555567764155555581554546715554545
-- 124:5547c6555547c7455556c7455546c8455555c8455546c9455455c9454545ca45
-- 125:830000067300000a8300000b7300001f8300005f7300007f830005cf7304bfff
-- 126:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 127:ff400004ff700003ffa00002ffc00001fff20000fff60000fff90000fffd0000
-- 128:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 129:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 130:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 131:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 132:3000355560002655a0001554d0000566f2000498f7000288fa000078fd000059
-- 133:5555555555555555444444445656565688888888787878888888878877676765
-- 134:5555555555555555544454446666666666666666545200006462000055660000
-- 135:5555555555555555544454446666666666666666000000000000000000000000
-- 136:5554688755457975444697556668755666665555000455550003544500166675
-- 137:5565656556565555655555555555565555655555565555556555555544444444
-- 138:5740000058200000671000006700000076000000750000008400000073000000
-- 139:2554545426554566355455863655555545555554455555454555545545445677
-- 140:5455b9454555ba455454ba454554ab455454ab5545549c5555549b5556548c55
-- 141:8408ffff7404ffff7404ffff7501dfff7500dfff7600bfff76009fff67008fff
-- 142:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 143:ffff3000ffff6000ffff9000ffffc000fffff100fffff500fffff800fffffb00
-- 144:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 145:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 146:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 147:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 148:ff300047ff600018ffa00007ffc00005fff20003fff70002fffa0000fffd0000
-- 149:6676778588888886878886658877664586668854677887457888745558874555
-- 150:4557100045483000554760005546700055548300555476005555571055554840
-- 152:002bdcdb005aaaaa008aaaaa0356678905544443165555554555555555555555
-- 153:babaaaababcccddeaaa9999aabbcccbc4455678b554544395555546855555478
-- 154:9000000090000001700045004000bd014000db012000fa011002f9010006f901
-- 155:5466888758888887788787876878788878878787687878887887878778788888
-- 156:55548c6555548c6555648c7455557c6555646c7455458c64558886558cc63455
-- 157:67105fff58204fff57402dff58500fff57600cff46700aff558109ff558307ff
-- 158:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 159:fffffd00ffffff30ffffff60ffffffa0ffffffc0fffffff1fffffff5fffffff9
-- 160:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 161:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 162:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 163:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 164:ffff3000ffff6000ffffa000ffffd000fffff200fffff700fffffa00fffffd00
-- 165:4984555528555555155555550455555503655555025555550055555500465555
-- 166:5555567055555484555554775555554955555556554555546665555446555555
-- 167:0000000200000004000000153000002680000045850001555910026547700465
-- 168:6555555555555555555555555555555555555555555555555555555555555555
-- 169:5555548755555486555554845555558355555581555546705555576055554850
-- 170:0008f901000bf901000df901002ffa01006ff801008ff60100bff70100cff601
-- 171:7888779c7878678c7888678b7878688b7888778b7878687b7888778b7878688b
-- 172:9cc545558bc645558ad645558bc745559ad745559ad83555a9e8455599d83555
-- 173:548506ff54770265546700005548301355478798554687685554444655555554
-- 174:dfffffff0bffffff04ffffff00afffff302fffff600affff9201ffff87008fff
-- 175:fffffffcfffffff9fffffff4fffffff5fffffff5fffffff5fffffff5fffffff5
-- 176:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 177:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 178:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 179:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 180:ffffff20ffffff60ffffffa0ffffffc0fffffff2fffffff7fffffff9fffffffd
-- 181:0036555500165555001555550004555500036555000265550000555500004655
-- 182:5555555556775555568755555566555555545555555567655556878655567876
-- 183:5486005555494016555593005554593055554595455554595676755468777865
-- 184:5555555555555555565555530466555400356542700156448830366548701654
-- 185:5555574055554820555567105555670055547600433254003232620023334100
-- 186:02fb300005f7000208f702560bf504880df404982ff504886ff404978ff40588
-- 187:7888778a7878777a78877789887877bd8787859a787887668787888878787878
-- 188:a9e94555a9d94555b7e92344cbdc8876aaabcccb666667788887877778787878
-- 189:55555554555555555455555556544434cbbabaa988899aab7676666578888888
-- 190:68300dff487008ff559400ff4478007f6458500d744781067764950089746910
-- 191:fffffff5fffffff5fffffff5fffffff5fffffff5fffffff5dffffff55ffffff8
-- 192:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 193:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 194:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 195:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 196:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 197:3000365560002655a0001555d0000577f2000487f7000387fa000177fd000068
-- 198:5786676658774557677765577777776777777777777777777777777777777777
-- 199:8777777577777776777777767777777677777775777778657677755577555565
-- 200:5570056355720554548304644476046556a91265587301656200255510046655
-- 201:3333300023332000333330004323320064434552565655565555555555555557
-- 202:bff30487fff405888cd304870000058810000497720005888100047660000477
-- 203:8787878778787878878787877878787887888888787777776665666677787888
-- 204:8787878778787878878787877878787888888887666666666666777788888888
-- 205:8787878778787878878787877888888887777676666666667787888888787878
-- 206:8786486078884681878873868888855966666558676778798888888978787879
-- 207:0cfffffa05fffffd00bfffff203fffff700bffff800affff800affff700affff
-- 208:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 209:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 210:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 211:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 212:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 213:ff200058ff600028ffa00017ffc00006fff20004fff70003fff90001fffd0000
-- 214:7777777777777777777777777777777787777778877778857777872068785000
-- 215:7764664077665200777410158830000671000000000000000000000000000000
-- 216:0156555536655555655555556555555566555555166555550056655500046655
-- 217:5555555755555548555555575555555755555576555555755555548355555572
-- 218:6000049840000588200004870000058800000587000005880000058700000588
-- 219:8887878778787878878787877878787887878787787878788787878778788889
-- 220:8787878778787878878787877878787887878787787878888888888888776532
-- 221:8787878778787878878787877878787887878888888888778765421011000000
-- 222:87878789787878798787877a7888888a88888665653311000000000000000000
-- 223:800affff700affff900affff900affff400affff000affff000affff000affff
-- 224:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 225:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 226:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 227:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 228:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 229:ffff3000ffff6000ffffa000ffffc000fffff200fffff700fffff900fffffd00
-- 230:5973000037000000000000000000000000000000000000000000000000000000
-- 231:00000000000000000000000000000000000042000008ff0003cfffc06ffffffa
-- 232:0000146600000014000000000000000000000000000000000000000000000000
-- 233:6555567066655760135668500001351000000000000000000000000000000000
-- 234:0000059800000687000001100020000002c1000006d0000009e000000ce00000
-- 235:9898876565321000000000000000000000000000000000000000000000000000
-- 236:4210000000000000000000000000000000000000000000000000000000000000
-- 239:000affff000affff000affff000affff000affff000affff0009ffff000bffff
-- 240:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 241:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 242:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 243:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 244:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 245:ffffff20ffffff60ffffffa0ffffffc0fffffff2fffffffdffffffffffffffff
-- 246:0000002a000006df00009fff004dffff08ffffffcfffffffffffffffffffffff
-- 247:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 248:b0000000fc300000fff81000ffffc700ffffffd8ffffffffffffffffffffffff
-- 249:0000000000000000000000000000000040000000fb741001ffffda88ffffffff
-- 250:0fd000003fc000007fc00000afb00000dfc00000dfb00000ffb1579bffdfffff
-- 251:000000000000000000000000000000000000001303589cdfdfffffffffffffff
-- 252:0000000000000000000000000000246968bcffffffffffffffffffffffffffff
-- 253:0000000000000001002579cdbdffffffffffffffffffffffffffffffffffffff
-- 254:00000147358acfffffffffffffffffffffffffffffffffffffffffffffffffff
-- 255:8bcfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- </TILES1>

-- <TILES2>
-- 000:cccf0000cccff000cccff000cccff000cccff000cccff000cccff000cccff000
-- 016:cccff000cccff000cccff000cccff000cccff000cccff000cccff000cccff000
-- 032:cccff000cccff000cccff000cccff000cccff000cccff000cccff000cccff000
-- 048:cccff000cccff000cccff000cccff000cccff000cccccccccccccccccccccccc
-- 049:0000000000000000000000000000000000000000ccccccccccccccccccccccc0
-- 060:00000000000000000000000000000000000000000ccccccc0ccccccccccccccc
-- 061:0000000000000000000000000000000000000000cccc0000cccccc00ccccccf0
-- 064:dccccccc0ddddddd000ddddd0000000000000000000000000000000000000000
-- 065:ccccccc0dddddddddddddddd0000000000000000000000000000000000000000
-- 076:cccccccc0ddddddd00dddddd0000000000000000000000000000000000000000
-- 077:ccccccffddccccffddccccff00ccccff00ccccff00ccccff00ccccff00ccccff
-- 082:000000000000000000000000000000000000000000000000000000000000000c
-- 083:00000000000000000000000000000000000000000000000000000000cccccccc
-- 084:00000000000000000000000000000000000000000000000000000000cccccccc
-- 085:00000000000000000000000000000000000000000000000000000000cccccccc
-- 086:00000000000000000000000000000000000000000000000000000000cccccccc
-- 087:00000000000000000000000000000000000000000000000000000000cccccccc
-- 088:00000000000000000000000000000000000000000000000000000000cccccccc
-- 089:00000000000000000000000000000000000000000000000000000000cccccccc
-- 090:00000000000000000000000000000000000000000000000000000000cccccccc
-- 091:00000000000000000000000000000000000000000000000000000000cccccccc
-- 092:00000000000000000000000000000000000000000000000000000000cccccccc
-- 093:00ccccff00ccccff00ccccff00ccccff00ccccff00ccccff00ccccffccccccff
-- 098:00000ccc00000ccc00000ccc00000ccc00000ccc00000ccc00000ccc00000ccc
-- 099:cccccccccccccccccfddddddcffdddddcff00000cff00000cff00000cff00000
-- 100:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 101:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 102:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 103:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 104:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 105:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 106:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 107:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 108:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 109:ccccccffccccddffdddddddfddddd00000000000000000000000000000000000
-- 114:00000ccc00000ccc00000ccc00000ccc00000ccc00000ccc00000ccc00000ccc
-- 115:cff00000cff00000cff00000cff00000cff00000cff00000cff00000cff00000
-- 129:000000000000000000000000000000000000000000000000000000000ccccccc
-- 130:00000ccc00000ccc00000ccc000000dc0000000d0000000000000000cccccccc
-- 131:ccccccc0cccccccfccccccccccccccccdddddddd0ddddddd00000000cccccccc
-- 132:000000000000000000000000f0000000ff000000df00000000000000cccccccc
-- 133:00000000000000000000000000000000000000000000000000000000cccccccc
-- 134:00000000000000000000000000000000000000000000000000000000cccccccc
-- 135:00000000000000000000000000000000000000000000000000000000cccccccc
-- 136:00000000000000000000000000000000000000000000000000000000cccccccc
-- 137:00000000000000000000000000000000000000000000000000000000cccccccc
-- 138:00000000000000000000000000000000000000000000000000000000cccccccc
-- 139:00000000000000000000000000000000000000000000000000000000cccccccc
-- 140:00000000000000000000000000000000000000000000000000000000cccccccc
-- 141:00000000000000000000000000000000000000000000000000000000cccccccc
-- 142:00000000000000000000000000000000000000000000000000000000cccccccc
-- 143:00000000000000000000000000000000000000000000000000000000cccccccc
-- 144:0000000c0000000c0000000c0000000c0000000c0000000c0000000c0000000c
-- 145:cccccccccccccccccccfddddcccffdddcccff000cccff000cccff000cccff000
-- 146:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 147:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 148:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 149:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 150:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 151:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 152:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 153:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 154:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 155:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 156:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 157:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 158:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 159:ccccccccccccccccdddddddddddddddd00000000000000000000000000000000
-- 160:0000000c0000000c0000000c0000000c0000000c0000000c0000000c0000000c
-- 161:cccff000cccff000cccff000cccff000cccff000cccff000cccff000cccff000
-- 176:0000000c0000000c0000000c0000000000000000000000000000000000000000
-- 177:ccccccc0cccccccfccccccccdccccccc0ddddddd000ddddd0000000000000000
-- 178:000000000000000000000000f0000000ff000000df0000000000000000000000
-- </TILES2>

-- <TILES3>
-- 004:0000000000000000000000000000000000000000000000000000168600001758
-- 005:0000000000014444000554760045688a148888ba69888bbb88a8bbbb688b8bbe
-- 006:14400000566668688888b88b888bbbbbdbebebbbbebeeeeedbebebeebebeeeee
-- 007:0000000010000000b84000008b875000b8b88500bb8b8850edb8bbb5eeee8bbb
-- 008:0000000000000000000000000000000000000000000000000000000060000000
-- 020:0001126400010246000122660004266800144466001226460021656600024646
-- 021:88b88bbb8aab8bbe88b8bbdb888bbbbe88b8bbdb888bbbbb88bbbbdb688bbbbe
-- 022:ebeeeeeebebeeeeeeeeeeeeebebeeeeeebeeeeeebeeeeeeedbeeeefebeeeefef
-- 023:eeeeebbbeeeeeb8beeeeee88eeeeeee8eeeeeeebeeeeeeeefeeeeeeeefeeeeee
-- 024:800000008400000062900000661000006240000088500000e8e00000ebb00000
-- 035:0000000000000000000000000000000000000004000000060000000100000002
-- 036:0022646601024646001264660114464611226466210246466211646426024646
-- 037:88b8bbeb688b8bbe8688bbeb688bbbbe8888bbbb688abbbe6668bbbb5646588d
-- 038:ebebeeeebeeeeeefeeebeeeeeebeeeefeeebeeeebebeeeeededbebeebebdbede
-- 039:fefeeeeeefeeeeeefeeeeeeeeeeeeeeefeeeeeeeeeeeeeeeeefeeeeedeeeeeee
-- 040:ebb10000eb830000ebb40000ed850000ebb60000db886000d8666000b868b000
-- 051:0000000100000004000000040000000000000000000000000000000000000000
-- 052:621165742202464622212564211a2666604a4666262a66866426d58806229a68
-- 053:6565416868686826414445626448244688ba8542688b54668886662688664626
-- 054:bbbbb88b8bb288586228a8866bbd8644bb8de886bebbeb8bbde9e8bbbfb8ee8b
-- 055:bbeeeeee9bbbeeeebbeeeeeb4c8eeebf8debeeb6beeeeebeddeeeebebeeeebbe
-- 056:868b600066bbb0002beb90008ebe0000b6680000be6b0000bb6e00008ee50000
-- 068:02624b7600224646000044660000264600004464000024460000246400000426
-- 069:8665426666562626666462666666244b666462686646264b6462622846262216
-- 070:beebbedbbebe8bdedeebb8b8beeebb8bdeeeebebbebebdbebb86ebee6bbeeeed
-- 071:bbeee8ebbeeeedbdbbebebeb8bbebebbbbebebe8eeeeeeb8eeeeebe1beeebe80
-- 072:bee00000bee00000ee100000be00000010000000000000000000000000000000
-- 083:0000000000000000000000000000000000000000000000000000000000000001
-- 084:0000026400000426000001220000002400000021000001120011111111011211
-- 085:6442211244222216622242462222221222424262122426262122426402122646
-- 086:88b8ebee668bbbab86babb8868688b4868ebdbd8268bbeb6668bbbb6688b8b88
-- 087:dbebeb80bebebd60bbebeb108dbeb8008bebb8408bbb8cdc68b8cddd6888eddd
-- 088:0000000000000000000000000000000000000000ac500000ccccc500ddcdaccc
-- 089:00000000000000000000000000000000000000000000000000000000aa100000
-- 097:0000000000000000000000000000001400001544000045450000554500005745
-- 098:0000000000000112014121214414121244412121444412125444414155444412
-- 099:0001211011111101211111101111110121111110121111112121111012111111
-- 100:1011211601111219111111171111121811111117121112091121211111111200
-- 101:2111446811122668812166665712142895512226797712249695842299995872
-- 102:88b888888bbbb88888888886668868686686668e26468bdf4468acff2668dfff
-- 103:88bdfddd68affddd68fffdddcffffddefffffcedfffffcddfffffcedffffdcde
-- 104:dddccaccdddcccacedecccccdedeccaceddddcccdedddccceddddcccdeddddcc
-- 105:cccacaa3accccccccccccccccccccccccccccccccccccccccccccccccccccccc
-- 106:00000000cca50000cccccac9cccccccdcccccccdcccccccaccccccd5ccccccd9
-- 107:0000000000000000000000009d000000ade00000add00000cde00000cdde0000
-- 113:0003555500045757000455970004479700115597003417970041459500341591
-- 114:7554514157554444957554547957554497757555777979557799977579999977
-- 115:2121111112121111414121214412121254411121554414147551444477554545
-- 116:2111211011121110212121101212121021412140141214514341447545444774
-- 117:9599999d597779705597975049975900459797001959a0001777a00019791000
-- 118:dcc1ffff00001fff000011ff0000017f0000111f000359140010ffda000fdfef
-- 119:ffff9aedffff9cdeffff5addffff5aceffff49ddffff1ccedfff4add3fff1acd
-- 120:ededdcccdeddddccededddccdeddddcdeddddddcdeddddcceddddddcdeddddcd
-- 121:cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
-- 122:ccccccdacccccdcccccccccccccccd9cccccdc5ccccccd1dccccdc4ccccdcd5d
-- 123:dddd0000cdde0000dddde000ddded500dddded00dddddd00dddddd00cddddd00
-- 129:0011449001121493044121750411025904411145054210140571210104951400
-- 130:99a9a99759aaaa9959aacaa919acccaa47aacaca07accccc049acccc047ccccc
-- 131:9555555597575757a1977777a1997979c7a999a9ac599aaacc49aacacc99acac
-- 132:555457a5555559a9777579cc79797ac9a9979acaaa999acdaaa99acdaa999aad
-- 133:4599101054a51100a5a31100a7471400aa555000aa555000d9540000a7590000
-- 134:001dffff001fefef005effff01dfffee00fefefd01dfdfdf00fffeff03eeffcf
-- 135:fafd49ddeff93acdfff949cdfffa39cdfffa59ddfffc79cdfffd99cdfffd59cd
-- 136:dddddddcdddddddddddddddcdddddddddddddddcddddaddddddcccddddddcccd
-- 137:cdcccccccaccccccccdcccccaccccccccacccccccccccccc9ccccccadccdcccc
-- 138:ccccdd7ccccddd9dccccddcccccdddccccddd4ccaccdd9cdccdddacccccddacd
-- 139:dcdddd00cdddcd50dddcdd50ddccde30dcccdd50cccdde50d9ddeda09ccddec1
-- 144:000000000000000100000005000000950000049a000009790000954500077514
-- 145:117911101417711111435701595534305479a740ac15777599ac979759999aaa
-- 146:117acccc015acccc1049cccc0019accc0047cccc0015a7cc400495cc500599cc
-- 147:ccc5accaccacaccccccaaacaccccaccccccacacaccccaaaccccacacaccccacaa
-- 148:ca999a9caaa99a7daaa99a4caa999a1aaaa9993aaa999a3aaaa9a95aaa999a5a
-- 149:a5950000a9910000a9500000a9300000a7400000971000019500000075000003
-- 150:00ffffde03ffdfdf11fddedf03efdfcf30feffcf03dfff9f30eeffaf03dfef7f
-- 151:fffd79ccfffd5acdfffea9ccffffaacdfffdcaccfffecacdffffa9ccffff5acd
-- 152:dddcccccddddccccdddccccaddddccccdddccccaddcdcdccdddddcccddcdcccd
-- 153:ccdcdccccccdcccc9cdcdccca9cdccccc79cdcccaaaacdccc9a99cdcca9aadcc
-- 154:ccddcacacccd9aa5ccdcaa3acdcda799ccdca7cccdcd3cccccda9ca5cdc55c31
-- 155:9caaedcac9acddadaaccdaddadcacddeca7cdded5cdddddecccccdedccccaddd
-- 156:0000000050000000d0000000d0000000e0000000d0000000dc000000de000000
-- 160:000aa544001ca914004aca41000cca54000aca91000aaca40009cac50005acc9
-- 161:599799aa4a979aaa5aa799aa4aaa599a49ca759a19aca77945ccc97915acca77
-- 162:900499cc700479ac700179cc500459ac5001599c5004475c7001454a5001141c
-- 163:cccacacaccccacaacccccacaccccccaccccccacaccccccaccccccacaccccccac
-- 164:aaa9a97aaa99997aaaa9a779aa99997aaaa9a779aa99999aa9a9a7aaaa9a99aa
-- 165:7500000075000003910000007000000391000000710000035110000010000007
-- 166:35deff7d0ddedf5c3fddfeaa0faddfc93eddefc93fdeddacdfcdfdaaffffdf9c
-- 167:ffff5accdfff59cdfefd99ccdffe59ccdefd97ccdfff97cddffec5ccdfffa5cc
-- 168:dddcdccccdcdcdccdcdcdccccdcdcdcddcdccccccdcdccccdcdccccccdcccccc
-- 169:caaa9cdcccac9ccdccaaaccccaacaaaccccaa99accaca99ccccaacdcccaccdcc
-- 170:ccc04a5accc4109accc015aaacc417acaac149caccc13aa9ccc04aa5cca01954
-- 171:cccacdddccc9cdddca99dddd997ccddd759cdddd59adcddd9accdddc1acdcddd
-- 172:dd400000ddd00000ddd00000ddde0000dddd0000ddddd000dddcd700ddcccd00
-- 176:0004caca0004accc0001aacc35359acc977577aa441114591000001103111101
-- 177:549ccca7957cccaaa9aacaa7aa9a9a9599999793ca9957517acaa550049caca9
-- 178:5001411a3001110c1001111a0001110c0001111a0001110a0000111a31001107
-- 179:cccccccad415799a0000000000000000001000000055cdcf0000101000000000
-- 180:aaa9a9caaaaaa9a9001000100100000000000000d50000001000000000000000
-- 181:0000000700000004100010000100000100001010000100010000001000000101
-- 182:fcfced5afcdeef7a311111110103030310301030030101013010101001010301
-- 183:fffea5ccefee94ad113111110303130110101030010303013010103001010303
-- 184:dcdcccccddcccccc111111111103111111113130030301033030301003030303
-- 185:ccccdccaccacacac11355ccc11173ccd113339dc011539aa313355970303349a
-- 186:aac01010acc00000aca00000ca900000c99000009a9000019770000197540003
-- 187:09ccddcc09acddad19ccdccd19addccd479accca377757445551115754157acc
-- 188:dcdcdcd0cdcdddddddddeddccdcdcdccccca9aca157aaa9caaaaccdccc99799c
-- 189:000000000000000000000000c0000000d0000000c0000000d1000000d0000000
-- 192:979513309aaaa9349745caaa777999a9779799a9599759995454559515455755
-- 193:1017cccc17007ccc07a01aca105c3caa701149a099311551759542445a264446
-- 194:a11111119111010150d01010003001000000001000000100448bdd505bbeeee1
-- 195:000000000000000000000000000000000000000000f000ae0033303300333013
-- 196:0000000000000101000000000000000000000000790955303503333019073500
-- 197:00000000010101010000001000000000000000001300030031300010c3300cd3
-- 198:1010303001010103101010100000000000000000008600ed00000050013c3073
-- 199:103030100101030330103010000000000000000000000000000a0003530c3700
-- 200:31303030030303013030303000000000000010100000dfd0dad0cdd073103539
-- 201:313351ca030333ac303171aa0000519a000011a90000f1de0000f1dd0000f2bd
-- 202:c9355147aa011455a9001144a7001111aaca75ccbebe5dddebede4ddbebdbe9d
-- 203:99aac50057a7709a5573559a15ca379cccdcdccccccdddcddddcededddddcedd
-- 204:0037510199999a94aaccccdcaccccdcdcaccccdccdddcccddcdcdcdcddcdcdcd
-- 205:ac00000019700000c5c00000ddcd0000dddc0000cddd0000dcdd0000cdcd0000
-- 208:4455555545555514545490154549001855900015710001150000001400000014
-- 209:9464646494242646824242669222244a9122446b9122466b7021446840124666
-- 210:8acdeee08dbeeee1bbeeeee0beeeeeb1dbebbbe0bebdbeb0bbbebb508bbede00
-- 211:0000101000000000000010000000043000003aa0000010000000000000000300
-- 212:3301311000021000010001400c53091319c30139000000000000000000000001
-- 213:33300133460006620040000130c3350c70535307000000000010000000031000
-- 214:0035703106600046100010003301733033003130010001002000000011000400
-- 215:5303331000042000000000000333033307330331030303131000050000100013
-- 216:3330339710000200000000003033100390d37109301313030061000400011000
-- 217:0000f48a0000f88b0000fb880300ee683300f8443506f7220008f322000be312
-- 218:bbebbb6dbeeeedb4bbebeeb08baebee1688beee9266bbeee246beeee2248beee
-- 219:ddedededdededddecddddddd0ddddddd04eddddd00addddd101ddddd1107dddd
-- 220:eddddddddeddddddddddeddddddddddddcddddddddcddddddddcddddddddcddd
-- 221:dcdd0000ddcd0000dcdc0000cdcc0000dcdc0000cdcc0000dcdc0000cccc0000
-- 224:0000001110000001000000000100000000000000000000000000000000000000
-- 225:441166691412268d111266bb011646be000266bb0006268d0004648b0006268d
-- 226:edbbea10eebdb200eee84000eed70000eee40000bebd0000eeeb0000deeb1000
-- 227:00000c430000033300000000000000000133300303cc10090010100000000006
-- 228:00c5509301173013010000100000000031003030330093301000335040004000
-- 229:570c335097033c100000000000000000003000000d3301330173003706400111
-- 230:c35007311ca00a9c0000000000000000001000001073130f50aad30300120000
-- 231:00733033003950030000000000100001100010003330f331dc503cc000000000
-- 232:33093370730337300000003011021000000000000759003c0353003d00000002
-- 233:3348d1023533c0001011c00008b710002b7310009c310000dc31100023000101
-- 234:226688de1246268e00486688012abeee126addfe126defee22bbeeeb1bbeeeda
-- 235:a000eddde000addde0008dede101aedde106cdedb101de702071da000052d400
-- 236:dddddcccddddddcddddddcdcddca59aada000000000000000000000000000000
-- 237:dcca0000ccaa0000caa00000a700000000000000000000000000000000000000
-- 241:0002626800062648000022660000222600000226000000020000000000000000
-- 242:edeea000beeea100bbebdb548bbebebe8abbbbeb6b8bbbbb6688868800262666
-- 243:00000000000000002048bb40bebeeebbebeddbbbbbbb8bbb88babbb88bbb8864
-- 244:000000000000000010001000bdbdb400ebdbbb10bbbb8b008661100011000000
-- 247:0000000000000000000000000000000000000086000000880000006600000001
-- 248:000000280000016e01ba408a08bdeeb326bbbbee66666bbe8662668812262226
-- 249:830011127300140670001149110005bdebe9abeebebabeeeb8bbeeed8bbeeebb
-- 250:8beefee3aeeeedb1ddeedb00eeee8000eeeb0000eeb00000eb400000b1000000
-- 251:1514d00001040000000000000000000000000000000000000000000000000000
-- </TILES3>

-- <SPRITES>
-- 000:0000000000cccccc0ccccccc0ccccccc0ccccccc0cccccee0cccccee0cccccef
-- 001:00000000cccccccccccccccccccccccccccccccceeeeeeeeeeeeeeee00000000
-- 002:00000000cfccccf0cfcccce0eccccce0eccccce0eccccce0eccccce00ccccce0
-- 004:000000000ccccccc0ccccccc0ccccccc0ccccccc0feeeeee00fecccc00cccccc
-- 005:00000000ccccccfccccccccfcccccccfcccccccceeeccccccccccccccccccccc
-- 006:00000000ccccccf0cccccce0cccccce0fccccce0fccccce0eccccce0eccccce0
-- 007:00000000000ccccf000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc
-- 008:00000000000fcccc00cccccc0fcccccceccccccceccccceeecccccccefcccccc
-- 009:00000000cccccccccccccccccccccccccccccccceeeeeeeeccccceeecccccccf
-- 010:00000000f0000000e0000000e0000000e0000000e0000000e000000000000000
-- 016:0ccccce00ccccce00ccccce00ccccce00ccccccc0fcccccc00cccccc00fecccc
-- 017:00000000000000000000000000000000cccccccccccccccccccccccccccccccc
-- 018:0ccccce00ccccce00ccccce00cccccef0cccccccffcccccce0cccccce0fecccc
-- 019:00000000000000000000000000000000cccccccccccccccccccccccccccccccc
-- 020:00cccccc0ccccccc0cccccee0ccccceffccccccccfcccccccfccccccccfccccc
-- 021:cccccccccccccccceeeccccc000cccccccccccccccccccccccccccccccccccce
-- 022:ecccccececccccececccccececccccececccccccefcccccce0cccccce0fecccc
-- 023:cc0cccccccfcccccccecccccccecccccccccccccccccccccccccccccccccccce
-- 024:e0cccccce0fecccce00eeeeee000feeeeccccccceccccccccccccccccccccccc
-- 025:cccccccfcccccccceeeccccceeecccccccccccccccccccccccccccccccccccce
-- 026:00000000f0000000e0000000e0000000e0000000e0000000e0000000e0000000
-- 032:000eeeee0000feee000000000000000000000000000000000000000000000000
-- 033:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 034:e00eeeeee000feee000000000000000000000000000000000000000000000000
-- 035:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 036:eefeeeeeeeefeeee000000000000000000000000000000000000000000000000
-- 037:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 038:e00eeeeef000feee000000000000000000000000000000000000000000000000
-- 039:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 040:eeeeeeeefeeeeeee000000000000000000000000000000000000000000000000
-- 041:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 042:e0000000f0000000000000000000000000000000000000000000000000000000
-- 050:000000000000cccc00cccccc00cccccc0ccccccc0cccccee0cccccee0cccccef
-- 051:00000000ccccccc0cccccccccccccccccccccccceeeccccceeeccccc000ccccc
-- 052:000000000000cccc00cccccc00cccccceccccccceccccceeeccccceeeccccccc
-- 053:00000000cccccccccccccccccccccccccccccccceeeeeeeeeeeeeeeeccccf000
-- 054:00000000f0000000e0000000e0000000e0000000e0000000e000000000000000
-- 056:000000000cccccf00cccccef0cccccef0ccccccc0ccccccc0ccccccc0ccccccc
-- 057:00000000000000000000000000000000cccccf00ccccce00ccccce00ccccce00
-- 058:000000000cccccf00cccccef0cccccef0ccccccc0ccccccc0ccccccc0ccccccc
-- 059:00000000000000000000000000000000ccccccfccccccccfcccccccfcccccccc
-- 060:000000000ccccccc0ccccccc0ccccccccccccccccccccceecccccceffccccccc
-- 061:00000000ccccc000ccccccc0ccccccc0cccccccceeeccccc000ccccccccccccc
-- 062:00000000000000000000000000000000f0000000e0000000e0000000e0000000
-- 066:0ccccce00ccccce00ccccce00ccccce00ccccccc0ccccccc0ccccccc0fcccccc
-- 067:000ccccc000ccccc000ccccc000cccccccccccccccccccceccccccceccccccec
-- 068:eccccccceccccccceccccccceccccceeeccccceeccccccefcccccce0cccccee0
-- 069:cccce000cccce000cccce000eeeee000eeeee000000000000000000000000000
-- 072:0cccccee0cccccee0cccccef0cccccef0ccccccc0fcccccc00cccccc00fecccc
-- 073:eeeeee00eeeeee000000000000000000cccccccccccccccccccccccccccccccc
-- 074:0cccccee0cccccee0cccccef0ccccce0fccccce0fccccce0cfcccce0cfcccce0
-- 075:eeeccccceeeccccc000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc
-- 076:fccccccceccccccceccccccceccccceeecccccccefcccccce0cccccce0fecccc
-- 077:ccccccceccccccceccccceeeeeeeeeeecccccccccccccccccccccccccccccccc
-- 078:e0000000e0000000f000000000000000f0000000e0000000e0000000e0000000
-- 082:00eeeeee00feeeee000000000000000000000000000000000000000000000000
-- 083:eeeeeeeeeeeeeeef000000000000000000000000000000000000000000000000
-- 084:feeeeee0eeeeeef0000000000000000000000000000000000000000000000000
-- 088:000eeeee0000feee000000000000000000000000000000000000000000000000
-- 089:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 090:eefeeee0eefeeee0000000000000000000000000000000000000000000000000
-- 091:000feeee0000eeee000000000000000000000000000000000000000000000000
-- 092:e00eeeeee000feee000000000000000000000000000000000000000000000000
-- 093:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 094:e0000000e0000000000000000000000000000000000000000000000000000000
-- 096:000000000cccccf00ccccce00ccccce00ccccccc0ccccccc0ccccccc0ccccccc
-- 097:00000000000000000000000000000000cccccf00ccccce00ccccce00ccccce00
-- 098:000000000ccccccc0ccccccc0ccccccc0ccccccc0cccccee0cccccef0ccccccc
-- 099:00000000ccccccfccccccccfcccccccfcccccccceeeccccc000ccccccccccccc
-- 100:00000000ccccccccccccccccccccccccfcccccccfccccceeeccccceeecccccef
-- 101:00000000ccccc000ccccccc0cccccccfcccccccceeeccccceeeccccc000ccccc
-- 102:000000000cccccf00ccccce00ccccce00ccccccceccccccceccccccceccccccc
-- 103:00000000000000000000000000000000cccccf00ccccce00ccccce00ccccce00
-- 104:000000000fcccccc0ccccccc0cccccce0cccccce00eeeeee0fccccce0ccccccf
-- 105:000000000cccccccfcccccccccccccccccccccccccccceeeccccceeecccccef0
-- 106:00000000ccccccccccccccccccccccceccccccceeeeeeeeeeeeeeeee00000000
-- 107:00000000fccccf00fcccce00ccccce00ccccce00ccccce00ccccce00ccccce00
-- 109:00000000ccccccccccccccccccccccccccccccccccccceeecccccef0cccccccc
-- 110:00000000cccc0000cccccc00cccccc00cccccccfeeccccce00ccccceccccccce
-- 112:0cccccee0cccccee0cccccef0ccccce00ccccccc0fcccccc00cccccc00fecccc
-- 113:eeeeee00eeeeee000000000000000000cccccccccccccccccccccccccccccccc
-- 114:0ccccccc0ccccccc0ccccccc0ccccceefccccccccfcccccccfccccccccfccccc
-- 115:ccccccceccccccceccccceeeeeeeeeeecccccccccccccccccccccccccccccccc
-- 116:eccccce0eccccce0fccccce0fccccce0fccccce0fccccce0eccccce0eccccce0
-- 117:000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc
-- 118:eccccceeeccccceeecccccefeccccce0eccccccccfcccccccfccccccccfccccc
-- 119:eeeeee00eeeeee000000000000000000cccccccccccccccccccccccccccccccc
-- 120:0cccccce0cccccce0cccccce0ccccccefccccccefccccccecfcccccecfccccce
-- 121:ccccce00ccccce00ccccce00ccccce00ccccccccfccccccc0ccccccc0feccccc
-- 122:00000000000000000000000000000000ccccccc0cccccccfccccccceccccccce
-- 123:ccccce00ccccce00ccccce00cccccef0ccccccccfccccccc0ccccccc0feccccc
-- 124:00000000000000000000000000000000cccccccfcccccccccccccccccccccccc
-- 125:ccccccccccccccccccccccccccccceeeccccccccfcccccccfccccccccfcccccc
-- 126:cccccceecccccceecccceeefeeeeeee0cccccccfccccccceccccccceccccccce
-- 128:000eeeee0000feee000000000000000000000000000000000000000000000000
-- 129:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 130:eefeeeeeeeefeeee000000000000000000000000000000000000000000000000
-- 131:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 132:efeeeee0efeeeee0000000000000000000000000000000000000000000000000
-- 133:000feeee0000eeee000000000000000000000000000000000000000000000000
-- 134:eefeeeeeeeefeeee000000000000000000000000000000000000000000000000
-- 135:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 136:eefeeeeeeefeeeee000000000000000000000000000000000000000000000000
-- 137:00eeeeee000feeee000000000000000000000000000000000000000000000000
-- 138:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 139:00eeeeee000feeee000000000000000000000000000000000000000000000000
-- 140:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 141:efeeeeeeeefeeeee000000000000000000000000000000000000000000000000
-- 142:eeeeeeeeeeeeeeee000000000000000000000000000000000000000000000000
-- 144:0000000000000000000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc
-- 145:0000000000000000f0000000e0000000e0000000cccccccfccccccceccccccce
-- 146:0000000000000000000fcccc000ccccc000ccccc000ccccc0000eeee000fcccc
-- 147:0000000000000000cc0cccccccfccccccecccccccecccccceecccccececcccce
-- 148:0000000000000000cccccccccccccccccccccccccccccccceeeeeeeeeeeeeeee
-- 149:0000000000000000ccf00000ccf00000ce000000ce000000ee000000ee000000
-- 160:000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc000fcccc000fcccc
-- 161:ccccccceeeeeeeeeeeeeeeeeef000000e0000000cccccccccccccccccccccccc
-- 162:000ccccc000ccccc000ccccc000ccccc000cccccccfcccccccfccccccccfcccc
-- 163:cfcccccececccccececccccececccccececccccececccccccefcccccce0ccccc
-- 164:f000000000000000000000000000000000000000cccccccccccccccccccccccc
-- 165:0000000000000000000000000000000000000000c0000000cf000000ce000000
-- 176:0000fccc0000feee00000fee0000000000000000000000000000000000000000
-- 177:cccccccceeeeeeeeeeeeeeee0000000000000000000000000000000000000000
-- 178:cccfcccceeeefeeeeeeefeee0000000000000000000000000000000000000000
-- 179:ce0fecccee00eeeeee000fee0000000000000000000000000000000000000000
-- 180:cccccccceeeeeeeeeeeeeeee0000000000000000000000000000000000000000
-- 181:ce000000ee000000ee0000000000000000000000000000000000000000000000
-- </SPRITES>

-- <SPRITES1>
-- 000:fffffffffffffffffffffffffffffc83fffc6000fd700000a10004890001ada7
-- 001:fffffffffffdb974b841000000000025001468ac5799a876a977677766777777
-- 002:ffbbbbbe210000010000000066989875babeeeee757ccccb68bccccc77cccccc
-- 003:dfffffff248bffff00004cff410010afdda4000cccee8004ccbde600cccbec31
-- 004:ffffffffffffffffffffffffffffffffffffffffffffffffdfffffffbfffffff
-- 005:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 006:fffffffffffffffffffffffafffffff1ffffffc0ffffffc0ffffffb0ffffffc0
-- 007:fd17ffffb100afff00310cff06eb01df0dee802f1cede6041cdcde402cdccde2
-- 008:ffffffffffffffffffffffffffffffffffffffffffffffff6fffffff08ffffff
-- 009:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 010:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 011:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 012:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 013:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 014:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 015:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 016:005ce95709edc777ad888777d666777786777777767777777777777786777777
-- 017:7777777777777777777777777777777777777777777777777777777776777776
-- 018:769dcccc768ccbcc777ccccc768ccbcc769dbccc76bccbcc59ccbbcc9bcccbcc
-- 019:ccccde52ccccdc20ccccdb00cccbe900cccce700ccccc100ccce8000ccdc2000
-- 020:afffffffbfffffff9fffffff9fffffff9fffffff9fffffff9fffffff9fffffff
-- 021:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 022:ffffffc0ffffffb0ffffff80ffffff80ffffff80ffffff80ffffff80ffffff70
-- 023:2dccccdd4eeddcce4a78bdbc12104bcb033307cc133315cb033307cb33105ccb
-- 024:109fffffb00bffffea01cfffce801dffbce603ffbbcd405fbbbdd207bbbadc10
-- 025:ffffffffffffffffffffffffffffffffffffffffffffffffffffffff9fffffff
-- 026:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffda
-- 027:ffffffffffffffffffffffffffffffffffffffffffffffffffca65af7200007f
-- 028:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 029:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 030:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 031:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 032:a7677769ba877776bbbb9777989ba6766668a86777769aa977778aaa77769aa9
-- 033:a867677a9ba9a9bb6abbbbab7abaaaba9baaaaaaaaaaaaaa9a9a9a9aa9a9a9a9
-- 034:bbabbbccbababbcc9aababcc79baaabc9aaaaa9aaaaaaaa99a9a9a9ba9a9a99b
-- 035:ccd80000ccd20000cd900000dd400000cb000001c6000004b20000099000000c
-- 036:9fffffffbfffffffcfffffffcfffffffdfffffffffffffffffffffffffffffff
-- 037:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 038:ffffff40ffffff40ffffff40ffffff40ffffff40fffffd10fffffd00fffffc00
-- 039:7b79979c7dcd809c7cabaaab8bbabbba8baaaaaa9baaaaaa8baaaaaa9aa9a9a9
-- 040:bbbbbda0bab98ae9abb98cccbaabc840aaaba100aaaab100aaabb100a9aab002
-- 041:0bffffff10dfffff20bffd8400bb500000000016000047aa0169a97679a87677
-- 042:fffc8500c8400002000048ad039bca998acc7667967986686769977c7777a9bb
-- 043:0011008f69b2008fce80008fcb10008fd700008fc000009f7000008f0000008f
-- 044:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 045:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 046:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 047:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 048:67689a9a8899a999999977789997777689877777988777778888677788887777
-- 049:999a999a99999999999999998999999979998989789898987988888888888888
-- 050:9a99999c999999ab999999a9999998b6898989b5989899b2888889a188888990
-- 051:5000003f2000009f000000cf000004ff00000aff00001dff00007fff0000cfff
-- 052:ff939dffff100036fa000000f10198649006aaab203987781039787820079787
-- 053:ffffffff9bcfffff0002123431000000a999888876779aaa8545564487555665
-- 054:fffffd01fffffd0034344301000000027877788aaaccccba449dcda8549ccca8
-- 055:9a9a9a9a9aa9a9a99a999999a999999999999999989999998989898998989898
-- 056:9a9ab89ba9aacdc89a9aba989999a78999999878999999768989976798988777
-- 057:9867777767777777677777778677777777777777777777767778887877779999
-- 058:77689ac677779bb077689c507678ba006789c500789aa000898c500098aa0000
-- 059:000001bf000009ff00001fff00009fff0001ffff0009ffff001fffff009fffff
-- 060:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 061:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 062:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 063:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 064:8888888888888887787878788787878778787877888777776468787841455686
-- 065:7788888876888888777878788787878778767878776477778765687746855777
-- 066:888889808888899078787991878787a2787877a6777777897777776a77777776
-- 067:0004ffff000affff001fffff009fffff009ffffc0007862070000000b7100044
-- 068:1003987820008887100049782000188710000598000001880000006900000028
-- 069:8855576588755665787556658786556578875566878765667878655687888555
-- 070:558dcc98549ccc97558dcc98548ccc97557ccc87548ccc87547ddcab547aa998
-- 071:88888889888888888888887788888876777888779a978787aba7787877a77787
-- 072:8989877788888777788778777787789878888987878784107878800087789100
-- 073:7777898977789888777888889999999966555556000000000000000000000000
-- 074:88b400008aa000008b400000b900000072000000000000070000000f0000008f
-- 075:01ffffff09ffffff1fffffff8fffffffdfffffffffffffffffffffffffffffff
-- 076:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 077:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 078:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 079:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 080:4322234423333323333333333333333333333333333333333333333333333332
-- 081:2786476765695576321864773217717634578147357593062665860146657800
-- 082:6767677676767676676767677666667766677765777653104531000100002588
-- 083:7a86799b66999877676766427763100031000000001589605899779897645458
-- 084:60000007700000030000000000000000000000000000000010000000a4000000
-- 085:8878875697878788788888884998877604321100000000000000000000000000
-- 086:6777677888888887888764485320000700000007000000170000001800000017
-- 087:7997777778967777799777778896777779966767799676767986676779956666
-- 088:7778910077779100777792007777920067678200767692006766830066669301
-- 089:0000000000000000000000000000000000000000000000000000000079a9a9a9
-- 090:000000df000007ff00000fff00007fff0000dfff0007ffff002fffff98dfffff
-- 091:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 092:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 093:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 094:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 095:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 096:2333332342223334554433336565333355542333556433335555432355555444
-- 097:565659106555597446666bb92465676424554665346555644555555555555554
-- 098:0147897679a85455877755556788656567786556667875556778755656788655
-- 099:4556565465555555565555555555555555555555556565555556565565556565
-- 100:6a70000055992000554870005565610055556400655565105656672055654110
-- 101:0000000000000000000000000000000000000000000000000000007c000000ff
-- 102:000000180000002800000028000000380000003902583038cfff6038ffff2048
-- 103:79866666788565657986676779cbcbcc77888888877777778888888886767676
-- 104:6666840666659405666684059465840476658504886585048865760476658602
-- 105:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 106:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 107:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 108:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 109:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 110:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 111:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 112:5555555564555555555545455543333335333323353232341643235504544454
-- 113:5555445654546777554469685554587655453885545447954545468655555587
-- 114:6668874687666555765545565455656546565531555310005510000066200000
-- 115:5655566665656542565421004210000000000000000000000000000000000000
-- 116:5410000010000000000000000000000000000000000000000000000000000000
-- 117:000000cf000000df000000cf000000df000000cf000000df000000cf000005ff
-- 118:ffff1049ffff2058ffff1049ffff2058fffd0059fffb0079fffb0045fffb0164
-- 119:7777777788888888777777777777777788888888989888983444444433323232
-- 120:7776660188966600777566017777860088888700989897104444440032323200
-- 121:dfffffffdfffffffdfffffffdfffffffdfffffffcfffffffafffffffafffffff
-- 122:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 123:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 124:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 125:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 126:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 127:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 128:0455553402655554015555550055555500465555003555550016555500155555
-- 129:5555547855555378555554695555545855555548555555475555554655555555
-- 130:5850000056700000667100007583000085750000857700008658100087574000
-- 131:000000000000000000000000000000000000000000000017000039df006affff
-- 132:00000000000000000000006b00028cff05afffffcfffffffffffffffffffffff
-- 133:0017cfff49ffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 134:fffb14a9fffb0165fff90156fff70165fff70155fff70154fff80255fff60265
-- 135:8988888855555555565656565555555555555555556565655656555555555565
-- 136:8888891055554730565658305555574055554740555557505556575055655660
-- 137:9fffffff8fffffff6fffffff6fffffff5fffffff2fffffff1fffffff1dffffff
-- 138:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 139:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 140:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 141:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 142:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 143:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 144:0004555500036555000255550001555500004555000045550000455500016555
-- 145:5555555455555554555555555555555555555555555555555555555555555555
-- 146:7857500278567008686672055775840048857600478567004686582055875750
-- 147:7dffffffffffffffffffffffffffffffbfffffff8fffffff3fffffff0dffffff
-- 148:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 149:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 150:fff40255fff30265fff30355fff20365fff30355fff10365ffc00465ffc00354
-- 151:55455555555555555556565555555555554555565536c5353434cb7532325beb
-- 152:5655566055556670555556716565547243565573546555834655557563555575
-- 153:0cffffff0affffff0affffff08ffffff07ffffff05ffffff03ffffff01ffffff
-- 154:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 155:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 156:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 157:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 158:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 159:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 160:0004444400477777015899990057777700288878001788880005567800047555
-- 161:4444444487877777aaaabbbb7677777778887878878787878888787856778888
-- 162:4368576076886580bcd955838897758577678667878786577878874887878757
-- 163:0affffff07ffffff03ffffff00dfffff009fffff106fffff301fffff600bffff
-- 164:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 165:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 166:ffb00233ffc00233ffc00333ffb00333ff800333ff801333ff800333ff801332
-- 167:33316abe3331782933234111334552242355543b335565482455664345555554
-- 168:c8445566edb535769ddc845779dcd947d78ddc47ec78db579ec78d674bec6886
-- 169:00cfffff00bfffff008fffff207fffff204fffff402fffff500dffff600affff
-- 170:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 171:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 172:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 173:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 174:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 175:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 176:0003897700017888000157780000555600003655000036650000165500000565
-- 177:6655566788877555887888777788878845678888655566885655555665556554
-- 178:7888885655678875665556758887757578788886878787867888788755678887
-- 179:7008ffff8105ffff8401dfff7600bfff68007fff58203fff48400dff57700aff
-- 180:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 181:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 182:ff800334ff602555ff402654ff402653ff402655ff403555ff303667fd103797
-- 183:5555555565555555455776553577875445687766545776775555577776546777
-- 184:36cdc746538ddc74553adda45544cdb567646dc6778758e7777775b877778666
-- 185:6009ffff7006ffff7204ffff7300ffff6500bfff65009fff57009fff6700afff
-- 186:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 187:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 188:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 189:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 190:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 191:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 192:00000156300000036000000090000000b0000000d0000000f3000000f6000000
-- 193:5555555666555555156655550046655500025655000014650000002600000000
-- 194:5545577955655456555655555555556555555556555555556655565546655555
-- 195:667107ff648302ff558500cf557600af5568105f6558401f5648500c55567008
-- 196:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 197:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 198:fd003788fc004787fd003788fd004788fc004788f9005787f9004788f9005787
-- 199:7855677777746777677558777786578777874578768864567778755586788555
-- 200:7777774477777754777777547777865577776548767555695555557455555630
-- 201:77009fff7600afff85009fff8100afff60009fff2000afff00009fff0000afff
-- 202:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 203:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 204:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 205:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 206:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 207:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 208:fa000000fd800000fffb1000fffff500ffffff90fffffffcffffffffffffffff
-- 209:000000000000000000000000000000000000000040000000f8000000ffb20000
-- 210:0356555500146555000036650000015600000003000000000000000000000000
-- 211:5556810555658400555576006555770066555820256558500036576000015780
-- 212:ffffffffffffffffbfffffff8fffffff3fffffff0dffffff0affffff06ffffff
-- 213:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 214:f9015788f9016787f8015888f5016787f5026888f5026787f5026878f5027788
-- 215:8778874586788755876878658778888578688876877786408877410087510000
-- 216:5556640055663000565200006410000020000000000000000000000000000000
-- 217:00009fff0000afff0000bfff0000ffff0006ffff000bffff004fffff00cfffff
-- 218:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 219:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 220:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 221:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 222:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 223:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 224:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 225:ffff6000fffff910ffffffc4ffffffffffffffffffffffffffffffffffffffff
-- 226:00000000000000000000000080000000fb200000fff60000ffff9100fffffc40
-- 227:0000049400000034000000000000000000000000000000000000000000000000
-- 228:02ffffff00dfffff00cfffff00cfffff00cfffff00cfffff00cfffff00cfffff
-- 229:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 230:f2036887f0037630d1033000d0000000d1000000d0000000d1000000d0000000
-- 231:4100000000000000000000000000000000000000000000000000000000000001
-- 232:0000000000000000000000060000006f000008ff0003cfff029fffff9fffffff
-- 233:09ffffff6fffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 234:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 235:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 236:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 237:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 238:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 239:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 240:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 241:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 242:fffffff8ffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 243:00000000b2000000ff600000fffa1000ffffc500ffffff90fffffffdffffffff
-- 244:00cfffff00cfffff00cfffff00cfffff00cfffff00dfffff68ffffffccffffff
-- 245:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 246:d1000000d0000000d1000000d0000000d000006cd0007cfff74cfffffaafffff
-- 247:0000028f00018dff018fffff7cffffffffffffffffffffffffffffffffffffff
-- 248:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 249:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 250:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 251:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 252:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 253:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 254:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- 255:ffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff
-- </SPRITES1>

-- <SPRITES2>
-- 000:0ccccccc0ccccccccccccccccccccccccccccfddcccccffdcccccff0cccccff0
-- 001:cccccccccccccccccccccccfcccccccfdddddddddddddddd0000000000000000
-- 002:0cccc0000ccccf00cccccff0cccccff0cccccff0cccccff0cccccff0cccccff0
-- 004:cccccccccccccccccccccccccccccccc0ddddddd00dccccc0ccccccc0ccccccc
-- 005:ccccc0cccccccc0cccccccfccccccccfddcccccfcccccccfcccccccfcccccccf
-- 006:ccccc000cccccf00cccccff0cccccff0cccccff0cccccff0cccccff0cccccfcc
-- 007:00ccccc000cccccf00cccccf00cccccf00cccccf00cccccf00cccccfc0cccccf
-- 008:000ccccc0cccccccfccccccccccccccccccccdddccccccccfcccccccfccccccc
-- 009:cccccccccccccccccccccccfcccccccfdddddddfccccddddcccccc00ccccccf0
-- 010:00000000000000000000000000000000f0000000f00000000000000000000000
-- 011:0000000000000000000000000000000c0000000c0000000c0000000c0000000c
-- 012:00ccccccccccccccccccccccccccccccccccfdddccccffddccccff00ccccff00
-- 013:ccccc000cccccc00ccccccf0ccccccfcdcccccfcdcccccfc0cccccfc0cccccfc
-- 014:00ccccccccccccccccccccccccccccccccccfdddccccffddcccccccccccccccc
-- 015:cccccc00ccccccf0ccccccffccccccffddddddffdddddddfcc000000ccf00000
-- 016:cccccff0cccccff0cccccff0cccccccc0ccccccc0ccccccc00dccccc000ddddd
-- 017:000000000000000000000000ccccccc0cccccccfcccccccfcccccccfdddddddf
-- 018:cccccff0cccccff0cccccff0cccccccc0cccccccfcccccccf0dcccccf00ddddd
-- 019:000000000000000000000000ccccccc0ccccccccccccccccccccccccdddddddd
-- 020:cccccccccccccdddcccccd00cccccccc0cccccccfcccccccc0dcccccd00ddddd
-- 021:cccccccfddcccccf00cccccfcccccccfcccccccfcccccccfcccccccfdddddddf
-- 022:cccccfcccccccfcccccccfccccccccccfcccccccfcccccccf0dcccccf00ddddd
-- 023:cfcccccfcfcccccfcfcccccfcccccccfcccccccfccccccccccccccdcdddddddd
-- 024:f0dcccccf00dddddf0000000ccccccccccccccccccccccccccccccccfddddddd
-- 025:cccccccfddcccccf00cccccfcccccccfcccccccfcccccccfccccccdfdddddddd
-- 026:0000000000000000f0000000f0000000f0000000f0000000f0000000f0000000
-- 027:0000000c0000000c0000000c0000000c0000000c000000000000000000000000
-- 028:ccccff00ccccff00ccccff00cccccccccccccccccccccccccccccccc0ddddddd
-- 029:0cccccfc0cccccfc0cccccfcccccccfccccccfcccccccfcccccffcccdddffddd
-- 030:ccccccccccccccccccccfdddccccffddccccff00ccccff00ccccff00ddddff00
-- 031:ccff0000ccff0000ddff0000dddf000000000000000000000000000000000000
-- 032:00000ddd00000000000000000000000000000000000000000000000000000000
-- 033:dddddddd00000000000000000000000000000000000000000000000000000000
-- 034:f0000ddd00000000000000000000000000000000000000000000000000000000
-- 035:dddddddd00000000000000000000000000000000000000000000000000000000
-- 036:dd000ddd00000000000000000000000000000000000000000000000000000000
-- 037:dddddddd00000000000000000000000000000000000000000000000000000000
-- 038:f0000ddd00000000000000000000000000000000000000000000000000000000
-- 039:ddddddd000000000000000000000000000000000000000000000000000000000
-- 040:00dddddd00000000000000000000000000000000000000000000000000000000
-- 041:ddddddd000000000000000000000000000000000000000000000000000000000
-- 044:00dddddd00000000000000000000000000000000000000000000000000000000
-- 045:ddddf0dd00000000000000000000000000000000000000000000000000000000
-- 046:dddddf0000000000000000000000000000000000000000000000000000000000
-- 048:ccccc000cccccf00cccccff0cccccccccccccccccccccccccccccccccccccfdd
-- 049:000000000000000000000000cccc0000ccccf000ccccff00ccccff00ddddff00
-- 050:ccccc000cccccf00cccccff0cccccccccccccccccccccccccccccccccccccfdd
-- 051:000000000000000000000000cccc00cccccccc0cccccccfccccccccfddcccccf
-- 052:cccccccccccccccccccccccccccccccccccccdddcccccd00cccccccccccccccc
-- 053:cccc0000cccccc00ccccccf0cccccccfddcccccf00cccccfcccccccfccccccff
-- 054:0000000000000000000000000000000000000000f0000000f0000000f0000000
-- 056:0ccccc000cccccf00cccccff0ccccccc0ccccccc0ccccccc0ccccccc0cccccfd
-- 057:000000000000000000000000ccccc000cccccf00cccccff0cccccff0dddddff0
-- 058:0ccccccc0ccccccc0ccccccc0ccccccc0cccccdd0cccccd00ccccccc0ccccccc
-- 059:ccccc00cccccccc0cccccccfccccccccdddccccc000ccccccccccccccccccccf
-- 060:ccccccccccccccccccccccccfcccccccfcccccfdfcccccfffcccccfffcccccff
-- 061:ccccc000ccccccc0cccccccfccccccccdddcccccdddccccc000ccccc000ccccc
-- 062:0ccccc000cccccf00cccccfffcccccccfcccccccfcccccccfcccccccfcccccfd
-- 063:000000000000000000000000ccccc000cccccf00cccccff0cccccff0dddddff0
-- 064:cccccffdcccccff0cccccff0cccccccc0ccccccc0ccccccc00dccccc000ddddd
-- 065:dddddf000000000000000000ccccccc0cccccccfccccccccccccccccdddddddd
-- 066:cccccffdcccccff0cccccff0cccccff0cccccff0fccccff0fccccff0fddddff0
-- 067:ddcccccf00cccccf00cccccf00cccccf00cccccf00cccccf00cccccf000ddddf
-- 068:cccccccccccccccccccccdddccccccccfcccccccfcccccccf0dcccccf00ddddd
-- 069:ccccccffccccffffdddfffffccccccc0cccccccfcccccccfcccccccfdddddddf
-- 070:f000000000000000000000000000000000000000f0000000f0000000f0000000
-- 072:0cccccff0cccccff0cccccff0ccccccc00cccccc00cccccc000dcccc0000dddd
-- 073:ddddddf00000000000000000ccccccccccccccccccccccccccccccccdddddddd
-- 074:0ccccccc0ccccccc0cccccdd0cccccccf0cccccccfcccccccf0dccccdff0dddd
-- 075:cccccccfcccccfffddddffffccccccccccccccccccccccccccccccccdddddddd
-- 076:fcccccfffcccccfffcccccff0cccccfffcccccfffcccccfffcccccffffddddff
-- 077:000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc000ccccc0000dddd
-- 078:fcccccfffcccccfffcccccfffccccccccfcccccccfccccccccfdccccddffdddd
-- 079:ddddddf00000000000000000ccccccccccccccccccccccccccccccccdddddddd
-- 080:00000ddd00000000000000000000000000000000000000000000000000000000
-- 081:dddddddd00000000000000000000000000000000000000000000000000000000
-- 082:d0ddddf000000000000000000000000000000000000000000000000000000000
-- 083:0000dddd00000000000000000000000000000000000000000000000000000000
-- 084:f0000ddd00000000000000000000000000000000000000000000000000000000
-- 085:dddddddd00000000000000000000000000000000000000000000000000000000
-- 086:f000000000000000000000000000000000000000000000000000000000000000
-- 088:000000dd00000000000000000000000000000000000000000000000000000000
-- 089:dddddddd00000000000000000000000000000000000000000000000000000000
-- 090:ddf000dd00000000000000000000000000000000000000000000000000000000
-- 091:dddddddd00000000000000000000000000000000000000000000000000000000
-- 092:df0ddddf00000000000000000000000000000000000000000000000000000000
-- 093:00000ddd00000000000000000000000000000000000000000000000000000000
-- 094:dddf00dd00000000000000000000000000000000000000000000000000000000
-- 095:dddddddd00000000000000000000000000000000000000000000000000000000
-- 099:000ccccc00cccccc00cccccc00cccccc00000000000ccccc00cccccc00cccccc
-- 100:c0ccccccc0ccccccfcccccccfcccccccfcccccfd0cccccfffcccccfffcccccff
-- 101:ccccccccccccccccccccccccccccccccdddddddddddddddd0000000000000000
-- 102:c0cccc00c0ccccf0fcccccfffcccccffdcccccffdcccccff0cccccff0cccccff
-- 104:0ccccccc0ccccccc0ccccccc0ccccccc0cccccdd0cccccd00ccccccc0ccccccc
-- 105:ccccc000ccccccc0cccccccfccccccccdddccccc000ccccccccccccccccccccf
-- 106:000000000000000000000000f0000000f0000000ff000000ff000000ff000000
-- 115:00cccccc00cccccc00ccccccc0cccccccfccccccccfcccccccfcccccddfddddd
-- 116:fcccccfffcccccfffcccccfffcccccccffccccccffccccccff0dccccff00dddd
-- 117:000000000000000000000000ccccccccccccccccccccccccccccccccdddddddd
-- 118:0cccccff0cccccff0cccccff0cccccccf0ccccccffccccccff0dccccff00dddd
-- 119:000000000000000000000000ccccccccccccccccccccccccccccccccdddddddd
-- 120:0ccccccc0ccccccc0cccccdd0cccccccc0cccccccfcccccccc0dccccddf0dddd
-- 121:cccccccfcccccfffddddffffccccccccccccccccccccccccccccccccdddddddd
-- 122:ff000000f0000000f000000000000000f0000000cf000000cf000000df000000
-- 128:0cccccc00ccccccccccccccccccccccc0ddddccc00dddccc00000ccccccccccc
-- 129:00000000c0000000cf000000cff00000cff00000cff00000cff00000cff00000
-- 131:dddfdddd00000000000000000000000000000000000000000000000000000000
-- 132:df0000dd00000000000000000000000000000000000000000000000000000000
-- 133:dddddddd00000000000000000000000000000000000000000000000000000000
-- 134:df0000dd00000000000000000000000000000000000000000000000000000000
-- 135:dddddddd00000000000000000000000000000000000000000000000000000000
-- 136:dddf00dd00000000000000000000000000000000000000000000000000000000
-- 137:dddddddd00000000000000000000000000000000000000000000000000000000
-- 138:ddf0000000000000000000000000000000000000000000000000000000000000
-- 144:cccccccccccccccddddddddddddddddd00000000000000000000000000000000
-- 145:cff00000dff00000ddf000000000000000000000000000000000000000000000
-- 149:00000000000000000000000000000000000000000000cccc0000cccc0000cccc
-- 150:0000000000000000000000000000000000000000c0000000cf000000cff00000
-- 151:000000000000000000000000000000000000000000000ccc0000cccc0000cccc
-- 152:0000000000000000000000000000000000000000cc00ccccccfcccccccfccccc
-- 153:0000000000000000000000000000000000000000cccccccccccccccccccccccc
-- 154:0000000000000000000000000000000000000000c0000000cf000000cff00000
-- 165:0000cccc0000cccc0000cccc0000cccc0000cccc0000cccc0000cccc0000cccc
-- 166:cccccccccccccccccccccccccccccccccfddddddcffdddddcff00000cff00000
-- 167:0000ccccf0000000ff000cccff00ccccff00ccccdf00cccc0000cccc0000cccc
-- 168:ccfccccc00fccccccc0cccccccfcccccccfcccccccfcccccccfcccccccfccccc
-- 169:ccccccccfdddddddffddddddff000000ff000000ff000000ff000000ff000000
-- 170:cff00000dff00000ddf000000000000000000000000000000000000000000000
-- 176:0000000c0000000c000000000000000000000000000000000000000000000000
-- 177:ccccccccccccccccccccccccccccccccdddddddceddddddc0000000c0000000c
-- 178:c0000000ccc00000cccf0000cccff000cccff000cccff000cccff000cccff000
-- 181:0000cccc00000ccc00000ccc000000dc0000000d000000000000000000000000
-- 182:ccccccccccccccccccccccccccccccccdddddddd0ddddddd0000000000000000
-- 183:ccc0cccccccfcccccccfcccccccfccccdddffdddddddf0dd0000000000000000
-- 184:ccfcccccccffccccccffccccccff0dccddff00dddddf00000000000000000000
-- 185:ccccccccccccccccccccccccccccccccdddddddddddddddd0000000000000000
-- 186:cc000000ccf00000ccff0000ccff0000ddff0000dddf00000000000000000000
-- 193:0000000c0000000c0000000c0000000c0000000c0000000c0000000c0000000c
-- 194:cccff000cccff000cccff000cccff000cccff000cccff000cccff000cccff000
-- 209:0000000c0000000c0000000c0000000c0000000c0000000c0000000c0000000c
-- 210:cccff000cccff000cccff000cccff000cccff000cccff000cccff000cccff000
-- 225:0000000c0000000c0000000c0000000c0000000c0000000c0000000c0000000c
-- 226:cccff000cccff000cccff000cccff000cccff000cccff000cccff000cccff000
-- 241:0000000c0000000c0000000c0000000c0000000c0000000c0000000c0000000c
-- 242:cccff000cccff000cccff000cccff000cccff000cccff000cccff000cccff000
-- </SPRITES2>

-- <SPRITES3>
-- 002:0000468600000012000000000000000000000000000000000000000000000000
-- 003:8661100001000000000000000000000000000000000000000000000000000000
-- 008:0000000800000028000000260000000100000000000000000000000000000000
-- 009:bbebb88bbb820220a10000000000000000000000000000000000000000000000
-- 010:2000000000000000000000000000000000000000000000000000000000000000
-- 016:0000000000000000000000000000000000000000000000000fffff00ff000000
-- 017:000000000000000000000000000000000000000000000000ff00ffffff00ff00
-- 018:000000000000000000000000000000000000000000000000f0000000ff000000
-- 019:00000000000000000000000000000000000000000000000000000fff0000ff00
-- 020:000000000000000000000000000000000000000000000000ff00ff000000ff00
-- 021:0000000000000000000000000000000000000000000000000000ff000000ff00
-- 022:000000000000000000000000000000000000000000000000ff00ff00ff00ff00
-- 023:0000000000000000000000000000000000000000000000000fffff00ff000000
-- 025:0000000000000000000000000000000000000000000000000fffff00ff000000
-- 026:000000000000000000000000000000000000000000000000ff00ffffff00ff00
-- 027:000000000000000000000000000000000000000000000000f0000fffff00ff00
-- 028:000000000000000000000000000000000000000000000000ff00ff000000ff00
-- 029:00000000000000000000000000000000000000000000000000000fff0000ff00
-- 030:000000000000000000000000000000000000000000000000f000ff00ff00ff00
-- 031:000000000000000000000000000000000000000000000000fffff000ff00ff00
-- 032:ff0000000ffff0000000ff000000ff000000ff00fffff0000000000000000000
-- 033:ff00ff00ff00ff00ff00ffffff00ff00ff00ff00ff00ff000000000000000000
-- 034:ff000000ff000000f0000000ff000000ff000000ff0000000000000000000000
-- 035:0000ff000000ff000000ff000000ff000000ff0000000fff0000000000000000
-- 036:0000ff000000ff000000ff000000ff000000ff00ff000fff0000000000000000
-- 037:0000ff000000ff000000ff000000ff000000ff00ff00ff000000000000000000
-- 038:ff00ff00ff00ff00ff00ff00ff00ff000ffff00000ff00000000000000000000
-- 039:ff000000ffff0000ff000000ff000000ff0000000fffff000000000000000000
-- 041:ff0000000ffff0000000ff000000ff000000ff00fffff0000000000000000000
-- 042:ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff000000000000000000
-- 043:ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff000fff0000000000000000
-- 044:0000ff000000ff000000ff000000ff000000ff00ff000fff0000000000000000
-- 045:0000ff000000ff000000ffff0000ff000000ff00ff00ff000000000000000000
-- 046:ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff000000000000000000
-- 047:ff00ff00ff00ff00fffff000ff00ff00ff00ff00ff00ff000000000000000000
-- 050:000000000000000000000000000000000000000f000000ff00000fff0000000f
-- 051:00000000000000000000000000000000f00000fff0000ff0f0000ff0f0000ff0
-- 052:00000000000000000000000000000000ff000ff00ff00ff00ff00ff00ff000ff
-- 053:00000000000000000000000000000000000000ffff000ff0ff000ff0fff00ff0
-- 054:00000000000000000000000000000000ff0000000ff000000ff00000fff00000
-- 055:000000000000000000000000000000000000000000000000000000000000ffff
-- 056:00000000000000000000000000000000000000000000000000000000ff000000
-- 057:000000000000000000000000000000000000ffff000000000000000000000fff
-- 058:00000000000000000000000000000000f0000fffff00ff00ff00ff00f000ff0f
-- 059:00000000000000000000000000000000f000ffffff000000ff000000ff000fff
-- 060:00000000000000000000000000000000f00000ffff000fffff00fffff00000ff
-- 066:0000000f0000000f0000000f00000fff00000000000000000000000000000000
-- 067:f00000fff0000000f0000000fff00fff00000000000000000000000000000000
-- 068:fff000000ff000000ff00000ff00000000000000000000000000000000000000
-- 069:ff000fffff000ff0ff000ff0ff0000ff00000000000000000000000000000000
-- 070:0ff000000ff000000ff00000ff00000000000000000000000000000000000000
-- 071:0000ffff00000000000000000000000000000000000000000000000000000000
-- 072:ff00000000000000000000000000000000000000000000000000000000000000
-- 073:0000ff000000ff000000ff0000000fff00000000000000000000000000000000
-- 074:0000fff00000ff000000ff00ff000fff00000000000000000000000000000000
-- 075:ff00ff00ff00ff00ff00ff00f0000fff00000000000000000000000000000000
-- 076:000000ff000000ff000000ffff00ffff00000000000000000000000000000000
-- 077:000000000000000000000000ff00000000000000000000000000000000000000
-- 086:0000000000000000000000ff000000ff000000ff000000ff000000ff000000ff
-- 087:0000000000000000fff000ff00ff00ff00ff00ff00ff00fffff000ff00ff00ff
-- 088:000000000000000000fffff000ff00ff00ff00ff00ff00ff00fffff000ff0000
-- 102:000000ff000000ff000000000000000000000000000000000000000000000000
-- 103:00ff00ff00ff00ff000000000000000000000000000000000000000000000000
-- 104:00ff000000ff0000000000000000000000000000000000000000000000000000
-- </SPRITES3>

-- <MAP>
-- 001:100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 002:10ff00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- </MAP>

-- <WAVES>
-- 000:00000000ffffffff00000000ffffffff
-- 001:0123456789abcdeffedcba9876543210
-- 002:0123456789abcdef0123456789abcdef
-- 003:789abcdefffedc987653210001234567
-- 004:fff00fff00000000ffffffff00000000
-- 008:0f0f0f888f0f08880f0f08880f0f888f
-- 012:0f0f0f888f0f08880f0f08880f0f888f
-- 013:8f8f8fac8f8f8ac88f8f8acf8f8fac8f
-- </WAVES>

-- <SFX>
-- 000:0300230063009300c300c3009300630023000300030003000300030003000300030003000300030003000300030003000300030003000300030003001750000a0000
-- 001:0300230063009300c300c3009300630023000300030003000300030003000300030003000300030003000300030003000300030003000300030003001650000a0000
-- 002:0300230063009300c300c3009300630023000300030003000300030003000300030003000300030003000300030003000300030003000300030003006040000a0000
-- 004:880038100820a830c840c850a800780038000800080008000800080008000800080008000800080008000800080008000800080008000800080008001d7000210600
-- 008:0c000c010c0f0c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c000c00227000000004
-- 012:0d000d010d0f0d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d000d00229000000004
-- 013:6d005d018d0f8d008d008d008d008d008d008d008d008d008d009d009d009d00ad00ad00bd00bd00cd00cd00dd00dd00ed00ed00fd00fd00fd00fd00229000000004
-- 016:0400240064009400c400c4009400640024000400040004000400040004000400040004000400040004000400040004000400040004000400040004001770000a0000
-- 017:0400240064009400c400c4009400640024000400040004000400040004000400040004000400040004000400040004000400040004000400040004001670000a0000
-- 018:0400240064009400c400c4009400640024000400040004000400040004000400040004000400040004000400040004000400040004000400040004001090000a0000
-- 020:020002b002003200820082009200e200f200f200a200a20092b0b200b200e200d200e200e200f200f200f200f200f200f200f200f200f200f200f200305000000000
-- 024:0400240064009400c800c8009800680028000400040004000400040004000400040004000400040004000400040004000400040004000400040004001750090a0000
-- 025:f200c2009200700030002800080000000000040004000400040004000400040004000400040004000400040004000400040004000400040004000400174009000000
-- 028:830033100320a330c340c850a800780038000800080008000800080008000800080008000800080008000800080008000800080008000800080008001d7002210600
-- 029:840034100420a330c340c850a800780038000800080008000800080008000800080008000800080008000800080008000800080008000800080008002d7002210600
-- 032:0ec700043020605f905ba088c0a8c0e8c0f8c0f8e0f8e0f8e0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8f0f8185000000000
-- 036:0f001f00320fa20db20bc00ac008c008c068d068d078d078e078e078e078e078e078e0a8e0b8e0d0e0f0e0f0e0f0e0f0e0f0e0f0e0f0e0f0f0f0f0f0487002000064
-- 040:8f00b600d600ef10ef40ef70ffa0ffb0ffa0ff60ff40ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff006f9034000000
-- 044:af00a600c600df10ff40ff70ffa0ffb0ffa0ff60ff40ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00ff00699034000000
-- </SFX>

-- <PATTERNS>
-- 000:b00802000000000000000000000000000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848000000000000000000
-- 001:900002000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b00002000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 002:900003411403411403411403900402000000000000000000000000000000000000000000000000000000000000000000900042000000000000000000900082100000900082100000b00082000000100000000000b00082000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 003:000000000000000000000000000000000000000000000000900045000000900047000000000000000000d00045000000d0004700000000000000000090004d000000000000000000b0004d000000000000000000b1014d0000000000000000000ff100000000000000000000d00045000000d00047000000000000000000b00045000000b00047000000000000000000400045000000400047000000000000000000000000000000000000000000400047000000000000000000000000000000
-- 004:400004000000000000000000000000000000000000000000400014000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400004000000000000000000000000000000000000000000d00002000000000000000000000000000000d00012000000000000000000000000000000000000000000000000000000d00002000000000000000000000000000000000000000000a00012000000000000000000a00026000000000000000000
-- 005:400003000000000000000000000000000000000000000000400013000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400003000000000000000000000000000000000000000000d00001000000000000000000000000000000d00011000000000000000000000000000000000000000000000000000000d00001000000000000000000000000000000000000000000a00011000000000000000000a00025000000000000000000
-- 006:000000000000000000000000000000000000000000000000000000000000b00047000000000000000000000000000000000000000000400049000000000000000000400049000000000000000000b00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000a00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000a00047000000a00044000000000000000000
-- 007:400024000000000000000000000000000000444422100020400414000000000000000000000000000000000000000000400024000000000000000000000000000000000000000000400004000000000000000000000000000000000000000000d00002000000000000000000000000000000d00012000000000000000000000000000000000000000000000000000000d00002000000000000000000000000000000000000000000a00012000000000000000000a00026000000000000000000
-- 008:400023000000000000000000000000000000444421100000400413000000000000000000000000000000000000000000400023000000000000000000000000000000000000000000400003000000000000000000000000000000000000000000d00001000000000000000000000000000000d00011000000000000000000000000000000000000000000000000000000d00001000000000000000000000000000000000000000000a00011000000000000000000a00025000000000000000000
-- 009:b00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848000000000000000000
-- 010:000000000000400049000000000000000000400049000000000000000000b00047000000000000000000000000000000000000000000400049000000000000000000400049000000000000000000b00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000a00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000a00047000000000000000000000000000000
-- 011:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000900042000000000000000000
-- 012:9000800000000000000000000000000000000000000000009ff184100000d431841000004ff1861000009341861ff000dff186100000443188100000dff1861000009341861000004ff186100000d431841000009ff1841000004341841000009ff184100000d431841000004ff186100000934186100000dff186100000443188100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 013:b00802000000b0088c000000000000000000000000000000b008ccb008ccb00802000000000000b008ccb0088cb008ccb00802000000b0088c000000000000000000000000000000b008ccb008ccb00802000000000000b008ccb0088cb008ccb00802000000b0088c000000000000000000000000000000b008ccb008ccb00802000000000000b008ccb0088cb008ccb00802000000b0088c000000000000000000000000000000b008ccb008ccb00802000000000000000000000000000000
-- 014:b00802000000b0088c000000000000000000000000000000b008ccb008ccb00802000000000000b008ccb0088cb008ccb00802000000b0088c000000000000000000000000000000b008ccb008ccb00802000000000000b008ccb0088cb008ccb00802000000b0088c000000000000000000000000000000b008ccb008ccb00802000000000000b008ccb0088cb008ccb00802000000b0088c000000000000000000000000000000b008ccb008ccb00802000000b00848d00848f00848400848
-- 015:b00802000000000000000000000000000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000b0088c000000b00848000000000000000000b008ccb008ccb00802000000b00848b008ccb0088cb008ccb00802000000000000000000000000000000000000000000000000000000000000000000b00848b00848b00848b00848
-- 016:000000000000000000000000000000000000000000000000000000000000b00047000000000000000000000000000000000000000000400049000000000000000000400049000000000000000000b00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000a00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000a00047000000a00044000000000000000000
-- 017:400024000000000000000000000000000000444422100020400414000000000000000000000000000000000000000000400024000000000000000000000000000000000000000000400004000000000000000000000000000000000000000000d00002000000000000000000000000000000d00012000000000000000000000000000000000000000000000000000000d00002000000000000000000000000000000000000000000a00012000000000000000000a000c3000000000000000000
-- 018:400023000000000000000000000000000000444421100000400413000000000000000000000000000000000000000000400023000000000000000000000000000000000000000000400003000000000000000000000000000000000000000000d00001000000000000000000000000000000d00011000000000000000000000000000000000000000000000000000000d00001000000000000000000000000000000000000000000a00011000000000000000000a000d5000000000000000000
-- 019:0ff100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d00025000000d00044000000d00084100000d2f182100000bf2184100000b2f182100000af2184100000a2f182100000
-- 020:000000000000400047000000000000000000400047000000000000000000b00047000000000000000000000000000000000000000000400049000000000000000000400049000000000000000000b00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000a00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000a00047000000a00044000000000000000000
-- 021:900002000000000000000000000000000000000000000000900012000000000000000000000000000000000000000000944424000000000000000000000000000000000000000000b44402000000000000000000000000000000000000000000000000000000000000000000400000000000000000000000400404000000000000000000000000000000000000000000400024000000000000000000000000000000000000000000400004000000000000000000100000000000000000000000
-- 022:900003000000000000000000000000000000000000000000900013000000000000000000000000000000000000000000944425000000000000000000000000000000000000000000b44403000000000000000000000000000000000000000000000000000000000000000000400001000000000000000000400403000000000000000000000000000000000000000000400023000000000000000000000000000000000000000000400003000000000000000000100000000000000000000000
-- 024:400004000000000000000000000000000000000000000000400014000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400004000000000000000000000000000000000000000000d00002000000000000000000000000000000d00012000000000000000000000000000000000000000000000000000000d00002000000000000000000000000000000000000000000a00012000000000000000000a000c5000000000000000000
-- 029:b00802000000b0088c000000b00848000000000000000000b008cc000000000000000000b00848000000000000000000b00802000000b0088c000000b00848000000000000000000000000000000b00802000000b00848000000000000000000b00802000000b0088c000000b00848000000000000000000b008cc000000000000000000b00848000000000000000000b00802000000000000000000b00848000000000000000000b008ccb008ccb00802000000b00848b00848b00848b00848
-- 030:000000000000b0088c000000b00848000000000000000000b008cc000000000000000000b00848000000000000000000000000000000b0088c000000b00848000000000000000000000000000000b00802000000b00848000000000000000000000000000000b0088c000000b00848000000000000000000b008cc000000000000000000b00848000000000000000000000000000000000000000000b00848000000000000000000b008ccb008ccb00802000000b00848000000000000000000
-- 031:900024000000400024000000900024000000d000240000004000c7000000000000000000400024100000400024100000400024100000400024100000d00022100000d00022100000d00022100000d00022100000900022000000100000000000000000000000000000000000900012000000000000000000000000000000000000000000100000000000000000000000900002000000000000000000000000000000000000000000900083000000000000000000900002000000000000000000
-- 032:900023000000400023000000900023000000d000230000004000d5000000000000000000400023100000400023100000400023100000400023100000d00021100000d00021100000d00021100000d00021100000900021000000100001000000000000000000000000000000900011000000000000000000000000000000000000000000100000000000000000000000900001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 033:900082000000400084000000900084000000d00084000000400046000000000000000000400047000000d00047000000400049000000d00047000000400047000000d00047000000400047000000d00045000000900045000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000900046000000000000000000
-- 034:900029900029900049000000d00029d00029d00049000000400029400029400049000000000000000000000000000000900049000000000000000000000000000000900049000000000000000000000000000000900049000000000000000000000000000000d00049000000000000000000000000000000900049000000000000000000000000000000400049000000000000000000000000000000900047000000000000000000000000000000d00045000000000000000000000000000000
-- 035:900004000000000000000000400004100000400004100000400014000000000000000000d00004000000000000000000900004100000900004100000900024000000000000000000000000000000000000000000000000000000000000000000900004100000d00014100000400085000000000000000000000000000000400024100000d00024100000900014000000000000000000000000000000900004100000d000241000004ff1c50ff1000aa100066100044100033100022100011100
-- 036:900003000000000000000000400003100000400003100000400013000000000000000000d00003000000000000000000900003100000900003100000900023000000000000000000000000000000000000000000000000000000000000000000900003100000d00013100000400003000000000000000000000000000000400023100000d00023100000900013000000000000000000000000000000900003100000d000231000004ff1d30ff1000aa100066100044100033100022100011100
-- 039:daa1460aa100099100066100022100066100d991c60aa1009aa1440aa1000aa1000661000221000661000a210002a1000a210002a1000991000aa1004aa1440aa1000991000661000221000661000991000aa100daa1420aa100099100066100022100066100daa1c20991009aa1420aa1000991000661000221000661000991000aa1000991000661000221000661000aa1000a210002a1000a21009261c20621000201000021004aa1420aa100099100066100044100033100022100011100
-- 040:9000040000009ff1c50aa100066100033100022100011100000000000000000000000000000000000000d331d6000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d331d20000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009331d2000000000000000000
-- 041:100000000000000000000000000000000000000000000000000000000000dff1d6000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000d2000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b111230661000ff100000000000000000000000000000000
-- 042:100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b111d30661000ff100000000000000000000000000000000
-- 045:9ff1040000009ff1c50aa1000661000331000221000111009ff102000000d00002100000d00002000000d00002000000100000000000000000000000900000000000d00002100000d00002000000d00002000000100000000000000000000000900002000000d00004100000d00083000000d00002000000100000000000000000000000900002000000d00083100000d00002000000d00083000000000000000000000000000000900002000000d00002100000d00083000000d00000000000
-- 046:9ff1050000009ff1d50aa1000661000331000221000111009ff103000000d00003100000d00003000000d00003000000100000000000000000000000900001000000d00003100000d00003000000d00003000000100000000000000000000000900003000000d00005100000d00003000000d00003000000100000000000000000000000900003000000d00003100000d00003000000d00003000000100000000000000000000000900003000000d00003100000d00003000000d00001000000
-- 047:9ff1040000009ff1c50aa1000661000331000221000111009ff102000000d00002100000d00002000000d00002000000100000000000000000000000900002000000d00002100000d00002000000d00083000000100000000000000000000000900002000000d00002100000d00002000000d00002000000100000000000000000000000900002000000d00002100000dff1c30ee1000dd1000cc1000bb1000aa100099100088100077100066100055100044100033100022100dff102000000
-- 048:9ff1050000009ff1d50aa1000661000331000221000111009ff103000000d00003100000d00003000000d00003000000100000000000000000000000900003000000d00003100000d00003000000d00003000000100000000000000000000000900003000000d00003100000d00003000000d00003000000100000000000000000000000900003000000d00003100000dff1d30ee1000dd1000cc1000bb1000aa100099100088100077100066100055100044100033100022100dff103000000
-- 049:000000000000000000000000000000000000000000000000000000000000d000d6000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d000d20000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009000d2000000000000000000000000000000000000000000
-- 050:000000000000400049000000000000000000400049000000000000000000d00047000000000000000000000000000000000000000000400049000000000000000000400049000000000000000000d00047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000900047000000000000000000000000000000000000000000d00047000000000000000000d00047000000000000000000900047000000000000000000000000000000
-- 051:400049000000400044000000000000000000400049000000000000000000d00047000000000000000000d441840000000000000000004ff149000000000000000000400049000000000000000000d00047000000000000000000d44184000000000000000000dff147000000000000000000d00047000000000000000000900047000000000000000000944184000000000000000000dff147000000000000000000d00047000000000000000000900047000000900044000000000000000000
-- 052:9ff1040000009ff1c50aa1000661000331000221000111009ff102000000d00083000000000000000000000000000000100000000000000000000000900000000000d00002100000d00002000000d00002000000100000000000000000000000900002000000d00004100000d00083000000d00002000000100000000000000000000000900002000000d00083100000d00002000000d00083000000000000000000000000000000900083000000d00002100000d00083000000000000000000
-- 054:400004000000000000000000000000000000000000000000400085000000000000000000000000000000000000000000400024000000000000000000000000000000000000000000400004000000000000000000000000000000000000000000d00002000000000000000000000000000000d00083000000000000000000000000000000000000000000000000000000d00002000000000000000000000000000000000000000000a00012000000000000000000a00026000000000000000000
-- 055:4000850000000000000000004ee4810000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff1000ee1000dd1000cc1000bb1000aa100099100088100077100066100066100055100055100044100044100033100033100022100022100022100022100011100011100000100
-- 056:4000950000000000000000004eec400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000ff1000ee1000dd1000cc1000bb1000aa100099100088100077100066100066100055100055100044100044100033100033100022100022100022100022100011100011100000100
-- 058:0ff100000000000000000000000000000000000000000000000000000000000000000000000000000000d331d6000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d331d20000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000009331d2000000000000000000
-- 059:4008040000000000000000000000000000000000000000004ff94a00000000000000000000000000000040894c00000000000000000000000000000048094c00000000000000000000000000000040494c00000000000000000000000000000042094c000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- </PATTERNS>

-- <TRACKS>
-- 000:f51500e51500e516c1f94354a80200180300a80205a80300a85710a85713a857531857531081a81095a8a081e81095e8f00000
-- 001:e19520e19520e4aa2af4ab2a18bf2aa4df2aa8bf2d01c13d000000000000000000000000000000000000000000000000f00000
-- 002:041500041500f51500e56910000000000000000000000000000000000000000000000000000000000000000000000000f00000
-- 003:c3e93f630000630000630000630000000000000000000000000000000000000000000000000000000000000000000000f00000
-- 004:a85710a85713000000000000000000000000000000000000000000000000000000000000000000000000000000000000f00000
-- </TRACKS>

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

-- <PALETTE1>
-- 000:000000222222333333444444555555666666777777888888999999aaaaaabbbbbbccccccddddddeeeeeeffffffffffff
-- </PALETTE1>

-- <PALETTE2>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE2>

-- <PALETTE3>
-- 000:000000222211552200223344553322554444884422556655996655777766888877cc8877999999bbaaaaddbbaaeeeeee
-- </PALETTE3>

