;;;
;;; Logi by neon/darklite
;;; 
;;; A 64 byte intro for the Tiki-100 computer released at Lovebyte 2021.
;;;
	.z80
	.area CODE
PORT_AY_PTR = 0x16
PORT_AY_DATA = 0x17
PORT_SYSTEM = 0x1c
	
HEIGHT = 63

;;; Start address for copied code
;;; This address is chosen so that after copying, the d and e
;;; register can be reused when setting up the memory and sound
START = 0xde02

	;; Must be linked with a start address of 0x0100
_start::
	di

	;; Copy the main part of the code to an address above 0x8000
	;; since the video RAM will be mapped into the lower 32k
	ld	de, #START+high_code-_start
	push	de
	ld	hl, #high_code
	;; Assumes bc is 0x00ff
	ldir

	;; Jump to high_code
	ret

high_code:
	;; Map video RAM into the low 32k by writing 0x0C to
	;; the system register
	ld	a, e
	out	(PORT_SYSTEM), a

	;; Set the mixer to 0xdf. This sets port A (and B) to
	;; output and enables the noise on channel C.
	ld	a, #7
	out	(PORT_AY_PTR), a
	ld	a, d
	out	(PORT_AY_DATA), a

main_loop:
	;; Set the AY pointer to point to the volume for channel C
	ld	a, #10
	out	(PORT_AY_PTR), a

	;; Copy data from ROM ("random" data) into the bottom
	;; two lines in the video RAM
	;; Use the r register to randomly select start offset
	;; The e register is reused
	ld	h, #0xea
	ld	a, r
	ld	l, a
	ld	d, #0x7e
	inc	b
	ldir

	;; Blur
	;; Load start pointer. Reuse the "random" l from above
	ld	h, #>(128*(255-HEIGHT))
loop1:
	ld	b, #64
loop2:
	;; Add two and two bytes and write the result back to the same
	;; two bytes
	ld	a, (hl)
	inc	l
	add	(hl)
	dec	l
	ld	(hl), a
	inc	l
	ld	(hl), a
	inc	l
	djnz	loop2

	;; Increment the high byte of the video RAM pointer and stop
	;; when it is 0x80 or above
	inc	h
	jp	p, START + loop1-_start

	;; Use whatever was in a as volume after clearing the top nibble
	and	#15
	out	(PORT_AY_DATA), a
	
	;; Scroll the screen by calling directly into ROM
	;; This probably requires ROM version 2.03W
	ld	a, #3
	call	0xe070

	;; Do this forever
	jr	main_loop
	
