;ZXN.RU promotion
;ZX Spectrum 48, 256 byte intro
;code - .ded^RMDA
;24.06.2021, Russia, Samara

;no sound (really?)
;duration: 2 min 40 sec. 
;first pass 1 min 30 sec. + infinite loop with different colors

;how to build:
;use SjASMplus https://github.com/z00m128/sjasmplus
;sjasmplus.exe zxn-ru.asm

;code footprint:
;--------------------------------------------------------------
;23b - color splash
;16b - R color bars fill
;13b - attr fadeout
;14b - 4x4 chess fill
;09b - cls
;20b - I-based Pentagon raindrops
;12b - LDIR screen fill with intro data
;25b - EX (SP),HL scroll
;13b - RLC (HL) scroll (reused several times)
;36b - qr-code attr print (reused several times)
;55b - qr-code data
;20b - initializations, calls, and other payload
;--------------------------------------------------------------
;powered by https://zxn.ru

 	DEVICE	ZXSPECTRUM48

	org	#ef3f		;61247

begin:	equ	$
;-------color splash-------------------------------------------
	ei
	ld	b,9
splsh2:	xor	a
splash:	halt
	out	(#fe),a	
	ld	d,#57
splsh3:	ld	(de),a
	inc	de
	bit	7,d		;bit 5 - fast, bit 7 - slow
	jr	z,splsh3
	add	a,9		
	cp	#48
	jr	nz,splash
	djnz	splsh2
	;a=#48 : b=#00 : de=#8000

;-------R color bars fill---------------------------------------
	di
goto10:	inc	a       ;a=0,2 no flash, a=1,ff good border but flash
	ld	r,a
colors:	ld	h,#ed		;#EDxx
	ld	e,a
	daa
	out	(#fe),a
	ld	(hl),a
	cp	(hl)
	dec	hl
	jr	z,colors+1
	rlca			;FX loop
	jr	nc,colors       ;
	;a=#03 : b=#00 : de=#80f2 : hl=#3ffe

;-------color bars rolling--------------------------------------
	call	rollin
	;a=#3f : bc=#0001 : de=#5aba : hl=#f03f

;-------attr fade out-------------------------------------------
	ld	c,a		;A or L
fade2:	ld	h,e             ;#BAxx
fade1:	dec	hl
	ld	a,(hl)
	and	c
	ld	(hl),a
	cp	(hl)
	jr	z,fade1
	srl	c
	jr	c,fade2
	;a=#00 : bc=#0000 : de=#5aba : hl=#3fff

;-------4x4 chess fill------------------------------------------
	ld	de,%0000111111110000	;#0ff0 pattern
chess4:	ld	h,#72			;#72xx
;#72	ld	(hl),d
	bit	2,h
	jr	z,chess5
	ld	(hl),e
chess5:	dec	hl
	ld	b,h
	djnz	chess4+1
	;a=#00 : bc=#0000 : de=#0ff0 : hl=#01ff

;-------chess rolling-------------------------------------------
	call	rollin
	;a=#3f : bc=#0001 : de=#5aba : hl=#f03f

;-------cls-----------------------------------------------------
	out	(#fe),a		;WHITE border
	add	hl,hl
cls:	ld	(hl),#38	;BLACK ink, WHITE paper
	dec	hl
	ld	b,h
	djnz	cls
	;a=#3f : bc=#0001 : de=#5aba : hl=#01ff

;---------------------------------------------------------------
	call	qrprnt
	;a=#3f : bc=#0001 : de=#5aba : hl=#f03f

;-------I-based Pentagon raindrops-----------------------------
pushi:	ld	sp,#5800	
	ld	bc,#0d00	;6144/2+#100
pushaf:	xor	a		;put 0 in A and some flags
	ld	i,a             ;put 0 in I
	inc	a               ;F=0 after this, AF=#0100
	ld	a,i             ;what happens with AF here?
	push	af              ;lets push results to screen
	dec	bc
	inc	b
	djnz	pushaf
	inc	l               ;FX loop
 	jr	nz,pushi        ;
	;a=#00 : bc=#00ff : de=#5aba : hl=#f000 : sp=#3ffe

;-------LDIR screen fill with intro data------------------------
	ld	d,a
	ld	a,87
fillsc:	ld	hl,begin
	dec	c	;ld bc,#00ff or something like #ff
	ldir
	dec	a
	jr	nz,fillsc
	;a=#00 : bc=#0000 : de=#5762 : hl=#f03e : sp=#3ffe  

;-------ex (sp),hl scroll--------------------------------------
exloop:	ld	sp,#4000
	ld	b,192
exrol:	
	ld	c,16
	ld	hl,#001e
	add	hl,sp
	ld	a,(hl)
	inc	l
	ld	h,(hl)
	ld	l,a
exrol2:	ex	(sp),hl
	pop	af
	dec	c
	jr	nz,exrol2
	djnz	exrol
	inc	d		;FX loop
	jr 	nz,exloop       ;
	;a=#00 : bc=#0000 : de=#0062 : hl=#0028 : sp=#5800

;---------------------------------------------------------------
	ld	hl,goto10	
	ld	sp,hl           ;restore SP in non-visible area
	push	hl		;RET address for intro loop
;---------------------------------------------------------------
rollin:	call	qrprnt
	;a=#3f : bc=#0001 : de=#5aba : hl=#f03f

roll:	ld	hl,#57ff
roll2:	rlc	(hl)
	dec	hl
	dec	l
	dec	hl
	cp	h		;reuse A from qr print
	jr	nz,roll2
	djnz	roll
	;a=#3f : bc=#ff01 : de=#5aba :hl=#3fff

;-------attr sprite printer------------------------------------

bits:	equ	21

qrprnt:	ld	hl,qrdata       ;bit-by-bit packed sprite data
	ld	de,#5826	;screen address for attr sprite
	ld	c,bits		;number of attrs in one line
qrloop:	ld	b,8
lines:	rlc	(hl)
	sbc	a,a
	cpl                     ;invert color
	and	%00111111	;set ink/paper
	ld	(de),a
	inc	de
	dec	c
	jr	nz,qrskip
;--------6b-------------
	ld	c,32-bits	;11 pixels shift
incde:	inc	de
	dec	c
	jr	nz,incde
;-----------------------
	ld	c,bits		;21 pixel
qrskip:	djnz    lines
	inc	hl
;	cp	(hl) / n	;check end of sprite
	cp	l		;sizecoding optimization via ORG 
	jr	nz,qrloop
	ld	(de),a		;lame last pixel patch
	ret

;-------QR data, bit-by-bit 21x21 pixels packed in 55 bytes-----
qrdata:	defb %11111110,%11001011,%11111100
	defb %00010111,%01010000,%01101110
	defb %10011010,%10111011,%01110101
	defb %11110101,%11011011,%10100001
	defb %00101110,%11000001,%00010001
	defb %00000111,%11111010,%10101111
	defb %11100000,%00011100,%00000000
	defb %10110111,%01010010,%01011100
	defb %01000011,%10111111,%11111110
	defb %11101001,%00010110,%01011011
	defb %00010010,%10100010,%10110100
	defb %11101100,%10000000,%01010100
	defb %01000011,%11111011,%01011010
	defb %00010000,%01011000,%10111101
	defb %10111010,%01001100,%10110101
	defb %11010111,%01111000,%10101110
	defb %10100010,%01001001,%00000100
	defb %00011111,%00011111,%11101101
	defb %11101110
;	defb #3f	;end of sprite marker
;--------------------------------------------------------------
finish:	
	SAVESNA	"zxn-ru.sna",begin
	SAVEBIN	"zxn-ru.bin",begin,finish-begin
;	EMPTYTRD"zxn-ru.trd","ZXN.RU"
;	SAVETRD	"zxn-ru.trd","zxnpromo.C",begin,finish-begin
;-------=RMDA=---------------------------------------------[eof]