;1490bpm
;ZX Spectrum 16/48/128, 256 byte intro
;code, gfx - .ded^RMDA
;17.06.2021, Russia, Samara

;duration: looped after 1 min. 45 sec.

;how to build:

;use SjASMplus https://github.com/z00m128/sjasmplus
;sjasmplus.exe 1490bpm.asm

;crunch .BIN with ZX2 https://github.com/einar-saukas/ZX2
;zx2.exe -f -b -x -z -y 1490bpm.bin

;MAGIC is here:
;1) Take ZX2 backwards depacker and tweak it to -x -z -y
;2) We will launch code thru depacker "self-overwrite" so...
;3) Remove first PUSH BC and first POP BC from depacker code
;4) Remove INC C and RET Z from depacker code
;5) Modify .BIN.ZX2 by removing first 2 bytes (EOF+last offset)
;6) Update all offset bytes in .BIN.ZX2 with one INC
;7) Link 203 bytes final .BIN.ZX2 with init code, set proper ORG
;---------------------------------------------------------------
;	org	#57e4	;22500
;013b - initialization (DI,SP,HL,DE,A,B)
;040b - depacker
;203b -ZX2 modified packed data
;	di
;	ld	hl,#8000
;	ld	sp,hl
;	ld	b,l
;	ld	a,h
;	ld	hl,#58e3
;	ld	de,#5dd1
;dzx2nb_literals:
;	rest of patched ZX2 "dzx2_nano_back.asm" is here
;	incbin	"1490bpm.bin.zx2"
;---------------------------------------------------------------
;8) You got it in 256 bytes!

;useful tools:
;53color editor http://53c.verve.space/
;file to HEX https://zxn.ru

	DEVICE	ZXSPECTRUM48

	org	#5800

begin:	equ	$

;---------------------------------------------------------------
disk:
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#21,#e0,#5a,#21,#e0,#5a,#07,#07,#07,#07,#07,#07,#07,#42,#42,#42,#42,#42,#42,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#21,#e0,#5a,#21,#e0,#5a,#07,#07,#07,#07,#07,#07,#42,#42,#42,#42,#42,#42,#42,#42,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#21,#e0,#5a,#21,#e0,#5a,#07,#07,#07,#07,#07,#07,#42,#42,#42,#42,#42,#42,#42,#42,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#21,#e0,#5a,#21,#e0,#5a,#07,#07,#07,#07,#07,#07,#42,#42,#42,#42,#42,#42,#42,#42,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#42,#42,#42,#42,#42,#42,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#00,#00,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#00,#00,#00,#00,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#00,#00,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#78,#07,#07,#eb,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#00,#00,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#00,#00,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#00,#00,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#00,#00,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#78,#78,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
	defb #89,#89,#89,#89,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#89,#89,#89,#89
;---------------------------------------------------------------
cover:	
	defb #89,#89,#89,#bf,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#bf,#89,#89,#89
	defb #89,#89,#89,#bf,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#07,#bf,#89,#89,#89
	
	DUP	6
	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#89,#89,#89
	EDUP

	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#4e,#bf,#bf,#bf,#4e,#4e,#4e,#bf,#4e,#4e,#4e,#bf,#4e,#4e,#4e,#bf,#bf,#89,#89,#89
	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#4e,#bf,#bf,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#bf,#89,#89,#89
	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#4e,#bf,#bf,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#bf,#bf,#bf,#bf,#4e,#bf,#bf,#89,#89,#89
	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#4e,#bf,#bf,#bf,#4e,#bf,#4e,#bf,#4e,#4e,#4e,#bf,#bf,#bf,#4e,#bf,#bf,#89,#89,#89
	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#4e,#bf,#bf,#bf,#4e,#bf,#4e,#bf,#bf,#bf,#4e,#bf,#bf,#bf,#4e,#bf,#bf,#89,#89,#89
	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#4e,#bf,#bf,#bf,#4e,#bf,#bf,#89,#89,#89
	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#4e,#4e,#4e,#bf,#4e,#4e,#4e,#bf,#4e,#4e,#4e,#bf,#bf,#bf,#4e,#bf,#bf,#89,#89,#89

	DUP	1
	defb #89,#89,#89,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#bf,#89,#89,#89
	EDUP

;-------additional bytes payload for compressor-----------------

	DUP	4	;up to +29 bytes is possible here
	defb	#89     ;this additional bytes give us free 
	EDUP		;-1 byte after ZX2 compression! 

;!!!----INIT,uncomment this if you debug without ZX2 depacker---
;	di : ld a,#21 : ld bc,#57ed : ld de,#5ae0 : ld hl,#57ff
;---------------------------------------------------------------

	out	(#fe),a
;-------chessboard----------------------------------------------
chess:	dec	hl
	ld	a,h
	rra
	sbc	a,a
	xor	%01010101
	ld	(hl),a
	xor	(hl)
	jr	z,chess
;---------------------------------------------------------------	
drive:	ld	sp,#5a4f
	DUP	4		;after ZX2 compression this 
	ex	(sp),hl         ;unrolled construction
		DUP	16      ;is smaller (!) compares with
		pop	af      ;"normal" 4xSP solution
		EDUP            ;
	EDUP                    ;
	inc	bc
	inc	b
	djnz	drive
;---------------------------------------------------------------
	ld	h,#70
	ld	sp,hl
	push	hl
;-------filled cover--------------------------------------------	
	ld	a,16
	ld	c,32
	ld	h,high cover	;H=#5b,L=0
sdvig:	push	bc
	push	de
	ldir
;-------ldir pause + LD HL,DE-----------------------------------
	ld	h,d
	ld	l,e
	ldir
;---------------------------------------------------------------
	pop	de
	pop 	bc
;---------------------------------------------------------------
	DUP	32
	inc	bc	;this save 1 byte in ZX2 packed binary
	dec	de	;compares with "RLE-logical": 
	EDUP		;DUP 32 inc bc EDUP DUP 32 inc de EDUP
;---------------------------------------------------------------
	dec	a
	jr	nz,sdvig
;---------------------------------------------------------------
	pop	bc
beep:	ld	d,1
	ld	h,#50
beep2:	ld	a,(hl)
	add	a,d
	or	b
	ld	d,a
	ld	(hl),a
	and	%00011001
	out	(#fe),a
	inc	hl
	bit	3,h
	jr	z,beep2
;--------------------------------------------------------------
	dec	bc
	bit	3,b
	jr	 nz,beep
color:	ld	(#581a+32*6),hl
	add	hl,bc
	ld	h,l
	jp	color	;last byte is used to JP

finish:	
	SAVESNA	"1490bpm.sna",begin
	SAVEBIN	"1490bpm.bin",begin,finish-begin
;-------=RMDA=---------------------------------------------[eof]